/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.internal.tasks

import com.android.build.gradle.internal.profile.AnalyticsService
import com.android.build.gradle.internal.services.getBuildService
import org.gradle.api.Project
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Internal

/**
 * A task associated with a variant name.
 */
interface VariantAwareTask {

    /** the name of the variant */
    var variantName: String

    @get:Internal
    val analyticsService: Property<AnalyticsService>
}

fun VariantAwareTask.configureVariantProperties(
    variantName: String,
    project: Project
) {
    this.variantName = variantName
    this.analyticsService.set(getBuildService(project.gradle.sharedServices))
}
