/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.component.impl;

import com.android.build.api.variant.AndroidVersion;
import com.android.build.api.variant.Renderscript;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.VariantPropertiesApiServices;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0003J\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0015\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lcom/android/build/api/component/impl/ConsumableCreationConfigImpl;", "", "config", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "variantDslInfo", "Lcom/android/build/gradle/internal/core/VariantDslInfo;", "(Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;Lcom/android/build/gradle/options/ProjectOptions;Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/internal/core/VariantDslInfo;)V", "getConfig", "()Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "dexingType", "Lcom/android/builder/dexing/DexingType;", "getDexingType", "()Lcom/android/builder/dexing/DexingType;", "getGlobalScope", "()Lcom/android/build/gradle/internal/scope/GlobalScope;", "isCoreLibraryDesugaringEnabled", "", "()Z", "minSdkVersionForDexing", "Lcom/android/build/api/variant/AndroidVersion;", "getMinSdkVersionForDexing", "()Lcom/android/build/api/variant/AndroidVersion;", "needsShrinkDesugarLibrary", "getNeedsShrinkDesugarLibrary", "getProjectOptions", "()Lcom/android/build/gradle/options/ProjectOptions;", "getVariantDslInfo", "()Lcom/android/build/gradle/internal/core/VariantDslInfo;", "getJava8LangSupportType", "Lcom/android/build/gradle/internal/scope/VariantScope$Java8LangSupport;", "getNeedsMergedJavaResStream", "creationConfig", "renderscript", "Lcom/android/build/api/variant/Renderscript;", "internalServices", "Lcom/android/build/gradle/internal/services/VariantPropertiesApiServices;", "gradle-core"})
public class ConsumableCreationConfigImpl {
    @NotNull
    private final ConsumableCreationConfig config;
    @NotNull
    private final ProjectOptions projectOptions;
    @NotNull
    private final GlobalScope globalScope;
    @NotNull
    private final VariantDslInfo<?> variantDslInfo;

    public ConsumableCreationConfigImpl(@NotNull ConsumableCreationConfig config2, @NotNull ProjectOptions projectOptions, @NotNull GlobalScope globalScope, @NotNull VariantDslInfo<?> variantDslInfo) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)globalScope, (String)"globalScope");
        Intrinsics.checkNotNullParameter(variantDslInfo, (String)"variantDslInfo");
        this.config = config2;
        this.projectOptions = projectOptions;
        this.globalScope = globalScope;
        this.variantDslInfo = variantDslInfo;
    }

    @NotNull
    public ConsumableCreationConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final ProjectOptions getProjectOptions() {
        return this.projectOptions;
    }

    @NotNull
    public final GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @NotNull
    public final VariantDslInfo<?> getVariantDslInfo() {
        return this.variantDslInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final DexingType getDexingType() {
        DexingType dexingType;
        DexingType dexingType2 = this.variantDslInfo.getDexingType();
        if (dexingType2 != null) {
            dexingType = dexingType2;
            return dexingType;
        }
        if (!this.getConfig().isMultiDexEnabled()) {
            dexingType = DexingType.MONO_DEX;
            return dexingType;
        }
        if (VariantApiExtensionsKt.getFeatureLevel(this.getConfig().getMinSdkVersion()) < 21) {
            Boolean bl;
            Integer n = this.variantDslInfo.getTargetDeployApiFromIDE();
            if (n == null) {
                bl = null;
            } else {
                Integer n2 = n;
                boolean bl2 = false;
                boolean bl3 = false;
                int it = ((Number)n2).intValue();
                boolean bl4 = false;
                bl = it >= 21;
            }
            if (!Intrinsics.areEqual(bl, (Object)true)) {
                dexingType = DexingType.LEGACY_MULTIDEX;
                return dexingType;
            }
        }
        dexingType = DexingType.NATIVE_MULTIDEX;
        return dexingType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getNeedsMergedJavaResStream() {
        if (this.variantDslInfo.getVariantType().isAar()) return true;
        Collection collection = this.globalScope.getExtension().getTransforms();
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!this.getConfig().getMinifiedEnabled()) return false;
        return true;
    }

    @NotNull
    public VariantScope.Java8LangSupport getJava8LangSupportType() {
        return !this.globalScope.getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible() ? VariantScope.Java8LangSupport.UNUSED : (this.getConfig().getServices().getProjectInfo().getProject().getPlugins().hasPlugin("me.tatarka.retrolambda") ? VariantScope.Java8LangSupport.RETROLAMBDA : (this.getConfig().getMinifiedEnabled() ? VariantScope.Java8LangSupport.R8 : VariantScope.Java8LangSupport.D8));
    }

    public final boolean isCoreLibraryDesugaringEnabled() {
        return this.isCoreLibraryDesugaringEnabled(this.getConfig());
    }

    public boolean getNeedsShrinkDesugarLibrary() {
        return this.isCoreLibraryDesugaringEnabled(this.getConfig());
    }

    public final boolean isCoreLibraryDesugaringEnabled(@NotNull ConsumableCreationConfig creationConfig) {
        boolean langDesugarEnabled;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        BaseExtension baseExtension = this.globalScope.getExtension();
        Intrinsics.checkNotNullExpressionValue((Object)baseExtension, (String)"globalScope.getExtension()");
        BaseExtension extension = baseExtension;
        Boolean bl = extension.getCompileOptions().getCoreLibraryDesugaringEnabled();
        Boolean bl2 = bl == null ? Boolean.valueOf(false) : bl;
        boolean libDesugarEnabled = bl2;
        boolean multidexEnabled = creationConfig.isMultiDexEnabled();
        VariantScope.Java8LangSupport langSupportType = this.getJava8LangSupportType();
        boolean bl3 = langDesugarEnabled = langSupportType == VariantScope.Java8LangSupport.D8 || langSupportType == VariantScope.Java8LangSupport.R8;
        if (libDesugarEnabled && !langDesugarEnabled) {
            IssueReporter.reportError$default((IssueReporter)this.globalScope.getDslServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to use core library desugaring, please enable java 8 language desugaring with D8 or R8.", null, null, (int)12, null);
        }
        if (libDesugarEnabled && !multidexEnabled) {
            IssueReporter.reportError$default((IssueReporter)this.globalScope.getDslServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to use core library desugaring, please enable multidex.", null, null, (int)12, null);
        }
        return libDesugarEnabled;
    }

    @NotNull
    public AndroidVersion getMinSdkVersionForDexing() {
        return this.getConfig().getMinSdkVersion();
    }

    @Nullable
    public final Renderscript renderscript(@NotNull VariantPropertiesApiServices internalServices) {
        Renderscript renderscript2;
        Intrinsics.checkNotNullParameter((Object)internalServices, (String)"internalServices");
        if (this.getConfig().getBuildFeatures().getRenderScript()) {
            Renderscript renderscript3 = internalServices.newInstance(Renderscript.class, new Object[0]);
            boolean bl = false;
            boolean bl2 = false;
            Renderscript it = renderscript3;
            boolean bl3 = false;
            it.getSupportModeEnabled().set((Object)this.getVariantDslInfo().getRenderscriptSupportModeEnabled());
            it.getSupportModeBlasEnabled().set((Object)this.getVariantDslInfo().getRenderscriptSupportModeBlasEnabled());
            it.getNdkModeEnabled().set((Object)this.getVariantDslInfo().getRenderscriptNdkModeEnabled());
            it.getOptimLevel().set((Object)this.getVariantDslInfo().getRenderscriptOptimLevel());
            renderscript2 = renderscript3;
        } else {
            renderscript2 = null;
        }
        return renderscript2;
    }
}

