/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.variant.impl;

import com.android.build.api.artifact.Artifact;
import com.android.build.gradle.internal.api.artifact.ArtifactTypeUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/build/api/variant/impl/ArtifactTypeTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/build/api/artifact/Artifact;", "()V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "gradle-core"})
public final class ArtifactTypeTypeAdapter
extends TypeAdapter<Artifact<?>> {
    public void write(@NotNull JsonWriter out, @NotNull Artifact<?> value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        out.beginObject();
        out.name("type").value(value.name());
        out.name("kind").value(value.getKind().dataType().getSimpleName());
        out.endObject();
    }

    @NotNull
    public Artifact<?> read(@NotNull JsonReader reader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        reader.beginObject();
        Artifact<?> artifactType = null;
        while (reader.hasNext()) {
            String string = reader.nextName();
            if (Intrinsics.areEqual((Object)string, (Object)"type")) {
                String string2 = reader.nextString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reader.nextString()");
                artifactType = ArtifactTypeUtils.toArtifactType(string2);
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"kind")) continue;
            reader.nextString();
        }
        reader.endObject();
        if (artifactType == null) {
            throw new IOException("Invalid artifact type declaration");
        }
        return artifactType;
    }
}

