/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.build;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a8\u0006\u0005"}, d2={"hardLinkOrCopy", "", "source", "Ljava/io/File;", "destination", "gradle-core"})
public final class CxxRegularBuilderKt {
    public static final void hardLinkOrCopy(@NotNull File source, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (FileUtils.isSameFile((File)source, (File)destination)) {
            return;
        }
        Files.deleteIfExists(destination.toPath());
        if (!source.exists()) {
            return;
        }
        try {
            Files.createLink(destination.toPath(), source.toPath().toRealPath(new LinkOption[0]));
            LoggingEnvironmentKt.infoln("linked " + source + " to " + destination, new Object[0]);
        }
        catch (IOException e) {
            com.google.common.io.Files.copy((File)source, (File)destination);
            LoggingEnvironmentKt.infoln("copied " + source + " to " + destination, new Object[0]);
        }
    }
}

