/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CmakeProperty;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.configure.CxxConfigurationFolding;
import com.android.build.gradle.internal.cxx.configure.CxxConfigurationFoldingKt;
import com.android.build.gradle.internal.cxx.configure.NdkBuildProperty;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.tasks.NativeBuildSystem;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010%\u001a\u00020\b2\u0010\u0010&\u001a\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018H\u0002J@\u0010'\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\u000e2\u0010\u0010(\u001a\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u00182\u0010\u0010)\u001a\f\u0012\u0004\u0012\u00020\b0\u0019j\u0002`\u001aH\u0002J\u001a\u0010*\u001a\u00020\b2\u0010\u0010&\u001a\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018H\u0002J.\u0010+\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\u000e2\u0010\u0010(\u001a\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018H\u0002J\u001c\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00042\n\u0010/\u001a\u00060\bj\u0002`\tH\u0002J\u0014\u00100\u001a\u00060\bj\u0002`\t2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0002J\u001a\u00103\u001a\u00020\b2\u0010\u00104\u001a\f\u0012\u0004\u0012\u00020\b0\u0019j\u0002`\u001aH\u0002J\u001a\u00105\u001a\u00020\b2\u0010\u0010(\u001a\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018H\u0002J\u0010\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\bH\u0002J0\u00108\u001a\u00020-*\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\u00040\u00072\n\u00109\u001a\u00060\bj\u0002`\t2\u0006\u0010.\u001a\u00020\u0004H\u0002R!\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR+\u0010\f\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R+\u0010\u0011\u001a\u001c\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\t0\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0017\u001a2\u0012$\u0012\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0019j\u0002`\u001a0\u000e\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001b\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000bR+\u0010\u001d\u001a\u001c\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\t0\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000bR(\u0010\u001f\u001a\u001c\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010!\u001a\u001c\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\t0\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000bR+\u0010#\u001a\u001c\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\t0\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000b\u00a8\u0006:"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/CxxConfigurationFolding;", "", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "(Ljava/util/List;)V", "buildAbis", "", "", "Lcom/android/build/gradle/internal/cxx/configure/TaskName;", "getBuildAbis", "()Ljava/util/Map;", "buildConfigureEdges", "", "Lkotlin/Pair;", "getBuildConfigureEdges", "()Ljava/util/Set;", "buildGroups", "Lcom/android/build/gradle/internal/cxx/configure/VariantName;", "getBuildGroups", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "buildSystemName", "builders", "Lcom/android/build/gradle/internal/cxx/configure/Configuration;", "", "Lcom/android/build/gradle/internal/cxx/configure/Targets;", "configureAbis", "getConfigureAbis", "configureGroups", "getConfigureGroups", "configurers", "namesSeen", "variantToBuild", "getVariantToBuild", "variantToConfiguration", "getVariantToConfiguration", "abiOf", "commands", "buildTaskNameOf", "configuration", "targets", "buildTypeOf", "configureTaskNameOf", "createBuildTask", "", "abi", "configureTaskName", "createConfigurationTask", "legalize", "name", "targetAnnotation", "unsorted", "taskNameAnnotation", "uniquify", "base", "setRepresentativeAbiForTask", "taskName", "gradle-core"})
public final class CxxConfigurationFolding {
    @NotNull
    private final Map<List<String>, String> configurers;
    @NotNull
    private final Map<Pair<List<String>, Set<String>>, String> builders;
    @NotNull
    private final Set<String> namesSeen;
    @NotNull
    private final NativeBuildSystem buildSystem;
    @NotNull
    private final String buildSystemName;
    @NotNull
    private final Map<String, CxxAbiModel> configureAbis;
    @NotNull
    private final Map<String, Set<String>> configureGroups;
    @NotNull
    private final Map<String, CxxAbiModel> buildAbis;
    @NotNull
    private final Map<String, Set<String>> buildGroups;
    @NotNull
    private final Map<String, Set<String>> variantToConfiguration;
    @NotNull
    private final Map<String, Set<String>> variantToBuild;
    @NotNull
    private final Set<Pair<String, String>> buildConfigureEdges;

    public CxxConfigurationFolding(@NotNull List<CxxAbiModel> abis2) {
        String string;
        Intrinsics.checkNotNullParameter(abis2, (String)"abis");
        boolean bl = false;
        this.configurers = new LinkedHashMap();
        bl = false;
        this.builders = new LinkedHashMap();
        bl = false;
        this.namesSeen = new LinkedHashSet();
        NativeBuildSystem nativeBuildSystem = this.buildSystem = ((CxxAbiModel)CollectionsKt.first(abis2)).getVariant().getModule().getBuildSystem();
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                string = "CMake";
                break;
            }
            case 2: {
                string = "NdkBuild";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.buildSystemName = string;
        boolean bl2 = false;
        this.configureAbis = new LinkedHashMap();
        bl2 = false;
        this.configureGroups = new LinkedHashMap();
        bl2 = false;
        this.buildAbis = new LinkedHashMap();
        bl2 = false;
        this.buildGroups = new LinkedHashMap();
        bl2 = false;
        this.variantToConfiguration = new LinkedHashMap();
        bl2 = false;
        this.variantToBuild = new LinkedHashMap();
        bl2 = false;
        this.buildConfigureEdges = new LinkedHashSet();
        for (CxxAbiModel abi : abis2) {
            if (!abi.isActiveAbi()) continue;
            String configureTaskName = this.createConfigurationTask(abi);
            this.createBuildTask(abi, configureTaskName);
        }
    }

    @NotNull
    public final Map<String, CxxAbiModel> getConfigureAbis() {
        return this.configureAbis;
    }

    @NotNull
    public final Map<String, Set<String>> getConfigureGroups() {
        return this.configureGroups;
    }

    @NotNull
    public final Map<String, CxxAbiModel> getBuildAbis() {
        return this.buildAbis;
    }

    @NotNull
    public final Map<String, Set<String>> getBuildGroups() {
        return this.buildGroups;
    }

    @NotNull
    public final Map<String, Set<String>> getVariantToConfiguration() {
        return this.variantToConfiguration;
    }

    @NotNull
    public final Map<String, Set<String>> getVariantToBuild() {
        return this.variantToBuild;
    }

    @NotNull
    public final Set<Pair<String, String>> getBuildConfigureEdges() {
        return this.buildConfigureEdges;
    }

    private final String createConfigurationTask(CxxAbiModel abi) {
        Pair<String, String> pair = this.configureTaskNameOf(abi.getConfigurationArguments());
        String groupTaskName = (String)pair.component1();
        String configureTaskName = (String)pair.component2();
        this.setRepresentativeAbiForTask(this.configureAbis, configureTaskName, abi);
        this.configureGroups.computeIfAbsent(groupTaskName, createConfigurationTask.1.INSTANCE).add(configureTaskName);
        this.variantToConfiguration.computeIfAbsent(abi.getVariant().getVariantName(), createConfigurationTask.2.INSTANCE).add(configureTaskName);
        return configureTaskName;
    }

    private final void createBuildTask(CxxAbiModel abi, String configureTaskName) {
        Pair<String, String> pair = this.buildTaskNameOf(abi.getConfigurationArguments(), abi.getVariant().getBuildTargetSet());
        String groupTaskName = (String)pair.component1();
        String buildTaskName = (String)pair.component2();
        this.setRepresentativeAbiForTask(this.buildAbis, buildTaskName, abi);
        CxxConfigurationFolding cxxConfigurationFolding = this;
        Collection collection = cxxConfigurationFolding.buildConfigureEdges;
        Pair pair2 = TuplesKt.to((Object)buildTaskName, (Object)configureTaskName);
        boolean bl = false;
        collection.add(pair2);
        this.buildGroups.computeIfAbsent(groupTaskName, createBuildTask.1.INSTANCE).add(buildTaskName);
        this.variantToBuild.computeIfAbsent(abi.getVariant().getVariantName(), createBuildTask.2.INSTANCE).add(buildTaskName);
    }

    private final String legalize(String name) {
        String result2 = name;
        Character[] characterArray = CxxConfigurationFoldingKt.access$getIllegalGradleTaskChars$p();
        int n = characterArray.length;
        for (int j = 0; j < n; ++j) {
            char ch = characterArray[j].charValue();
            if (!StringsKt.contains$default((CharSequence)result2, (char)ch, (boolean)false, (int)2, null)) continue;
            result2 = StringsKt.replace$default((String)result2, (char)ch, (char)'_', (boolean)false, (int)4, null);
        }
        return result2;
    }

    private final String uniquify(String base) {
        String name = base;
        int index = 1;
        while (this.namesSeen.contains(name)) {
            int n = index;
            index = n + 1;
            name = base + '-' + index;
        }
        CxxConfigurationFolding cxxConfigurationFolding = this;
        Collection collection = cxxConfigurationFolding.namesSeen;
        boolean bl = false;
        collection.add(name);
        return name;
    }

    private final String abiOf(List<String> commands) {
        String string;
        NativeBuildSystem nativeBuildSystem = this.buildSystem;
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                List<CommandLineArgument> arguments = BuildSystemCommandLineKt.toCmakeArguments(commands);
                String string2 = BuildSystemCommandLineKt.getCmakeProperty(arguments, CmakeProperty.CMAKE_ANDROID_ARCH_ABI);
                if (string2 == null) {
                    string = "";
                    break;
                }
                string = string2;
                break;
            }
            case 2: {
                List<CommandLineArgument> arguments = BuildSystemCommandLineKt.toNdkBuildArguments(commands);
                String string3 = BuildSystemCommandLineKt.getNdkBuildProperty(arguments, NdkBuildProperty.APP_ABI);
                if (string3 == null) {
                    string = "";
                    break;
                }
                string = string3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String buildTypeOf(List<String> commands) {
        String string;
        NativeBuildSystem nativeBuildSystem = this.buildSystem;
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                List<CommandLineArgument> arguments = BuildSystemCommandLineKt.toCmakeArguments(commands);
                String string2 = BuildSystemCommandLineKt.getCmakeProperty(arguments, CmakeProperty.CMAKE_BUILD_TYPE);
                if (string2 == null) {
                    string = "";
                    break;
                }
                string = string2;
                break;
            }
            case 2: {
                String string3;
                List<CommandLineArgument> arguments = BuildSystemCommandLineKt.toNdkBuildArguments(commands);
                String string4 = BuildSystemCommandLineKt.getNdkBuildProperty(arguments, NdkBuildProperty.NDK_DEBUG);
                if (string4 == null) {
                    string = "";
                    break;
                }
                String string5 = string4;
                boolean bl = false;
                boolean bl2 = false;
                String it = string5;
                boolean bl3 = false;
                string = string3 = Intrinsics.areEqual((Object)it, (Object)"1") ? "Debug" : "Release";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String targetAnnotation(Set<String> unsorted) {
        List targets = CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)unsorted));
        return targets.isEmpty() ? "" : (targets.size() == 1 ? '[' + (String)targets.get(0) + ']' : (targets.size() == 2 ? '[' + (String)targets.get(0) + ',' + (String)targets.get(1) + ']' : '[' + (String)targets.get(0) + ',' + (String)targets.get(1) + ",etc]"));
    }

    private final String taskNameAnnotation(List<String> configuration) {
        String buildType = this.buildTypeOf(configuration);
        return Intrinsics.stringPlus((String)this.buildSystemName, (Object)buildType);
    }

    private final Pair<String, String> configureTaskNameOf(List<String> configuration) {
        String annotation = this.taskNameAnnotation(configuration);
        String groupTaskName = Intrinsics.stringPlus((String)"configure", (Object)annotation);
        String string = this.configurers.computeIfAbsent(configuration, (Function<List<String>, String>)new Function<List<? extends String>, String>(this, configuration, groupTaskName){
            final /* synthetic */ CxxConfigurationFolding this$0;
            final /* synthetic */ List<String> $configuration;
            final /* synthetic */ String $groupTaskName;
            {
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                this.$groupTaskName = $groupTaskName;
            }

            @NotNull
            public final String apply(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String abi = CxxConfigurationFolding.access$abiOf(this.this$0, this.$configuration);
                return CxxConfigurationFolding.access$uniquify(this.this$0, CxxConfigurationFolding.access$legalize(this.this$0, this.$groupTaskName + '[' + abi + ']'));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"private fun configureTaskNameOf(configuration: Configuration) : Pair<TaskName, TaskName> {\n        val annotation = taskNameAnnotation(configuration)\n        val groupTaskName = \"configure$annotation\"\n        return groupTaskName to configurers.computeIfAbsent(configuration) {\n            val abi = abiOf(configuration)\n            uniquify(legalize(\"$groupTaskName[$abi]\"))\n        }\n    }");
        return TuplesKt.to((Object)groupTaskName, (Object)string);
    }

    private final Pair<String, String> buildTaskNameOf(List<String> configuration, Set<String> targets) {
        String annotation = this.taskNameAnnotation(configuration);
        String groupTaskName = Intrinsics.stringPlus((String)"build", (Object)annotation);
        String string = this.builders.computeIfAbsent((Pair<List<String>, Set<String>>)TuplesKt.to(configuration, targets), (Function<Pair<List<String>, Set<String>>, String>)new Function<Pair<? extends List<? extends String>, ? extends Set<? extends String>>, String>(this, configuration, targets, groupTaskName){
            final /* synthetic */ CxxConfigurationFolding this$0;
            final /* synthetic */ List<String> $configuration;
            final /* synthetic */ Set<String> $targets;
            final /* synthetic */ String $groupTaskName;
            {
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                this.$targets = $targets;
                this.$groupTaskName = $groupTaskName;
            }

            @NotNull
            public final String apply(@NotNull Pair<? extends List<String>, ? extends Set<String>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String abi = CxxConfigurationFolding.access$abiOf(this.this$0, this.$configuration);
                String targetAnnotation = CxxConfigurationFolding.access$targetAnnotation(this.this$0, this.$targets);
                return CxxConfigurationFolding.access$uniquify(this.this$0, CxxConfigurationFolding.access$legalize(this.this$0, this.$groupTaskName + '[' + abi + ']' + targetAnnotation));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"private fun buildTaskNameOf(configuration: Configuration, targets: Targets)\n            : Pair<TaskName, TaskName> {\n        val annotation = taskNameAnnotation(configuration)\n        val groupTaskName = \"build$annotation\"\n        return groupTaskName to builders.computeIfAbsent(configuration to targets) {\n            val abi = abiOf(configuration)\n            val targetAnnotation = targetAnnotation(targets)\n            uniquify(legalize(\"$groupTaskName[$abi]$targetAnnotation\"))\n        }\n    }");
        return TuplesKt.to((Object)groupTaskName, (Object)string);
    }

    private final void setRepresentativeAbiForTask(Map<String, CxxAbiModel> $this$setRepresentativeAbiForTask, String taskName, CxxAbiModel abi) {
        Map<String, CxxAbiModel> map = $this$setRepresentativeAbiForTask;
        CxxAbiModel prior = map.get(taskName);
        if (prior == null) {
            Map<String, CxxAbiModel> map2 = map;
            boolean bl = false;
            map2.put(taskName, abi);
        } else {
            if (prior.getAbi() != abi.getAbi()) {
                String string = "Expected " + (Object)((Object)prior.getAbi()) + " but got " + (Object)((Object)abi.getAbi());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (!Intrinsics.areEqual(prior.getConfigurationArguments(), abi.getConfigurationArguments())) {
                String string = "Expected same configuration arguments";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }

    public static final /* synthetic */ String access$abiOf(CxxConfigurationFolding $this, List commands) {
        return $this.abiOf(commands);
    }

    public static final /* synthetic */ String access$uniquify(CxxConfigurationFolding $this, String base) {
        return $this.uniquify(base);
    }

    public static final /* synthetic */ String access$legalize(CxxConfigurationFolding $this, String name) {
        return $this.legalize(name);
    }

    public static final /* synthetic */ String access$targetAnnotation(CxxConfigurationFolding $this, Set unsorted) {
        return $this.targetAnnotation(unsorted);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            nArray[NativeBuildSystem.CMAKE.ordinal()] = 1;
            nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

