/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.Ndk;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.utils.HelpfulEnumConverter;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class NdkOptions
implements CoreNdkOptions,
Serializable,
Ndk {
    private static final long serialVersionUID = 1L;
    public static final HelpfulEnumConverter<DebugSymbolLevel> DEBUG_SYMBOL_LEVEL_CONVERTER = new HelpfulEnumConverter(DebugSymbolLevel.class);
    private String moduleName;
    private String cFlags;
    private List<String> ldLibs;
    private final Set<String> abiFilters = new HashSet<String>(0);
    private String stl;
    private Integer jobs;
    private DebugSymbolLevel debugSymbolLevel;

    public void _initWith(CoreNdkOptions ndkConfig) {
        this.moduleName = ndkConfig.getModuleName();
        this.cFlags = ndkConfig.getcFlags();
        this.setLdLibs(ndkConfig.getLdLibs());
        this.setAbiFilters(ndkConfig.getAbiFilters());
    }

    @Override
    @Input
    @Optional
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    @Input
    @Optional
    public String getcFlags() {
        return this.cFlags;
    }

    public void setcFlags(String cFlags) {
        this.cFlags = cFlags;
    }

    public void setCFlags(String cFlags) {
        this.cFlags = cFlags;
    }

    public String getCFlags() {
        return this.cFlags;
    }

    @Override
    @Input
    @Optional
    public List<String> getLdLibs() {
        return this.ldLibs;
    }

    public NdkOptions ldLibs(String lib) {
        if (this.ldLibs == null) {
            this.ldLibs = Lists.newArrayList();
        }
        this.ldLibs.add(lib);
        return this;
    }

    public NdkOptions ldLibs(String ... libs) {
        if (this.ldLibs == null) {
            this.ldLibs = Lists.newArrayListWithCapacity((int)libs.length);
        }
        Collections.addAll(this.ldLibs, libs);
        return this;
    }

    public NdkOptions setLdLibs(Collection<String> libs) {
        if (libs != null) {
            if (this.ldLibs == null) {
                this.ldLibs = Lists.newArrayListWithCapacity((int)libs.size());
            } else {
                this.ldLibs.clear();
            }
            this.ldLibs.addAll(libs);
        } else {
            this.ldLibs = null;
        }
        return this;
    }

    @Override
    @Input
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public NdkOptions abiFilter(String filter2) {
        this.abiFilters.add(filter2);
        return this;
    }

    public NdkOptions abiFilters(String ... filters) {
        Collections.addAll(this.abiFilters, filters);
        return this;
    }

    public NdkOptions setAbiFilters(Collection<String> filters) {
        this.abiFilters.clear();
        if (filters != null) {
            this.abiFilters.addAll(filters);
        }
        return this;
    }

    @Override
    public String getStl() {
        return this.stl;
    }

    public void setStl(String stl2) {
        this.stl = stl2;
    }

    @Override
    public Integer getJobs() {
        return this.jobs;
    }

    public void setJobs(Integer jobs) {
        this.jobs = jobs;
    }

    @Override
    public String getDebugSymbolLevel() {
        if (this.debugSymbolLevel == null) {
            return null;
        }
        return (String)Verify.verifyNotNull((Object)((String)DEBUG_SYMBOL_LEVEL_CONVERTER.reverse().convert((Object)this.debugSymbolLevel)), (String)"No string representation for enum.", (Object[])new Object[0]);
    }

    public void setDebugSymbolLevel(String debugSymbolLevel) {
        this.debugSymbolLevel = (DebugSymbolLevel)((Object)DEBUG_SYMBOL_LEVEL_CONVERTER.convert((Object)debugSymbolLevel));
    }

    public static enum DebugSymbolLevel {
        FULL,
        SYMBOL_TABLE,
        NONE;

    }
}

