/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.AvdManager;
import com.android.build.gradle.internal.AvdSnapshotHandler;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.Revision;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002#$B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019J\u0014\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u000e\u0010\"\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0019R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/provider/ProviderFactory;)V", "avdFolder", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getAvdFolder", "()Lorg/gradle/api/provider/Provider;", "avdManager", "Lcom/android/build/gradle/internal/AvdManager;", "getAvdManager", "()Lcom/android/build/gradle/internal/AvdManager;", "avdManager$delegate", "Lkotlin/Lazy;", "emulatorDirectory", "getEmulatorDirectory", "logger", "Lcom/android/utils/ILogger;", "allAvds", "", "", "avdProvider", "imageProvider", "imageHash", "deviceName", "hardwareProfile", "deleteAvds", "", "avds", "ensureLoadableSnapshot", "Parameters", "RegistrationAction", "gradle-core"})
public abstract class AvdComponentsBuildService
implements BuildService<Parameters> {
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ProviderFactory providerFactory;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Lazy avdManager$delegate;
    @NotNull
    private final Provider<Directory> avdFolder;
    @NotNull
    private final Provider<Directory> emulatorDirectory;

    @Inject
    public AvdComponentsBuildService(@NotNull ObjectFactory objectFactory, @NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(AvdComponentsBuildService.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(AvdComponentsBuildService::class.java)");
        this.logger = loggerWrapper;
        this.avdManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AvdManager>(this){
            final /* synthetic */ AvdComponentsBuildService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AvdManager invoke() {
                AndroidLocationsBuildService locationsService = (AndroidLocationsBuildService)((Parameters)this.this$0.getParameters()).getAndroidLocationsService().get();
                File file = ((Directory)((Parameters)this.this$0.getParameters()).getAvdLocation().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.avdLocation.get().asFile");
                File file2 = file;
                file = ((Parameters)this.this$0.getParameters()).getSdkService().map((Transformer)new Transformer<SdkComponentsBuildService.VersionedSdkLoader, SdkComponentsBuildService>(this.this$0){
                    final /* synthetic */ AvdComponentsBuildService this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final SdkComponentsBuildService.VersionedSdkLoader transform(SdkComponentsBuildService it) {
                        return it.sdkLoader((Provider<String>)((Provider)((Parameters)this.this$0.getParameters()).getCompileSdkVersion()), (Provider<Revision>)((Provider)((Parameters)this.this$0.getParameters()).getBuildToolsRevision()));
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"abstract class AvdComponentsBuildService @Inject constructor(\n    private val objectFactory: ObjectFactory,\n    private val providerFactory: ProviderFactory\n) :\n        BuildService<AvdComponentsBuildService.Parameters> {\n\n    private val logger: ILogger = LoggerWrapper.getLogger(AvdComponentsBuildService::class.java)\n\n    interface Parameters : BuildServiceParameters {\n        val sdkService: Property<SdkComponentsBuildService>\n        val compileSdkVersion: Property<String>\n        val buildToolsRevision: Property<Revision>\n        val androidLocationsService: Property<AndroidLocationsBuildService>\n        val avdLocation: DirectoryProperty\n    }\n\n    private val avdManager: AvdManager by lazy {\n        val locationsService = parameters.androidLocationsService.get()\n        AvdManager(\n            parameters.avdLocation.get().asFile,\n            parameters.sdkService.map {\n                it.sdkLoader(parameters.compileSdkVersion, parameters.buildToolsRevision)\n            },\n            AndroidSdkHandler.getInstance(\n                locationsService,\n                parameters.sdkService.get().sdkDirectoryProvider.get().asFile.toPath()\n            ),\n            locationsService,\n            AvdSnapshotHandler()\n        )\n    }\n\n    /**\n     * Returns the location of the shared avd folder.\n     */\n    val avdFolder: Provider<Directory> = parameters.avdLocation\n\n    /**\n     * Returns the location of the emulator.\n     */\n    val emulatorDirectory: Provider<Directory> =\n        parameters.sdkService.flatMap {\n            it.sdkLoader(\n                parameters.compileSdkVersion,\n                parameters.buildToolsRevision).emulatorDirectoryProvider\n        }\n\n    /**\n     * Returns the names of all avds currently in the shared avd folder.\n     */\n    fun allAvds(): List<String> = avdManager.allAvds()\n\n    /**\n     * Removes all the specified avds.\n     *\n     * This will delete the specified avds from the shared avd folder and update the avd cache.\n     *\n     * @param avds names of the avds to be deleted.\n     */\n    fun deleteAvds(avds: List<String>) {\n        avdManager.deleteAvds(avds)\n    }\n\n    fun avdProvider(\n        imageProvider: Provider<Directory>,\n        imageHash: String,\n        deviceName: String,\n        hardwareProfile: String\n    ): Provider<Directory> =\n        objectFactory.directoryProperty().fileProvider(providerFactory.provider {\n            avdManager.createOrRetrieveAvd(imageProvider, imageHash, deviceName, hardwareProfile)\n        })\n\n    /**\n     * Ensures that a given AVD has a loadable snapshot for the current emulator version.\n     *\n     * Checks to make sure the default_boot snapshot on a given avd is loadable with the current\n     * emulator version. If not, a new snapshot is created which will replace any old snapshot if\n     * it existed.\n     *\n     * If a snapshot fails to be created, an error is thrown.\n     *\n     * @param deviceName The name of the avd to check. This avd should have already been created via\n     * a call to get() on the provider returned by [avdProvider].\n     */\n    fun ensureLoadableSnapshot(deviceName: String) {\n        avdManager.loadSnapshotIfNeeded(deviceName)\n    }\n\n    class RegistrationAction(\n        project: Project,\n        private val avdFolderLocation: Provider<Directory>,\n        private val sdkService: Provider<SdkComponentsBuildService>,\n        private val compileSdkVersion: Provider<String>,\n        private val buildToolsRevision: Provider<Revision>\n    ) : ServiceRegistrationAction<AvdComponentsBuildService, Parameters>(\n        project,\n        AvdComponentsBuildService::class.java\n    ) {\n\n        override fun configure(parameters: Parameters) {\n            parameters.avdLocation.set(avdFolderLocation)\n            parameters.sdkService.set(sdkService)\n            parameters.compileSdkVersion.set(compileSdkVersion)\n            parameters.buildToolsRevision.set(buildToolsRevision)\n            parameters.sdkService.set(getBuildService(project.gradle.sharedServices))\n            parameters.androidLocationsService.set(getBuildService(project.gradle.sharedServices))\n        }\n    }\n\n}");
                File file3 = file;
                file = AndroidSdkHandler.getInstance((AndroidLocationsProvider)locationsService, (Path)((Directory)((SdkComponentsBuildService)((Parameters)this.this$0.getParameters()).getSdkService().get()).getSdkDirectoryProvider().get()).getAsFile().toPath());
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getInstance(\n                locationsService,\n                parameters.sdkService.get().sdkDirectoryProvider.get().asFile.toPath()\n            )");
                Intrinsics.checkNotNullExpressionValue((Object)locationsService, (String)"locationsService");
                return new AvdManager(file2, (Provider<SdkComponentsBuildService.VersionedSdkLoader>)file3, (AndroidSdkHandler)file, locationsService, new AvdSnapshotHandler(null, 1, null));
            }
        }));
        this.avdFolder = (Provider)((Parameters)this.getParameters()).getAvdLocation();
        loggerWrapper = ((Parameters)this.getParameters()).getSdkService().flatMap((Transformer)new Transformer<Provider<? extends Directory>, SdkComponentsBuildService>(this){
            final /* synthetic */ AvdComponentsBuildService this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends Directory> transform(SdkComponentsBuildService it) {
                return it.sdkLoader((Provider<String>)((Provider)((Parameters)this.this$0.getParameters()).getCompileSdkVersion()), (Provider<Revision>)((Provider)((Parameters)this.this$0.getParameters()).getBuildToolsRevision())).getEmulatorDirectoryProvider();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"parameters.sdkService.flatMap {\n            it.sdkLoader(\n                parameters.compileSdkVersion,\n                parameters.buildToolsRevision).emulatorDirectoryProvider\n        }");
        this.emulatorDirectory = loggerWrapper;
    }

    private final AvdManager getAvdManager() {
        Lazy lazy = this.avdManager$delegate;
        boolean bl = false;
        return (AvdManager)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getAvdFolder() {
        return this.avdFolder;
    }

    @NotNull
    public final Provider<Directory> getEmulatorDirectory() {
        return this.emulatorDirectory;
    }

    @NotNull
    public final List<String> allAvds() {
        return this.getAvdManager().allAvds();
    }

    public final void deleteAvds(@NotNull List<String> avds) {
        Intrinsics.checkNotNullParameter(avds, (String)"avds");
        this.getAvdManager().deleteAvds(avds);
    }

    @NotNull
    public final Provider<Directory> avdProvider(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Intrinsics.checkNotNullParameter(imageProvider, (String)"imageProvider");
        Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
        DirectoryProperty directoryProperty = this.objectFactory.directoryProperty().fileProvider(this.providerFactory.provider((Callable)new Callable<File>(this, imageProvider, imageHash, deviceName, hardwareProfile){
            final /* synthetic */ AvdComponentsBuildService this$0;
            final /* synthetic */ Provider<Directory> $imageProvider;
            final /* synthetic */ String $imageHash;
            final /* synthetic */ String $deviceName;
            final /* synthetic */ String $hardwareProfile;
            {
                this.this$0 = $receiver;
                this.$imageProvider = $imageProvider;
                this.$imageHash = $imageHash;
                this.$deviceName = $deviceName;
                this.$hardwareProfile = $hardwareProfile;
            }

            public final File call() {
                return AvdComponentsBuildService.access$getAvdManager(this.this$0).createOrRetrieveAvd(this.$imageProvider, this.$imageHash, this.$deviceName, this.$hardwareProfile);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"fun avdProvider(\n        imageProvider: Provider<Directory>,\n        imageHash: String,\n        deviceName: String,\n        hardwareProfile: String\n    ): Provider<Directory> =\n        objectFactory.directoryProperty().fileProvider(providerFactory.provider {\n            avdManager.createOrRetrieveAvd(imageProvider, imageHash, deviceName, hardwareProfile)\n        })");
        return (Provider)directoryProperty;
    }

    public final void ensureLoadableSnapshot(@NotNull String deviceName) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        this.getAvdManager().loadSnapshotIfNeeded(deviceName);
    }

    public static final /* synthetic */ AvdManager access$getAvdManager(AvdComponentsBuildService $this) {
        return $this.getAvdManager();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "androidLocationsService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/AndroidLocationsBuildService;", "getAndroidLocationsService", "()Lorg/gradle/api/provider/Property;", "avdLocation", "Lorg/gradle/api/file/DirectoryProperty;", "getAvdLocation", "()Lorg/gradle/api/file/DirectoryProperty;", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "compileSdkVersion", "", "getCompileSdkVersion", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "gradle-core"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<SdkComponentsBuildService> getSdkService();

        @NotNull
        public Property<String> getCompileSdkVersion();

        @NotNull
        public Property<Revision> getBuildToolsRevision();

        @NotNull
        public Property<AndroidLocationsBuildService> getAndroidLocationsService();

        @NotNull
        public DirectoryProperty getAvdLocation();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "avdFolderLocation", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "compileSdkVersion", "", "buildToolsRevision", "Lcom/android/repository/Revision;", "(Lorg/gradle/api/Project;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<AvdComponentsBuildService, Parameters> {
        @NotNull
        private final Provider<Directory> avdFolderLocation;
        @NotNull
        private final Provider<SdkComponentsBuildService> sdkService;
        @NotNull
        private final Provider<String> compileSdkVersion;
        @NotNull
        private final Provider<Revision> buildToolsRevision;

        public RegistrationAction(@NotNull Project project2, @NotNull Provider<Directory> avdFolderLocation, @NotNull Provider<SdkComponentsBuildService> sdkService, @NotNull Provider<String> compileSdkVersion, @NotNull Provider<Revision> buildToolsRevision) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(avdFolderLocation, (String)"avdFolderLocation");
            Intrinsics.checkNotNullParameter(sdkService, (String)"sdkService");
            Intrinsics.checkNotNullParameter(compileSdkVersion, (String)"compileSdkVersion");
            Intrinsics.checkNotNullParameter(buildToolsRevision, (String)"buildToolsRevision");
            super(project2, AvdComponentsBuildService.class, null, 4, null);
            this.avdFolderLocation = avdFolderLocation;
            this.sdkService = sdkService;
            this.compileSdkVersion = compileSdkVersion;
            this.buildToolsRevision = buildToolsRevision;
        }

        @Override
        public void configure(@NotNull Parameters parameters) {
            BuildServiceRegistry buildServiceRegistry$iv;
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            parameters.getAvdLocation().set(this.avdFolderLocation);
            parameters.getSdkService().set(this.sdkService);
            parameters.getCompileSdkVersion().set(this.compileSdkVersion);
            parameters.getBuildToolsRevision().set(this.buildToolsRevision);
            Property<SdkComponentsBuildService> property = parameters.getSdkService();
            BuildServiceRegistry buildServiceRegistry = this.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
            boolean $i$f$getBuildService = false;
            Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(SdkComponentsBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            Provider provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
            property.set(provider2);
            Property<AndroidLocationsBuildService> property2 = parameters.getAndroidLocationsService();
            buildServiceRegistry$iv = this.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry$iv, (String)"project.gradle.sharedServices");
            $i$f$getBuildService = false;
            object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AndroidLocationsBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
            property2.set(provider2);
        }
    }
}

