/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.cxx.configure.NdkLocator;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkInstallStatus;
import com.android.build.gradle.internal.ndk.NdkPlatform;
import com.android.build.gradle.internal.ndk.NdkR14Info;
import com.android.build.gradle.internal.ndk.NdkR17Info;
import com.android.build.gradle.internal.ndk.NdkR18Info;
import com.android.build.gradle.internal.ndk.NdkR19Info;
import com.android.build.gradle.internal.ndk.NdkR21Info;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler;", "", "ndkLocator", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocator;", "compileSdkVersion", "", "(Lcom/android/build/gradle/internal/cxx/configure/NdkLocator;Ljava/lang/String;)V", "ndkInstallStatus", "Lcom/android/build/gradle/internal/ndk/NdkInstallStatus;", "ndkPlatform", "getNdkPlatform", "()Lcom/android/build/gradle/internal/ndk/NdkInstallStatus;", "getNdkInfo", "Lcom/android/build/gradle/internal/ndk/DefaultNdkInfo;", "ndk", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "downloadOkay", "", "getNdkStatus", "gradle-core"})
public class NdkHandler {
    @NotNull
    private final NdkLocator ndkLocator;
    @NotNull
    private final String compileSdkVersion;
    @Nullable
    private NdkInstallStatus ndkInstallStatus;

    public NdkHandler(@NotNull NdkLocator ndkLocator, @NotNull String compileSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)ndkLocator, (String)"ndkLocator");
        Intrinsics.checkNotNullParameter((Object)compileSdkVersion, (String)"compileSdkVersion");
        this.ndkLocator = ndkLocator;
        this.compileSdkVersion = compileSdkVersion;
    }

    private final DefaultNdkInfo getNdkInfo(NdkLocatorRecord ndk) {
        return ndk.getRevision().getMajor() >= 21 ? (DefaultNdkInfo)new NdkR21Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 19 ? (DefaultNdkInfo)new NdkR19Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 18 ? (DefaultNdkInfo)new NdkR18Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 17 ? (DefaultNdkInfo)new NdkR17Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 14 ? (DefaultNdkInfo)new NdkR14Info(ndk.getNdk()) : new DefaultNdkInfo(ndk.getNdk())))));
    }

    private final NdkInstallStatus getNdkStatus(boolean downloadOkay) {
        NdkLocatorRecord ndkLocatorRecord = this.ndkLocator.findNdkPath(downloadOkay);
        if (ndkLocatorRecord == null) {
            return NdkInstallStatus.NotInstalled.INSTANCE;
        }
        NdkLocatorRecord ndk = ndkLocatorRecord;
        DefaultNdkInfo ndkInfo = this.getNdkInfo(ndk);
        String error = ndkInfo.validate();
        if (error != null) {
            return new NdkInstallStatus.Invalid(error);
        }
        return new NdkInstallStatus.Valid(new NdkPlatform(ndk.getNdk(), ndkInfo, ndk.getRevision(), this.compileSdkVersion));
    }

    @NotNull
    public final NdkInstallStatus getNdkPlatform(boolean downloadOkay) {
        if (this.ndkInstallStatus == null || downloadOkay && Intrinsics.areEqual((Object)this.ndkInstallStatus, (Object)NdkInstallStatus.NotInstalled.INSTANCE)) {
            this.ndkInstallStatus = this.getNdkStatus(downloadOkay);
        }
        NdkInstallStatus ndkInstallStatus = this.ndkInstallStatus;
        Intrinsics.checkNotNull((Object)ndkInstallStatus);
        return ndkInstallStatus;
    }

    @NotNull
    public final NdkInstallStatus getNdkPlatform() {
        return this.getNdkPlatform(false);
    }
}

