/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a8\u0006\f"}, d2={"populateAssetPacksConfigurations", "", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "assetPacks", "", "", "assetPackFilesConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "assetPackManifestConfiguration", "gradle-core"})
public final class AssetPackUtilKt {
    public static final void populateAssetPacksConfigurations(@NotNull Project project2, @NotNull IssueReporter issueReporter2, @NotNull Set<String> assetPacks, @NotNull Configuration assetPackFilesConfiguration, @NotNull Configuration assetPackManifestConfiguration) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter(assetPacks, (String)"assetPacks");
        Intrinsics.checkNotNullParameter((Object)assetPackFilesConfiguration, (String)"assetPackFilesConfiguration");
        Intrinsics.checkNotNullParameter((Object)assetPackManifestConfiguration, (String)"assetPackManifestConfiguration");
        DependencyHandler depHandler = project2.getDependencies();
        List notFound = new ArrayList();
        for (String assetPack : assetPacks) {
            if (project2.findProject(assetPack) != null) {
                ImmutableMap filesDependency = ImmutableMap.of((Object)"path", (Object)assetPack, (Object)"configuration", (Object)"packElements");
                depHandler.add(assetPackFilesConfiguration.getName(), (Object)depHandler.project((Map)filesDependency));
                ImmutableMap manifestDependency = ImmutableMap.of((Object)"path", (Object)assetPack, (Object)"configuration", (Object)"manifestElements");
                depHandler.add(assetPackManifestConfiguration.getName(), (Object)depHandler.project((Map)manifestDependency));
                continue;
            }
            notFound.add(assetPack);
        }
        if (!notFound.isEmpty()) {
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)Intrinsics.stringPlus((String)"Unable to find matching projects for Asset Packs: ", (Object)notFound), null, null, (int)12, null);
        }
    }
}

