/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.testing.utp.GradleAndroidTestResultListenerService;
import com.android.build.gradle.internal.testing.utp.UtpTestResultListener;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServer;", "Ljava/io/Closeable;", "port", "", "listener", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;", "serverFactory", "Lkotlin/Function1;", "Lio/grpc/ServerBuilder;", "(ILcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;Lkotlin/jvm/functions/Function1;)V", "getPort", "()I", "server", "Lio/grpc/Server;", "getServer$annotations", "()V", "getServer", "()Lio/grpc/Server;", "close", "", "Companion", "gradle-core"})
public final class UtpTestResultListenerServer
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int port;
    @NotNull
    private final Server server;
    private static final Logger logger = Logging.getLogger(UtpTestResultListenerServer.class);
    private static final int DEFAULT_GRPC_SERVER_PORT = 9624;
    private static final int DEFAULT_MAX_RETRY_ATTEMPT = 10;

    private UtpTestResultListenerServer(int port, UtpTestResultListener listener, Function1<? super Integer, ? extends ServerBuilder<?>> serverFactory) {
        this.port = port;
        Server server = ((ServerBuilder)serverFactory.invoke((Object)this.port)).addService((BindableService)new GradleAndroidTestResultListenerService(listener)).build().start();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"serverFactory(port)\n            .addService(GradleAndroidTestResultListenerService(listener))\n            .build()\n            .start()");
        this.server = server;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final Server getServer() {
        return this.server;
    }

    @VisibleForTesting
    public static /* synthetic */ void getServer$annotations() {
    }

    @Override
    public void close() {
        this.server.shutdownNow().awaitTermination();
    }

    public /* synthetic */ UtpTestResultListenerServer(int port, UtpTestResultListener listener, Function1 serverFactory, DefaultConstructorMarker $constructor_marker) {
        this(port, listener, serverFactory);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002JX\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u00042\u0018\b\u0002\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServer$Companion;", "", "()V", "DEFAULT_GRPC_SERVER_PORT", "", "DEFAULT_MAX_RETRY_ATTEMPT", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "createServerBuilder", "Lio/grpc/ServerBuilder;", "certChainFile", "Ljava/io/File;", "privateKeyFile", "trustCertCollectionFile", "port", "startServer", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServer;", "listener", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;", "defaultPort", "maxRetryAttempt", "serverFactory", "Lkotlin/Function1;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final UtpTestResultListenerServer startServer(@NotNull File certChainFile, @NotNull File privateKeyFile, @NotNull File trustCertCollectionFile, @Nullable UtpTestResultListener listener, int defaultPort, int maxRetryAttempt, @NotNull Function1<? super Integer, ? extends ServerBuilder<?>> serverFactory) {
            Intrinsics.checkNotNullParameter((Object)certChainFile, (String)"certChainFile");
            Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
            Intrinsics.checkNotNullParameter((Object)trustCertCollectionFile, (String)"trustCertCollectionFile");
            Intrinsics.checkNotNullParameter(serverFactory, (String)"serverFactory");
            int n = 0;
            if (n < maxRetryAttempt) {
                while (true) {
                    int attempt = n++;
                    int port = defaultPort + attempt;
                    try {
                        return new UtpTestResultListenerServer(port, listener, serverFactory, null);
                    }
                    catch (IOException exception) {
                        logger.info("Failed to bind and start the gRPC server. Retrying with a different port number.");
                        if (n < maxRetryAttempt) continue;
                    }
                    break;
                }
            }
            logger.error("Unable to start the gRPC server.");
            return null;
        }

        public static /* synthetic */ UtpTestResultListenerServer startServer$default(Companion companion, File file, File file2, File file3, UtpTestResultListener utpTestResultListener, int n, int n2, Function1 function1, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                n = 9624;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 10;
            }
            if ((n3 & 0x40) != 0) {
                function1 = new Function1<Integer, ServerBuilder<?>>(file, file2, file3){
                    final /* synthetic */ File $certChainFile;
                    final /* synthetic */ File $privateKeyFile;
                    final /* synthetic */ File $trustCertCollectionFile;
                    {
                        this.$certChainFile = $certChainFile;
                        this.$privateKeyFile = $privateKeyFile;
                        this.$trustCertCollectionFile = $trustCertCollectionFile;
                        super(1);
                    }

                    @NotNull
                    public final ServerBuilder<?> invoke(int port) {
                        return com.android.build.gradle.internal.testing.utp.UtpTestResultListenerServer$Companion.access$createServerBuilder(UtpTestResultListenerServer.Companion, this.$certChainFile, this.$privateKeyFile, this.$trustCertCollectionFile, port);
                    }
                };
            }
            return companion.startServer(file, file2, file3, utpTestResultListener, n, n2, function1);
        }

        private final ServerBuilder<?> createServerBuilder(File certChainFile, File privateKeyFile, File trustCertCollectionFile, int port) {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((File)certChainFile, (File)privateKeyFile);
            boolean bl = false;
            boolean bl2 = false;
            SslContextBuilder $this$createServerBuilder_u24lambda_u2d0 = sslContextBuilder;
            boolean bl3 = false;
            $this$createServerBuilder_u24lambda_u2d0.trustManager(trustCertCollectionFile);
            $this$createServerBuilder_u24lambda_u2d0.clientAuth(ClientAuth.REQUIRE);
            GrpcSslContexts.configure((SslContextBuilder)$this$createServerBuilder_u24lambda_u2d0);
            SslContext sslContext = sslContextBuilder.build();
            sslContextBuilder = NettyServerBuilder.forPort((int)port).sslContext(sslContext);
            Intrinsics.checkNotNullExpressionValue((Object)sslContextBuilder, (String)"forPort(port).sslContext(sslContext)");
            return (ServerBuilder)sslContextBuilder;
        }

        public static final /* synthetic */ ServerBuilder access$createServerBuilder(Companion $this, File certChainFile, File privateKeyFile, File trustCertCollectionFile, int port) {
            return $this.createServerBuilder(certChainFile, privateKeyFile, trustCertCollectionFile, port);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

