/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.GradleLocalPropertiesFactory;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkType;
import com.android.builder.errors.IssueReporter;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/SdkLocator;", "", "()V", "ANDROID_DIR_PROPERTY", "", "getANDROID_DIR_PROPERTY$annotations", "ANDROID_HOME_SYSTEM_PROPERTY", "getANDROID_HOME_SYSTEM_PROPERTY$annotations", "cachedSdkLocation", "Lcom/android/build/gradle/internal/SdkLocation;", "cachedSdkLocationKey", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "sdkTestDirectory", "Ljava/io/File;", "getSdkTestDirectory$annotations", "getSdkTestDirectory", "()Ljava/io/File;", "setSdkTestDirectory", "(Ljava/io/File;)V", "getSdkDirectory", "projectRootDir", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "getSdkLocation", "sourceSet", "resetCache", "", "updateCache", "sdkLocation", "SdkLocationSource", "gradle-core"})
public final class SdkLocator {
    @NotNull
    public static final SdkLocator INSTANCE = new SdkLocator();
    @Nullable
    private static File sdkTestDirectory;
    @NotNull
    public static final String ANDROID_DIR_PROPERTY = "android.dir";
    @NotNull
    public static final String ANDROID_HOME_SYSTEM_PROPERTY = "android.home";
    @Nullable
    private static SdkLocationSourceSet cachedSdkLocationKey;
    @Nullable
    private static SdkLocation cachedSdkLocation;

    private SdkLocator() {
    }

    @Nullable
    public static final File getSdkTestDirectory() {
        return sdkTestDirectory;
    }

    public static final void setSdkTestDirectory(@Nullable File file) {
        sdkTestDirectory = file;
    }

    @JvmStatic
    @VisibleForTesting
    public static /* synthetic */ void getSdkTestDirectory$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getANDROID_DIR_PROPERTY$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getANDROID_HOME_SYSTEM_PROPERTY$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final File getSdkDirectory(@NotNull File projectRootDir, @NotNull IssueReporter issueReporter2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)projectRootDir, (String)"projectRootDir");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        SdkLocation sdkLocation = SdkLocator.getSdkLocation(new SdkLocationSourceSet(projectRootDir, null, null, null, 14, null), issueReporter2);
        if (sdkLocation.getType() == SdkType.MISSING) {
            file = new File(projectRootDir, "missingSdkDirectory");
        } else {
            File file2 = sdkLocation.getDirectory();
            if (file2 == null) {
                String string = Intrinsics.stringPlus((String)"Directory must not be null when type = ", (Object)((Object)sdkLocation.getType()));
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            file = file2;
        }
        return file;
    }

    @JvmStatic
    @NotNull
    public static final synchronized SdkLocation getSdkLocation(@NotNull SdkLocationSourceSet sourceSet, @NotNull IssueReporter issueReporter2) {
        Object it;
        int n;
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        SdkLocationSourceSet object = cachedSdkLocationKey;
        if (object != null) {
            SdkLocationSourceSet sdkLocationSourceSet = object;
            n = 0;
            boolean bl = false;
            it = sdkLocationSourceSet;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it, (Object)sourceSet)) {
                SdkLocation sdkLocation = cachedSdkLocation;
                Intrinsics.checkNotNull((Object)sdkLocation);
                return sdkLocation;
            }
        }
        for (SdkLocationSource source : SdkLocationSource.values()) {
            it = source.getSdkLocation(sourceSet);
            if (it == null) continue;
            Object bl2 = it;
            boolean bl = false;
            boolean bl3 = false;
            Object it2 = bl2;
            boolean bl4 = false;
            INSTANCE.updateCache((SdkLocation)it2, sourceSet);
            return it2;
        }
        SdkLocation sdkLocation = new SdkLocation(null, SdkType.MISSING);
        int n2 = 0;
        n = 0;
        SdkLocation it3 = sdkLocation;
        boolean bl = false;
        INSTANCE.updateCache(it3, sourceSet);
        String filePath = new File(sourceSet.getProjectRoot(), "local.properties").getAbsolutePath();
        String message = "SDK location not found. Define location with an ANDROID_SDK_ROOT environment variable or by setting the sdk.dir path in your project's local properties file at '" + filePath + "'.";
        IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.SDK_NOT_SET, (String)message, (String)filePath, null, (int)8, null);
        return it3;
    }

    private final synchronized void updateCache(SdkLocation sdkLocation, SdkLocationSourceSet sourceSet) {
        cachedSdkLocationKey = sourceSet;
        cachedSdkLocation = sdkLocation;
    }

    @JvmStatic
    public static final synchronized void resetCache() {
        GradleLocalPropertiesFactory.INSTANCE.resetCache$gradle_core();
        cachedSdkLocationKey = null;
        cachedSdkLocation = null;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH&J\u001a\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "", "sdkType", "Lcom/android/build/gradle/internal/SdkType;", "(Ljava/lang/String;ILcom/android/build/gradle/internal/SdkType;)V", "getSdkType", "()Lcom/android/build/gradle/internal/SdkType;", "getSdkLocation", "Lcom/android/build/gradle/internal/SdkLocation;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "getSdkPathProperty", "Ljava/io/File;", "validateSdkPath", "path", "", "rootDir", "TEST_SDK_DIRECTORY", "LOCAL_SDK_DIR", "LOCAL_ANDROID_DIR", "INJECTED_SDK_HOME", "gradle-core"})
    public static final abstract class SdkLocationSource
    extends Enum<SdkLocationSource> {
        @NotNull
        private final SdkType sdkType;
        public static final /* enum */ SdkLocationSource TEST_SDK_DIRECTORY = new TEST_SDK_DIRECTORY("TEST_SDK_DIRECTORY", 0);
        public static final /* enum */ SdkLocationSource LOCAL_SDK_DIR = new LOCAL_SDK_DIR("LOCAL_SDK_DIR", 1);
        public static final /* enum */ SdkLocationSource LOCAL_ANDROID_DIR = new LOCAL_ANDROID_DIR("LOCAL_ANDROID_DIR", 2);
        public static final /* enum */ SdkLocationSource INJECTED_SDK_HOME = new INJECTED_SDK_HOME("INJECTED_SDK_HOME", 3);
        private static final /* synthetic */ SdkLocationSource[] $VALUES;

        private SdkLocationSource(SdkType sdkType) {
            this.sdkType = sdkType;
        }

        @NotNull
        public final SdkType getSdkType() {
            return this.sdkType;
        }

        @Nullable
        public final SdkLocation getSdkLocation(@NotNull SdkLocationSourceSet sourceSet) {
            SdkLocation sdkLocation;
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            File file = this.getSdkPathProperty(sourceSet);
            if (file == null) {
                sdkLocation = null;
            } else {
                File file2 = file;
                boolean bl = false;
                boolean bl2 = false;
                File it = file2;
                boolean bl3 = false;
                sdkLocation = new SdkLocation(it, this.getSdkType());
            }
            return sdkLocation;
        }

        @Nullable
        public abstract File getSdkPathProperty(@NotNull SdkLocationSourceSet var1);

        @Nullable
        protected final File validateSdkPath(@NotNull String path, @NotNull File rootDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            File sdk = new File(path);
            if (!sdk.isAbsolute()) {
                File file = new File(rootDir, path).getCanonicalFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(rootDir, path).canonicalFile");
                sdk = file;
            }
            return sdk.isDirectory() ? sdk : null;
        }

        public static SdkLocationSource[] values() {
            SdkLocationSource[] sdkLocationSourceArray = $VALUES;
            SdkLocationSource[] sdkLocationSourceArray2 = new SdkLocationSource[sdkLocationSourceArray.length];
            System.arraycopy(sdkLocationSourceArray, 0, sdkLocationSourceArray2, 0, sdkLocationSourceArray.length);
            return sdkLocationSourceArray2;
        }

        public static SdkLocationSource valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(SdkLocationSource.class, value);
        }

        public /* synthetic */ SdkLocationSource(String $enum$name, int $enum$ordinal, SdkType sdkType, DefaultConstructorMarker $constructor_marker) {
            this(sdkType);
        }

        static {
            SdkLocationSource[] sdkLocationSourceArray = new SdkLocationSource[]{TEST_SDK_DIRECTORY, LOCAL_SDK_DIR, LOCAL_ANDROID_DIR, INJECTED_SDK_HOME};
            $VALUES = sdkLocationSourceArray;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$TEST_SDK_DIRECTORY;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class TEST_SDK_DIRECTORY
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            TEST_SDK_DIRECTORY() {
                void var1_1;
            }

            @Override
            @Nullable
            public File getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet) {
                File file;
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                File file2 = INSTANCE.getSdkTestDirectory();
                if (file2 == null) {
                    file = null;
                } else {
                    String string = file2.getAbsolutePath();
                    if (string == null) {
                        file = null;
                    } else {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        file = this.validateSdkPath(it, sourceSet.getProjectRoot());
                    }
                }
                return file;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$LOCAL_SDK_DIR;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class LOCAL_SDK_DIR
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            LOCAL_SDK_DIR() {
                void var1_1;
            }

            @Override
            @Nullable
            public File getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet) {
                File file;
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                String string = sourceSet.getLocalProperties$gradle_core().getProperty("sdk.dir");
                if (string == null) {
                    file = null;
                } else {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    file = this.validateSdkPath(it, sourceSet.getProjectRoot());
                }
                return file;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$LOCAL_ANDROID_DIR;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class LOCAL_ANDROID_DIR
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            LOCAL_ANDROID_DIR() {
                void var1_1;
            }

            @Override
            @Nullable
            public File getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet) {
                File file;
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                String string = sourceSet.getLocalProperties$gradle_core().getProperty(SdkLocator.ANDROID_DIR_PROPERTY);
                if (string == null) {
                    file = null;
                } else {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    file = this.validateSdkPath(it, sourceSet.getProjectRoot());
                }
                return file;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$INJECTED_SDK_HOME;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class INJECTED_SDK_HOME
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            INJECTED_SDK_HOME() {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public File getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet) {
                void $this$groupByTo$iv$iv2;
                boolean bl;
                String string;
                Map map;
                File it;
                boolean bl2;
                boolean bl3;
                File file;
                Object object;
                String path;
                boolean bl4;
                boolean bl5;
                String string2;
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                boolean bl6 = false;
                Map map2 = new LinkedHashMap();
                String string3 = sourceSet.getEnvironmentProperties$gradle_core().getProperty("ANDROID_SDK_ROOT");
                if (string3 != null) {
                    string2 = string3;
                    bl5 = false;
                    bl4 = false;
                    path = string2;
                    boolean bl7 = false;
                    object = this.validateSdkPath(path, sourceSet.getProjectRoot());
                    if (object != null) {
                        file = object;
                        bl3 = false;
                        bl2 = false;
                        it = file;
                        boolean bl8 = false;
                        map = map2;
                        string = "ANDROID_SDK_ROOT";
                        bl = false;
                        map.put(string, it);
                    }
                }
                string3 = sourceSet.getEnvironmentProperties$gradle_core().getProperty("ANDROID_HOME");
                if (string3 != null) {
                    string2 = string3;
                    bl5 = false;
                    bl4 = false;
                    path = string2;
                    boolean bl9 = false;
                    object = this.validateSdkPath(path, sourceSet.getProjectRoot());
                    if (object != null) {
                        file = object;
                        bl3 = false;
                        bl2 = false;
                        it = file;
                        boolean bl10 = false;
                        map = map2;
                        string = "ANDROID_HOME";
                        bl = false;
                        map.put(string, it);
                    }
                }
                string3 = sourceSet.getSystemProperties$gradle_core().getProperty(SdkLocator.ANDROID_HOME_SYSTEM_PROPERTY);
                if (string3 != null) {
                    string2 = string3;
                    bl5 = false;
                    bl4 = false;
                    path = string2;
                    boolean bl11 = false;
                    object = this.validateSdkPath(path, sourceSet.getProjectRoot());
                    if (object != null) {
                        file = object;
                        bl3 = false;
                        bl2 = false;
                        it = file;
                        boolean bl12 = false;
                        map = map2;
                        string = SdkLocator.ANDROID_HOME_SYSTEM_PROPERTY;
                        bl = false;
                        map.put(string, it);
                    }
                }
                if (map2.isEmpty()) {
                    return null;
                }
                if (map2.size() == 1) {
                    return (File)CollectionsKt.single((Iterable)map2.values());
                }
                Iterable $this$groupBy$iv = map2.entrySet();
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                    Object object2;
                    Map.Entry it2 = (Map.Entry)element$iv$iv;
                    boolean bl13 = false;
                    File key$iv$iv = (File)it2.getValue();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl14 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map reverseMap = destination$iv$iv;
                if (reverseMap.size() == 1) {
                    return (File)CollectionsKt.single((Iterable)reverseMap.keySet());
                }
                String string4 = "\nSeveral environment variables and/or system properties contain different paths to the SDK.\nPlease correct and use only one way to inject the SDK location.\n";
                boolean $this$groupByTo$iv$iv2 = false;
                String message = ((Object)StringsKt.trimStart((CharSequence)string4)).toString();
                Iterable $this$sortedBy$iv = map2.entrySet();
                boolean $i$f$sortedBy = false;
                boolean bl15 = false;
                for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Map.Entry it = (Map.Entry)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = (String)it.getKey();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                })) {
                    message = message + '\n' + (String)entry.getKey() + ": " + entry.getValue();
                }
                message = StringsKt.trimIndent((String)Intrinsics.stringPlus((String)message, (Object)"\n\nIt is recommended to use ANDROID_HOME as other methods are deprecated\n"));
                throw new RuntimeException(message);
            }
        }
    }
}

