/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dexing;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dexing.DexWorkAction;
import com.android.build.gradle.internal.dexing.DexWorkActionKt;
import com.android.build.gradle.internal.dexing.DexWorkActionParams;
import com.android.build.gradle.internal.dexing.IncrementalDexSpec;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTaskDelegate;
import com.android.builder.dexing.ClassBucket;
import com.android.builder.dexing.DependencyGraphUpdater;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexParameters;
import com.android.builder.dexing.MutableDependencyGraph;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.ide.common.blame.MessageReceiver;
import com.android.utils.FileUtils;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007\u001aJ\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u00112\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0016H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u001b\u001a\u00020\u0011\u001a\u001c\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"loggerWrapper", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getDexArchiveBuilder", "Lcom/android/builder/dexing/DexArchiveBuilder;", "dexWorkActionParams", "Lcom/android/build/gradle/internal/dexing/DexWorkActionParams;", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "launchProcessing", "", "receiver", "process", "dexArchiveBuilder", "inputClassFiles", "Lcom/android/builder/dexing/ClassBucket;", "inputFilter", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "outputPath", "desugarGraphUpdater", "Lcom/android/builder/dexing/DependencyGraphUpdater;", "processIncrementally", "processNonIncrementally", "readDesugarGraph", "Lcom/android/builder/dexing/MutableDependencyGraph;", "desugarGraphFile", "writeDesugarGraph", "desugarGraph", "gradle-core"})
public final class DexWorkActionKt {
    @NotNull
    private static final LoggerWrapper loggerWrapper;

    public static final void launchProcessing(@NotNull DexWorkActionParams dexWorkActionParams, @NotNull MessageReceiver receiver2) {
        Intrinsics.checkNotNullParameter((Object)dexWorkActionParams, (String)"dexWorkActionParams");
        Intrinsics.checkNotNullParameter((Object)receiver2, (String)"receiver");
        DexArchiveBuilder dexArchiveBuilder = DexWorkActionKt.getDexArchiveBuilder(dexWorkActionParams, receiver2);
        if (((IncrementalDexSpec)dexWorkActionParams.getDexSpec().get()).isIncremental()) {
            DexWorkActionKt.processIncrementally(dexArchiveBuilder, dexWorkActionParams);
        } else {
            DexWorkActionKt.processNonIncrementally(dexArchiveBuilder, dexWorkActionParams);
        }
    }

    private static final void processIncrementally(DexArchiveBuilder dexArchiveBuilder, DexWorkActionParams dexWorkActionParams) {
        boolean bl;
        MutableDependencyGraph<File> desugarGraph;
        File file;
        MutableDependencyGraph<File> mutableDependencyGraph;
        IncrementalDexSpec incrementalDexSpec = (IncrementalDexSpec)dexWorkActionParams.getDexSpec().get();
        boolean bl2 = false;
        boolean bl3 = false;
        IncrementalDexSpec $this$processIncrementally_u24lambda_u2d4 = incrementalDexSpec;
        boolean bl4 = false;
        File file2 = $this$processIncrementally_u24lambda_u2d4.getDesugarGraphFile();
        if (file2 == null) {
            mutableDependencyGraph = null;
        } else {
            MutableDependencyGraph<File> mutableDependencyGraph2;
            file = file2;
            boolean bl5 = false;
            boolean bl6 = false;
            File it = file;
            boolean bl7 = false;
            try {
                mutableDependencyGraph2 = DexWorkActionKt.readDesugarGraph($this$processIncrementally_u24lambda_u2d4.getDesugarGraphFile());
            }
            catch (Exception e) {
                loggerWrapper.warning("Failed to read desugaring graph. Cause: " + e.getClass().getSimpleName() + ", message: " + e.getMessage() + ".\nFall back to non-incremental mode.", new Object[0]);
                DexWorkActionKt.processNonIncrementally(dexArchiveBuilder, dexWorkActionParams);
                return;
            }
            mutableDependencyGraph = mutableDependencyGraph2;
        }
        MutableDependencyGraph<File> mutableDependencyGraph3 = desugarGraph = mutableDependencyGraph;
        file = mutableDependencyGraph3 == null ? null : mutableDependencyGraph3.getAllDependents($this$processIncrementally_u24lambda_u2d4.getChangedFiles());
        Object unchangedButImpactedFiles = file == null ? SetsKt.emptySet() : file;
        Set changedOrImpactedFiles = SetsKt.plus($this$processIncrementally_u24lambda_u2d4.getChangedFiles(), (Iterable)((Iterable)unchangedButImpactedFiles));
        mutableDependencyGraph3 = desugarGraph;
        if (mutableDependencyGraph3 != null) {
            MutableDependencyGraph<File> mutableDependencyGraph4 = mutableDependencyGraph3;
            boolean bl8 = false;
            bl = false;
            MutableDependencyGraph<File> graph = mutableDependencyGraph4;
            boolean bl9 = false;
            Iterable $this$forEach$iv = changedOrImpactedFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl10 = false;
                graph.removeNode((Object)it);
            }
        }
        Function2 filter2 = (Function2)new Function2<File, String, Boolean>((Set<? extends File>)changedOrImpactedFiles){
            final /* synthetic */ Set<File> $changedOrImpactedFiles;
            {
                this.$changedOrImpactedFiles = $changedOrImpactedFiles;
                super(2);
            }

            public final boolean invoke(@NotNull File rootPath, @NotNull String relativePath) {
                Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
                Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                return this.$changedOrImpactedFiles.contains(rootPath) || this.$changedOrImpactedFiles.contains(FilesKt.resolve((File)rootPath, (String)relativePath));
            }
        };
        DexWorkActionKt.process(dexArchiveBuilder, $this$processIncrementally_u24lambda_u2d4.getInputClassFiles(), (Function2<? super File, ? super String, Boolean>)filter2, $this$processIncrementally_u24lambda_u2d4.getOutputPath(), (DependencyGraphUpdater<File>)((DependencyGraphUpdater)desugarGraph));
        File file3 = $this$processIncrementally_u24lambda_u2d4.getDesugarGraphFile();
        if (file3 != null) {
            File file4 = file3;
            bl = false;
            boolean bl11 = false;
            File it = file4;
            boolean bl12 = false;
            Intrinsics.checkNotNull(desugarGraph);
            DexWorkActionKt.writeDesugarGraph(it, desugarGraph);
        }
    }

    private static final void processNonIncrementally(DexArchiveBuilder dexArchiveBuilder, DexWorkActionParams dexWorkActionParams) {
        File it;
        boolean bl;
        boolean bl2;
        File file;
        MutableDependencyGraph mutableDependencyGraph;
        IncrementalDexSpec incrementalDexSpec = (IncrementalDexSpec)dexWorkActionParams.getDexSpec().get();
        boolean bl3 = false;
        boolean bl4 = false;
        IncrementalDexSpec $this$processNonIncrementally_u24lambda_u2d7 = incrementalDexSpec;
        boolean bl5 = false;
        File file2 = $this$processNonIncrementally_u24lambda_u2d7.getDesugarGraphFile();
        if (file2 == null) {
            mutableDependencyGraph = null;
        } else {
            file = file2;
            bl2 = false;
            bl = false;
            it = file;
            boolean bl6 = false;
            mutableDependencyGraph = new MutableDependencyGraph();
        }
        MutableDependencyGraph desugarGraph = mutableDependencyGraph;
        DexWorkActionKt.process(dexArchiveBuilder, $this$processNonIncrementally_u24lambda_u2d7.getInputClassFiles(), (Function2<? super File, ? super String, Boolean>)((Function2)processNonIncrementally.1.1.INSTANCE), $this$processNonIncrementally_u24lambda_u2d7.getOutputPath(), (DependencyGraphUpdater<File>)((DependencyGraphUpdater)desugarGraph));
        file2 = $this$processNonIncrementally_u24lambda_u2d7.getDesugarGraphFile();
        if (file2 != null) {
            file = file2;
            bl2 = false;
            bl = false;
            it = file;
            boolean bl7 = false;
            FileUtils.mkdirs((File)it.getParentFile());
            Intrinsics.checkNotNull((Object)desugarGraph);
            DexWorkActionKt.writeDesugarGraph(it, (MutableDependencyGraph<File>)desugarGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void process(DexArchiveBuilder dexArchiveBuilder, ClassBucket inputClassFiles, Function2<? super File, ? super String, Boolean> inputFilter2, File outputPath, DependencyGraphUpdater<File> desugarGraphUpdater) {
        List inputRoots = inputClassFiles.getBucketGroup().getRoots();
        Object $this$forEach$iv = inputRoots;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            File it = (File)element$iv;
            boolean bl = false;
            loggerWrapper.verbose("Dexing '" + it.getPath() + "' to '" + outputPath.getPath() + '\'', new Object[0]);
        }
        try {
            $this$forEach$iv = (Closeable)Closer.create();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Closer closer = (Closer)$this$forEach$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)closer, (String)"closer");
                AutoCloseable autoCloseable = inputClassFiles.getClassFiles(inputFilter2, closer);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl6 = false;
                    Path path = outputPath.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputPath.toPath()");
                    dexArchiveBuilder.convert(it, path, desugarGraphUpdater);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)throwable);
            }
        }
        catch (DexArchiveBuilderException ex) {
            throw new DexArchiveBuilderException(Intrinsics.stringPlus((String)"Failed to process: ", (Object)CollectionsKt.joinToString$default((Iterable)inputRoots, (CharSequence)", ", null, null, (int)0, null, (Function1)process.3.INSTANCE, (int)30, null)), (Throwable)ex);
        }
    }

    private static final DexArchiveBuilder getDexArchiveBuilder(DexWorkActionParams dexWorkActionParams, MessageReceiver messageReceiver) {
        DexArchiveBuilder dexArchiveBuilder = null;
        boolean bl = false;
        boolean bl2 = false;
        DexWorkActionParams $this$getDexArchiveBuilder_u24lambda_u2d11 = dexWorkActionParams;
        boolean bl3 = false;
        IncrementalDexSpec dexSpec = (IncrementalDexSpec)$this$getDexArchiveBuilder_u24lambda_u2d11.getDexSpec().get();
        dexArchiveBuilder = DexArchiveBuilder.Companion.createD8DexBuilder(new DexParameters(dexSpec.getDexParams().getMinSdkVersion(), dexSpec.getDexParams().getDebuggable(), dexSpec.getDexParams().getDexPerClass(), dexSpec.getDexParams().getWithDesugaring(), (ClassFileProviderFactory)DexArchiveBuilderTaskDelegate.Companion.getSharedState$gradle_core().getService(dexSpec.getDexParams().getDesugarBootclasspath()).getService(), (ClassFileProviderFactory)DexArchiveBuilderTaskDelegate.Companion.getSharedState$gradle_core().getService(dexSpec.getDexParams().getDesugarClasspath()).getService(), dexSpec.getDexParams().getCoreLibDesugarConfig(), dexSpec.getDexParams().getCoreLibDesugarOutputKeepRuleFile(), messageReceiver));
        return dexArchiveBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final MutableDependencyGraph<File> readDesugarGraph(@NotNull File desugarGraphFile) {
        MutableDependencyGraph mutableDependencyGraph;
        Intrinsics.checkNotNullParameter((Object)desugarGraphFile, (String)"desugarGraphFile");
        Closeable closeable = new FileInputStream(desugarGraphFile);
        int n = 8192;
        boolean bl = false;
        closeable = new ObjectInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl2 = false;
            Object object = it.readObject();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.builder.dexing.MutableDependencyGraph<java.io.File>");
            }
            mutableDependencyGraph = (MutableDependencyGraph)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return mutableDependencyGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeDesugarGraph(@NotNull File desugarGraphFile, @NotNull MutableDependencyGraph<File> desugarGraph) {
        Intrinsics.checkNotNullParameter((Object)desugarGraphFile, (String)"desugarGraphFile");
        Intrinsics.checkNotNullParameter(desugarGraph, (String)"desugarGraph");
        Closeable closeable = new FileOutputStream(desugarGraphFile);
        int n = 8192;
        boolean bl = false;
        closeable = new ObjectOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl2 = false;
            it.writeObject(desugarGraph);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(DexWorkAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(DexWorkAction::class.java)");
        DexWorkActionKt.loggerWrapper = loggerWrapper;
    }
}

