/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.SystemPropertyInputs;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0014\u0010\u0016\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/lint/SystemPropertyInputs;", "", "()V", "androidLintLogJarProblems", "Lorg/gradle/api/provider/Property;", "", "getAndroidLintLogJarProblems", "()Lorg/gradle/api/provider/Property;", "javaHome", "getJavaHome", "javaVendor", "getJavaVendor", "javaVersion", "getJavaVersion", "lintApiDatabase", "Lorg/gradle/api/file/RegularFileProperty;", "getLintApiDatabase", "()Lorg/gradle/api/file/RegularFileProperty;", "lintAutofix", "getLintAutofix", "lintBaselinesContinue", "getLintBaselinesContinue", "lintConfigurationOverride", "getLintConfigurationOverride", "lintHtmlPrefs", "getLintHtmlPrefs", "lintNullnessIgnoreDeprecated", "getLintNullnessIgnoreDeprecated", "lintUnusedResourcesExcludeTests", "getLintUnusedResourcesExcludeTests", "lintUnusedResourcesIncludeTests", "getLintUnusedResourcesIncludeTests", "userHome", "getUserHome", "initialize", "", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "isForAnalysis", "", "gradle-core"})
public abstract class SystemPropertyInputs {
    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAndroidLintLogJarProblems();

    @Internal
    @NotNull
    public abstract Property<String> getJavaHome();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJavaVendor();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJavaVersion();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getLintApiDatabase();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintAutofix();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintBaselinesContinue();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getLintConfigurationOverride();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintHtmlPrefs();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintNullnessIgnoreDeprecated();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintUnusedResourcesExcludeTests();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintUnusedResourcesIncludeTests();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getUserHome();

    public final void initialize(@NotNull ProviderFactory providerFactory, boolean isForAnalysis) {
        Provider provider2;
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        if (isForAnalysis) {
            this.getLintAutofix().disallowChanges();
            this.getLintBaselinesContinue().disallowChanges();
            this.getLintHtmlPrefs().disallowChanges();
            this.getUserHome().disallowChanges();
        } else {
            Property<String> property = this.getLintAutofix();
            provider2 = providerFactory.systemProperty("lint.autofix");
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"lint.autofix\")");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
            Property<String> property2 = this.getLintBaselinesContinue();
            provider2 = providerFactory.systemProperty("lint.baselines.continue");
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"lint.baselines.continue\")");
            HasConfigurableValuesKt.setDisallowChanges(property2, provider2);
            Property<String> property3 = this.getLintHtmlPrefs();
            provider2 = providerFactory.systemProperty("lint.html.prefs");
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"lint.html.prefs\")");
            HasConfigurableValuesKt.setDisallowChanges(property3, provider2);
            Property<String> property4 = this.getUserHome();
            provider2 = providerFactory.systemProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"user.home\")");
            HasConfigurableValuesKt.setDisallowChanges(property4, provider2);
        }
        Property<String> property = this.getAndroidLintLogJarProblems();
        provider2 = providerFactory.systemProperty("android.lint.log-jar-problems");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"android.lint.log-jar-problems\")");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        Property<String> property5 = this.getJavaHome();
        provider2 = providerFactory.systemProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"java.home\")");
        HasConfigurableValuesKt.setDisallowChanges(property5, provider2);
        Property<String> property6 = this.getJavaVendor();
        provider2 = providerFactory.systemProperty("java.vendor");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"java.vendor\")");
        HasConfigurableValuesKt.setDisallowChanges(property6, provider2);
        Property<String> property7 = this.getJavaVersion();
        provider2 = providerFactory.systemProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"java.version\")");
        HasConfigurableValuesKt.setDisallowChanges(property7, provider2);
        this.getLintApiDatabase().fileProvider(providerFactory.systemProperty("LINT_API_DATABASE").map((Transformer)initialize.1.INSTANCE));
        this.getLintApiDatabase().disallowChanges();
        this.getLintConfigurationOverride().fileProvider(providerFactory.systemProperty("lint.configuration.override").map((Transformer)initialize.2.INSTANCE));
        this.getLintConfigurationOverride().disallowChanges();
        Property<String> property8 = this.getLintNullnessIgnoreDeprecated();
        provider2 = providerFactory.systemProperty("lint.nullness.ignore-deprecated");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"lint.nullness.ignore-deprecated\")");
        HasConfigurableValuesKt.setDisallowChanges(property8, provider2);
        Property<String> property9 = this.getLintUnusedResourcesExcludeTests();
        provider2 = providerFactory.systemProperty("lint.unused-resources.exclude-tests");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"lint.unused-resources.exclude-tests\")");
        HasConfigurableValuesKt.setDisallowChanges(property9, provider2);
        Property<String> property10 = this.getLintUnusedResourcesIncludeTests();
        provider2 = providerFactory.systemProperty("lint.unused-resources.include-tests");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.systemProperty(\"lint.unused-resources.include-tests\")");
        HasConfigurableValuesKt.setDisallowChanges(property10, provider2);
    }
}

