/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.VariantDimensionData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.dsl.BaseFlavor;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.SourceProviderContainerImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class ProductFlavorContainerImpl
implements ProductFlavorContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ProductFlavor productFlavor;
    private final SourceProvider sourceProvider;
    private final Collection<SourceProviderContainer> extraSourceProviders;

    static ProductFlavorContainer createProductFlavorContainer(VariantDimensionData variantDimensionData, BaseFlavor productFlavor, boolean includeProdSourceSet, boolean includeAndroidTest, boolean includeUnitTest, Collection<SourceProviderContainer> sourceProviderContainers) {
        DefaultAndroidSourceSet sourceSet;
        List<SourceProviderContainer> clonedContainers = SourceProviderContainerImpl.cloneCollection(sourceProviderContainers);
        if (includeAndroidTest && (sourceSet = variantDimensionData.getTestSourceSet((VariantType)VariantTypeImpl.ANDROID_TEST)) != null) {
            clonedContainers.add(SourceProviderContainerImpl.create(VariantTypeImpl.ANDROID_TEST.getArtifactName(), sourceSet));
        }
        if (includeUnitTest && (sourceSet = variantDimensionData.getTestSourceSet((VariantType)VariantTypeImpl.UNIT_TEST)) != null) {
            clonedContainers.add(SourceProviderContainerImpl.create(VariantTypeImpl.UNIT_TEST.getArtifactName(), sourceSet));
        }
        SourceProviderImpl prodSourceSet = null;
        if (includeProdSourceSet) {
            prodSourceSet = new SourceProviderImpl(variantDimensionData.getSourceSet());
        }
        return new ProductFlavorContainerImpl(new ProductFlavorImpl(productFlavor, null), prodSourceSet, clonedContainers);
    }

    private ProductFlavorContainerImpl(ProductFlavorImpl productFlavor, SourceProviderImpl sourceProvider, Collection<SourceProviderContainer> extraSourceProviders) {
        this.productFlavor = productFlavor;
        this.sourceProvider = sourceProvider;
        this.extraSourceProviders = extraSourceProviders;
    }

    public ProductFlavor getProductFlavor() {
        return this.productFlavor;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.extraSourceProviders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductFlavorContainerImpl that = (ProductFlavorContainerImpl)o;
        return Objects.equals(this.productFlavor, that.productFlavor) && Objects.equals(this.sourceProvider, that.sourceProvider) && Objects.equals(this.extraSourceProviders, that.extraSourceProviders);
    }

    public int hashCode() {
        return Objects.hash(this.productFlavor, this.sourceProvider, this.extraSourceProviders);
    }
}

