/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.MajorMinorVersion;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0001H\u0001\u001a\"\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"MINIMUM_REQUIRED_STUDIO_VERSION", "Lcom/android/build/gradle/internal/ide/MajorMinorVersion;", "SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "parseVersion", "version", "", "verifyIDEIsNotOld", "", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "injectedVersion", "minRequiredVersion", "versionOf", "year", "", "major", "minor", "gradle-core"})
@JvmName(name="StudioVersions")
public final class StudioVersions {
    @NotNull
    private static final MajorMinorVersion MINIMUM_REQUIRED_STUDIO_VERSION = new MajorMinorVersion(2021, 2, 1);
    private static final Splitter SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)". ")).omitEmptyStrings();

    public static final void verifyIDEIsNotOld(@NotNull ProjectOptions projectOptions) {
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        if (!projectOptions.get(BooleanOption.ENABLE_STUDIO_VERSION_CHECK)) {
            return;
        }
        StudioVersions.verifyIDEIsNotOld(projectOptions.get(StringOption.IDE_ANDROID_STUDIO_VERSION), MINIMUM_REQUIRED_STUDIO_VERSION);
    }

    @VisibleForTesting
    public static final void verifyIDEIsNotOld(@Nullable String injectedVersion, @NotNull MajorMinorVersion minRequiredVersion) {
        Intrinsics.checkNotNullParameter((Object)minRequiredVersion, (String)"minRequiredVersion");
        if (injectedVersion == null) {
            return;
        }
        MajorMinorVersion majorMinorVersion = StudioVersions.parseVersion(injectedVersion);
        if (majorMinorVersion == null) {
            throw new InvalidUserDataException("Unrecognized Android Studio (or Android Support plugin for IntelliJ IDEA) version '" + injectedVersion + "', please retry with version " + minRequiredVersion + " or newer.");
        }
        MajorMinorVersion parsedInjected = majorMinorVersion;
        if (parsedInjected.compareTo(minRequiredVersion) < 0 && !StringsKt.endsWith$default((String)injectedVersion, (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
            throw new RuntimeException("This version of the Android Support plugin for IntelliJ IDEA (or Android Studio) cannot open this project, please retry with version " + minRequiredVersion + " or newer.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @Nullable
    public static final MajorMinorVersion parseVersion(@NotNull String version) {
        MajorMinorVersion majorMinorVersion;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Iterable iterable = SPLITTER.split((CharSequence)version);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"SPLITTER.split(version)");
        boolean $i$f$map = false;
        void var4_3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Integer n = StringsKt.toIntOrNull((String)it);
            Integer n2 = n == null ? -1 : n;
            collection.add(n2);
        }
        List segments = (List)destination$iv$iv;
        if (segments.size() < 3) {
            return null;
        }
        if (((Number)segments.get(0)).intValue() <= 4) {
            majorMinorVersion = StudioVersions.versionOf(0, ((Number)segments.get(0)).intValue(), ((Number)segments.get(1)).intValue());
        } else if (((Number)segments.get(0)).intValue() == 10 && ((Number)segments.get(1)).intValue() == 4) {
            majorMinorVersion = StudioVersions.versionOf(0, ((Number)segments.get(1)).intValue(), ((Number)segments.get(2)).intValue());
        } else {
            if (StringsKt.startsWith$default((String)version, (String)"10.2020.3 ", (boolean)false, (int)2, null)) {
                return new MajorMinorVersion(2020, 3, 1);
            }
            majorMinorVersion = ((Number)segments.get(0)).intValue() >= 2020 ? StudioVersions.versionOf(((Number)segments.get(0)).intValue(), ((Number)segments.get(1)).intValue(), ((Number)segments.get(2)).intValue()) : null;
        }
        return majorMinorVersion;
    }

    private static final MajorMinorVersion versionOf(int year, int major, int minor) {
        if (major < 0 || minor < 0) {
            return null;
        }
        return new MajorMinorVersion(year, major, minor);
    }
}

