/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.matcher;

import com.android.build.gradle.internal.matcher.GlobPathMatcherFactory;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/matcher/FileExtensionWithPrefixPathMatcher;", "Ljava/nio/file/PathMatcher;", "matcher", "Ljava/util/regex/Matcher;", "(Ljava/util/regex/Matcher;)V", "extension", "", "getExtension", "()Ljava/lang/String;", "getMatcher", "()Ljava/util/regex/Matcher;", "prefix", "getPrefix", "matches", "", "p0", "Ljava/nio/file/Path;", "Companion", "gradle-core"})
public class FileExtensionWithPrefixPathMatcher
implements PathMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Matcher matcher;
    @NotNull
    private final String prefix;
    @NotNull
    private final String extension;
    @NotNull
    private static final Pattern pattern;

    public FileExtensionWithPrefixPathMatcher(@NotNull Matcher matcher) {
        String string;
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this.matcher = matcher;
        if (!this.matcher.matches()) {
            throw new IllegalArgumentException("matcher " + this.matcher + " does not match this factory");
        }
        String string2 = this.matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(1)");
        this.prefix = string2;
        if (this.matcher.groupCount() > 1) {
            string2 = this.matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(2)");
            string = string2;
        } else {
            string = "";
        }
        this.extension = string;
    }

    @NotNull
    public final Matcher getMatcher() {
        return this.matcher;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @Override
    public boolean matches(@Nullable Path p0) {
        String string;
        String string2;
        Path path = p0;
        String string3 = path == null ? null : (string2 = (string = ((Object)path).toString()) == null ? null : StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
        if (string2 == null) {
            return false;
        }
        String pathAsString = string2;
        return StringsKt.startsWith$default((String)pathAsString, (String)this.prefix, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)pathAsString, (char)'/', (int)this.prefix.length(), (boolean)false, (int)4, null) == -1 && StringsKt.endsWith$default((String)pathAsString, (String)this.extension, (boolean)false, (int)2, null);
    }

    static {
        Pattern pattern = Pattern.compile("(/[^*{}]*/)\\*\\.([^*/{}]*)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"(/[^*{}]*/)\\\\*\\\\.([^*/{}]*)\")");
        FileExtensionWithPrefixPathMatcher.pattern = pattern;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/matcher/FileExtensionWithPrefixPathMatcher$Companion;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "factory", "Lcom/android/build/gradle/internal/matcher/GlobPathMatcherFactory;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        @NotNull
        public final GlobPathMatcherFactory factory() {
            return new GlobPathMatcherFactory(){

                @NotNull
                public FileExtensionWithPrefixPathMatcher build(@NotNull Matcher glob) {
                    Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
                    return new FileExtensionWithPrefixPathMatcher(glob);
                }

                @NotNull
                public Pattern pattern() {
                    return FileExtensionWithPrefixPathMatcher.Companion.getPattern();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

