/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ClassesHierarchyBuildService;
import com.android.build.gradle.internal.tasks.FixStackFramesDelegate;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.RecalculateStackFramesTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/tasks/RecalculateStackFramesTask;", "Lcom/android/build/gradle/internal/tasks/NewIncrementalTask;", "()V", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "classesHierarchyBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/ClassesHierarchyBuildService;", "getClassesHierarchyBuildService", "()Lorg/gradle/api/provider/Property;", "classesInputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getClassesInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "classesOutputDir", "getClassesOutputDir", "jarsInputDir", "getJarsInputDir", "jarsOutputDir", "getJarsOutputDir", "referencedClasses", "getReferencedClasses", "createDelegate", "Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate;", "doTaskAction", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "CreationAction", "gradle-core"})
public abstract class RecalculateStackFramesTask
extends NewIncrementalTask {
    @Classpath
    @Incremental
    @NotNull
    public abstract DirectoryProperty getClassesInputDir();

    @Classpath
    @Incremental
    @NotNull
    public abstract DirectoryProperty getJarsInputDir();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getReferencedClasses();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getClassesOutputDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getJarsOutputDir();

    @Internal
    @NotNull
    public abstract Property<ClassesHierarchyBuildService> getClassesHierarchyBuildService();

    private final FixStackFramesDelegate createDelegate() {
        Object object = ((Directory)this.getClassesInputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classesInputDir.get().asFile");
        File file = object;
        object = ((Directory)this.getJarsInputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jarsInputDir.get().asFile");
        File file2 = object;
        object = this.getBootClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bootClasspath.files");
        Object object2 = object;
        object = this.getReferencedClasses().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"referencedClasses.files");
        Object object3 = object;
        object = ((Directory)this.getClassesOutputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classesOutputDir.get().asFile");
        Object object4 = object;
        object = ((Directory)this.getJarsOutputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jarsOutputDir.get().asFile");
        return new FixStackFramesDelegate(file, file2, (Set<? extends File>)object2, (Set<? extends File>)object3, (File)object4, (File)object, this.getWorkerExecutor(), this, (Provider<ClassesHierarchyBuildService>)((Provider)this.getClassesHierarchyBuildService()));
    }

    @Override
    public void doTaskAction(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        if (inputChanges.isIncremental()) {
            FixStackFramesDelegate fixStackFramesDelegate = this.createDelegate();
            Iterable iterable = inputChanges.getFileChanges((Provider)this.getJarsInputDir());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(jarsInputDir)");
            Iterable iterable2 = iterable;
            iterable = inputChanges.getFileChanges((Provider)this.getClassesInputDir());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(classesInputDir)");
            fixStackFramesDelegate.doIncrementalRun(iterable2, iterable);
        } else {
            this.createDelegate().doFullRun();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/RecalculateStackFramesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/RecalculateStackFramesTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<RecalculateStackFramesTask, ComponentCreationConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<RecalculateStackFramesTask> type;

        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
            this.name = this.computeTaskName("fixInstrumented", "ClassesStackFrames");
            this.type = RecalculateStackFramesTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<RecalculateStackFramesTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<RecalculateStackFramesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.FIXED_STACK_FRAMES_ASM_INSTRUMENTED_PROJECT_CLASSES.INSTANCE);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).on(InternalArtifactType.FIXED_STACK_FRAMES_ASM_INSTRUMENTED_PROJECT_JARS.INSTANCE);
        }

        @Override
        public void configure(@NotNull RecalculateStackFramesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            this.creationConfig.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.ASM_INSTRUMENTED_PROJECT_CLASSES.INSTANCE, (Property)task.getClassesInputDir());
            this.creationConfig.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.ASM_INSTRUMENTED_PROJECT_JARS.INSTANCE, (Property)task.getJarsInputDir());
            Object[] objectArray = new Object[]{this.creationConfig.getGlobal().getBootClasspath()};
            task.getBootClasspath().from(objectArray).disallowChanges();
            objectArray = new Object[]{this.creationConfig.getVariantScope().getProvidedOnlyClasspath()};
            ConfigurableFileCollection configurableFileCollection = task.getReferencedClasses().from(objectArray);
            objectArray = new Object[]{this.creationConfig.getDependenciesClassesJarsPostAsmInstrumentation(AndroidArtifacts.ArtifactScope.ALL)};
            configurableFileCollection.from(objectArray).disallowChanges();
            Property<ClassesHierarchyBuildService> property = task.getClassesHierarchyBuildService();
            BuildServiceRegistry buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(ClassesHierarchyBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            Provider provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        }
    }
}

