/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.Version;
import com.android.build.gradle.internal.cxx.logging.CxxStructuredLogEncoder;
import com.android.build.gradle.internal.cxx.logging.EncodedLoggingMessage;
import com.android.build.gradle.internal.cxx.logging.IssueReporterLoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.LoggingMessage;
import com.android.build.gradle.internal.cxx.logging.LoggingMessageKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughDeduplicatingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.builder.errors.IssueReporter;
import com.google.protobuf.GeneratedMessageV3;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u00020\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/IssueReporterLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/PassThroughDeduplicatingLoggingEnvironment;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "rootBuildGradleFolder", "Ljava/io/File;", "cxxFolder", "(Lcom/android/builder/errors/IssueReporter;Ljava/io/File;Ljava/io/File;)V", "analyticsService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "(Lcom/android/builder/errors/IssueReporter;Lcom/android/build/gradle/internal/profile/AnalyticsService;Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;)V", "internals", "Lcom/android/build/gradle/internal/cxx/logging/IssueReporterLoggingEnvironment$CxxDiagnosticCodesTrackingInternals;", "(Lcom/android/builder/errors/IssueReporter;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/cxx/logging/IssueReporterLoggingEnvironment$CxxDiagnosticCodesTrackingInternals;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "structuredLogEncoder", "Lcom/android/build/gradle/internal/cxx/logging/CxxStructuredLogEncoder;", "close", "", "log", "message", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "logStructured", "Lkotlin/Function1;", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "Lcom/google/protobuf/GeneratedMessageV3;", "CxxDiagnosticCodesTrackingInternals", "gradle-core"})
public final class IssueReporterLoggingEnvironment
extends PassThroughDeduplicatingLoggingEnvironment {
    @NotNull
    private final IssueReporter issueReporter;
    @Nullable
    private final File cxxFolder;
    @Nullable
    private final CxxDiagnosticCodesTrackingInternals internals;
    @Nullable
    private final CxxStructuredLogEncoder structuredLogEncoder;
    private final Logger logger;

    private IssueReporterLoggingEnvironment(IssueReporter issueReporter2, File rootBuildGradleFolder, File cxxFolder, CxxDiagnosticCodesTrackingInternals internals) {
        CxxStructuredLogEncoder cxxStructuredLogEncoder;
        this.issueReporter = issueReporter2;
        this.cxxFolder = cxxFolder;
        this.internals = internals;
        File structuredLogFolder = IssueReporterLoggingEnvironmentKt.getCxxStructuredLogFolder(rootBuildGradleFolder);
        if (structuredLogFolder.isDirectory()) {
            File log2 = FilesKt.resolve((File)structuredLogFolder, (String)("log_" + System.currentTimeMillis() + '_' + Thread.currentThread().getId() + ".bin"));
            cxxStructuredLogEncoder = new CxxStructuredLogEncoder(log2);
        } else {
            cxxStructuredLogEncoder = null;
        }
        this.structuredLogEncoder = cxxStructuredLogEncoder;
        this.logger = Logging.getLogger(IssueReporterLoggingEnvironment.class);
    }

    public IssueReporterLoggingEnvironment(@NotNull IssueReporter issueReporter2, @NotNull File rootBuildGradleFolder, @Nullable File cxxFolder) {
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)rootBuildGradleFolder, (String)"rootBuildGradleFolder");
        this(issueReporter2, rootBuildGradleFolder, cxxFolder, null);
    }

    public IssueReporterLoggingEnvironment(@NotNull IssueReporter issueReporter2, @NotNull AnalyticsService analyticsService, @NotNull CxxVariantModel variant2) {
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        boolean bl = false;
        this(issueReporter2, variant2.getModule().getProject().getRootBuildGradleFolder(), variant2.getModule().getCxxFolder(), new CxxDiagnosticCodesTrackingInternals(analyticsService, variant2, new ArrayList()));
    }

    @Override
    public void log(@NotNull LoggingMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>(message2){
            final /* synthetic */ LoggingMessage $message;
            {
                this.$message = $message;
                super(1);
            }

            @NotNull
            public final GeneratedMessageV3 invoke(@NotNull StringEncoder strings) {
                Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
                EncodedLoggingMessage.Builder builder = EncodedLoggingMessage.newBuilder().setLevel(this.$message.getLevel());
                Object object = this.$message.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"message.message");
                EncodedLoggingMessage.Builder encoded = builder.setMessageId(strings.encode((String)object)).setDiagnosticCode(this.$message.getDiagnosticCode());
                if (this.$message.getFile() != null) {
                    object = this.$message.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"message.file");
                    encoded.setFileId(strings.encode((String)object));
                }
                if (this.$message.getTag() != null) {
                    object = this.$message.getTag();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"message.tag");
                    encoded.setTagId(strings.encode((String)object));
                }
                object = encoded.build();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"encoded.build()");
                return (GeneratedMessageV3)object;
            }
        }));
        LoggingMessage.LoggingLevel loggingLevel = message2.getLevel();
        int n = loggingLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[loggingLevel.ordinal()];
        switch (n) {
            case 1: {
                this.logger.info(LoggingMessageKt.text(message2));
                break;
            }
            case 2: {
                this.logger.lifecycle(LoggingMessageKt.text(message2));
                break;
            }
            case 3: {
                CxxDiagnosticCodesTrackingInternals cxxDiagnosticCodesTrackingInternals = this.internals;
                if (cxxDiagnosticCodesTrackingInternals != null) {
                    List<Integer> list = cxxDiagnosticCodesTrackingInternals.getCxxDiagnosticCodes();
                    list.add(message2.getDiagnosticCode());
                }
                IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, (String)LoggingMessageKt.text(message2), null, null, (int)12, null);
                this.logger.warn(LoggingMessageKt.text(message2));
                break;
            }
            case 4: {
                CxxDiagnosticCodesTrackingInternals cxxDiagnosticCodesTrackingInternals = this.internals;
                if (cxxDiagnosticCodesTrackingInternals != null) {
                    List<Integer> list = cxxDiagnosticCodesTrackingInternals.getCxxDiagnosticCodes();
                    list.add(message2.getDiagnosticCode());
                }
                IssueReporter.reportError$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, (String)LoggingMessageKt.text(message2), null, null, (int)12, null);
                this.logger.error(LoggingMessageKt.text(message2));
                break;
            }
            case 5: {
                Object object;
                CxxDiagnosticCodesTrackingInternals cxxDiagnosticCodesTrackingInternals = this.internals;
                if (cxxDiagnosticCodesTrackingInternals != null) {
                    object = cxxDiagnosticCodesTrackingInternals.getCxxDiagnosticCodes();
                    object.add(message2.getDiagnosticCode());
                }
                StringBuilder sb = new StringBuilder(LoggingMessageKt.text(message2));
                sb.append("Please refer to bug https://issuetracker.google.com/" + message2.getDiagnosticCode() + " for more information.\n");
                if (this.cxxFolder != null) {
                    sb.append("If possible, please also attach a zipped copy of " + this.cxxFolder + " to the bug to assist in diagnosing the issue.\n");
                }
                sb.append("The current Android Gradle Plugin Version is " + Version.ANDROID_GRADLE_PLUGIN_VERSION + ".\n");
                object = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
                IssueReporter.reportError$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, (String)object, null, null, (int)12, null);
                this.logger.error(sb.toString());
            }
        }
    }

    @Override
    public void logStructured(@NotNull Function1<? super StringEncoder, ? extends GeneratedMessageV3> message2) {
        Intrinsics.checkNotNullParameter(message2, (String)"message");
        CxxStructuredLogEncoder cxxStructuredLogEncoder = this.structuredLogEncoder;
        if (cxxStructuredLogEncoder != null) {
            cxxStructuredLogEncoder.write((GeneratedMessageV3)message2.invoke((Object)this.structuredLogEncoder));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.structuredLogEncoder != null) {
                LoggingEnvironmentKt.lifecycleln("Closing '" + this.structuredLogEncoder.getFile() + '\'', new Object[0]);
                this.structuredLogEncoder.close();
            }
            if (this.internals != null) {
                CxxVariantModel variant2 = this.internals.getVariant();
                GradleBuildVariant.Builder builder = this.internals.getAnalyticsService().getVariantBuilder(variant2.getModule().getGradleModulePathName(), variant2.getVariantName());
                if (builder == null) {
                    return;
                }
                GradleBuildVariant.Builder builder2 = builder;
                builder2.addAllCxxDiagnosticCodes((Iterable)this.internals.getCxxDiagnosticCodes());
            }
        }
        finally {
            super.close();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/IssueReporterLoggingEnvironment$CxxDiagnosticCodesTrackingInternals;", "", "analyticsService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "cxxDiagnosticCodes", "", "", "(Lcom/android/build/gradle/internal/profile/AnalyticsService;Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/List;)V", "getAnalyticsService", "()Lcom/android/build/gradle/internal/profile/AnalyticsService;", "getCxxDiagnosticCodes", "()Ljava/util/List;", "getVariant", "()Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "gradle-core"})
    private static final class CxxDiagnosticCodesTrackingInternals {
        @NotNull
        private final AnalyticsService analyticsService;
        @NotNull
        private final CxxVariantModel variant;
        @NotNull
        private final List<Integer> cxxDiagnosticCodes;

        public CxxDiagnosticCodesTrackingInternals(@NotNull AnalyticsService analyticsService, @NotNull CxxVariantModel variant2, @NotNull List<Integer> cxxDiagnosticCodes) {
            Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            Intrinsics.checkNotNullParameter(cxxDiagnosticCodes, (String)"cxxDiagnosticCodes");
            this.analyticsService = analyticsService;
            this.variant = variant2;
            this.cxxDiagnosticCodes = cxxDiagnosticCodes;
        }

        @NotNull
        public final AnalyticsService getAnalyticsService() {
            return this.analyticsService;
        }

        @NotNull
        public final CxxVariantModel getVariant() {
            return this.variant;
        }

        @NotNull
        public final List<Integer> getCxxDiagnosticCodes() {
            return this.cxxDiagnosticCodes;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoggingMessage.LoggingLevel.values().length];
            nArray[LoggingMessage.LoggingLevel.INFO.ordinal()] = 1;
            nArray[LoggingMessage.LoggingLevel.LIFECYCLE.ordinal()] = 2;
            nArray[LoggingMessage.LoggingLevel.WARN.ordinal()] = 3;
            nArray[LoggingMessage.LoggingLevel.ERROR.ordinal()] = 4;
            nArray[LoggingMessage.LoggingLevel.BUG.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

