/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.api.variant.impl.DirectoryEntry;
import com.android.build.api.variant.impl.SourceDirectoriesImpl;
import com.android.build.api.variant.impl.SourcesImpl;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.v2.CustomSourceDirectory;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import kotlin.jvm.functions.Function1;

final class SourceProviderImpl
implements SourceProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final File manifestFile;
    private final Collection<File> javaDirs;
    private final Collection<File> kotlinDirs;
    private final Collection<File> resourcesDirs;
    private final Collection<File> aidlDirs;
    private final Collection<File> rsDirs;
    private final Collection<File> resDirs;
    private final Collection<File> assetsDirs;
    private final Collection<File> libsDirs;
    private final Collection<File> shaderDirs;
    private final Collection<File> mlModelsDirs;
    private final Collection<CustomSourceDirectory> customDirectories;

    public SourceProviderImpl(SourceProvider sourceProvider) {
        this.name = sourceProvider.getName();
        this.manifestFile = sourceProvider.getManifestFile();
        this.javaDirs = sourceProvider.getJavaDirectories();
        this.kotlinDirs = sourceProvider.getKotlinDirectories();
        this.resourcesDirs = sourceProvider.getResourcesDirectories();
        this.aidlDirs = sourceProvider.getAidlDirectories();
        this.rsDirs = sourceProvider.getRenderscriptDirectories();
        this.resDirs = sourceProvider.getResDirectories();
        this.assetsDirs = sourceProvider.getAssetsDirectories();
        this.libsDirs = sourceProvider.getJniLibsDirectories();
        this.shaderDirs = sourceProvider.getShadersDirectories();
        this.mlModelsDirs = sourceProvider.getMlModelsDirectories();
        this.customDirectories = sourceProvider.getCustomDirectories();
    }

    public SourceProviderImpl(SourceProvider sourceProvider, SourcesImpl variantSources) {
        this.name = sourceProvider.getName();
        this.manifestFile = sourceProvider.getManifestFile();
        this.javaDirs = this.getSourcesForIdeModel(variantSources.getJava());
        this.kotlinDirs = this.getSourcesForIdeModel(variantSources.getKotlin());
        this.resourcesDirs = sourceProvider.getResourcesDirectories();
        this.aidlDirs = sourceProvider.getAidlDirectories();
        this.rsDirs = sourceProvider.getRenderscriptDirectories();
        this.resDirs = this.getSourcesForIdeModel(variantSources.getRes());
        this.assetsDirs = this.getSourcesForIdeModel(variantSources.getAssets());
        this.libsDirs = this.getSourcesForIdeModel(variantSources.getJniLibs());
        this.shaderDirs = this.getSourcesForIdeModel(variantSources.getShaders());
        this.mlModelsDirs = sourceProvider.getMlModelsDirectories();
        this.customDirectories = sourceProvider.getCustomDirectories();
    }

    private Collection<File> getSourcesForIdeModel(SourceDirectoriesImpl sourceDirectories) {
        return sourceDirectories.variantSourcesForModel$gradle_core((Function1<? super DirectoryEntry, Boolean>)((Function1)directoryEntry -> directoryEntry.getShouldBeAddedToIdeModel()));
    }

    public String getName() {
        return this.name;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public Collection<File> getJavaDirectories() {
        return this.javaDirs;
    }

    public Collection<File> getKotlinDirectories() {
        return this.kotlinDirs;
    }

    public Collection<File> getResourcesDirectories() {
        return this.resourcesDirs;
    }

    public Collection<File> getAidlDirectories() {
        return this.aidlDirs;
    }

    public Collection<File> getRenderscriptDirectories() {
        return this.rsDirs;
    }

    public Collection<File> getCDirectories() {
        return Collections.emptyList();
    }

    public Collection<File> getCppDirectories() {
        return Collections.emptyList();
    }

    public Collection<File> getResDirectories() {
        return this.resDirs;
    }

    public Collection<File> getAssetsDirectories() {
        return this.assetsDirs;
    }

    public Collection<File> getJniLibsDirectories() {
        return this.libsDirs;
    }

    public Collection<File> getShadersDirectories() {
        return this.shaderDirs;
    }

    public Collection<File> getMlModelsDirectories() {
        return this.mlModelsDirs;
    }

    public Collection<CustomSourceDirectory> getCustomDirectories() {
        return this.customDirectories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceProviderImpl that = (SourceProviderImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.manifestFile, that.manifestFile) && Objects.equals(this.javaDirs, that.javaDirs) && Objects.equals(this.kotlinDirs, that.kotlinDirs) && Objects.equals(this.resourcesDirs, that.resourcesDirs) && Objects.equals(this.aidlDirs, that.aidlDirs) && Objects.equals(this.rsDirs, that.rsDirs) && Objects.equals(this.resDirs, that.resDirs) && Objects.equals(this.assetsDirs, that.assetsDirs) && Objects.equals(this.libsDirs, that.libsDirs) && Objects.equals(this.shaderDirs, that.shaderDirs) && Objects.equals(this.mlModelsDirs, that.mlModelsDirs) && Objects.equals(this.customDirectories, that.customDirectories);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.manifestFile, this.javaDirs, this.kotlinDirs, this.resourcesDirs, this.aidlDirs, this.rsDirs, this.resDirs, this.assetsDirs, this.libsDirs, this.shaderDirs, this.mlModelsDirs, this.customDirectories);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("manifestFile", (Object)this.manifestFile).add("javaDirs", this.javaDirs).add("kotlinDirs", this.kotlinDirs).add("resourcesDirs", this.resourcesDirs).add("aidlDirs", this.aidlDirs).add("rsDirs", this.rsDirs).add("resDirs", this.resDirs).add("assetsDirs", this.assetsDirs).add("libsDirs", this.libsDirs).add("shaderDirs", this.shaderDirs).add("mlModelsDirs", this.mlModelsDirs).add("customDirectories", this.customDirectories).toString();
    }
}

