/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.AndroidLintInputs;
import com.android.build.gradle.internal.lint.AndroidLintWorkAction;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintTool;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.utils.PathUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!J,\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140!2\u0006\u0010'\u001a\u00020(JP\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140!2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/lint/LintTool;", "", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "lintCacheDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getLintCacheDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "lintClassLoaderBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/LintClassLoaderBuildService;", "getLintClassLoaderBuildService", "()Lorg/gradle/api/provider/Property;", "runInProcess", "", "getRunInProcess", "version", "", "getVersion", "versionKey", "getVersionKey", "workerHeapSize", "getWorkerHeapSize", "deriveVersionKey", "Lorg/gradle/api/provider/Provider;", "taskCreationServices", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "initialize", "", "initializeLintCacheDir", "", "submit", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "mainClass", "arguments", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "android", "fatalOnly", "await", "returnValueOutputFile", "Ljava/io/File;", "gradle-core"})
public abstract class LintTool {
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    @NotNull
    public abstract Property<String> getVersionKey();

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getRunInProcess();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getWorkerHeapSize();

    @Internal
    @NotNull
    public abstract DirectoryProperty getLintCacheDirectory();

    @NotNull
    public final List<String> initializeLintCacheDir() {
        String string;
        Object[] objectArray;
        Path directory2 = ((Directory)this.getLintCacheDirectory().get()).getAsFile().toPath();
        Object[] lintVersionMarkerFile = directory2.resolve("lint-cache-version.txt");
        String currentVersion = Intrinsics.stringPlus((String)"Cache for Android Lint", (Object)this.getVersionKey().get());
        Object[] objectArray2 = lintVersionMarkerFile;
        boolean bl = false;
        boolean bl2 = false;
        Object[] it = objectArray2;
        boolean bl3 = false;
        Object object = objectArray = Files.exists((Path)it, new LinkOption[0]) ? objectArray2 : null;
        if (objectArray == null) {
            string = null;
        } else {
            objectArray2 = objectArray;
            bl = false;
            bl2 = false;
            it = objectArray2;
            boolean bl4 = false;
            List<String> list = Files.readAllLines((Path)it);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(it)");
            string = (String)CollectionsKt.singleOrNull(list);
        }
        String previousVersion = string;
        if (!Intrinsics.areEqual(previousVersion, (Object)currentVersion)) {
            PathUtils.deleteRecursivelyIfExists((Path)directory2);
            Files.createDirectories(directory2, new FileAttribute[0]);
            Files.write((Path)lintVersionMarkerFile, (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)currentVersion), new OpenOption[0]);
        }
        objectArray = new String[]{"--cache-dir", ((Object)directory2).toString()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Internal
    @NotNull
    public abstract Property<LintClassLoaderBuildService> getLintClassLoaderBuildService();

    public final void initialize(@NotNull TaskCreationServices taskCreationServices) {
        String string;
        Intrinsics.checkNotNullParameter((Object)taskCreationServices, (String)"taskCreationServices");
        Object[] objectArray = new Object[]{taskCreationServices.getLintFromMaven().getFiles()};
        HasConfigurableValuesKt.fromDisallowChanges(this.getClasspath(), objectArray);
        Property<LintClassLoaderBuildService> property = this.getLintClassLoaderBuildService();
        Object buildServiceRegistry$iv = taskCreationServices.getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(LintClassLoaderBuildService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        HasConfigurableValuesKt.setDisallowChanges(this.getVersionKey(), this.deriveVersionKey(taskCreationServices, (Provider<LintClassLoaderBuildService>)((Provider)this.getLintClassLoaderBuildService())));
        Property<String> property2 = this.getVersion();
        buildServiceRegistry$iv = taskCreationServices.getProjectOptions().get(StringOption.LINT_VERSION_OVERRIDE);
        if (buildServiceRegistry$iv == null) {
            string = null;
        } else {
            Object object2 = buildServiceRegistry$iv;
            boolean bl = false;
            string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        }
        HasConfigurableValuesKt.setDisallowChanges(property2, AndroidLintInputs.getLintMavenArtifactVersion$default(string, null, null, null, 12, null));
        ProjectOptions projectOptions = taskCreationServices.getProjectOptions();
        Property<Boolean> property3 = this.getRunInProcess();
        Provider provider3 = projectOptions.getProvider(BooleanOption.RUN_LINT_IN_PROCESS);
        Intrinsics.checkNotNullExpressionValue(provider3, (String)"projectOptions.getProvid\u2026tion.RUN_LINT_IN_PROCESS)");
        HasConfigurableValuesKt.setDisallowChanges(property3, provider3);
        Property<String> property4 = this.getWorkerHeapSize();
        provider3 = projectOptions.getProvider(StringOption.LINT_HEAP_SIZE);
        Intrinsics.checkNotNullExpressionValue(provider3, (String)"projectOptions.getProvid\u2026ingOption.LINT_HEAP_SIZE)");
        HasConfigurableValuesKt.setDisallowChanges(property4, provider3);
        Property property5 = (Property)this.getLintCacheDirectory();
        provider3 = taskCreationServices.getProjectInfo().getBuildDirectory().dir("intermediates/lint-cache");
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"taskCreationServices.pro\u2026TERMEDIATES}/lint-cache\")");
        HasConfigurableValuesKt.setDisallowChanges(property5, provider3);
    }

    private final Provider<String> deriveVersionKey(TaskCreationServices taskCreationServices, Provider<LintClassLoaderBuildService> lintClassLoaderBuildService) {
        Object object;
        String string;
        String string2;
        String string3 = taskCreationServices.getProjectOptions().get(StringOption.LINT_VERSION_OVERRIDE);
        if (string3 == null) {
            string2 = null;
        } else {
            string = string3;
            boolean bl = false;
            string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        String lintVersion = AndroidLintInputs.getLintMavenArtifactVersion$default(string2, null, null, null, 12, null);
        Provider versionProvider2 = taskCreationServices.provider((Function0)new Function0<String>(lintVersion){
            final /* synthetic */ String $lintVersion;
            {
                this.$lintVersion = $lintVersion;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$lintVersion;
            }
        });
        if (StringsKt.endsWith$default((String)lintVersion, (String)"-dev", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)lintVersion, (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
            Provider jarsHash2 = lintClassLoaderBuildService.zip(this.getClasspath().getElements(), (BiFunction)deriveVersionKey.jarsHash.1.INSTANCE);
            string = versionProvider2.zip(jarsHash2, (BiFunction)deriveVersionKey.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n                val ja\u2026n}_$hash\" }\n            }");
            object = string;
        } else {
            object = versionProvider2;
        }
        return object;
    }

    public final void submit(@NotNull WorkerExecutor workerExecutor, @NotNull String mainClass, @NotNull List<String> arguments, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        LintTool.submit$default(this, workerExecutor, mainClass, arguments, true, false, false, lintMode, null, 128, null);
    }

    public final void submit(@NotNull WorkerExecutor workerExecutor, @NotNull String mainClass, @NotNull List<String> arguments, boolean android, boolean fatalOnly, boolean await, @NotNull LintMode lintMode, @Nullable File returnValueOutputFile) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        Object object = this.getRunInProcess().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runInProcess.get()");
        WorkQueue workQueue2 = (Boolean)object != false ? workerExecutor.noIsolation() : workerExecutor.processIsolation(new Action(this){
            final /* synthetic */ LintTool this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ProcessWorkerSpec it) {
                Object object = new Object[]{this.this$0.getClasspath()};
                it.getClasspath().from(object);
                object = (String)this.this$0.getWorkerHeapSize().getOrNull();
                it.getForkOptions().setMaxHeapSize((String)(object == null ? "" + Runtime.getRuntime().maxMemory() / (long)1024 / (long)1024 + 'm' : object));
            }
        });
        workQueue2.submit(AndroidLintWorkAction.class, new Action(mainClass, arguments, this, android, fatalOnly, returnValueOutputFile, lintMode){
            final /* synthetic */ String $mainClass;
            final /* synthetic */ List<String> $arguments;
            final /* synthetic */ LintTool this$0;
            final /* synthetic */ boolean $android;
            final /* synthetic */ boolean $fatalOnly;
            final /* synthetic */ File $returnValueOutputFile;
            final /* synthetic */ LintMode $lintMode;
            {
                this.$mainClass = $mainClass;
                this.$arguments = $arguments;
                this.this$0 = $receiver;
                this.$android = $android;
                this.$fatalOnly = $fatalOnly;
                this.$returnValueOutputFile = $returnValueOutputFile;
                this.$lintMode = $lintMode;
            }

            public final void execute(AndroidLintWorkAction.LintWorkActionParameters parameters) {
                parameters.getMainClass().set((Object)this.$mainClass);
                parameters.getArguments().set((Iterable)this.$arguments);
                Object[] objectArray = new Object[]{this.this$0.getClasspath()};
                parameters.getClasspath().from(objectArray);
                parameters.getVersionKey().set((Provider)this.this$0.getVersionKey());
                parameters.getAndroid().set((Object)this.$android);
                parameters.getFatalOnly().set((Object)this.$fatalOnly);
                parameters.getRunInProcess().set(this.this$0.getRunInProcess().get());
                parameters.getReturnValueOutputFile().set(this.$returnValueOutputFile);
                parameters.getLintMode().set((Object)((Object)this.$lintMode));
            }
        });
        if (await) {
            workQueue2.await();
        }
    }

    public static /* synthetic */ void submit$default(LintTool lintTool, WorkerExecutor workerExecutor, String string, List list, boolean bl, boolean bl2, boolean bl3, LintMode lintMode, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: submit");
        }
        if ((n & 0x80) != 0) {
            file = null;
        }
        lintTool.submit(workerExecutor, string, list, bl, bl2, bl3, lintMode, file);
    }
}

