/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.AndroidVersion;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.utils.D8BackportedMethodsGenerator;
import com.android.build.gradle.internal.utils.DesugarConfigJson;
import com.android.build.gradle.internal.utils.DesugarLibConfigExtractor;
import com.android.build.gradle.internal.utils.DesugarLibLintExtractor;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.builder.packaging.JarFlinger;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.sdklib.AndroidTargetHash;
import com.android.tools.r8.Version;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013\u001a \u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u001a<\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u001e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u0011\u001a(\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001H\u0002\u001a\u0010\u0010&\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a \u0010'\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"ANDROID_SUBDIR", "", "ATTR_LINT_COMPILE_SDK", "Lorg/gradle/api/attributes/Attribute;", "ATTR_LINT_MIN_SDK", "D8_DESUGAR_METHODS", "DESUGAR_LIB_CONFIG", "DESUGAR_LIB_CONFIG_FILE", "DESUGAR_LIB_DEX", "DESUGAR_LIB_LINT", "FAKE_DEPENDENCY_JAR", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getD8DesugarMethodFileFromTransform", "getDesugarLibConfig", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "getDesugarLibConfigFromTransform", "getDesugarLibConfiguration", "getDesugarLibJarFromMaven", "getDesugarLibLintFromTransform", "minSdkVersion", "", "compileSdkVersion", "getDesugaredMethods", "coreLibDesugar", "", "Lcom/android/build/api/variant/AndroidVersion;", "bootclasspath", "", "Lorg/gradle/api/file/RegularFile;", "registerD8BackportedMethodsTransform", "", "Lorg/gradle/api/file/ConfigurableFileCollection;", "d8Version", "registerDesugarLibConfigTransform", "registerDesugarLibLintTransform", "gradle-core"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    @NotNull
    private static final String DESUGAR_LIB_CONFIG_FILE = "desugar.json";
    @NotNull
    private static final String ANDROID_SUBDIR = "android";
    @NotNull
    private static final String FAKE_DEPENDENCY_JAR = "FakeDependency.jar";
    @NotNull
    public static final String DESUGAR_LIB_DEX = "_internal-desugar-lib-dex";
    @NotNull
    public static final String DESUGAR_LIB_CONFIG = "_internal-desugar-lib-config";
    @NotNull
    private static final String DESUGAR_LIB_LINT = "_internal-desugar-lib-lint";
    @NotNull
    private static final String D8_DESUGAR_METHODS = "_internal-d8-desugar-methods";
    @NotNull
    private static final Attribute<String> ATTR_LINT_MIN_SDK;
    @NotNull
    private static final Attribute<String> ATTR_LINT_COMPILE_SDK;

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Configuration configuration = DesugarLibUtils.getDesugarLibConfiguration(project2);
        return DesugarLibUtils.getArtifactCollection(configuration);
    }

    @NotNull
    public static final Provider<String> getDesugarLibConfig(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration = (Configuration)object2;
        DesugarLibUtils.registerDesugarLibConfigTransform(project2);
        object2 = project2.getProviders().of(DesugarConfigJson.class, new Action(configuration){
            final /* synthetic */ Configuration $configuration;
            {
                this.$configuration = $configuration;
            }

            public final void execute(ValueSourceSpec<DesugarConfigJson.Parameters> it) {
                ((DesugarConfigJson.Parameters)it.getParameters()).getDesugarJson().setFrom((Iterable)DesugarLibUtils.access$getDesugarLibConfigFromTransform(this.$configuration));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"val configuration = proj\u2026orm(configuration))\n    }");
        return object2;
    }

    @NotNull
    public static final FileCollection getDesugaredMethods(@NotNull Project project2, boolean coreLibDesugar, @NotNull AndroidVersion minSdkVersion2, @Nullable String compileSdkVersion, @NotNull Provider<List<RegularFile>> bootclasspath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)minSdkVersion2, (String)"minSdkVersion");
        Intrinsics.checkNotNullParameter(bootclasspath, (String)"bootclasspath");
        ConfigurableFileCollection desugaredMethodsFiles = project2.getObjects().fileCollection();
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration coreLibDesugarConfig = (Configuration)object2;
        if (coreLibDesugar && compileSdkVersion != null) {
            int minSdk = VariantApiExtensionsKt.getFeatureLevel(minSdkVersion2);
            com.android.sdklib.AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)compileSdkVersion);
            Intrinsics.checkNotNull((Object)androidVersion);
            int compileSdk = androidVersion.getFeatureLevel();
            DesugarLibUtils.registerDesugarLibLintTransform(project2, minSdk, compileSdk);
            Object[] objectArray = new Object[]{DesugarLibUtils.getDesugarLibLintFromTransform(coreLibDesugarConfig, minSdk, compileSdk)};
            desugaredMethodsFiles.from(objectArray);
        }
        File file = project2.getGradle().getGradleUserHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.gradle.gradleUserHomeDir");
        object2 = SynchronizedFile.getInstanceWithMultiProcessLocking((File)FilesKt.resolve((File)file, (String)ANDROID_SUBDIR)).write(new ExceptionFunction(project2, coreLibDesugar, bootclasspath, desugaredMethodsFiles){
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $coreLibDesugar;
            final /* synthetic */ Provider<List<RegularFile>> $bootclasspath;
            final /* synthetic */ ConfigurableFileCollection $desugaredMethodsFiles;
            {
                this.$project = $project;
                this.$coreLibDesugar = $coreLibDesugar;
                this.$bootclasspath = $bootclasspath;
                this.$desugaredMethodsFiles = $desugaredMethodsFiles;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final ConfigurableFileCollection accept(File it) {
                Object[] objectArray;
                Object[] objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                File fakeJar = FilesKt.resolve((File)it, (String)"FakeDependency.jar");
                if (!fakeJar.exists()) {
                    fakeJar.getParentFile().mkdirs();
                    Closeable closeable = (Closeable)new JarFlinger(fakeJar.toPath());
                    boolean bl = false;
                    boolean bl2 = false;
                    objectArray2 = null;
                    try {
                        JarFlinger it2 = (JarFlinger)closeable;
                        boolean bl3 = false;
                        objectArray = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        objectArray2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)objectArray2);
                    }
                }
                Object[] objectArray3 = new Object[]{fakeJar};
                Dependency fakeDependency = this.$project.getDependencies().create((Object)this.$project.files(objectArray3));
                objectArray2 = new Dependency[]{fakeDependency};
                Configuration adhocConfiguration = this.$project.getConfigurations().detachedConfiguration((Dependency[])objectArray2);
                objectArray = new Object[]{this.$bootclasspath};
                objectArray2 = this.$project.files(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"project.files(bootclasspath)");
                ConfigurableFileCollection configurableFileCollection = objectArray2;
                objectArray2 = Version.getVersionString();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getVersionString()");
                DesugarLibUtils.access$registerD8BackportedMethodsTransform(this.$project, this.$coreLibDesugar, configurableFileCollection, (String)objectArray2);
                objectArray2 = this.$desugaredMethodsFiles;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"desugaredMethodsFiles");
                Object object = objectArray2;
                objectArray2 = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)adhocConfiguration, (String)"adhocConfiguration");
                objectArray2[0] = DesugarLibUtils.access$getD8DesugarMethodFileFromTransform(adhocConfiguration);
                HasConfigurableValuesKt.fromDisallowChanges(object, objectArray2);
                return this.$desugaredMethodsFiles;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project: Project,\n    co\u2026sugaredMethodsFiles\n    }");
        return (FileCollection)object2;
    }

    private static final Configuration getDesugarLibConfiguration(Project project2) {
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration = (Configuration)object2;
        if (configuration.getDependencies().isEmpty()) {
            throw new RuntimeException("coreLibraryDesugaring configuration contains no dependencies. If you intend to enable core library desugaring, please add dependencies to coreLibraryDesugaring configuration.");
        }
        return configuration;
    }

    private static final FileCollection getDesugarLibConfigFromTransform(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)getDesugarLibConfigFromTransform.1.INSTANCE).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final void registerDesugarLibConfigTransform(Project project2) {
        project2.getDependencies().registerTransform(DesugarLibConfigExtractor.class, (Action)registerDesugarLibConfigTransform.1.INSTANCE);
    }

    private static final void registerDesugarLibLintTransform(Project project2, int minSdkVersion2, int compileSdkVersion) {
        project2.getDependencies().registerTransform(DesugarLibLintExtractor.class, new Action(minSdkVersion2, compileSdkVersion){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$compileSdkVersion = $compileSdkVersion;
            }

            public final void execute(TransformSpec<DesugarLibLintExtractor.Parameters> spec) {
                spec.parameters(new Action(this.$minSdkVersion, this.$compileSdkVersion){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ int $compileSdkVersion;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$compileSdkVersion = $compileSdkVersion;
                    }

                    public final void execute(DesugarLibLintExtractor.Parameters parameters) {
                        parameters.getMinSdkVersion().set((Object)this.$minSdkVersion);
                        parameters.getCompileSdkVersion().set((Object)this.$compileSdkVersion);
                    }
                });
                spec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                spec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-lint");
                spec.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                spec.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                spec.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                spec.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
            }
        });
    }

    private static final void registerD8BackportedMethodsTransform(Project project2, boolean coreLibDesugar, ConfigurableFileCollection bootclasspath, String d8Version) {
        project2.getDependencies().registerTransform(D8BackportedMethodsGenerator.class, new Action(d8Version, coreLibDesugar, project2, bootclasspath){
            final /* synthetic */ String $d8Version;
            final /* synthetic */ boolean $coreLibDesugar;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigurableFileCollection $bootclasspath;
            {
                this.$d8Version = $d8Version;
                this.$coreLibDesugar = $coreLibDesugar;
                this.$project = $project;
                this.$bootclasspath = $bootclasspath;
            }

            public final void execute(TransformSpec<D8BackportedMethodsGenerator.Parameters> spec) {
                spec.parameters(new Action(this.$d8Version, this.$coreLibDesugar, this.$project, this.$bootclasspath){
                    final /* synthetic */ String $d8Version;
                    final /* synthetic */ boolean $coreLibDesugar;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ConfigurableFileCollection $bootclasspath;
                    {
                        this.$d8Version = $d8Version;
                        this.$coreLibDesugar = $coreLibDesugar;
                        this.$project = $project;
                        this.$bootclasspath = $bootclasspath;
                    }

                    public final void execute(D8BackportedMethodsGenerator.Parameters parameters) {
                        parameters.getD8Version().set((Object)this.$d8Version);
                        if (this.$coreLibDesugar) {
                            parameters.getCoreLibDesugarConfig().set(DesugarLibUtils.getDesugarLibConfig(this.$project));
                            Object[] objectArray = new Object[]{this.$bootclasspath};
                            parameters.getBootclasspath().from(objectArray);
                        }
                    }
                });
                spec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                spec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-d8-desugar-methods");
            }
        });
    }

    private static final FileCollection getDesugarLibLintFromTransform(Configuration configuration, int minSdkVersion2, int compileSdkVersion) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(new Action(minSdkVersion2, compileSdkVersion){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$compileSdkVersion = $compileSdkVersion;
            }

            public final void execute(ArtifactView.ViewConfiguration configuration) {
                configuration.attributes(new Action(this.$minSdkVersion, this.$compileSdkVersion){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ int $compileSdkVersion;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$compileSdkVersion = $compileSdkVersion;
                    }

                    public final void execute(AttributeContainer it) {
                        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-lint");
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                    }
                });
            }
        }).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"minSdkVersion: Int,\n    \u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getD8DesugarMethodFileFromTransform(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)getD8DesugarMethodFileFromTransform.1.INSTANCE).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    public static final /* synthetic */ FileCollection access$getDesugarLibConfigFromTransform(Configuration configuration) {
        return DesugarLibUtils.getDesugarLibConfigFromTransform(configuration);
    }

    public static final /* synthetic */ void access$registerD8BackportedMethodsTransform(Project project2, boolean coreLibDesugar, ConfigurableFileCollection bootclasspath, String d8Version) {
        DesugarLibUtils.registerD8BackportedMethodsTransform(project2, coreLibDesugar, bootclasspath, d8Version);
    }

    public static final /* synthetic */ FileCollection access$getD8DesugarMethodFileFromTransform(Configuration configuration) {
        return DesugarLibUtils.getD8DesugarMethodFileFromTransform(configuration);
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_MIN_SDK$p() {
        return ATTR_LINT_MIN_SDK;
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_COMPILE_SDK$p() {
        return ATTR_LINT_COMPILE_SDK;
    }

    static {
        Attribute attribute = Attribute.of((String)"lint-min-sdk", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"of(\"lint-min-sdk\", String::class.java)");
        ATTR_LINT_MIN_SDK = attribute;
        attribute = Attribute.of((String)"lint-compile-sdk", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"of(\"lint-compile-sdk\", String::class.java)");
        ATTR_LINT_COMPILE_SDK = attribute;
    }
}

