/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class AndroidDependenciesRenderer
extends TextReportRenderer {
    private final MavenCoordinatesCacheBuildService mavenCoordinatesCacheBuildService;
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    public AndroidDependenciesRenderer(MavenCoordinatesCacheBuildService mavenCoordinatesCacheBuildService) {
        this.mavenCoordinatesCacheBuildService = mavenCoordinatesCacheBuildService;
    }

    public void startProject(ProjectDetails project2) {
        super.startProject(project2);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    public void completeProject(ProjectDetails project2) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No dependencies");
        }
        super.completeProject(project2);
    }

    public void startComponent(ComponentImpl component2) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit(styledTextOutput -> this.getTextOutput().withStyle(StyledTextOutput.Style.Header).text((Object)component2.getName()), true);
    }

    public void render(ComponentImpl component2) {
        ImmutableMap<String, String> buildMapping = BuildMappingUtils.computeBuildMapping(component2.getServices().getProjectInfo().getProject().getGradle());
        Set<ResolvedArtifact> compileArtifacts = ArtifactUtils.getAllArtifacts(component2, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, null, buildMapping);
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)component2.getVariantDependencies().getCompileClasspath().getName());
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)" - Dependencies for compilation");
        this.getTextOutput().println();
        this.renderer.startChildren();
        this.render((List<ResolvedArtifact>)ImmutableList.copyOf(compileArtifacts));
        this.renderer.completeChildren();
        Set<ResolvedArtifact> runtimeArtifacts = ArtifactUtils.getAllArtifacts(component2, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, null, buildMapping);
        this.getTextOutput().println();
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)component2.getVariantDependencies().getRuntimeClasspath().getName());
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)" - Dependencies for runtime/packaging");
        this.getTextOutput().println();
        this.renderer.startChildren();
        this.render((List<ResolvedArtifact>)ImmutableList.copyOf(runtimeArtifacts));
        this.renderer.completeChildren();
    }

    public void complete() {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(List<ResolvedArtifact> artifacts) {
        int count = artifacts.size();
        for (int i2 = 0; i2 < count; ++i2) {
            ResolvedArtifact artifact = artifacts.get(i2);
            this.renderer.visit(styledTextOutput -> {
                String text;
                ComponentIdentifier id = artifact.getComponentIdentifier();
                if (id instanceof ProjectComponentIdentifier) {
                    String projectId = BuildMappingUtils.getIdString((ProjectComponentIdentifier)id);
                    if (artifact.isWrappedModule()) {
                        String file = artifact.getArtifactFile().getAbsolutePath();
                        text = String.format("%s (file: %s)", projectId, file);
                    } else if (artifact.getDependencyType() == ResolvedArtifact.DependencyType.ANDROID) {
                        String variant2 = artifact.getVariantName();
                        text = String.format("%s (variant: %s)", projectId, variant2);
                    } else {
                        text = projectId;
                    }
                } else {
                    text = id instanceof ModuleComponentIdentifier ? artifact.computeModelAddress(this.mavenCoordinatesCacheBuildService) : artifact.getArtifactFile().getAbsolutePath();
                }
                this.getTextOutput().text((Object)text);
            }, i2 == count - 1);
        }
    }
}

