/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.SecondaryInput;
import com.android.build.api.transform.TransformException;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.builder.profile.Recorder;
import com.android.ide.common.attribution.TaskCategoryLabel;
import com.android.ide.common.util.ReferenceHolder;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
@BuildAnalyzer(taskCategoryLabels={TaskCategoryLabel.SOURCE_PROCESSING})
public abstract class NonIncrementalTransformTask
extends TransformTask {
    @TaskAction
    void transform() throws IOException, TransformException, InterruptedException {
        final ReferenceHolder consumedInputs = ReferenceHolder.empty();
        final ReferenceHolder referencedInputs = ReferenceHolder.empty();
        GradleTransformExecution preExecutionInfo = GradleTransformExecution.newBuilder().setType(AnalyticsUtil.getTransformType(this.getTransform().getClass()).getNumber()).setIsIncremental(false).setTransformClassName(this.getTransform().getClass().getName()).build();
        AnalyticsService analyticsService = (AnalyticsService)this.getAnalyticsService().get();
        analyticsService.recordBlock(GradleBuildProfileSpan.ExecutionType.TASK_TRANSFORM_PREPARATION, preExecutionInfo, (String)this.getProjectPath().get(), this.getVariantName(), new Recorder.VoidBlock(){

            public void call() {
                consumedInputs.setValue(TransformTask.computeNonIncTransformInput(NonIncrementalTransformTask.this.consumedInputStreams));
                referencedInputs.setValue(TransformTask.computeNonIncTransformInput(NonIncrementalTransformTask.this.referencedInputStreams));
            }
        });
        this.runTransform((List)consumedInputs.getValue(), (List)referencedInputs.getValue(), false, (Collection<SecondaryInput>)ImmutableList.of(), preExecutionInfo, analyticsService);
    }
}

