/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.SecondaryInput;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.IncrementalTransformTask;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.NonIncrementalTransformTask;
import com.android.build.gradle.internal.pipeline.StreamBasedTask;
import com.android.build.gradle.internal.pipeline.TransformInvocationBuilder;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.profile.Recorder;
import com.android.ide.common.attribution.TaskCategoryLabel;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
@BuildAnalyzer(taskCategoryLabels={TaskCategoryLabel.SOURCE_PROCESSING})
public abstract class TransformTask
extends StreamBasedTask {
    private Transform transform;
    Collection<SecondaryFile> secondaryFiles = null;
    List<FileCollection> secondaryInputFiles = null;

    @Internal
    public Transform getTransform() {
        return this.transform;
    }

    @Input
    public Set<? super QualifiedContent.Scope> getScopes() {
        return this.transform.getScopes();
    }

    @Input
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return this.transform.getReferencedScopes();
    }

    @Input
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.transform.getInputTypes();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    public Collection<File> getOldSecondaryInputs() {
        return this.transform.getSecondaryFileInputs();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<FileCollection> getSecondaryFileInputs() {
        return this.secondaryInputFiles;
    }

    @OutputFiles
    public Map<String, File> getOtherFileOutputs() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int index = 0;
        for (File outputFile : this.transform.getSecondaryFileOutputs()) {
            builder.put((Object)("otherFileOutput" + Integer.toString(++index)), (Object)outputFile);
        }
        return builder.build();
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getOutputDirectory();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getOutputFile();

    @OutputDirectories
    public Map<String, File> getOtherFolderOutputs() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int index = 0;
        for (File outputFolder : this.transform.getSecondaryDirectoryOutputs()) {
            builder.put((Object)("otherFolderOutput" + Integer.toString(++index)), (Object)outputFolder);
        }
        return builder.build();
    }

    @Input
    public Map<String, Object> getOtherInputs() {
        return this.transform.getParameterInputs();
    }

    protected static List<TransformInput> computeNonIncTransformInput(Collection<TransformStream> streams) {
        return streams.stream().map(TransformStream::asNonIncrementalInput).collect(Collectors.toList());
    }

    protected void runTransform(final List<TransformInput> consumedInputs, final List<TransformInput> referencedInputs, final boolean isIncremental, final Collection<SecondaryInput> changedSecondaryInputs, GradleTransformExecution preExecutionInfo, AnalyticsService analyticsService) {
        GradleTransformExecution executionInfo = preExecutionInfo.toBuilder().setIsIncremental(isIncremental).build();
        analyticsService.recordBlock(GradleBuildProfileSpan.ExecutionType.TASK_TRANSFORM, executionInfo, (String)this.getProjectPath().get(), this.getVariantName(), new Recorder.VoidBlock(){

            public void call() throws Exception {
                Context context = new Context(){

                    public LoggingManager getLogging() {
                        return TransformTask.this.getLogging();
                    }

                    public File getTemporaryDir() {
                        return TransformTask.this.getTemporaryDir();
                    }

                    public String getPath() {
                        return TransformTask.this.getPath();
                    }

                    public String getProjectName() {
                        return (String)TransformTask.this.getProjectPath().get();
                    }

                    public String getVariantName() {
                        return TransformTask.this.getVariantName();
                    }

                    public WorkerExecutor getWorkerExecutor() {
                        return TransformTask.this.getWorkerExecutor();
                    }
                };
                TransformTask.this.getTransform().transform(new TransformInvocationBuilder(context).addInputs(consumedInputs).addReferencedInputs(referencedInputs).addSecondaryInputs(changedSecondaryInputs).addOutputProvider(TransformTask.this.outputStream != null ? TransformTask.this.outputStream.asOutput() : null).setIncrementalMode(isIncremental).build());
                if (TransformTask.this.outputStream != null) {
                    TransformTask.this.outputStream.save();
                }
            }
        });
    }

    public static class CreationAction<T extends Transform>
    extends TaskCreationAction<TransformTask> {
        private final String variantName;
        private final String taskName;
        private final T transform;
        private Collection<TransformStream> consumedInputStreams;
        private Collection<TransformStream> referencedInputStreams;
        private IntermediateStream outputStream;
        private boolean allowIncremental;

        CreationAction(String variantName, String taskName, T transform2, Collection<TransformStream> consumedInputStreams, Collection<TransformStream> referencedInputStreams, IntermediateStream outputStream, boolean allowIncremental) {
            this.variantName = variantName;
            this.taskName = taskName;
            this.transform = transform2;
            this.consumedInputStreams = consumedInputStreams;
            this.referencedInputStreams = referencedInputStreams;
            this.outputStream = outputStream;
            this.allowIncremental = allowIncremental;
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<TransformTask> getType() {
            if (this.allowIncremental) {
                return IncrementalTransformTask.class;
            }
            return NonIncrementalTransformTask.class;
        }

        @Override
        public void configure(TransformTask task) {
            task.transform = this.transform;
            this.transform.setOutputDirectory((Property)task.getOutputDirectory());
            this.transform.setOutputFile((Property)task.getOutputFile());
            task.consumedInputStreams = this.consumedInputStreams;
            task.referencedInputStreams = this.referencedInputStreams;
            task.outputStream = this.outputStream;
            if (this.outputStream != null) {
                task.getStreamOutputFolder().fileProvider(task.getProject().provider(this.outputStream::getRootLocation));
            }
            task.setVariantName(this.variantName);
            boolean cachingEnabled = this.transform.isCacheable();
            task.getOutputs().cacheIf("Transform " + this.transform.getClass().getName() + " declares itself as cacheable", (Spec & Serializable)t -> cachingEnabled);
            task.registerConsumedAndReferencedStreamInputs();
            task.getProjectPath().set((Object)task.getProject().getPath());
            task.secondaryInputFiles = this.transform.getSecondaryFiles().stream().map(secondaryFile -> secondaryFile.getFileCollection(task.getProject())).collect(Collectors.toList());
            task.getAnalyticsService().set(BuildServicesKt.getBuildService(task.getProject().getGradle().getSharedServices(), AnalyticsService.class));
        }
    }
}

