/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigDataProvider;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.BundleTaskUtil;
import com.android.build.gradle.internal.tasks.BundleToApkTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.ide.common.attribution.TaskCategoryLabel;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.utils.FileUtils;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(taskCategoryLabels={TaskCategoryLabel.APK_PACKAGING})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "aapt2", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "androidPrivacySandboxSdkArchives", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAndroidPrivacySandboxSdkArchives", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "bundle", "Lorg/gradle/api/file/RegularFileProperty;", "getBundle", "()Lorg/gradle/api/file/RegularFileProperty;", "enableLocalTesting", "Lorg/gradle/api/provider/Property;", "", "getEnableLocalTesting", "()Lorg/gradle/api/provider/Property;", "outputFile", "getOutputFile", "<set-?>", "Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "signingConfigData", "getSigningConfigData", "()Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "doTaskAction", "", "BundleToolRunnable", "CreationAction", "Params", "gradle-core"})
public abstract class BundleToApkTask
extends NonIncrementalTask {
    private SigningConfigDataProvider signingConfigData;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getBundle();

    @Nested
    @NotNull
    public abstract Aapt2Input getAapt2();

    @Nested
    @NotNull
    public final SigningConfigDataProvider getSigningConfigData() {
        SigningConfigDataProvider signingConfigDataProvider2 = this.signingConfigData;
        if (signingConfigDataProvider2 != null) {
            return signingConfigDataProvider2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfigData");
        return null;
    }

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getAndroidPrivacySandboxSdkArchives();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableLocalTesting();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(BundleToolRunnable.class, new Action(this){
            final /* synthetic */ BundleToApkTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getBundleFile().set((Provider)this.this$0.getBundle());
                it.getAapt2File().set((Object)Aapt2Daemon.getAapt2Executable(this.this$0.getAapt2()).toFile());
                Object[] objectArray = new Object[]{this.this$0.getAndroidPrivacySandboxSdkArchives()};
                it.getAndroidPrivacySandboxSdkArchives().from(objectArray);
                it.getOutputFile().set((Provider)this.this$0.getOutputFile());
                SigningConfigData signingConfigData = this.this$0.getSigningConfigData().resolve();
                if (signingConfigData != null) {
                    SigningConfigData config2 = signingConfigData;
                    boolean bl = false;
                    it.getKeystoreFile().set((Object)config2.getStoreFile());
                    it.getKeystorePassword().set((Object)config2.getStorePassword());
                    it.getKeyAlias().set((Object)config2.getKeyAlias());
                    it.getKeyPassword().set((Object)config2.getKeyPassword());
                }
                it.getEnableLocalTesting().set((Provider)this.this$0.getEnableLocalTesting());
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0012\u0010\u001c\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "aapt2File", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getAapt2File", "()Lorg/gradle/api/provider/Property;", "androidPrivacySandboxSdkArchives", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAndroidPrivacySandboxSdkArchives", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "bundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "enableLocalTesting", "", "getEnableLocalTesting", "keyAlias", "", "getKeyAlias", "keyPassword", "getKeyPassword", "keystoreFile", "getKeystoreFile", "keystorePassword", "getKeystorePassword", "outputFile", "getOutputFile", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getBundleFile();

        @NotNull
        public abstract Property<File> getAapt2File();

        @NotNull
        public abstract ConfigurableFileCollection getAndroidPrivacySandboxSdkArchives();

        @NotNull
        public abstract RegularFileProperty getOutputFile();

        @NotNull
        public abstract Property<File> getKeystoreFile();

        @NotNull
        public abstract Property<String> getKeystorePassword();

        @NotNull
        public abstract Property<String> getKeyAlias();

        @NotNull
        public abstract Property<String> getKeyPassword();

        @NotNull
        public abstract Property<Boolean> getEnableLocalTesting();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$BundleToolRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/BundleToApkTask$Params;", "()V", "run", "", "gradle-core"})
    public static abstract class BundleToolRunnable
    extends ProfileAwareWorkAction<Params> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            FileUtils.deleteIfExists((File)((File)((Params)this.getParameters()).getOutputFile().getAsFile().get()));
            BuildApksCommand.Builder builder = BuildApksCommand.builder().setExecutorService(MoreExecutors.listeningDecorator((ExecutorService)ForkJoinPool.commonPool())).setBundlePath(((File)((Params)this.getParameters()).getBundleFile().getAsFile().get()).toPath()).setOutputFile(((File)((Params)this.getParameters()).getOutputFile().getAsFile().get()).toPath()).setAapt2Command(Aapt2Command.createFromExecutablePath((Path)((File)((Params)this.getParameters()).getAapt2File().get()).toPath()));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()\n              \u2026      )\n                )");
            BuildApksCommand.Builder builder2 = BundleTaskUtil.setSigningConfiguration(builder, (File)((Params)this.getParameters()).getKeystoreFile().getOrNull(), (String)((Params)this.getParameters()).getKeystorePassword().getOrNull(), (String)((Params)this.getParameters()).getKeyAlias().getOrNull(), (String)((Params)this.getParameters()).getKeyPassword().getOrNull());
            Object object = ((Params)this.getParameters()).getEnableLocalTesting().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.enableLocalTesting.get()");
            BuildApksCommand.Builder command = builder2.setLocalTestingMode(((Boolean)object).booleanValue()).setEnableApkSerializerWithoutBundleRecompression(true);
            if (!((Params)this.getParameters()).getAndroidPrivacySandboxSdkArchives().isEmpty()) {
                void $this$mapTo$iv$iv;
                Set set = ((Params)this.getParameters()).getAndroidPrivacySandboxSdkArchives().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"parameters.androidPrivacySandboxSdkArchives.files");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toPath());
                }
                List asars = (List)destination$iv$iv;
                command.setRuntimeEnabledSdkArchivePaths(GuavaKtxKt.toImmutableSet(asars));
            }
            command.build().execute();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/BundleToApkTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<BundleToApkTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return VariantTaskCreationAction.computeTaskName$default(this, "makeApkFromBundleFor", null, 2, null);
        }

        @Override
        @NotNull
        public Class<BundleToApkTask> getType() {
            return BundleToApkTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<BundleToApkTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("bundle.apks").on(InternalArtifactType.APKS_FROM_BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull BundleToApkTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE, (Property)task.getBundle());
            ((ApkCreationConfig)this.creationConfig).getServices().initializeAapt2Input(task.getAapt2());
            if (((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT)) {
                Object[] objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(((ApkCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_ARCHIVE, null, 8, null)};
                HasConfigurableValuesKt.fromDisallowChanges(task.getAndroidPrivacySandboxSdkArchives(), objectArray);
            } else {
                task.getAndroidPrivacySandboxSdkArchives().disallowChanges();
            }
            task.signingConfigData = SigningConfigDataProvider.Companion.create((ApkCreationConfig)this.creationConfig);
            task.getEnableLocalTesting().set((Object)((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_LOCAL_TESTING));
        }
    }
}

