/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.MultipleArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.AndroidAttributes;
import com.android.build.gradle.internal.dependency.DexingTransformKt;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.InternalMultipleArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.D8BundleMainDexListTaskKt;
import com.android.build.gradle.internal.tasks.DexMergingAction;
import com.android.build.gradle.internal.tasks.DexMergingTask;
import com.android.build.gradle.internal.tasks.DexMergingTaskDelegate;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.builder.dexing.DexUtilsKt;
import com.android.builder.dexing.DexingType;
import com.android.builder.files.SerializableFileChanges;
import com.android.ide.common.attribution.TaskCategoryLabel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(taskCategoryLabels={TaskCategoryLabel.DEXING, TaskCategoryLabel.MERGING})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u0014\u0010\u0019\u001a\u00020\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTask;", "Lcom/android/build/gradle/internal/tasks/NewIncrementalTask;", "()V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "dexDirs", "getDexDirs", "()Lorg/gradle/api/file/FileCollection;", "duplicateClassesCheck", "Lorg/gradle/api/file/DirectoryProperty;", "getDuplicateClassesCheck", "()Lorg/gradle/api/file/DirectoryProperty;", "fileDependencyDexDir", "getFileDependencyDexDir", "mainDexListOutput", "Lorg/gradle/api/file/RegularFileProperty;", "getMainDexListOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "numberOfBuckets", "Lorg/gradle/api/provider/Property;", "", "getNumberOfBuckets", "()Lorg/gradle/api/provider/Property;", "outputDir", "getOutputDir", "sharedParams", "Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams;", "getSharedParams", "()Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams;", "doTaskAction", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "CreationAction", "SharedParams", "gradle-core"})
public abstract class DexMergingTask
extends NewIncrementalTask {
    private FileCollection dexDirs;

    @Nested
    @NotNull
    public abstract SharedParams getSharedParams();

    @Input
    @NotNull
    public abstract Property<Integer> getNumberOfBuckets();

    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getDexDirs() {
        FileCollection fileCollection2 = this.dexDirs;
        if (fileCollection2 != null) {
            return fileCollection2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dexDirs");
        return null;
    }

    @Incremental
    @Optional
    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getFileDependencyDexDir();

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getDuplicateClassesCheck();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Optional
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getMainDexListOutput();

    /*
     * WARNING - void declaration
     */
    @Override
    public void doTaskAction(@NotNull InputChanges inputChanges) {
        List list;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        Directory directory2 = (Directory)this.getFileDependencyDexDir().getOrNull();
        Iterable $this$flatMap$iv = CollectionsKt.plus((Iterable)((Iterable)this.getDexDirs()), (Iterable)CollectionsKt.listOfNotNull((Object)(directory2 != null ? directory2.getAsFile() : null)));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv;
            File dir = (File)element$iv$iv;
            boolean bl = false;
            if (!dir.isDirectory()) {
                boolean $i$a$-check-DexMergingTask$doTaskAction$dexJars$1$22 = false;
                String $i$a$-check-DexMergingTask$doTaskAction$dexJars$1$22 = "Directory does not exist: " + dir.getPath();
                throw new IllegalStateException($i$a$-check-DexMergingTask$doTaskAction$dexJars$1$22.toString());
            }
            Intrinsics.checkNotNull((Object)dir.listFiles());
            boolean $i$f$filter = false;
            File[] fileArray = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv2;
                void it = element$iv$iv2 = $this$filterTo$iv$iv[i];
                boolean bl2 = false;
                Function1 function1 = DexUtilsKt.isJarFile();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!((Boolean)function1.invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List dexJars = (List)destination$iv$iv;
        List dexDirsOrJars = CollectionsKt.plus((Iterable)((Iterable)this.getDexDirs()), (Iterable)dexJars);
        if (inputChanges.isIncremental()) {
            Iterable iterable2 = inputChanges.getFileChanges(this.getDexDirs());
            Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"inputChanges.getFileChanges(dexDirs)");
            Iterable iterable3 = inputChanges.getFileChanges((Provider)this.getFileDependencyDexDir());
            Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"inputChanges.getFileChanges(fileDependencyDexDir)");
            list = CollectionsKt.plus((Iterable)iterable2, (Iterable)iterable3);
        } else {
            list = null;
        }
        List fileChanges = list;
        this.getWorkerExecutor().noIsolation().submit(DexMergingTaskDelegate.class, new Action(this, dexDirsOrJars, inputChanges, fileChanges){
            final /* synthetic */ DexMergingTask this$0;
            final /* synthetic */ List<File> $dexDirsOrJars;
            final /* synthetic */ InputChanges $inputChanges;
            final /* synthetic */ List<FileChange> $fileChanges;
            {
                this.this$0 = $receiver;
                this.$dexDirsOrJars = $dexDirsOrJars;
                this.$inputChanges = $inputChanges;
                this.$fileChanges = $fileChanges;
            }

            public final void execute(DexMergingTaskDelegate.Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                SharedParams sharedParams = this.this$0.getSharedParams();
                Object object = this.this$0.getNumberOfBuckets().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"numberOfBuckets.get()");
                List<FileChange> list = this.$fileChanges;
                it.initialize(sharedParams, ((Number)object).intValue(), this.$dexDirsOrJars, this.this$0.getOutputDir(), this.$inputChanges.isIncremental(), (SerializableFileChanges)(list != null ? IncrementalChangesUtils.toSerializable((Iterable<? extends FileChange>)list) : null), this.this$0.getMainDexListOutput());
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams;", "", "()V", "debuggable", "Lorg/gradle/api/provider/Property;", "", "getDebuggable", "()Lorg/gradle/api/provider/Property;", "dexingType", "Lcom/android/builder/dexing/DexingType;", "getDexingType", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormatMode", "mainDexListConfig", "Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams$MainDexListConfig;", "getMainDexListConfig", "()Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams$MainDexListConfig;", "minSdkVersion", "", "getMinSdkVersion", "MainDexListConfig", "gradle-core"})
    public static abstract class SharedParams {
        @Input
        @NotNull
        public abstract Property<DexingType> getDexingType();

        @Input
        @NotNull
        public abstract Property<Integer> getMinSdkVersion();

        @Input
        @NotNull
        public abstract Property<Boolean> getDebuggable();

        @Internal
        @NotNull
        public abstract Property<SyncOptions.ErrorFormatMode> getErrorFormatMode();

        @Nested
        @NotNull
        public abstract MainDexListConfig getMainDexListConfig();

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams$MainDexListConfig;", "", "()V", "aaptGeneratedRules", "Lorg/gradle/api/file/RegularFileProperty;", "getAaptGeneratedRules", "()Lorg/gradle/api/file/RegularFileProperty;", "libraryClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLibraryClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "platformMultidexProguardRules", "Lorg/gradle/api/provider/ListProperty;", "", "getPlatformMultidexProguardRules", "()Lorg/gradle/api/provider/ListProperty;", "userMultidexKeepFile", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getUserMultidexKeepFile", "()Lorg/gradle/api/provider/Property;", "userMultidexProguardRules", "Lorg/gradle/api/file/RegularFile;", "getUserMultidexProguardRules", "gradle-core"})
        public static abstract class MainDexListConfig {
            @Optional
            @InputFile
            @PathSensitive(value=PathSensitivity.NONE)
            @NotNull
            public abstract RegularFileProperty getAaptGeneratedRules();

            @Optional
            @InputFiles
            @PathSensitive(value=PathSensitivity.NONE)
            @NotNull
            public abstract ListProperty<RegularFile> getUserMultidexProguardRules();

            @Optional
            @Input
            @NotNull
            public abstract ListProperty<String> getPlatformMultidexProguardRules();

            @Optional
            @InputFile
            @PathSensitive(value=PathSensitivity.NONE)
            @NotNull
            public abstract Property<File> getUserMultidexKeepFile();

            @Optional
            @Classpath
            @NotNull
            public abstract ConfigurableFileCollection getLibraryClasses();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BC\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\b\u0010$\u001a\u00020\u001fH\u0002J\u0016\u0010%\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/DexMergingTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "action", "Lcom/android/build/gradle/internal/tasks/DexMergingAction;", "dexingType", "Lcom/android/builder/dexing/DexingType;", "dexingUsingArtifactTransforms", "", "separateFileDependenciesDexingTask", "outputType", "Lcom/android/build/gradle/internal/scope/InternalMultipleArtifactType;", "Lorg/gradle/api/file/Directory;", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;Lcom/android/build/gradle/internal/tasks/DexMergingAction;Lcom/android/builder/dexing/DexingType;ZZLcom/android/build/gradle/internal/scope/InternalMultipleArtifactType;)V", "internalName", "", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "getDexDirs", "Lorg/gradle/api/file/FileCollection;", "getMaxNumberOfBucketsBasedOnDexFileLimit", "", "minSdkVersion", "getNumberOfBuckets", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "getRecommendedNumberOfBucketsBasedOnWorkers", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<DexMergingTask, ApkCreationConfig> {
        @NotNull
        private final DexMergingAction action;
        @NotNull
        private final DexingType dexingType;
        private final boolean dexingUsingArtifactTransforms;
        private final boolean separateFileDependenciesDexingTask;
        @NotNull
        private final InternalMultipleArtifactType<Directory> outputType;
        @NotNull
        private final String internalName;
        @NotNull
        private final String name;
        @NotNull
        private final Class<DexMergingTask> type;

        @JvmOverloads
        public CreationAction(@NotNull ApkCreationConfig creationConfig, @NotNull DexMergingAction action, @NotNull DexingType dexingType, boolean dexingUsingArtifactTransforms, boolean separateFileDependenciesDexingTask, @NotNull InternalMultipleArtifactType<Directory> outputType) {
            String string;
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)dexingType, (String)"dexingType");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            super((ComponentCreationConfig)creationConfig);
            this.action = action;
            this.dexingType = dexingType;
            this.dexingUsingArtifactTransforms = dexingUsingArtifactTransforms;
            this.separateFileDependenciesDexingTask = separateFileDependenciesDexingTask;
            this.outputType = outputType;
            switch (WhenMappings.$EnumSwitchMapping$0[this.action.ordinal()]) {
                case 1: {
                    string = creationConfig.computeTaskName("mergeLibDex");
                    break;
                }
                case 2: {
                    string = creationConfig.computeTaskName("mergeExtDex");
                    break;
                }
                case 3: {
                    string = creationConfig.computeTaskName("mergeProjectDex");
                    break;
                }
                case 4: {
                    string = creationConfig.computeTaskName("mergeDex");
                    break;
                }
                case 5: {
                    string = creationConfig.computeTaskName("mergeDex");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.name = this.internalName = string;
            this.type = DexMergingTask.class;
        }

        public /* synthetic */ CreationAction(ApkCreationConfig apkCreationConfig, DexMergingAction dexMergingAction, DexingType dexingType, boolean bl, boolean bl2, InternalMultipleArtifactType internalMultipleArtifactType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            if ((n & 0x20) != 0) {
                internalMultipleArtifactType = InternalMultipleArtifactType.DEX.INSTANCE;
            }
            this(apkCreationConfig, dexMergingAction, dexingType, bl, bl2, internalMultipleArtifactType);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<DexMergingTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<DexMergingTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWith((Function1)handleProvider.1.INSTANCE).toAppendTo((Artifact.Multiple)this.outputType);
            if (this.dexingType == DexingType.LEGACY_MULTIDEX) {
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).withName("mainDexList.txt").on(InternalArtifactType.LEGACY_MULTIDEX_MAIN_DEX_LIST.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull DexMergingTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ProjectOptions projectOptions = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions();
            HasConfigurableValuesKt.setDisallowChanges(task.getSharedParams().getDexingType(), this.dexingType);
            HasConfigurableValuesKt.setDisallowChanges(task.getSharedParams().getMinSdkVersion(), VariantApiExtensionsKt.getFeatureLevel(((ApkCreationConfig)this.creationConfig).getMinSdkVersionForDexing()));
            HasConfigurableValuesKt.setDisallowChanges(task.getSharedParams().getDebuggable(), ((ApkCreationConfig)this.creationConfig).getDebuggable());
            HasConfigurableValuesKt.setDisallowChanges(task.getSharedParams().getErrorFormatMode(), SyncOptions.getErrorFormatMode(projectOptions));
            if (this.dexingType == DexingType.LEGACY_MULTIDEX) {
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES.INSTANCE, (Property)task.getSharedParams().getMainDexListConfig().getAaptGeneratedRules());
                HasConfigurableValuesKt.setDisallowChanges(task.getSharedParams().getMainDexListConfig().getUserMultidexProguardRules(), ((ApkCreationConfig)this.creationConfig).getArtifacts().getAll((MultipleArtifact)MultipleArtifact.MULTIDEX_KEEP_PROGUARD.INSTANCE));
                File file = ((ApkCreationConfig)this.creationConfig).getMultiDexKeepFile();
                if (file != null) {
                    File it = file;
                    boolean bl = false;
                    HasConfigurableValuesKt.setDisallowChanges(task.getSharedParams().getMainDexListConfig().getUserMultidexKeepFile(), it);
                }
                HasConfigurableValuesKt.setDisallowChanges(task.getSharedParams().getMainDexListConfig().getPlatformMultidexProguardRules(), (Iterable)D8BundleMainDexListTaskKt.getPlatformRules());
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROVIDED_ONLY, QualifiedContent.Scope.TESTED_CODE};
                Set libraryScopes = SetsKt.setOf((Object[])objectArray);
                FileCollection fileCollection2 = ((ApkCreationConfig)this.creationConfig).getTransformManager().getPipelineOutputAsFileCollection(new StreamFilter(libraryScopes){
                    final /* synthetic */ Set<QualifiedContent.Scope> $libraryScopes;
                    {
                        this.$libraryScopes = $libraryScopes;
                    }

                    public final boolean accept(@NotNull Set<QualifiedContent.ContentType> contentTypes, @NotNull Set<? super QualifiedContent.Scope> scopes2) {
                        Intrinsics.checkNotNullParameter(contentTypes, (String)"contentTypes");
                        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
                        return contentTypes.contains(QualifiedContent.DefaultContentType.CLASSES) && !((Collection)CollectionsKt.intersect((Iterable)this.$libraryScopes, (Iterable)scopes2)).isEmpty();
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"val libraryScopes = setO\u2026y()\n                    }");
                FileCollection libraryClasses2 = fileCollection2;
                Provider<List<RegularFile>> bootClasspath2 = ((ApkCreationConfig)this.creationConfig).getGlobal().getBootClasspath();
                Object[] objectArray2 = new Object[]{bootClasspath2, libraryClasses2};
                task.getSharedParams().getMainDexListConfig().getLibraryClasses().from(objectArray2).disallowChanges();
            }
            Property<Integer> property = task.getNumberOfBuckets();
            Provider provider2 = task.getProject().getProviders().provider(new Callable(this, projectOptions){
                final /* synthetic */ CreationAction this$0;
                final /* synthetic */ ProjectOptions $projectOptions;
                {
                    this.this$0 = $receiver;
                    this.$projectOptions = $projectOptions;
                }

                public final Integer call() {
                    return CreationAction.access$getNumberOfBuckets(this.this$0, this.$projectOptions);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"override fun configure(t\u2026)\n            }\n        }");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
            task.dexDirs = this.getDexDirs((ApkCreationConfig)this.creationConfig, this.action);
            if (this.separateFileDependenciesDexingTask) {
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.EXTERNAL_FILE_LIB_DEX_ARCHIVES.INSTANCE, (Property)task.getFileDependencyDexDir());
            }
            if (projectOptions.get(BooleanOption.ENABLE_DUPLICATE_CLASSES_CHECK)) {
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.DUPLICATE_CLASSES_CHECK.INSTANCE, (Property)task.getDuplicateClassesCheck());
            }
        }

        private final FileCollection getDexDirs(ApkCreationConfig creationConfig, DexMergingAction action) {
            AndroidAttributes attributes2 = DexingTransformKt.getDexingArtifactConfiguration(creationConfig).getAttributes();
            return CreationAction.getDexDirs$forAction(this, creationConfig, attributes2, action);
        }

        private final int getNumberOfBuckets(ProjectOptions projectOptions) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[this.action.ordinal()]) {
                case 2: 
                case 4: 
                case 5: {
                    n = 1;
                    break;
                }
                case 1: 
                case 3: {
                    if (!(this.dexingType == DexingType.NATIVE_MULTIDEX)) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    Integer customNumberOfBuckets = (Integer)projectOptions.getProvider(IntegerOption.DEXING_NUMBER_OF_BUCKETS).getOrNull();
                    if (customNumberOfBuckets != null) {
                        if (!(customNumberOfBuckets >= 1)) {
                            boolean $i$a$-check-DexMergingTask$CreationAction$getNumberOfBuckets$22 = false;
                            String $i$a$-check-DexMergingTask$CreationAction$getNumberOfBuckets$22 = "The value of " + IntegerOption.DEXING_NUMBER_OF_BUCKETS.getPropertyName() + " is invalid (must be >= 1): " + customNumberOfBuckets;
                            throw new IllegalStateException($i$a$-check-DexMergingTask$CreationAction$getNumberOfBuckets$22.toString());
                        }
                        return customNumberOfBuckets;
                    }
                    int targetDeployApi = VariantApiExtensionsKt.getFeatureLevel(((ApkCreationConfig)this.creationConfig).getMinSdkVersionForDexing());
                    int overrideMinSdkVersion = Math.max(21, targetDeployApi);
                    n = this.getNumberOfBuckets(overrideMinSdkVersion);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        private final int getNumberOfBuckets(int minSdkVersion2) {
            return Math.min(this.getMaxNumberOfBucketsBasedOnDexFileLimit(minSdkVersion2), this.getRecommendedNumberOfBucketsBasedOnWorkers());
        }

        private final int getMaxNumberOfBucketsBasedOnDexFileLimit(int minSdkVersion2) {
            int n;
            if (!(minSdkVersion2 >= 21)) {
                boolean bl = false;
                String string = "Expected minSdkVersion >= 21 but found " + minSdkVersion2;
                throw new IllegalStateException(string.toString());
            }
            switch (minSdkVersion2) {
                case 21: 
                case 22: {
                    n = 20;
                    break;
                }
                default: {
                    n = 200;
                }
            }
            return n;
        }

        private final int getRecommendedNumberOfBucketsBasedOnWorkers() {
            return 16;
        }

        @JvmOverloads
        public CreationAction(@NotNull ApkCreationConfig creationConfig, @NotNull DexMergingAction action, @NotNull DexingType dexingType, boolean dexingUsingArtifactTransforms, boolean separateFileDependenciesDexingTask) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)dexingType, (String)"dexingType");
            this(creationConfig, action, dexingType, dexingUsingArtifactTransforms, separateFileDependenciesDexingTask, null, 32, null);
        }

        @JvmOverloads
        public CreationAction(@NotNull ApkCreationConfig creationConfig, @NotNull DexMergingAction action, @NotNull DexingType dexingType, boolean dexingUsingArtifactTransforms) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)dexingType, (String)"dexingType");
            this(creationConfig, action, dexingType, dexingUsingArtifactTransforms, false, null, 48, null);
        }

        @JvmOverloads
        public CreationAction(@NotNull ApkCreationConfig creationConfig, @NotNull DexMergingAction action, @NotNull DexingType dexingType) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)dexingType, (String)"dexingType");
            this(creationConfig, action, dexingType, false, false, null, 56, null);
        }

        private static final FileCollection getDexDirs$forAction(CreationAction this$0, ApkCreationConfig $creationConfig, AndroidAttributes attributes2, DexMergingAction action) {
            switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                case 2: {
                    FileCollection fileCollection2;
                    if (this$0.dexingUsingArtifactTransforms) {
                        AndroidArtifacts.ArtifactScope artifactScope = this$0.separateFileDependenciesDexingTask ? AndroidArtifacts.ArtifactScope.REPOSITORY_MODULE : AndroidArtifacts.ArtifactScope.EXTERNAL;
                        fileCollection2 = $creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, artifactScope, AndroidArtifacts.ArtifactType.DEX, attributes2);
                    } else {
                        Object[] artifactScope = new Object[]{$creationConfig.getArtifacts().get(InternalArtifactType.EXTERNAL_LIBS_DEX_ARCHIVE.INSTANCE), $creationConfig.getArtifacts().get(InternalArtifactType.EXTERNAL_LIBS_DEX_ARCHIVE_WITH_ARTIFACT_TRANSFORMS.INSTANCE)};
                        fileCollection2 = (FileCollection)$creationConfig.getServices().fileCollection(artifactScope);
                    }
                    return fileCollection2;
                }
                case 1: {
                    FileCollection fileCollection3;
                    if (this$0.dexingUsingArtifactTransforms) {
                        LibraryElements classesLibraryElements = $creationConfig.getServices().named(LibraryElements.class, "classes");
                        if (!(attributes2.getLibraryElementsAttribute() == null)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        AndroidAttributes updatedAttributes = new AndroidAttributes(attributes2.getStringAttributes(), classesLibraryElements, null, 4, null);
                        fileCollection3 = $creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.DEX, updatedAttributes);
                    } else {
                        Object[] objectArray = new Object[]{$creationConfig.getArtifacts().get(InternalArtifactType.SUB_PROJECT_DEX_ARCHIVE.INSTANCE)};
                        fileCollection3 = (FileCollection)$creationConfig.getServices().fileCollection(objectArray);
                    }
                    return fileCollection3;
                }
                case 3: {
                    Object[] objectArray = new Object[]{$creationConfig.getArtifacts().get(InternalArtifactType.PROJECT_DEX_ARCHIVE.INSTANCE), $creationConfig.getArtifacts().get(InternalArtifactType.MIXED_SCOPE_DEX_ARCHIVE.INSTANCE)};
                    return (FileCollection)$creationConfig.getServices().fileCollection(objectArray);
                }
                case 4: {
                    Object[] objectArray = new Object[]{CreationAction.getDexDirs$forAction(this$0, $creationConfig, attributes2, DexMergingAction.MERGE_PROJECT), CreationAction.getDexDirs$forAction(this$0, $creationConfig, attributes2, DexMergingAction.MERGE_LIBRARY_PROJECTS), this$0.dexingType == DexingType.LEGACY_MULTIDEX ? CreationAction.getDexDirs$forAction(this$0, $creationConfig, attributes2, DexMergingAction.MERGE_EXTERNAL_LIBS) : $creationConfig.getArtifacts().getAll(InternalMultipleArtifactType.EXTERNAL_LIBS_DEX.INSTANCE)};
                    return (FileCollection)$creationConfig.getServices().fileCollection(objectArray);
                }
                case 5: {
                    Object[] objectArray = new Object[]{$creationConfig.getArtifacts().get(InternalArtifactType.PROJECT_DEX_ARCHIVE.INSTANCE)};
                    return (FileCollection)$creationConfig.getServices().fileCollection(objectArray);
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        public static final /* synthetic */ int access$getNumberOfBuckets(CreationAction $this, ProjectOptions projectOptions) {
            return $this.getNumberOfBuckets(projectOptions);
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DexMergingAction.values().length];
                nArray[DexMergingAction.MERGE_LIBRARY_PROJECTS.ordinal()] = 1;
                nArray[DexMergingAction.MERGE_EXTERNAL_LIBS.ordinal()] = 2;
                nArray[DexMergingAction.MERGE_PROJECT.ordinal()] = 3;
                nArray[DexMergingAction.MERGE_ALL.ordinal()] = 4;
                nArray[DexMergingAction.MERGE_TRANSFORMED_CLASSES.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

