/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.gnumake.NativeBuildConfigValueBuilder;
import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.NdkBuildProperty;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessCommand;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessKt;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessType;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NdkBuildExternalNativeJsonGenerator;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.base.Charsets;
import com.google.gson.GsonBuilder;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a*\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0002R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/tasks/NdkBuildExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "applicationMk", "Ljava/io/File;", "getApplicationMk", "()Ljava/io/File;", "makeFile", "getMakeFile", "ndkBuild", "", "getNdkBuild", "()Ljava/lang/String;", "executeProcess", "", "ops", "Lorg/gradle/process/ExecOperations;", "getProcessBuilder", "Lcom/android/build/gradle/internal/cxx/process/ExecuteProcessCommand;", "parseDryRunOutput", "stdout", "removeJobsFlagIfPresent", "", "gradle-core"})
public final class NdkBuildExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    public NdkBuildExternalNativeJsonGenerator(@NotNull CxxAbiModel abi, @Nullable GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        super(abi, variantBuilder);
        GradleBuildVariant.Builder builder = variantBuilder;
        if (builder != null) {
            builder.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD);
        }
        if (abi.getVariant().getModule().getMakeFile().isDirectory()) {
            Object[] objectArray = new Object[]{abi.getVariant().getModule().getMakeFile()};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.INVALID_EXTERNAL_NATIVE_BUILD_CONFIG, "Gradle project ndkBuild.path %s is a folder. Only files (like Android.mk) are allowed.", objectArray);
        } else if (!abi.getVariant().getModule().getMakeFile().exists()) {
            Object[] objectArray = new Object[]{abi.getVariant().getModule().getMakeFile()};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.INVALID_EXTERNAL_NATIVE_BUILD_CONFIG, "Gradle project ndkBuild.path is %s but that file doesn't exist", objectArray);
        }
    }

    @Override
    @NotNull
    public ExecuteProcessCommand getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Object[] objectArray = new String[]{NdkBuildProperty.APP_SHORT_COMMANDS + "=false", NdkBuildProperty.LOCAL_SHORT_COMMANDS + "=false", "-B", "-n"};
        return ExecuteProcessKt.createExecuteProcessCommand(this.getNdkBuild()).addArgs(CollectionsKt.plus((Collection)abi.getConfigurationArguments(), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    @Override
    public void executeProcess(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        ExecuteProcessType executeProcessType = ExecuteProcessType.CONFIGURE_PROCESS;
        ExecuteProcessCommand executeProcessCommand = this.getProcessBuilder(abi);
        ExecuteProcessKt.executeProcess$default(abi, executeProcessType, executeProcessCommand, ops2, null, executeProcess.1.INSTANCE, (Function1)new Function1<File, Unit>(this, abi){
            final /* synthetic */ NdkBuildExternalNativeJsonGenerator this$0;
            final /* synthetic */ CxxAbiModel $abi;
            {
                this.this$0 = $receiver;
                this.$abi = $abi;
                super(1);
            }

            public final void invoke(@NotNull File stdout) {
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                NdkBuildExternalNativeJsonGenerator.access$parseDryRunOutput(this.this$0, this.$abi, stdout);
            }
        }, 8, null);
    }

    private final void parseDryRunOutput(CxxAbiModel abi, File stdout) {
        LoggingEnvironmentKt.infoln("parse and convert ndk-build output to build configuration JSON", new Object[0]);
        String buildOutput = FilesKt.readText$default((File)stdout, null, (int)1, null);
        List commandLine = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.getNdkBuild()), (Iterable)abi.getConfigurationArguments());
        NativeBuildConfigValueBuilder builder = new NativeBuildConfigValueBuilder(this.getMakeFile(), abi.getVariant().getModule().getModuleRootFolder(), CxxAbiModelKt.getCompileCommandsJsonBinFile(abi), null, 8, null).setCommands(commandLine, CollectionsKt.plus((Collection)this.removeJobsFlagIfPresent(commandLine), (Iterable)CollectionsKt.listOf((Object)"clean")), abi.getVariant().getVariantName(), buildOutput);
        builder.setSkipProcessingCompilerFlags(true);
        NativeBuildConfigValue buildConfig = builder.build();
        File file = this.getApplicationMk();
        if (file != null) {
            File it = file;
            boolean bl = false;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)it.getAbsolutePath(), (String)"it.absolutePath");
            LoggingEnvironmentKt.infoln("found application make file %s", objectArray);
            Collection<File> collection = buildConfig.buildFiles;
            Intrinsics.checkNotNull(collection);
            collection.add(it);
        }
        String actualResult = new GsonBuilder().registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)buildConfig);
        Path path = CxxAbiModelKt.getJsonFile(abi).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)actualResult, (String)"actualResult");
        String string = actualResult;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private final String getNdkBuild() {
        String string;
        Object tool = "ndk-build";
        if (ExternalNativeJsonGenerator.isWindows()) {
            tool = (String)tool + ".cmd";
        }
        File toolFile = new File(this.getAbi().getVariant().getModule().getNdkFolder().getPath(), (String)tool);
        try {
            String string2 = toolFile.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                // Att\u2026nonicalPath\n            }");
            string = string2;
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{e};
            LoggingEnvironmentKt.warnln("Attempted to get ndkFolder canonical path and failed: %s\nFalling back to absolute path.", objectArray);
            String string3 = toolFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                warnln\u2026bsolutePath\n            }");
            string = string3;
        }
        return string;
    }

    private final File getApplicationMk() {
        File file;
        File it = file = new File(this.getMakeFile().getParent(), "Application.mk");
        boolean bl = false;
        return it.exists() ? file : null;
    }

    private final File getMakeFile() {
        return this.getAbi().getVariant().getModule().getMakeFile().isDirectory() ? new File(this.getAbi().getVariant().getModule().getMakeFile(), "Android.mk") : this.getAbi().getVariant().getModule().getMakeFile();
    }

    private final List<String> removeJobsFlagIfPresent(List<String> $this$removeJobsFlagIfPresent) {
        return BuildSystemCommandLineKt.toStringList(BuildSystemCommandLineKt.removeNdkBuildJobs(BuildSystemCommandLineKt.toNdkBuildArguments($this$removeJobsFlagIfPresent)));
    }

    public static final /* synthetic */ void access$parseDryRunOutput(NdkBuildExternalNativeJsonGenerator $this, CxxAbiModel abi, File stdout) {
        $this.parseDryRunOutput(abi, stdout);
    }
}

