/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.tasks.DependencyGraphAnalyzer;
import com.android.build.gradle.tasks.DependencyUsageFinder;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/tasks/DependencyGraphAnalyzer;", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "depsUsageFinder", "Lcom/android/build/gradle/tasks/DependencyUsageFinder;", "(Lorg/gradle/api/artifacts/Configuration;Lcom/android/build/gradle/tasks/DependencyUsageFinder;)V", "renderableDependencies", "", "", "Lorg/gradle/api/tasks/diagnostics/internal/graph/nodes/RenderableDependency;", "getRenderableDependencies", "()Ljava/util/Map;", "findAccessibleDependencies", "", "findIndirectRequiredDependencies", "mapIdsToRenderableDependencies", "gradle-core"})
public final class DependencyGraphAnalyzer {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final DependencyUsageFinder depsUsageFinder;
    @NotNull
    private final Map<String, RenderableDependency> renderableDependencies;

    public DependencyGraphAnalyzer(@NotNull Configuration configuration, @NotNull DependencyUsageFinder depsUsageFinder) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)depsUsageFinder, (String)"depsUsageFinder");
        this.configuration = configuration;
        this.depsUsageFinder = depsUsageFinder;
        this.renderableDependencies = this.mapIdsToRenderableDependencies();
    }

    @NotNull
    public final Map<String, RenderableDependency> getRenderableDependencies() {
        return this.renderableDependencies;
    }

    @NotNull
    public final Set<String> findIndirectRequiredDependencies() {
        Set requiredRenderableDependencies2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.depsUsageFinder.getRequiredDependencies()), (Function1)((Function1)new Function1<String, RenderableDependency>(this){
            final /* synthetic */ DependencyGraphAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final RenderableDependency invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getRenderableDependencies().get(it);
            }
        })), (Function1)findIndirectRequiredDependencies.requiredRenderableDependencies.2.INSTANCE), (Function1)findIndirectRequiredDependencies.requiredRenderableDependencies.3.INSTANCE));
        Set<String> accessibleDependencies = this.findAccessibleDependencies();
        return SetsKt.minus((Set)requiredRenderableDependencies2, (Iterable)accessibleDependencies);
    }

    private final Set<String> findAccessibleDependencies() {
        Set visited = new LinkedHashSet();
        LinkedList<String> queue = new LinkedList<String>();
        Iterable $this$forEach$iv = this.depsUsageFinder.getUsedDirectDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!this.renderableDependencies.containsKey(it)) continue;
            queue.add(it);
        }
        while (!queue.isEmpty()) {
            String componentIdentifier = (String)queue.pop();
            RenderableDependency dependency = this.renderableDependencies.get(componentIdentifier);
            Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"componentIdentifier");
            visited.add(componentIdentifier);
            Object object = dependency;
            if (object == null || (object = object.getChildren()) == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                RenderableDependency it = (RenderableDependency)element$iv;
                boolean bl = false;
                Object object2 = it.getId();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ComponentIdentifier");
                String childComponentIdentifier = ((ComponentIdentifier)object2).getDisplayName();
                if (visited.contains(childComponentIdentifier)) continue;
                queue.push(childComponentIdentifier);
            }
        }
        return visited;
    }

    private final Map<String, RenderableDependency> mapIdsToRenderableDependencies() {
        ResolvedComponentResult dependencyGraph = this.configuration.getIncoming().getResolutionResult().getRoot();
        RenderableModuleResult renderableGraph = new RenderableModuleResult(dependencyGraph);
        Map renderableDependencies = new LinkedHashMap();
        Set set = renderableGraph.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"renderableGraph.children");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            RenderableDependency it = (RenderableDependency)element$iv;
            boolean bl = false;
            Object object = it.getId();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ComponentIdentifier");
            ComponentIdentifier componentIdentifier = (ComponentIdentifier)object;
            Map map = renderableDependencies;
            Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier.getDisplayName(), (String)"componentIdentifier.displayName");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            RenderableDependency renderableDependency = it;
            map.put(string, renderableDependency);
        }
        return renderableDependencies;
    }
}

