/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.ExtractJniTransform;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/dependency/ExtractJniTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "inputJar", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputJar", "()Lorg/gradle/api/provider/Provider;", "doTransform", "", "Ljava/io/File;", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "transform", "gradle-core"})
public abstract class ExtractJniTransform
implements TransformAction<GenericTransformParameters> {
    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputJar();

    public void transform(@NotNull TransformOutputs transformOutputs) {
        Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
        File file = ((FileSystemLocation)this.getInputJar().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"inputJar.get().asFile");
        this.doTransform(file, transformOutputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doTransform(File inputJar, TransformOutputs transformOutputs) {
        Closeable closeable = new ZipFile(inputJar);
        Throwable throwable = null;
        try {
            ZipFile it = (ZipFile)closeable;
            boolean bl = false;
            Iterator entries2 = it.stream().filter(doTransform.1.entries.1.INSTANCE).iterator();
            if (!entries2.hasNext()) {
                return;
            }
            File outputDir = transformOutputs.dir((Object)FilesKt.getNameWithoutExtension((File)inputJar));
            FileUtils.mkdirs((File)outputDir);
            while (entries2.hasNext()) {
                ZipEntry entry = (ZipEntry)entries2.next();
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                String relativePath = StringsKt.replace$default((String)StringsKt.substringAfter$default((String)string, (char)'/', null, (int)2, null), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
                Object object = new String[]{relativePath};
                File outFile = FileUtils.join((File)outputDir, (String[])object);
                FileUtils.mkdirs((File)outFile.getParentFile());
                object = new BufferedInputStream(it.getInputStream(entry));
                Throwable throwable2 = null;
                try {
                    long l;
                    BufferedInputStream inFileStream = (BufferedInputStream)object;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)outFile, (String)"outFile");
                    Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(outFile));
                    Throwable throwable3 = null;
                    try {
                        BufferedOutputStream outFileStream = (BufferedOutputStream)closeable2;
                        boolean bl3 = false;
                        l = ByteStreams.copy((InputStream)inFileStream, (OutputStream)outFileStream);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

