/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.Apk;
import com.android.tools.profgen.ArtProfile;
import com.android.tools.profgen.DexFile;
import com.android.tools.profgen.DexFileData;
import com.android.tools.profgen.DexMethod;
import com.android.tools.profgen.MethodData;
import com.android.tools.profgen.ObfuscationMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a4\u0010\u0000\u001a\u00020\u00012\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"dumpProfile", "", "file", "Ljava/io/File;", "profile", "Lcom/android/tools/profgen/ArtProfile;", "apk", "Lcom/android/tools/profgen/Apk;", "obf", "Lcom/android/tools/profgen/ObfuscationMap;", "strict", "", "os", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "extractName", "", "profileKey", "profgen"})
public final class ProfileDumperKt {
    public static final void dumpProfile(@NotNull Appendable os, @NotNull ArtProfile profile, @NotNull Apk apk, @NotNull ObfuscationMap obf, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        Intrinsics.checkNotNullParameter((Object)obf, (String)"obf");
        for (Map.Entry<DexFile, DexFileData> entry : profile.getProfileData().entrySet()) {
            DexFile file;
            Object v0;
            DexFileData dexFileData2;
            DexFile dexFile;
            block6: {
                dexFile = entry.getKey();
                dexFileData2 = entry.getValue();
                Iterable iterable = apk.getDexes();
                for (Object object : iterable) {
                    DexFile it = (DexFile)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)ProfileDumperKt.extractName(dexFile.getName()))) continue;
                    v0 = object;
                    break block6;
                }
                v0 = null;
            }
            if ((DexFile)v0 == null) {
                if (!strict) continue;
                throw new IllegalStateException("Cannot find Dex File " + dexFile.getName());
            }
            for (Map.Entry<Integer, MethodData> entry2 : dexFileData2.getMethods().entrySet()) {
                int key = ((Number)entry2.getKey()).intValue();
                MethodData method = entry2.getValue();
                DexMethod dexMethod = (DexMethod)CollectionsKt.getOrNull((List)file.getMethodPool$profgen(), (int)key);
                if (method.getFlags() == 0 || dexMethod == null) continue;
                DexMethod deobfuscated = obf.deobfuscate$profgen(dexMethod);
                method.print(os);
                deobfuscated.print(os);
                os.append('\n');
            }
            Iterator<Object> iterator2 = dexFileData2.getTypeIndexes().iterator();
            while (iterator2.hasNext()) {
                Object object;
                int key = ((Number)iterator2.next()).intValue();
                String dexClass = (String)CollectionsKt.getOrNull((List)file.getTypePool$profgen(), (int)key);
                if (dexClass == null) continue;
                List<String> deobfuscated = obf.deobfuscate$profgen(dexClass);
                object = deobfuscated.iterator();
                while (object.hasNext()) {
                    String type = (String)object.next();
                    os.append(type);
                    os.append('\n');
                }
            }
        }
    }

    public static /* synthetic */ void dumpProfile$default(Appendable appendable, ArtProfile artProfile2, Apk apk, ObfuscationMap obfuscationMap, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        ProfileDumperKt.dumpProfile(appendable, artProfile2, apk, obfuscationMap, bl);
    }

    public static final void dumpProfile(@NotNull File file, @NotNull ArtProfile profile, @NotNull Apk apk, @NotNull ObfuscationMap obf, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        Intrinsics.checkNotNullParameter((Object)obf, (String)"obf");
        OutputStream outputStream = new FileOutputStream(file);
        Charset charset = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter(outputStream, charset);
        int n = 8192;
        ProfileDumperKt.dumpProfile(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n), profile, apk, obf, strict);
    }

    public static /* synthetic */ void dumpProfile$default(File file, ArtProfile artProfile2, Apk apk, ObfuscationMap obfuscationMap, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        ProfileDumperKt.dumpProfile(file, artProfile2, apk, obfuscationMap, bl);
    }

    private static final String extractName(String profileKey) {
        int index = StringsKt.indexOf$default((CharSequence)profileKey, (String)"!", (int)0, (boolean)false, (int)6, null);
        if (index < 0) {
            index = StringsKt.indexOf$default((CharSequence)profileKey, (String)":", (int)0, (boolean)false, (int)6, null);
        }
        String string = profileKey.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }
}

