/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.InternalScopedArtifact;
import com.android.build.api.artifact.impl.InternalScopedArtifacts;
import com.android.build.api.variant.LibraryVariantBuilder;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.dependency.ConfigurationVariantMapping;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.ComponentPublishingInfo;
import com.android.build.gradle.internal.publishing.PublishedConfigSpec;
import com.android.build.gradle.internal.publishing.VariantPublishingInfo;
import com.android.build.gradle.internal.res.GenerateApiPublicTxtTask;
import com.android.build.gradle.internal.res.GenerateEmptyResourceFilesTask;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.DokkaParallelBuildService;
import com.android.build.gradle.internal.tasks.AarMetadataTask;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesDir;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesJar;
import com.android.build.gradle.internal.tasks.BundleLibraryJavaRes;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.JacocoTask;
import com.android.build.gradle.internal.tasks.LibraryAarJarsTask;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTask;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeGeneratedProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.PackageRenderscriptTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.BundleAar;
import com.android.build.gradle.tasks.CompileLibraryResourcesTask;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.JavaDocGenerationTask;
import com.android.build.gradle.tasks.JavaDocJarTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.ProcessLibraryArtProfileTask;
import com.android.build.gradle.tasks.ProcessLibraryManifest;
import com.android.build.gradle.tasks.SourceJarTask;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.build.gradle.tasks.sync.LibraryVariantModelTask;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001*B[\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010#\u001a\u00020\u0015H\u0014J\u001c\u0010$\u001a\u00020\u00152\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bH\u0014J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0014\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/LibraryTaskManager;", "Lcom/android/build/gradle/internal/TaskManager;", "Lcom/android/build/api/variant/LibraryVariantBuilder;", "Lcom/android/build/gradle/internal/component/LibraryCreationConfig;", "project", "Lorg/gradle/api/Project;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "testFixturesComponents", "Lcom/android/build/gradle/internal/component/TestFixturesCreationConfig;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "localConfig", "Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;", "extension", "Lcom/android/build/gradle/BaseExtension;", "(Lorg/gradle/api/Project;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;Lcom/android/build/gradle/BaseExtension;)V", "createBundleTask", "", "variant", "createCompileLibraryResourcesTask", "createComponent", "componentName", "", "isClassifierRequired", "", "createDependencyStreams", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "createJacocoTask", "createLibraryAssetsTask", "createMergeResourcesTasks", "createPrepareLintJarForPublishTask", "doCreateTasksForVariant", "variantInfo", "getJavaResMergingScopes", "", "Lcom/android/build/api/artifact/impl/InternalScopedArtifacts$InternalScope;", "postJavacCreation", "MergeResourceCallback", "gradle-core"})
public final class LibraryTaskManager
extends TaskManager<LibraryVariantBuilder, LibraryCreationConfig> {
    public LibraryTaskManager(@NotNull Project project2, @NotNull Collection<? extends ComponentInfo<LibraryVariantBuilder, LibraryCreationConfig>> variants, @NotNull Collection<? extends TestComponentCreationConfig> testComponents, @NotNull Collection<? extends TestFixturesCreationConfig> testFixturesComponents, @NotNull GlobalTaskCreationConfig globalConfig2, @NotNull TaskManagerConfig localConfig, @NotNull BaseExtension extension2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
        Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
        Intrinsics.checkNotNullParameter((Object)globalConfig2, (String)"globalConfig");
        Intrinsics.checkNotNullParameter((Object)localConfig, (String)"localConfig");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        super(project2, variants, testComponents, testFixturesComponents, globalConfig2, localConfig, extension2);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<LibraryVariantBuilder, LibraryCreationConfig> variantInfo) {
        Intrinsics.checkNotNullParameter(variantInfo, (String)"variantInfo");
        LibraryCreationConfig libraryVariant = variantInfo.getVariant();
        BuildFeatureValues buildFeatures = libraryVariant.getBuildFeatures();
        this.createAnchorTasks(libraryVariant);
        this.taskFactory.register(new LibraryVariantModelTask.CreationAction(libraryVariant));
        this.createDependencyStreams(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createGenerateResValuesTask(libraryVariant);
            this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(libraryVariant));
            this.taskFactory.register(new ExtractDeepLinksTask.AarCreationAction(libraryVariant));
        } else {
            if (this.globalConfig.getNamespacedAndroidResources()) {
                this.getLogger().error("Disabling resource processing in resource namespace aware modules is not supported currently.");
            }
            this.taskFactory.register(new GenerateEmptyResourceFilesTask.CreateAction(libraryVariant));
        }
        this.taskFactory.register(new CheckManifest.CreationAction(libraryVariant));
        this.taskFactory.register(new ProcessLibraryManifest.CreationAction(libraryVariant, libraryVariant.getTargetSdkVersion(), libraryVariant.getMaxSdkVersion()));
        this.createRenderscriptTask(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createMergeResourcesTasks(libraryVariant);
            this.createCompileLibraryResourcesTask(libraryVariant);
        }
        this.createShaderTask(libraryVariant);
        this.createMergeAssetsTask(libraryVariant);
        this.createLibraryAssetsTask(libraryVariant);
        this.createBuildConfigTask(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createProcessResTask(libraryVariant, null, TaskManager.MergeType.PACKAGE, libraryVariant.getServices().getProjectInfo().getProjectBaseName());
            if (!libraryVariant.getDebuggable() && !this.globalConfig.getNamespacedAndroidResources()) {
                this.createVerifyLibraryResTask(libraryVariant);
            }
            this.registerLibraryRClassTransformStream(libraryVariant);
        }
        this.createProcessJavaResTask(libraryVariant);
        this.createAidlTask(libraryVariant);
        this.createDataBindingTasksIfNecessary(libraryVariant);
        this.createMlkitTask(libraryVariant);
        TaskManager.Companion.setJavaCompilerTask(this.createJavacTask(libraryVariant), libraryVariant);
        this.taskFactory.register(new MergeGeneratedProguardFilesCreationAction(libraryVariant));
        this.createMergeJniLibFoldersTasks(libraryVariant);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction(libraryVariant));
        this.taskFactory.register(new PackageRenderscriptTask.CreationAction(libraryVariant));
        this.taskFactory.register(new MergeConsumerProguardFilesTask.CreationAction(libraryVariant));
        this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(libraryVariant));
        if (libraryVariant.getServices().getProjectOptions().get(BooleanOption.ENABLE_EXTRACT_ANNOTATIONS)) {
            this.taskFactory.register(new ExtractAnnotations.CreationAction(libraryVariant));
        }
        boolean instrumented = libraryVariant.isAndroidTestCoverageEnabled();
        this.maybeCreateTransformClassesWithAsmTask(libraryVariant);
        if (instrumented) {
            this.createJacocoTask(libraryVariant);
        }
        this.taskFactory.register(new BundleLibraryClassesJar.CreationAction(libraryVariant, AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS));
        this.taskFactory.register(new BundleLibraryClassesDir.CreationAction(libraryVariant));
        this.taskFactory.register(new BundleLibraryJavaRes.CreationAction(libraryVariant));
        this.taskFactory.register(new ZipMergingTask.CreationAction(libraryVariant));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectOnlyCreationAction(libraryVariant, InternalArtifactType.LIBRARY_JNI.INSTANCE));
        this.createMergeJavaResTask(libraryVariant);
        this.maybeCreateJavaCodeShrinkerTask(libraryVariant);
        this.taskFactory.register(new LibraryAarJarsTask.CreationAction(libraryVariant, libraryVariant.getOptimizationCreationConfig().getMinifiedEnabled()));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectAndLocalJarsCreationAction(libraryVariant, InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI.INSTANCE));
        this.taskFactory.register(new AarMetadataTask.CreationAction(libraryVariant));
        this.taskFactory.register(new BundleAar.LibraryLocalLintCreationAction(libraryVariant));
        this.createBundleTask(libraryVariant);
    }

    private final void createBundleTask(LibraryCreationConfig variant2) {
        this.taskFactory.register(new BundleAar.LibraryCreationAction(variant2));
        variant2.getTaskContainer().getAssembleTask().configure(new Action(variant2){
            final /* synthetic */ LibraryCreationConfig $variant;
            {
                this.$variant = $variant;
            }

            public final void execute(@NotNull Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Object[] objectArray = new Object[]{this.$variant.getArtifacts().get((SingleArtifact)SingleArtifact.AAR.INSTANCE)};
                task.dependsOn(objectArray);
            }
        });
        VariantPublishingInfo publishInfo = variant2.getPublishInfo();
        if (publishInfo != null) {
            List<ComponentPublishingInfo> components2 = publishInfo.getComponents();
            PropertyReference1Impl propertyReference1Impl = createBundleTask.2.INSTANCE;
            if (components2.stream().anyMatch(new Predicate((Function1)propertyReference1Impl){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            })) {
                this.taskFactory.register(new SourceJarTask.CreationAction(variant2));
            }
            propertyReference1Impl = createBundleTask.3.INSTANCE;
            if (components2.stream().anyMatch(new /* invalid duplicate definition of identical inner class */)) {
                new DokkaParallelBuildService.RegistrationAction(this.project).execute();
                this.taskFactory.register(new JavaDocGenerationTask.CreationAction(variant2));
                this.taskFactory.register(new JavaDocJarTask.CreationAction(variant2));
            }
            Iterable $this$forEach$iv = components2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ComponentPublishingInfo it = (ComponentPublishingInfo)element$iv;
                boolean bl = false;
                this.createComponent(variant2, it.getComponentName(), it.isClassifierRequired());
            }
        }
    }

    @Override
    public void createJacocoTask(@NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        TaskProvider jacocoTask = this.taskFactory.register(new JacocoTask.CreationAction(creationConfig));
        creationConfig.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).use(jacocoTask).toFork$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE, createJacocoTask.1.INSTANCE, (Function1)createJacocoTask.2.INSTANCE, (Function1)createJacocoTask.3.INSTANCE, (Function1)createJacocoTask.4.INSTANCE, InternalScopedArtifact.JACOCO_TRANSFORMED_CLASSES.INSTANCE);
    }

    private final void createComponent(LibraryCreationConfig variant2, String componentName, boolean isClassifierRequired) {
        VariantDependencies variantDependencies2 = variant2.getVariantDependencies();
        AdhocComponentWithVariants component2 = (AdhocComponentWithVariants)this.project.getComponents().findByName(componentName);
        if (component2 == null) {
            component2 = this.localConfig.getComponentFactory().adhoc(componentName);
            this.project.getComponents().add((Object)component2);
        }
        Configuration apiPub = variantDependencies2.getElements(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.API_PUBLICATION, componentName, isClassifierRequired));
        Configuration runtimePub = variantDependencies2.getElements(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.RUNTIME_PUBLICATION, componentName, isClassifierRequired));
        Configuration sourcePub = variantDependencies2.getElements(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.SOURCE_PUBLICATION, componentName, isClassifierRequired));
        Configuration javaDocPub = variantDependencies2.getElements(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.JAVA_DOC_PUBLICATION, componentName, isClassifierRequired));
        AdhocComponentWithVariants adhocComponentWithVariants = component2;
        Intrinsics.checkNotNull((Object)adhocComponentWithVariants);
        adhocComponentWithVariants.addVariantsFromConfiguration(apiPub, (Action)new ConfigurationVariantMapping("compile", isClassifierRequired));
        component2.addVariantsFromConfiguration(runtimePub, (Action)new ConfigurationVariantMapping("runtime", isClassifierRequired));
        if (sourcePub != null) {
            component2.addVariantsFromConfiguration(sourcePub, (Action)new ConfigurationVariantMapping("runtime", true));
        }
        if (javaDocPub != null) {
            component2.addVariantsFromConfiguration(javaDocPub, (Action)new ConfigurationVariantMapping("runtime", true));
        }
    }

    @Override
    protected void createDependencyStreams(@NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        super.createDependencyStreams(creationConfig);
        creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.LOCAL_DEPS).setInitialContent$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE, creationConfig.computeLocalPackagedJars());
    }

    private final void createMergeResourcesTasks(LibraryCreationConfig variant2) {
        ImmutableSet immutableSet;
        if (this.globalConfig.getNamespacedAndroidResources()) {
            MergeResources.Flag[] flagArray = new MergeResources.Flag[]{MergeResources.Flag.PROCESS_VECTOR_DRAWABLES};
            ImmutableSet immutableSet2 = Sets.immutableEnumSet((Enum)MergeResources.Flag.REMOVE_RESOURCE_NAMESPACES, (Enum[])flagArray);
            immutableSet = immutableSet2;
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet2, (String)"{\n            Sets.immut\u2026S\n            )\n        }");
        } else {
            ImmutableSet immutableSet3 = Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]);
            immutableSet = immutableSet3;
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet3, (String)"{\n            Sets.immut\u2026S\n            )\n        }");
        }
        ImmutableSet flags = immutableSet;
        MergeResourceCallback callback = new MergeResourceCallback(variant2);
        this.basicCreateMergeResourcesTask(variant2, TaskManager.MergeType.PACKAGE, false, false, false, (Set)flags, callback);
        ComponentCreationConfig componentCreationConfig = variant2;
        ImmutableSet immutableSet4 = ImmutableSet.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet4, (String)"of()");
        this.createMergeResourcesTask(componentCreationConfig, false, (Set)immutableSet4);
        this.taskFactory.register(new GenerateApiPublicTxtTask.CreationAction(variant2));
    }

    private final void createCompileLibraryResourcesTask(LibraryCreationConfig variant2) {
        if (variant2.getAndroidResourcesCreationConfig() != null) {
            AndroidResourcesCreationConfig androidResourcesCreationConfig2 = variant2.getAndroidResourcesCreationConfig();
            Intrinsics.checkNotNull((Object)androidResourcesCreationConfig2);
            if (androidResourcesCreationConfig2.isPrecompileDependenciesResourcesEnabled()) {
                this.taskFactory.register(new CompileLibraryResourcesTask.CreationAction(variant2));
            }
        }
    }

    @Override
    protected void postJavacCreation(@NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        super.postJavacCreation(creationConfig);
        this.taskFactory.register(new ProcessLibraryArtProfileTask.CreationAction(creationConfig));
        this.taskFactory.register(new BundleLibraryClassesJar.CreationAction(creationConfig, AndroidArtifacts.PublishedConfigType.API_ELEMENTS));
    }

    public final void createLibraryAssetsTask(@NotNull LibraryCreationConfig variant2) {
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        this.taskFactory.register(new MergeSourceSetFolders.LibraryAssetCreationAction(variant2));
    }

    @Override
    @NotNull
    protected Set<InternalScopedArtifacts.InternalScope> getJavaResMergingScopes(@NotNull ComponentCreationConfig creationConfig) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        if (creationConfig.getComponentType().isTestComponent()) {
            InternalScopedArtifacts.InternalScope[] internalScopeArray = new InternalScopedArtifacts.InternalScope[]{InternalScopedArtifacts.InternalScope.SUB_PROJECT, InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS, InternalScopedArtifacts.InternalScope.LOCAL_DEPS};
            set = SetsKt.setOf((Object[])internalScopeArray);
        } else {
            set = SetsKt.setOf((Object)((Object)InternalScopedArtifacts.InternalScope.LOCAL_DEPS));
        }
        return set;
    }

    @Override
    protected void createPrepareLintJarForPublishTask() {
        super.createPrepareLintJarForPublishTask();
        for (LibraryCreationConfig variant2 : this.variantPropertiesList) {
            variant2.getArtifacts().copy(InternalArtifactType.LINT_PUBLISH_JAR.INSTANCE, this.globalConfig.getGlobalArtifacts());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/LibraryTaskManager$MergeResourceCallback;", "Lcom/android/build/gradle/internal/tasks/factory/TaskProviderCallback;", "Lcom/android/build/gradle/tasks/MergeResources;", "variant", "Lcom/android/build/gradle/internal/component/LibraryCreationConfig;", "(Lcom/android/build/gradle/internal/component/LibraryCreationConfig;)V", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    private static final class MergeResourceCallback
    implements TaskProviderCallback<MergeResources> {
        @NotNull
        private final LibraryCreationConfig variant;

        public MergeResourceCallback(@NotNull LibraryCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            this.variant = variant2;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<MergeResources> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            this.variant.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("public.txt").on(InternalArtifactType.PUBLIC_RES.INSTANCE);
        }
    }
}

