/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.BaseArtifactImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.build.gradle.internal.ide.dependencies.LibraryDependencyCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.level2.DependencyGraphs;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

public final class JavaArtifactImpl
extends BaseArtifactImpl
implements JavaArtifact,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<String> ideSetupTaskNames;
    private final File mockablePlatformJar;

    public static JavaArtifactImpl clone(JavaArtifact javaArtifact, int modelLevel, boolean modelWithFullDependency, LibraryDependencyCacheBuildService libraryDependencyCache) {
        SourceProvider variantSP = javaArtifact.getVariantSourceProvider();
        SourceProvider flavorsSP = javaArtifact.getMultiFlavorSourceProvider();
        return new JavaArtifactImpl(javaArtifact.getName(), javaArtifact.getAssembleTaskName(), javaArtifact.getCompileTaskName(), javaArtifact.getIdeSetupTaskNames(), javaArtifact.getGeneratedSourceFolders(), javaArtifact.getClassesFolder(), javaArtifact.getAdditionalClassesFolders(), javaArtifact.getJavaResourcesFolder(), javaArtifact.getMockablePlatformJar(), LibraryUtils.clone(javaArtifact.getDependencies(), modelLevel), libraryDependencyCache.clone(javaArtifact.getDependencyGraphs(), modelLevel, modelWithFullDependency), variantSP != null ? new SourceProviderImpl(variantSP) : null, flavorsSP != null ? new SourceProviderImpl(flavorsSP) : null);
    }

    public JavaArtifactImpl(String name, String assembleTaskName, String compileTaskName, Iterable<String> ideSetupTaskNames, Collection<File> generatedSourceFolders, File classesFolder, Set<File> additionalClassesFolders, File javaResourcesFolder, File mockablePlatformJar, Dependencies compileDependencies, DependencyGraphs dependencyGraphs, SourceProvider variantSourceProvider, SourceProvider multiFlavorSourceProviders) {
        super(name, assembleTaskName, null, compileTaskName, classesFolder, additionalClassesFolders, javaResourcesFolder, compileDependencies, dependencyGraphs, variantSourceProvider, multiFlavorSourceProviders, generatedSourceFolders);
        this.mockablePlatformJar = mockablePlatformJar;
        this.ideSetupTaskNames = Sets.newHashSet(ideSetupTaskNames);
    }

    public Set<String> getIdeSetupTaskNames() {
        return this.ideSetupTaskNames;
    }

    public File getMockablePlatformJar() {
        return this.mockablePlatformJar;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaArtifactImpl that = (JavaArtifactImpl)o;
        return Objects.equal(this.ideSetupTaskNames, that.ideSetupTaskNames) && Objects.equal((Object)this.mockablePlatformJar, (Object)that.mockablePlatformJar);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.ideSetupTaskNames, this.mockablePlatformJar});
    }
}

