/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\bJ\u001a\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00190\u0006H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010!\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\bJ2\u0010#\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00190\u0006H\u0002J)\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H&0*H\u0002\u00a2\u0006\u0002\u0010+R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR \u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/build/gradle/internal/testing/AdbHelper;", "", "versionedSdkLoader", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "processFactory", "Lkotlin/Function1;", "", "", "Ljava/lang/ProcessBuilder;", "(Lorg/gradle/api/provider/Provider;Lkotlin/jvm/functions/Function1;)V", "adbExecutable", "Ljava/io/File;", "getAdbExecutable", "()Ljava/io/File;", "adbExecutable$delegate", "Lkotlin/Lazy;", "allSerials", "logger", "Lcom/android/utils/ILogger;", "findAllDeviceSerialsWithIdPrefix", "idPrefix", "findDeviceSerialWithId", "idValue", "getDeviceProperty", "", "propertyName", "emulatorSerial", "stdoutTextProcessor", "getIdForSerial", "serial", "isBootCompleted", "", "isPackageManagerStarted", "killDevice", "runAdbShell", "shellCommandArgs", "runWithTimeout", "T", "timeoutSeconds", "", "function", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "gradle-core"})
public final class AdbHelper {
    @NotNull
    private final Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader;
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processFactory;
    @NotNull
    private final Lazy adbExecutable$delegate;

    public AdbHelper(@NotNull Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader2, @NotNull Function1<? super List<String>, ProcessBuilder> processFactory) {
        Intrinsics.checkNotNullParameter(versionedSdkLoader2, (String)"versionedSdkLoader");
        Intrinsics.checkNotNullParameter(processFactory, (String)"processFactory");
        this.versionedSdkLoader = versionedSdkLoader2;
        this.processFactory = processFactory;
        this.adbExecutable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ AdbHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                return ((RegularFile)((SdkComponentsBuildService.VersionedSdkLoader)AdbHelper.access$getVersionedSdkLoader$p(this.this$0).get()).getAdbExecutableProvider().get()).getAsFile();
            }
        }));
    }

    public /* synthetic */ AdbHelper(Provider provider2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Provider<SdkComponentsBuildService.VersionedSdkLoader>)provider2, (Function1<? super List<String>, ProcessBuilder>)function1);
    }

    @NotNull
    public final File getAdbExecutable() {
        Lazy lazy = this.adbExecutable$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-adbExecutable>(...)");
        return (File)object;
    }

    public final boolean isBootCompleted(@NotNull String emulatorSerial, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)emulatorSerial, (String)"emulatorSerial");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        AtomicBoolean bootCompleted = new AtomicBoolean(false);
        this.getDeviceProperty("sys.boot_completed", emulatorSerial, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(logger, bootCompleted){
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ AtomicBoolean $bootCompleted;
            {
                this.$logger = $logger;
                this.$bootCompleted = $bootCompleted;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Integer n = StringsKt.toIntOrNull((String)it);
                int n2 = 1;
                if (n != null && n == n2) {
                    this.$logger.info("sys.boot_completed=1", new Object[0]);
                    this.$bootCompleted.set(true);
                }
            }
        }));
        if (bootCompleted.get()) {
            return true;
        }
        this.getDeviceProperty("dev.bootcomplete", emulatorSerial, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(logger, bootCompleted){
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ AtomicBoolean $bootCompleted;
            {
                this.$logger = $logger;
                this.$bootCompleted = $bootCompleted;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Integer n = StringsKt.toIntOrNull((String)it);
                int n2 = 1;
                if (n != null && n == n2) {
                    this.$logger.info("dev.bootcomplete=1", new Object[0]);
                    this.$bootCompleted.set(true);
                }
            }
        }));
        return bootCompleted.get();
    }

    public final boolean isPackageManagerStarted(@NotNull String emulatorSerial) {
        Intrinsics.checkNotNullParameter((Object)emulatorSerial, (String)"emulatorSerial");
        AtomicBoolean result2 = new AtomicBoolean(false);
        Object[] objectArray = new String[]{"/system/bin/pm", "path", "android"};
        this.runAdbShell(emulatorSerial, CollectionsKt.listOf((Object[])objectArray), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(result2){
            final /* synthetic */ AtomicBoolean $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"package:", (boolean)false, (int)2, null)) {
                    this.$result.set(true);
                }
            }
        }));
        return result2.get();
    }

    @NotNull
    public final String findDeviceSerialWithId(@NotNull String idValue, @Nullable ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)idValue, (String)"idValue");
        List<String> serials = this.allSerials(logger);
        for (String serial : serials) {
            if (!Intrinsics.areEqual((Object)this.getIdForSerial(serial), (Object)idValue)) continue;
            return serial;
        }
        throw new IllegalStateException(("Failed to find serial for device id: " + idValue).toString());
    }

    public static /* synthetic */ String findDeviceSerialWithId$default(AdbHelper adbHelper, String string, ILogger iLogger, int n, Object object) {
        if ((n & 2) != 0) {
            iLogger = null;
        }
        return adbHelper.findDeviceSerialWithId(string, iLogger);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> findAllDeviceSerialsWithIdPrefix(@NotNull String idPrefix) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)idPrefix, (String)"idPrefix");
        Iterable $this$filter$iv = AdbHelper.allSerials$default(this, null, 1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String serial = (String)element$iv$iv;
            boolean bl = false;
            String id = this.getIdForSerial(serial);
            if (!(id != null && StringsKt.startsWith$default((String)id, (String)idPrefix, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void killDevice(@NotNull String serial) {
        Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
        Object[] objectArray = new String[]{this.getAdbExecutable().getAbsolutePath(), "-s", serial, "emu", "kill"};
        Process killProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])objectArray))).start();
        killProcess.waitFor();
    }

    private final List<String> allSerials(ILogger logger) {
        List serials = new ArrayList();
        Object[] objectArray = new String[]{this.getAdbExecutable().getAbsolutePath(), "devices"};
        Process listDevicesProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])objectArray))).start();
        try {
            this.runWithTimeout(60L, (Function0)new Function0<Integer>(listDevicesProcess, logger, (List<String>)serials){
                final /* synthetic */ Process $listDevicesProcess;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ List<String> $serials;
                {
                    this.$listDevicesProcess = $listDevicesProcess;
                    this.$logger = $logger;
                    this.$serials = $serials;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    GrabProcessOutput.grabProcessOutput((Process)this.$listDevicesProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(this.$logger, this.$serials){
                        final /* synthetic */ ILogger $logger;
                        final /* synthetic */ List<String> $serials;
                        {
                            this.$logger = $logger;
                            this.$serials = $serials;
                        }

                        public void out(@Nullable String line) {
                            block2: {
                                List values;
                                block3: {
                                    int n;
                                    if (line == null) {
                                        return;
                                    }
                                    Regex regex = new Regex("\\s+");
                                    String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                                    CharSequence charSequence = trimmed;
                                    values = regex.split(charSequence, n = 0);
                                    if (values.size() != 2) break block2;
                                    if (!Intrinsics.areEqual(values.get(1), (Object)"device")) break block3;
                                    ILogger iLogger = this.$logger;
                                    if (iLogger != null) {
                                        iLogger.info("Found device: " + values.get(0), new Object[0]);
                                    }
                                    this.$serials.add((String)values.get(0));
                                    break block2;
                                }
                                ILogger iLogger = this.$logger;
                                if (iLogger == null) break block2;
                                iLogger.info("Found inactive device: " + values.get(0) + " status: " + values.get(1), new Object[0]);
                            }
                        }

                        public void err(@Nullable String line) {
                        }
                    });
                    return this.$listDevicesProcess.waitFor();
                }
            });
        }
        catch (TimeoutException e) {
            listDevicesProcess.destroy();
            listDevicesProcess.waitFor();
            throw new IllegalStateException("Adb device retrieval timed out. Failed to destroy emulator properly".toString());
        }
        return serials;
    }

    static /* synthetic */ List allSerials$default(AdbHelper adbHelper, ILogger iLogger, int n, Object object) {
        if ((n & 1) != 0) {
            iLogger = null;
        }
        return adbHelper.allSerials(iLogger);
    }

    private final String getIdForSerial(String serial) {
        Ref.ObjectRef id = new Ref.ObjectRef();
        Object[] objectArray = new String[]{this.getAdbExecutable().getAbsolutePath(), "-s", serial, "emu", "avd", "id"};
        Process idDetectionProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])objectArray))).start();
        try {
            this.runWithTimeout(60L, (Function0)new Function0<Integer>(idDetectionProcess, (Ref.ObjectRef<String>)id){
                final /* synthetic */ Process $idDetectionProcess;
                final /* synthetic */ Ref.ObjectRef<String> $id;
                {
                    this.$idDetectionProcess = $idDetectionProcess;
                    this.$id = $id;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    GrabProcessOutput.grabProcessOutput((Process)this.$idDetectionProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(this.$id){
                        final /* synthetic */ Ref.ObjectRef<String> $id;
                        {
                            this.$id = $id;
                        }

                        public void out(@Nullable String line) {
                            if (line == null) {
                                return;
                            }
                            String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                            if (((CharSequence)trimmed).length() > 0 && !Intrinsics.areEqual((Object)trimmed, (Object)"OK")) {
                                this.$id.element = trimmed;
                            }
                        }

                        public void err(@Nullable String line) {
                        }
                    });
                    return this.$idDetectionProcess.waitFor();
                }
            });
        }
        catch (TimeoutException e) {
            idDetectionProcess.destroy();
            idDetectionProcess.waitFor();
        }
        return (String)id.element;
    }

    private final void getDeviceProperty(String propertyName, String emulatorSerial, Function1<? super String, Unit> stdoutTextProcessor) {
        Object[] objectArray = new String[]{"getprop", propertyName};
        this.runAdbShell(emulatorSerial, CollectionsKt.listOf((Object[])objectArray), stdoutTextProcessor);
    }

    private final void runAdbShell(String emulatorSerial, List<String> shellCommandArgs, Function1<? super String, Unit> stdoutTextProcessor) {
        Object[] objectArray = new String[]{this.getAdbExecutable().getAbsolutePath(), "-s", emulatorSerial, "shell"};
        Process getPropProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)shellCommandArgs))).start();
        GrabProcessOutput.grabProcessOutput((Process)getPropProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(stdoutTextProcessor){
            final /* synthetic */ Function1<String, Unit> $stdoutTextProcessor;
            {
                this.$stdoutTextProcessor = $stdoutTextProcessor;
            }

            public void out(@Nullable String line) {
                if (line == null) {
                    return;
                }
                this.$stdoutTextProcessor.invoke((Object)((Object)StringsKt.trim((CharSequence)line)).toString());
            }

            public void err(@Nullable String line) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T runWithTimeout(long timeoutSeconds, Function0<? extends T> function) {
        ExecutorService executor2 = Executors.newSingleThreadExecutor();
        Future future = executor2.submit(new Callable(function){
            private final /* synthetic */ Function0 function;
            {
                this.function = function;
            }

            public final /* synthetic */ Object call() {
                return this.function.invoke();
            }
        });
        try {
            Object t = future.get(timeoutSeconds, TimeUnit.SECONDS);
            return t;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        finally {
            executor2.shutdown();
        }
    }

    public static final /* synthetic */ Provider access$getVersionedSdkLoader$p(AdbHelper $this) {
        return $this.versionedSdkLoader;
    }
}

