/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.external.cmake.server.BuildFiles;
import com.android.build.gradle.external.cmake.server.CmakeInputsResult;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.ConfigureCommandResult;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.HandshakeRequest;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.ModelUtilsKt;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.ProtocolVersion;
import com.android.build.gradle.external.cmake.server.Server;
import com.android.build.gradle.external.cmake.server.ServerFactory;
import com.android.build.gradle.external.cmake.server.ServerUtils;
import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.external.cmake.server.receiver.InteractiveMessage;
import com.android.build.gradle.external.cmake.server.receiver.MessageReceiver;
import com.android.build.gradle.external.cmake.server.receiver.ServerReceiver;
import com.android.build.gradle.internal.cxx.cmake.MakeCmakeMessagePathsAbsoluteKt;
import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.configure.CompileCommandsKt;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrintWriterLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModel;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessCommand;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessKt;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGeneratorUtilsKt;
import com.android.build.gradle.tasks.CmakeServerExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessException;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/tasks/CmakeServerExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "cmake", "Lcom/android/build/gradle/internal/cxx/model/CxxCmakeModuleModel;", "getCmake", "()Lcom/android/build/gradle/internal/cxx/model/CxxCmakeModuleModel;", "doHandshake", "", "generator", "", "sourceDirectory", "Ljava/io/File;", "buildDirectory", "cmakeServer", "Lcom/android/build/gradle/external/cmake/server/Server;", "executeProcess", "ops", "Lorg/gradle/process/ExecOperations;", "executeProcessAndGetOutput", "generateAndroidGradleBuild", "getBuildFiles", "", "getHandshakeRequest", "Lcom/android/build/gradle/external/cmake/server/HandshakeRequest;", "cmakeServerProtocolVersion", "Lcom/android/build/gradle/external/cmake/server/ProtocolVersion;", "getNativeBuildConfigValue", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "getProcessBuilder", "Lcom/android/build/gradle/internal/cxx/process/ExecuteProcessCommand;", "Companion", "gradle-core"})
public final class CmakeServerExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CMAKE_SERVER_LOG_PREFIX = "CMAKE SERVER: ";

    public CmakeServerExternalNativeJsonGenerator(@NotNull CxxAbiModel abi, @Nullable GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        super(abi, variantBuilder);
        GradleBuildVariant.Builder builder = variantBuilder;
        if (builder != null) {
            builder.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.CMAKE);
        }
        CmakeExternalNativeJsonGeneratorUtilsKt.cmakeMakefileChecks(abi.getVariant());
    }

    private final CxxCmakeModuleModel getCmake() {
        CxxCmakeModuleModel cxxCmakeModuleModel = this.getAbi().getVariant().getModule().getCmake();
        Intrinsics.checkNotNull((Object)cxxCmakeModuleModel);
        return cxxCmakeModuleModel;
    }

    @Override
    public void executeProcess(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        this.executeProcessAndGetOutput(abi);
    }

    @Override
    @NotNull
    public ExecuteProcessCommand getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        File file = this.getCmake().getCmakeExe();
        Intrinsics.checkNotNull((Object)file);
        return ExecuteProcessKt.createExecuteProcessCommand(file).addArgs(abi.getConfigurationArguments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeProcessAndGetOutput(CxxAbiModel abi) {
        File cmakeServerLogFile = CxxAbiModelKt.getCmakeServerLogFile(abi).getAbsoluteFile();
        cmakeServerLogFile.getParentFile().mkdirs();
        AutoCloseable autoCloseable = new PassThroughPrintWriterLoggingEnvironment(new PrintWriter(cmakeServerLogFile, "UTF-8"), CMAKE_SERVER_LOG_PREFIX);
        Throwable throwable = null;
        try {
            PassThroughPrintWriterLoggingEnvironment it = (PassThroughPrintWriterLoggingEnvironment)autoCloseable;
            boolean bl = false;
            ServerReceiver serverReceiver2 = new ServerReceiver().setMessageReceiver(new MessageReceiver(abi){
                final /* synthetic */ CxxAbiModel $abi;
                {
                    this.$abi = $abi;
                }

                public final void receive(@NotNull InteractiveMessage message2) {
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    File file = this.$abi.getVariant().getModule().getMakeFile().getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"abi.variant.module.makeFile.parentFile");
                    com.android.build.gradle.tasks.CmakeServerExternalNativeJsonGenerator$Companion.access$logInteractiveMessage(CmakeServerExternalNativeJsonGenerator.Companion, message2, file);
                }
            }).setDiagnosticReceiver(executeProcessAndGetOutput.1.serverReceiver.2.INSTANCE);
            File file = this.getCmake().getCmakeExe();
            Intrinsics.checkNotNull((Object)file);
            File cmakeBinFolder = file.getParentFile();
            Server server = ServerFactory.create(cmakeBinFolder, serverReceiver2);
            Intrinsics.checkNotNullExpressionValue((Object)server, (String)"create(cmakeBinFolder, serverReceiver)");
            Server cmakeServer = server;
            if (!cmakeServer.connect()) {
                throw new RuntimeException("Unable to connect to Cmake server located at: " + cmakeBinFolder.getAbsolutePath());
            }
            try {
                List<CommandLineArgument> arguments = BuildSystemCommandLineKt.toCmakeArguments(abi.getConfigurationArguments());
                List<String> cacheArgumentsList = BuildSystemCommandLineKt.toStringList(BuildSystemCommandLineKt.onlyKeepCmakeServerArguments(arguments));
                ConfigureCommandResult configureCommandResult = null;
                String string = BuildSystemCommandLineKt.getCmakeGenerator(arguments);
                Intrinsics.checkNotNull((Object)string);
                File file2 = abi.getVariant().getModule().getMakeFile().getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"abi.variant.module.makeFile.parentFile");
                String string2 = BuildSystemCommandLineKt.getCmakeBinaryOutputPath(arguments);
                Intrinsics.checkNotNull((Object)string2);
                this.doHandshake(string, file2, new File(string2), cmakeServer);
                Collection $this$toTypedArray$iv = cacheArgumentsList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] argsArray = thisCollection$iv.toArray(new String[0]);
                ConfigureCommandResult configureCommandResult2 = cmakeServer.configure(Arrays.copyOf(argsArray, argsArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)configureCommandResult2, (String)"cmakeServer.configure(*argsArray)");
                configureCommandResult = configureCommandResult2;
                if (!ServerUtils.isConfigureResultValid(configureCommandResult.configureResult)) {
                    String string3 = "Error configuring CMake server (%s).\r\n%s";
                    Object[] objectArray = new Object[]{cmakeServer.getCmakePath(), configureCommandResult.interactiveMessages};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                    throw new ProcessException(string4);
                }
                ComputeResult computeResult = CmakeServerExternalNativeJsonGenerator.Companion.doCompute(cmakeServer);
                if (!ServerUtils.isComputedResultValid(computeResult)) {
                    throw new ProcessException(StringsKt.trimIndent((String)("\n                    Error computing CMake server result.\n                    " + configureCommandResult.interactiveMessages + "\n                    ")));
                }
                this.generateAndroidGradleBuild(abi, cmakeServer);
            }
            finally {
                cmakeServer.disconnect();
            }
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void doHandshake(String generator, File sourceDirectory, File buildDirectory, Server cmakeServer) throws IOException {
        List<ProtocolVersion> supportedProtocolVersions = cmakeServer.getSupportedVersion();
        if (supportedProtocolVersions == null || supportedProtocolVersions.isEmpty()) {
            String string = "Gradle does not support the Cmake server version. %s";
            Object[] objectArray = new Object[]{CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new RuntimeException(string2);
        }
        ProtocolVersion protocolVersion = supportedProtocolVersions.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)protocolVersion, (String)"supportedProtocolVersions[0]");
        HandshakeResult handshakeResult = cmakeServer.handshake(this.getHandshakeRequest(generator, sourceDirectory, buildDirectory, protocolVersion));
        Intrinsics.checkNotNullExpressionValue((Object)handshakeResult, (String)"cmakeServer.handshake(\n \u2026]\n            )\n        )");
        HandshakeResult handshakeResult2 = handshakeResult;
        if (!ServerUtils.isHandshakeResultValid(handshakeResult2)) {
            String string = "Invalid handshake result from Cmake server: \n%s\n%s";
            Object[] objectArray = new Object[]{CmakeUtils.getObjectToString(handshakeResult2), CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            throw new RuntimeException(string3);
        }
    }

    private final HandshakeRequest getHandshakeRequest(String generator, File sourceDirectory, File buildDirectory, ProtocolVersion cmakeServerProtocolVersion) {
        if (!sourceDirectory.isDirectory()) {
            Object[] objectArray = new Object[]{sourceDirectory};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_SERVER_SOURCE_DIRECTORY_MISSING, "Not a directory: %s", objectArray);
        }
        HandshakeRequest handshakeRequest = new HandshakeRequest();
        handshakeRequest.cookie = "gradle-cmake-cookie";
        handshakeRequest.generator = generator;
        handshakeRequest.protocolVersion = cmakeServerProtocolVersion;
        handshakeRequest.buildDirectory = CmakeServerExternalNativeJsonGenerator.Companion.normalizeFilePath(buildDirectory);
        handshakeRequest.sourceDirectory = CmakeServerExternalNativeJsonGenerator.Companion.normalizeFilePath(sourceDirectory);
        return handshakeRequest;
    }

    private final void generateAndroidGradleBuild(CxxAbiModel abi, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = this.getNativeBuildConfigValue(abi, cmakeServer);
        AndroidBuildGradleJsons.writeNativeBuildConfigValueToJsonFile(CxxAbiModelKt.getJsonFile(abi), nativeBuildConfigValue);
        CompileCommandsKt.convertCMakeToCompileCommandsBin$default(CxxAbiModelKt.getCompileCommandsJsonFile(abi), CxxAbiModelKt.getCompileCommandsJsonBinFile(abi), 0, null, 12, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final NativeBuildConfigValue getNativeBuildConfigValue(CxxAbiModel abi, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = CmakeServerExternalNativeJsonGenerator.Companion.createDefaultNativeBuildConfigValue();
        Preconditions.checkNotNull(nativeBuildConfigValue.buildFiles);
        Collection<File> collection = nativeBuildConfigValue.buildFiles;
        Intrinsics.checkNotNull(collection);
        collection.addAll((Collection<File>)this.getBuildFiles(cmakeServer));
        Preconditions.checkNotNull(nativeBuildConfigValue.cleanCommandsComponents);
        List<List<String>> list = nativeBuildConfigValue.cleanCommandsComponents;
        Intrinsics.checkNotNull(list);
        String[] stringArray = new String[]{"clean"};
        list.add(CxxAbiModelKt.createNinjaCommand(abi, stringArray));
        stringArray = new String[]{"{LIST_OF_TARGETS_TO_BUILD}"};
        nativeBuildConfigValue.buildTargetsCommandComponents = CxxAbiModelKt.createNinjaCommand(abi, stringArray);
        CodeModel codeModel = cmakeServer.codemodel();
        Intrinsics.checkNotNullExpressionValue((Object)codeModel, (String)"cmakeServer.codemodel()");
        CodeModel codeModel2 = codeModel;
        if (!ServerUtils.isCodeModelValid(codeModel2)) {
            String string = "Invalid code model received from Cmake server: \n%s\n%s";
            Object[] objectArray = new Object[]{CmakeUtils.getObjectToString(codeModel2), CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new RuntimeException(string2);
        }
        Preconditions.checkNotNull(nativeBuildConfigValue.cFileExtensions);
        Collection<String> collection2 = nativeBuildConfigValue.cFileExtensions;
        Intrinsics.checkNotNull(collection2);
        Set<String> set = CmakeUtils.getCExtensionSet(codeModel2);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getCExtensionSet(codeModel)");
        collection2.addAll((Collection<String>)set);
        Preconditions.checkNotNull(nativeBuildConfigValue.cppFileExtensions);
        Collection<String> collection3 = nativeBuildConfigValue.cppFileExtensions;
        Intrinsics.checkNotNull(collection3);
        Set<String> set2 = CmakeUtils.getCppExtensionSet(codeModel2);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getCppExtensionSet(codeModel)");
        collection3.addAll((Collection<String>)set2);
        CxxAbiModelKt.getAdditionalProjectFilesIndexFile(abi).getParentFile().mkdirs();
        Object object = CxxAbiModelKt.getAdditionalProjectFilesIndexFile(abi);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Object object2 = charset;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter additionalProjectFilesIndexWriter = (BufferedWriter)object;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)codeModel2.configurations, (String)"codeModel.configurations");
            for (Configuration config2 : codeModel2.configurations) {
                Intrinsics.checkNotNullExpressionValue((Object)config2.projects, (String)"config.projects");
                for (Project project2 : config2.projects) {
                    Intrinsics.checkNotNullExpressionValue((Object)project2.targets, (String)"project.targets");
                    for (Target target : project2.targets) {
                        Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
                        if (!CmakeServerExternalNativeJsonGenerator.Companion.canAddTargetToNativeLibrary(target)) continue;
                        NativeLibraryValue nativeLibraryValue = CmakeServerExternalNativeJsonGenerator.Companion.getNativeLibraryValue(abi, target, additionalProjectFilesIndexWriter);
                        String libraryName = target.name + "-" + config2.name + "-" + abi.getAbi().getTag();
                        Preconditions.checkNotNull(nativeBuildConfigValue.libraries);
                        Map<String, NativeLibraryValue> map = nativeBuildConfigValue.libraries;
                        Intrinsics.checkNotNull(map);
                        map.put(libraryName, nativeLibraryValue);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return nativeBuildConfigValue;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getBuildFiles(Server cmakeServer) {
        void $this$sortedBy$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        File it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        CmakeInputsResult cmakeInputsResult = cmakeServer.cmakeInputs();
        Intrinsics.checkNotNullExpressionValue((Object)cmakeInputsResult, (String)"cmakeServer.cmakeInputs()");
        CmakeInputsResult cmakeInputsResult2 = cmakeInputsResult;
        if (!ServerUtils.isCmakeInputsResultValid(cmakeInputsResult2) || cmakeInputsResult2.buildFiles == null) {
            return CollectionsKt.listOf((Object)this.getAbi().getVariant().getModule().getMakeFile().getAbsoluteFile());
        }
        String string = cmakeInputsResult2.sourceDirectory;
        if (string == null) {
            string = this.getAbi().getVariant().getModule().getMakeFile().getAbsoluteFile().getParent();
        }
        File sourceDirectory = new File(string);
        Collection collection = CollectionsKt.listOf((Object)this.getAbi().getVariant().getModule().getMakeFile());
        Intrinsics.checkNotNullExpressionValue((Object)cmakeInputsResult2.buildFiles, (String)"cmakeInputsResult.buildFiles");
        Object[] objectArray = cmakeInputsResult2.buildFiles;
        Collection collection2 = collection;
        boolean $i$f$flatMap = false;
        void var7_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (String element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block10: {
                block9: {
                    Object[] objectArray2;
                    BuildFiles buildFiles = (BuildFiles)((Object)element$iv$iv);
                    boolean bl = false;
                    object = objectArray2 = buildFiles.sources;
                    if (objectArray2 == null) break block9;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sources");
                    object = ArraysKt.filterNotNull((Object[])objectArray2);
                    if (object != null) break block10;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String element$iv$iv;
            element$iv$iv = (String)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(new File((String)((Object)it)));
        }
        List files2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        $this$map$iv = files2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            if (!(StringsKt.compareTo((String)string2, (String)"CMakeLists.txt", (boolean)true) == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            it = (File)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(FilesKt.resolve((File)sourceDirectory, (File)file).getCanonicalFile());
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPath().length());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPath().length()));
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/tasks/CmakeServerExternalNativeJsonGenerator$Companion;", "", "()V", "CMAKE_SERVER_LOG_PREFIX", "", "canAddTargetToNativeLibrary", "", "target", "Lcom/android/build/gradle/external/cmake/server/Target;", "createDefaultNativeBuildConfigValue", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "doCompute", "Lcom/android/build/gradle/external/cmake/server/ComputeResult;", "cmakeServer", "Lcom/android/build/gradle/external/cmake/server/Server;", "getCmakeInfoString", "getNativeLibraryValue", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValue;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "additionalProjectFilesIndexWriter", "Ljava/io/BufferedWriter;", "logInteractiveMessage", "", "message", "Lcom/android/build/gradle/external/cmake/server/receiver/InteractiveMessage;", "makeFileDirectory", "Ljava/io/File;", "normalizeFilePath", "file", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getCmakeInfoString(Server cmakeServer) {
            return "Cmake path: " + cmakeServer.getCmakePath();
        }

        private final void logInteractiveMessage(InteractiveMessage message2, File makeFileDirectory) {
            String correctedMessage;
            block10: {
                block9: {
                    String cmakeWarningPrefix;
                    block8: {
                        block7: {
                            String cmakeErrorPrefix = "CMake Error";
                            cmakeWarningPrefix = "CMake Warning";
                            if (message2.type != null && Intrinsics.areEqual((Object)message2.type, (Object)"error")) {
                                String string = message2.errorMessage;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.errorMessage");
                                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_SERVER_INTERACTIVE_ERROR, MakeCmakeMessagePathsAbsoluteKt.makeCmakeMessagePathsAbsolute(string, makeFileDirectory), new Object[0]);
                                return;
                            }
                            String string = message2.message;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.message");
                            correctedMessage = MakeCmakeMessagePathsAbsoluteKt.makeCmakeMessagePathsAbsolute(string, makeFileDirectory);
                            if (message2.title != null && Intrinsics.areEqual((Object)message2.title, (Object)"Error")) break block7;
                            String string2 = message2.message;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.message");
                            if (!StringsKt.startsWith$default((String)string2, (String)cmakeErrorPrefix, (boolean)false, (int)2, null)) break block8;
                        }
                        LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_SERVER_INTERACTIVE_ERROR, correctedMessage, new Object[0]);
                        return;
                    }
                    if (message2.title != null && Intrinsics.areEqual((Object)message2.title, (Object)"Warning")) break block9;
                    String string = message2.message;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.message");
                    if (!StringsKt.startsWith$default((String)string, (String)cmakeWarningPrefix, (boolean)false, (int)2, null)) break block10;
                }
                LoggingEnvironmentKt.warnln(correctedMessage, new Object[0]);
                return;
            }
            LoggingEnvironmentKt.infoln(correctedMessage, new Object[0]);
        }

        private final ComputeResult doCompute(Server cmakeServer) throws IOException {
            ComputeResult computeResult = cmakeServer.compute();
            Intrinsics.checkNotNullExpressionValue((Object)computeResult, (String)"cmakeServer.compute()");
            return computeResult;
        }

        private final NativeLibraryValue getNativeLibraryValue(CxxAbiModel abi, Target target, BufferedWriter additionalProjectFilesIndexWriter) {
            NativeLibraryValue nativeLibraryValue = new NativeLibraryValue();
            nativeLibraryValue.abi = abi.getAbi().getTag();
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)target.name, (String)"target.name");
            nativeLibraryValue.buildCommandComponents = CxxAbiModelKt.createNinjaCommand(abi, stringArray);
            nativeLibraryValue.artifactName = target.name;
            String string = nativeLibraryValue.buildType = abi.getVariant().isDebuggableEnabled() ? "debug" : "release";
            if (!Intrinsics.areEqual((Object)"OBJECT_LIBRARY", (Object)target.type) && target.artifacts != null) {
                Intrinsics.checkNotNullExpressionValue((Object)target.artifacts, (String)"target.artifacts");
                if (!(((Object[])target.artifacts).length == 0)) {
                    nativeLibraryValue.output = new File(target.artifacts[0]);
                }
            }
            nativeLibraryValue.runtimeFiles = ModelUtilsKt.findRuntimeFiles(target);
            File sourceDirectory = new File(target.sourceDirectory);
            FileGroup[] $this$orEmpty$iv = target.fileGroups;
            boolean $i$f$orEmpty = false;
            FileGroup[] fileGroupArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                fileGroupArray = new FileGroup[]{};
            }
            for (FileGroup fileGroup : fileGroupArray) {
                if (Intrinsics.areEqual((Object)fileGroup.language, (Object)"C") || Intrinsics.areEqual((Object)fileGroup.language, (Object)"CXX")) continue;
                Intrinsics.checkNotNullExpressionValue((Object)fileGroup.sources, (String)"fileGroup.sources");
                for (String source : fileGroup.sources) {
                    Appendable appendable = additionalProjectFilesIndexWriter;
                    Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
                    Appendable appendable2 = appendable.append(FilesKt.resolve((File)sourceDirectory, (String)source).getAbsolutePath());
                    Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append('\\n')");
                }
            }
            return nativeLibraryValue;
        }

        private final boolean canAddTargetToNativeLibrary(Target target) {
            return target.artifacts != null || target.fileGroups != null;
        }

        private final NativeBuildConfigValue createDefaultNativeBuildConfigValue() {
            NativeBuildConfigValue nativeBuildConfigValue = new NativeBuildConfigValue();
            nativeBuildConfigValue.buildFiles = new ArrayList();
            nativeBuildConfigValue.cleanCommandsComponents = new ArrayList();
            nativeBuildConfigValue.libraries = new HashMap();
            nativeBuildConfigValue.toolchains = new HashMap();
            nativeBuildConfigValue.cFileExtensions = new ArrayList();
            nativeBuildConfigValue.cppFileExtensions = new ArrayList();
            nativeBuildConfigValue.stringTable = Maps.newHashMap();
            return nativeBuildConfigValue;
        }

        private final String normalizeFilePath(File file) {
            String string;
            if (ExternalNativeJsonGenerator.isWindows()) {
                String string2 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
                string = StringsKt.replace$default((String)string2, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            } else {
                String string3 = file.getPath();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
            }
            return string;
        }

        public static final /* synthetic */ void access$logInteractiveMessage(Companion $this, InteractiveMessage message2, File makeFileDirectory) {
            $this.logInteractiveMessage(message2, makeFileDirectory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

