/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.caching.CachingEnvironmentKt;
import com.android.build.gradle.internal.cxx.caching.ThreadCachingEnvironment;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKey;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.PassThroughRecordingLoggingEnvironment;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a2\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a`\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u001a&\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0006H\u0007\u001a\u0012\u0010\u0016\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0018\u001a\u00020\u0006H\u0007\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0002\u00a8\u0006\u001f"}, d2={"findNdkPathImpl", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "userSettings", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorKey;", "getNdkSourceProperties", "Lkotlin/Function1;", "Ljava/io/File;", "Lcom/android/build/gradle/internal/cxx/configure/SdkSourceProperties;", "sdkHandler", "Lcom/android/build/gradle/internal/SdkHandler;", "ndkVersionFromDsl", "", "ndkPathFromDsl", "ndkDirProperty", "sdkFolder", "ndkVersionedFolderNames", "", "getNdkFolderParsedRevision", "Lcom/android/repository/Revision;", "ndkDirFolder", "getNdkVersionInfo", "ndkRoot", "getNdkVersionOrDefault", "getNdkVersionedFolders", "ndkVersionRoot", "logUserInputs", "", "parseRevision", "version", "stripPreviewFromRevision", "revision", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNdkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkLocator.kt\ncom/android/build/gradle/internal/cxx/configure/NdkLocatorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 CachingEnvironment.kt\ncom/android/build/gradle/internal/cxx/caching/CachingEnvironmentKt\n*L\n1#1,466:1\n3792#2:467\n4307#2,2:468\n59#3,29:470\n*S KotlinDebug\n*F\n+ 1 NdkLocator.kt\ncom/android/build/gradle/internal/cxx/configure/NdkLocatorKt\n*L\n363#1:467\n363#1:468,2\n421#1:470,29\n*E\n"})
public final class NdkLocatorKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NdkLocatorRecord findNdkPathImpl(NdkLocatorKey userSettings, Function1<? super File, SdkSourceProperties> getNdkSourceProperties, SdkHandler sdkHandler) {
        Object ndkPathFolder;
        NdkLocatorKey $this$findNdkPathImpl_u24lambda_u241 = userSettings;
        boolean bl = false;
        NdkLocatorKt.logUserInputs(userSettings);
        Revision revision = NdkLocatorKt.parseRevision(NdkLocatorKt.getNdkVersionOrDefault($this$findNdkPathImpl_u24lambda_u241.getNdkVersionFromDsl()));
        if (revision == null) {
            return null;
        }
        Revision revisionFromNdkVersion = revision;
        CharSequence charSequence = $this$findNdkPathImpl_u24lambda_u241.getNdkPathFromDsl();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            ndkPathFolder = new File($this$findNdkPathImpl_u24lambda_u241.getNdkPathFromDsl());
            Revision revisionFromNdkPath = NdkLocatorKt.findNdkPathImpl$lambda$1$getNdkFolderRevision(getNdkSourceProperties, (File)ndkPathFolder);
            if (revisionFromNdkPath == null) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, "Location specified by android.ndkPath (" + $this$findNdkPathImpl_u24lambda_u241.getNdkPathFromDsl() + ") did not contain a valid NDK and couldn't be used", new Object[0]);
                return null;
            }
            CharSequence charSequence2 = $this$findNdkPathImpl_u24lambda_u241.getNdkDirProperty();
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_IS_AMBIGUOUS, "Both android.ndkPath and ndk.dir in local.properties are set", new Object[0]);
                return null;
            }
            charSequence2 = $this$findNdkPathImpl_u24lambda_u241.getNdkVersionFromDsl();
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) && !Intrinsics.areEqual((Object)revisionFromNdkVersion, (Object)revisionFromNdkPath)) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_IS_AMBIGUOUS, "android.ndkVersion is [" + revisionFromNdkVersion + "] but android.ndkPath " + (File)ndkPathFolder + " refers to a different version [" + revisionFromNdkPath + "].", new Object[0]);
                return null;
            }
            return new NdkLocatorRecord((File)ndkPathFolder, revisionFromNdkPath);
        }
        ndkPathFolder = $this$findNdkPathImpl_u24lambda_u241.getNdkDirProperty();
        if (!(ndkPathFolder == null || StringsKt.isBlank((CharSequence)ndkPathFolder))) {
            File ndkDirFolder = new File($this$findNdkPathImpl_u24lambda_u241.getNdkDirProperty());
            Revision revision2 = NdkLocatorKt.findNdkPathImpl$lambda$1$getNdkFolderRevision(getNdkSourceProperties, ndkDirFolder);
            if (revision2 != null) {
                NdkLocatorRecord ndkLocatorRecord;
                if (!Intrinsics.areEqual((Object)revision2, (Object)revisionFromNdkVersion) && $this$findNdkPathImpl_u24lambda_u241.getNdkVersionFromDsl() != null) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_VERSION_IS_UNMATCHED, "NDK from ndk.dir at " + ndkDirFolder + " had version [" + revision2 + "] which disagrees with android.ndkVersion [" + revisionFromNdkVersion + "]", new Object[0]);
                    return null;
                }
                NdkLocatorRecord resolutionWithNdkDir = new NdkLocatorRecord(ndkDirFolder, revision2);
                LoggingEnvironmentKt.infoln("Checking whether deleting ndk.dir and setting android.ndkVersion to [" + revision2 + "] would result in the same NDK", new Object[0]);
                AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(null, "ndk.dir delete check", true, 1, null);
                Throwable throwable = null;
                try {
                    PassThroughPrefixingLoggingEnvironment it = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
                    boolean bl2 = false;
                    NdkLocatorRecord resolutionWithoutNdkDir = NdkLocatorKt.findNdkPathImpl(NdkLocatorKey.copy$default(userSettings, revision2.toString(), null, null, null, null, 26, null), getNdkSourceProperties, null);
                    if (Intrinsics.areEqual((Object)resolutionWithoutNdkDir, (Object)resolutionWithNdkDir)) {
                        LoggingEnvironmentKt.infoln("Deleting ndk.dir and setting android.ndkVersion to [" + revision2 + "] would result in the same NDK.", new Object[0]);
                    } else {
                        LoggingEnvironmentKt.infoln("Deleting ndk.dir and setting android.ndkVersion to [" + revision2 + "] would *not* result in the same NDK.", new Object[0]);
                    }
                    ndkLocatorRecord = resolutionWithoutNdkDir;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                NdkLocatorRecord resolutionWithoutNdkDir = ndkLocatorRecord;
                if (Intrinsics.areEqual((Object)resolutionWithNdkDir, (Object)resolutionWithoutNdkDir)) {
                    LoggingEnvironmentKt.warnln(CxxDiagnosticCode.NDK_DIR_IS_DEPRECATED, "NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. Please delete ndk.dir from local.properties and set android.ndkVersion to [" + revision2 + "] in all native modules in the project. https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                    return resolutionWithNdkDir;
                }
                if (resolutionWithoutNdkDir == null) {
                    LoggingEnvironmentKt.warnln(CxxDiagnosticCode.NDK_DIR_IS_DEPRECATED, "NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. Please use android.ndkVersion or android.ndkPath in build.gradle to specify the NDK to use. https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                    return resolutionWithNdkDir;
                }
                LoggingEnvironmentKt.warnln(CxxDiagnosticCode.NDK_DIR_IS_DEPRECATED, "NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. If you delete ndk.dir from local.properties and set android.ndkVersion to [" + revision2 + "] then NDK at " + resolutionWithoutNdkDir.getNdk() + " will be used. https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                return resolutionWithNdkDir;
            }
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_IS_INVALID, "Location specified by ndk.dir (" + $this$findNdkPathImpl_u24lambda_u241.getNdkDirProperty() + ") did not contain a valid NDK and couldn't be used", new Object[0]);
            return null;
        }
        if ($this$findNdkPathImpl_u24lambda_u241.getSdkFolder() != null) {
            File versionedNdkPath = new File(new File($this$findNdkPathImpl_u24lambda_u241.getSdkFolder(), "ndk"), String.valueOf(revisionFromNdkVersion));
            Revision sideBySideRevision = NdkLocatorKt.findNdkPathImpl$lambda$1$getNdkFolderRevision(getNdkSourceProperties, versionedNdkPath);
            if (sideBySideRevision != null) {
                return new NdkLocatorRecord(versionedNdkPath, sideBySideRevision);
            }
            File ndkBundlePath = new File($this$findNdkPathImpl_u24lambda_u241.getSdkFolder(), "ndk-bundle");
            Revision bundleRevision = NdkLocatorKt.findNdkPathImpl$lambda$1$getNdkFolderRevision(getNdkSourceProperties, ndkBundlePath);
            if (bundleRevision != null && Intrinsics.areEqual((Object)bundleRevision, (Object)revisionFromNdkVersion)) {
                return new NdkLocatorRecord(ndkBundlePath, bundleRevision);
            }
        }
        if (sdkHandler == null) {
            return null;
        }
        LoggingEnvironmentKt.infoln("No NDK was found. Trying to download it now.", new Object[0]);
        File downloaded = sdkHandler.installNdk(revisionFromNdkVersion);
        if (downloaded != null) {
            LoggingEnvironmentKt.infoln("NDK " + revisionFromNdkVersion + " was downloaded to " + downloaded + ". Using that.", new Object[0]);
            return new NdkLocatorRecord(downloaded, revisionFromNdkVersion);
        }
        throw new InvalidUserDataException("NDK not configured. Download it with SDK manager. Preferred NDK version is '25.1.8937393'. ");
    }

    @Nullable
    public static final Revision getNdkFolderParsedRevision(@NotNull File ndkDirFolder, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        Intrinsics.checkNotNullParameter((Object)ndkDirFolder, (String)"ndkDirFolder");
        Intrinsics.checkNotNullParameter(getNdkSourceProperties, (String)"getNdkSourceProperties");
        SdkSourceProperties properties = (SdkSourceProperties)getNdkSourceProperties.invoke((Object)ndkDirFolder);
        if (properties == null) {
            LoggingEnvironmentKt.infoln("Folder " + ndkDirFolder + " does not exist. Ignoring.", new Object[0]);
            return null;
        }
        String packageRevision = properties.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION);
        if (packageRevision == null) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, "Folder " + ndkDirFolder + " has no Pkg.Revision in source.properties. Ignoring.", new Object[0]);
            return null;
        }
        return NdkLocatorKt.parseRevision(packageRevision);
    }

    private static final void logUserInputs(NdkLocatorKey userSettings) {
        NdkLocatorKey $this$logUserInputs_u24lambda_u242 = userSettings;
        boolean bl = false;
        String string = $this$logUserInputs_u24lambda_u242.getNdkVersionFromDsl();
        if (string == null) {
            string = "not set";
        }
        LoggingEnvironmentKt.infoln("android.ndkVersion from module build.gradle is [" + string + "]", new Object[0]);
        String string2 = $this$logUserInputs_u24lambda_u242.getNdkPathFromDsl();
        if (string2 == null) {
            string2 = "not set";
        }
        LoggingEnvironmentKt.infoln("android.ndkPath from module build.gradle is " + string2, new Object[0]);
        String string3 = $this$logUserInputs_u24lambda_u242.getNdkDirProperty();
        if (string3 == null) {
            string3 = "not set";
        }
        LoggingEnvironmentKt.infoln("ndk.dir in local.properties is " + string3, new Object[0]);
        LoggingEnvironmentKt.infoln("Not considering ANDROID_NDK_HOME because support was removed after deprecation period.", new Object[0]);
        if ($this$logUserInputs_u24lambda_u242.getSdkFolder() != null) {
            LoggingEnvironmentKt.infoln("sdkFolder is " + $this$logUserInputs_u24lambda_u242.getSdkFolder(), new Object[0]);
            String[] stringArray = new String[]{"ndk"};
            File sxsRoot = FileUtils.join((File)$this$logUserInputs_u24lambda_u242.getSdkFolder(), (String[])stringArray);
            if (!sxsRoot.isDirectory()) {
                LoggingEnvironmentKt.infoln("NDK side-by-side folder from sdkFolder " + sxsRoot + " does not exist", new Object[0]);
            }
        } else {
            LoggingEnvironmentKt.infoln("sdkFolder is not set", new Object[0]);
        }
    }

    private static final String getNdkVersionOrDefault(String ndkVersionFromDsl) {
        String string;
        CharSequence charSequence = ndkVersionFromDsl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            LoggingEnvironmentKt.infoln("Because no explicit NDK was requested, the default version [25.1.8937393] for this Android Gradle Plugin will be used", new Object[0]);
            string = "25.1.8937393";
        } else {
            string = ndkVersionFromDsl;
        }
        return string;
    }

    private static final Revision parseRevision(String version) {
        try {
            Revision revision = Revision.parseRevision((String)version);
            Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"parseRevision(version)");
            Revision revision2 = NdkLocatorKt.stripPreviewFromRevision(revision);
            if (revision2.toIntArray(true).length < 3) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_IS_AMBIGUOUS, "Specified NDK version [" + version + "] does not have enough precision. Use major.minor.micro in version.", new Object[0]);
                return null;
            }
            return revision2;
        }
        catch (NumberFormatException e) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_VERSION_IS_INVALID, "Requested NDK version '" + version + "' could not be parsed", new Object[0]);
            return null;
        }
    }

    @VisibleForTesting
    @Nullable
    public static final SdkSourceProperties getNdkVersionInfo(@NotNull File ndkRoot) {
        Intrinsics.checkNotNullParameter((Object)ndkRoot, (String)"ndkRoot");
        if (!ndkRoot.exists()) {
            return null;
        }
        File sourceProperties = new File(ndkRoot, "source.properties");
        if (!sourceProperties.exists()) {
            File releaseTxt = FilesKt.resolve((File)ndkRoot, (String)"RELEASE.TXT");
            if (releaseTxt.exists()) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_VERSION_UNSUPPORTED, "NDK at " + ndkRoot + " is not supported (pre-r11)", new Object[0]);
                return null;
            }
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, "NDK at " + ndkRoot + " did not have a source.properties file", new Object[0]);
            return null;
        }
        return SdkSourceProperties.Companion.fromInstallFolder(ndkRoot);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<String> getNdkVersionedFolders(@NotNull File ndkVersionRoot) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ndkVersionRoot, (String)"ndkVersionRoot");
        if (!ndkVersionRoot.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = ndkVersionRoot.list();
        Intrinsics.checkNotNull((Object)stringArray);
        String[] $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        String[] stringArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!new File(ndkVersionRoot, (String)it).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Revision stripPreviewFromRevision(Revision revision) {
        Revision revision2;
        int[] parts = revision.toIntArray(false);
        switch (parts.length) {
            case 1: {
                revision2 = new Revision(parts[0]);
                break;
            }
            case 2: {
                revision2 = new Revision(parts[0], parts[1]);
                break;
            }
            default: {
                revision2 = new Revision(parts[0], parts[1], parts[2]);
            }
        }
        return revision2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public static final NdkLocatorRecord findNdkPathImpl(@Nullable String ndkVersionFromDsl, @Nullable String ndkPathFromDsl, @Nullable String ndkDirProperty, @Nullable File sdkFolder, @NotNull List<String> ndkVersionedFolderNames, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties, @Nullable SdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter(ndkVersionedFolderNames, (String)"ndkVersionedFolderNames");
        Intrinsics.checkNotNullParameter(getNdkSourceProperties, (String)"getNdkSourceProperties");
        NdkLocatorKey key = new NdkLocatorKey(ndkVersionFromDsl, ndkPathFromDsl, ndkDirProperty, sdkFolder, ndkVersionedFolderNames);
        boolean $i$f$cache = false;
        String baseName$iv = NdkLocatorRecord.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)baseName$iv, (String)"baseName");
        NdkLocatorRecord prior$iv = ThreadCachingEnvironment.Companion.readInCurrentEnvironment(key, baseName$iv, NdkLocatorRecord.class);
        NdkLocatorRecord ndkLocatorRecord = prior$iv;
        if (ndkLocatorRecord == null) {
            AutoCloseable autoCloseable = new PassThroughRecordingLoggingEnvironment();
            Throwable throwable = null;
            try {
                PassThroughRecordingLoggingEnvironment logger$iv = (PassThroughRecordingLoggingEnvironment)autoCloseable;
                boolean bl = false;
                try {
                    NdkLocatorRecord ndkLocatorRecord2;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable2 = new PassThroughRecordingLoggingEnvironment();
                    Throwable throwable2 = null;
                    try {
                        PassThroughRecordingLoggingEnvironment it = (PassThroughRecordingLoggingEnvironment)autoCloseable2;
                        boolean bl3 = false;
                        ndkLocatorRecord2 = NdkLocatorKt.findNdkPathImpl(key, getNdkSourceProperties, sdkHandler);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                    }
                    NdkLocatorRecord computed$iv = ndkLocatorRecord2;
                    ThreadCachingEnvironment.Companion.writeInCurrentEnvironment(key, CachingEnvironmentKt.snakeCase(baseName$iv), computed$iv, logger$iv.getRecord(), NdkLocatorRecord.class);
                    NdkLocatorRecord ndkLocatorRecord3 = computed$iv;
                    ndkLocatorRecord = ndkLocatorRecord3;
                }
                catch (Exception e$iv) {
                    try {
                        ThreadCachingEnvironment.Companion.writeFailureInCurrentEnvironment(key, CachingEnvironmentKt.snakeCase(baseName$iv), e$iv, logger$iv.getRecord(), NdkLocatorRecord.class);
                        throw e$iv;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return ndkLocatorRecord;
    }

    private static final Revision findNdkPathImpl$lambda$1$getNdkFolderRevision(Function1<? super File, SdkSourceProperties> $getNdkSourceProperties, File ndkDirFolder) {
        return NdkLocatorKt.getNdkFolderParsedRevision(ndkDirFolder, $getNdkSourceProperties);
    }
}

