/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.lint.CustomLintCheckUtils;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"getLocalCustomLintChecksForModel", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "getLocalCustomLintChecks", "Lorg/gradle/api/file/FileCollection;", "lintChecks", "Lorg/gradle/api/artifacts/Configuration;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "lenientMode", "", "gradle-core"})
@JvmName(name="CustomLintCheckUtils")
public final class CustomLintCheckUtils {
    @NotNull
    public static final ImmutableList<File> getLocalCustomLintChecksForModel(@NotNull Project project, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Configuration lintChecks = project.getConfigurations().getByName("lintChecks");
        Intrinsics.checkNotNull((Object)lintChecks);
        ArtifactCollection artifactCollection = CustomLintCheckUtils.getLocalCustomLintChecks(lintChecks, true);
        Collection failures = artifactCollection.getFailures();
        if (!failures.isEmpty()) {
            DependencyFailureHandler failureHandler = new DependencyFailureHandler();
            String string = project.getPath() + "/" + lintChecks.getName();
            Intrinsics.checkNotNull((Object)failures);
            failureHandler.addErrors(string, failures);
            failureHandler.registerIssues(issueReporter2);
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)artifactCollection.getArtifactFiles().getFiles());
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
        return immutableList;
    }

    @NotNull
    public static final FileCollection getLocalCustomLintChecks(@NotNull Configuration lintChecks) {
        Intrinsics.checkNotNullParameter((Object)lintChecks, (String)"lintChecks");
        FileCollection fileCollection2 = CustomLintCheckUtils.getLocalCustomLintChecks(lintChecks, false).getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getArtifactFiles(...)");
        return fileCollection2;
    }

    private static final ArtifactCollection getLocalCustomLintChecks(Configuration lintChecks, boolean lenientMode) {
        Function1 function1 = (Function1)new Function1<ArtifactView.ViewConfiguration, Unit>(lenientMode){
            final /* synthetic */ boolean $lenientMode;
            {
                this.$lenientMode = $lenientMode;
                super(1);
            }

            public final void invoke(ArtifactView.ViewConfiguration config2) {
                Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
                Function1 function1 = getLocalCustomLintChecks.1.INSTANCE;
                config2.attributes(new Action(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ void execute(Object p0) {
                        this.function.invoke(p0);
                    }
                });
                config2.lenient(this.$lenientMode);
            }
        };
        ArtifactCollection artifactCollection = lintChecks.getIncoming().artifactView(new /* invalid duplicate definition of identical inner class */).getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
        return artifactCollection;
    }
}

