/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0005\u001c\u001d\u001e\u001f B1\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u001a\u001a\u00020\u001bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0004\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00060\u0006 \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata;", "", "sourceFile", "Ljava/io/File;", "featureSplits", "", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$FeatureInfo;", "minSdkVersion", "", "maxNumberOfSplitsBeforeO", "<init>", "(Ljava/io/File;Ljava/util/Set;II)V", "getSourceFile", "()Ljava/io/File;", "Lcom/google/common/collect/ImmutableSet;", "kotlin.jvm.PlatformType", "Lcom/google/common/collect/ImmutableSet;", "getResOffsetFor", "modulePath", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getFeatureNameFor", "featureNameToNamespaceMap", "", "getFeatureNameToNamespaceMap", "()Ljava/util/Map;", "toBuilder", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$Builder;", "FeatureInfo", "Builder", "Companion", "FeatureSetMetadataTypeAdapter", "FeatureInfoTypeAdapter", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nFeatureSetMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureSetMetadata.kt\ncom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n295#2,2:233\n295#2,2:235\n1216#2,2:237\n1246#2,4:239\n*S KotlinDebug\n*F\n+ 1 FeatureSetMetadata.kt\ncom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata\n*L\n38#1:233,2\n42#1:235,2\n46#1:237,2\n46#1:239,4\n*E\n"})
public final class FeatureSetMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File sourceFile;
    private final int minSdkVersion;
    private final int maxNumberOfSplitsBeforeO;
    private final ImmutableSet<FeatureInfo> featureSplits;
    public static final int MAX_NUMBER_OF_SPLITS_BEFORE_O = 50;
    public static final int MAX_NUMBER_OF_SPLITS_STARTING_IN_O = 127;
    @NotNull
    public static final String OUTPUT_FILE_NAME = "feature-metadata.json";
    public static final int BASE_ID = 127;

    private FeatureSetMetadata(File sourceFile, Set<FeatureInfo> featureSplits, int minSdkVersion2, int maxNumberOfSplitsBeforeO) {
        this.sourceFile = sourceFile;
        this.minSdkVersion = minSdkVersion2;
        this.maxNumberOfSplitsBeforeO = maxNumberOfSplitsBeforeO;
        this.featureSplits = ImmutableSet.copyOf((Collection)featureSplits);
    }

    @Nullable
    public final File getSourceFile() {
        return this.sourceFile;
    }

    @Nullable
    public final Integer getResOffsetFor(@NotNull String modulePath) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
            ImmutableSet<FeatureInfo> immutableSet = this.featureSplits;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"featureSplits");
            Iterable $this$firstOrNull$iv = (Iterable)immutableSet;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FeatureInfo it = (FeatureInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModulePath(), (Object)modulePath)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        FeatureInfo featureInfo = v1;
        return featureInfo != null ? Integer.valueOf(featureInfo.getResOffset()) : null;
    }

    @Nullable
    public final String getFeatureNameFor(@NotNull String modulePath) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
            ImmutableSet<FeatureInfo> immutableSet = this.featureSplits;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"featureSplits");
            Iterable $this$firstOrNull$iv = (Iterable)immutableSet;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FeatureInfo it = (FeatureInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModulePath(), (Object)modulePath)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        FeatureInfo featureInfo = v1;
        return featureInfo != null ? featureInfo.getFeatureName() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getFeatureNameToNamespaceMap() {
        void $this$associateByTo$iv$iv;
        ImmutableSet<FeatureInfo> immutableSet = this.featureSplits;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"featureSplits");
        Iterable $this$associateBy$iv = (Iterable)immutableSet;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            FeatureInfo featureInfo = (FeatureInfo)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            FeatureInfo it = (FeatureInfo)element$iv$iv;
            String string = it.getFeatureName();
            boolean bl2 = false;
            String string2 = it.getNamespace();
            map.put(string, string2);
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
        return (Map)immutableMap;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this);
    }

    @JvmStatic
    @NotNull
    public static final FeatureSetMetadata load(@NotNull File input) throws IOException {
        return Companion.load(input);
    }

    public /* synthetic */ FeatureSetMetadata(File sourceFile, Set featureSplits, int minSdkVersion2, int maxNumberOfSplitsBeforeO, DefaultConstructorMarker $constructor_marker) {
        this(sourceFile, featureSplits, minSdkVersion2, maxNumberOfSplitsBeforeO);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\b\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$Builder;", "", "minSdkVersion", "", "maxNumberOfSplitsBeforeO", "featureSplits", "", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$FeatureInfo;", "<init>", "(IILjava/util/Set;)V", "(II)V", "featureSetMetadata", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata;", "(Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata;)V", "addFeatureSplit", "modulePath", "", "featureName", "packageName", "save", "", "outputFile", "Ljava/io/File;", "build", "gradle-core"})
    public static final class Builder {
        private final int minSdkVersion;
        private final int maxNumberOfSplitsBeforeO;
        @NotNull
        private final Set<FeatureInfo> featureSplits;

        private Builder(int minSdkVersion2, int maxNumberOfSplitsBeforeO, Set<FeatureInfo> featureSplits) {
            this.minSdkVersion = minSdkVersion2;
            this.maxNumberOfSplitsBeforeO = maxNumberOfSplitsBeforeO;
            this.featureSplits = featureSplits;
        }

        public Builder(int minSdkVersion2, int maxNumberOfSplitsBeforeO) {
            this(minSdkVersion2, maxNumberOfSplitsBeforeO, new LinkedHashSet());
        }

        public Builder(@NotNull FeatureSetMetadata featureSetMetadata) {
            Intrinsics.checkNotNullParameter((Object)featureSetMetadata, (String)"featureSetMetadata");
            int n = featureSetMetadata.minSdkVersion;
            int n2 = featureSetMetadata.maxNumberOfSplitsBeforeO;
            ImmutableSet immutableSet = featureSetMetadata.featureSplits;
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"access$getFeatureSplits$p(...)");
            this(n, n2, CollectionsKt.toMutableSet((Iterable)((Iterable)immutableSet)));
        }

        public final int addFeatureSplit(@NotNull String modulePath, @NotNull String featureName2, @NotNull String packageName) {
            int n;
            Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
            Intrinsics.checkNotNullParameter((Object)featureName2, (String)"featureName");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            if (this.minSdkVersion < 26) {
                if (this.featureSplits.size() >= this.maxNumberOfSplitsBeforeO) {
                    throw new RuntimeException("You have reached the maximum number of feature splits : " + this.maxNumberOfSplitsBeforeO);
                }
                n = 126 - this.featureSplits.size();
            } else {
                if (this.featureSplits.size() >= 127) {
                    throw new RuntimeException("You have reached the maximum number of feature splits : 127");
                }
                n = 128 + this.featureSplits.size();
            }
            int id = n;
            this.featureSplits.add(new FeatureInfo(modulePath, featureName2, id, packageName));
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void save(@NotNull File outputFile) throws IOException {
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            Object object = outputFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
            object = (Closeable)new JsonWriter((Writer)(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n)));
            object2 = null;
            try {
                JsonWriter writer = (JsonWriter)object;
                boolean bl = false;
                new FeatureSetMetadataTypeAdapter(outputFile).write(writer, this.build());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }

        private final FeatureSetMetadata build() {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.featureSplits);
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"copyOf(...)");
            return new FeatureSetMetadata(null, (Set)immutableSet, this.minSdkVersion, this.maxNumberOfSplitsBeforeO, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u0016\u0010\n\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$Companion;", "", "<init>", "()V", "MAX_NUMBER_OF_SPLITS_BEFORE_O", "", "MAX_NUMBER_OF_SPLITS_STARTING_IN_O", "OUTPUT_FILE_NAME", "", "getOUTPUT_FILE_NAME$annotations", "BASE_ID", "getBASE_ID$annotations", "load", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata;", "input", "Ljava/io/File;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getOUTPUT_FILE_NAME$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getBASE_ID$annotations() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final FeatureSetMetadata load(@NotNull File input) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            File inputFile = input.isDirectory() ? new File(input, FeatureSetMetadata.OUTPUT_FILE_NAME) : input;
            Object object = inputFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
            object = (Closeable)new JsonReader((Reader)(object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n)));
            object2 = null;
            try {
                JsonReader it = (JsonReader)object;
                boolean bl = false;
                try {
                    FeatureSetMetadata featureSetMetadata = new FeatureSetMetadataTypeAdapter(inputFile).read(it);
                    return featureSetMetadata;
                }
                catch (Exception e) {
                    try {
                        throw new IOException("Failed loading feature set metadata from " + inputFile, e);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                }
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$FeatureInfo;", "", "modulePath", "", "featureName", "resOffset", "", "namespace", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "getModulePath", "()Ljava/lang/String;", "getFeatureName", "getResOffset", "()I", "getNamespace", "gradle-core"})
    private static final class FeatureInfo {
        @NotNull
        private final String modulePath;
        @NotNull
        private final String featureName;
        private final int resOffset;
        @NotNull
        private final String namespace;

        public FeatureInfo(@NotNull String modulePath, @NotNull String featureName2, int resOffset2, @NotNull String namespace2) {
            Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
            Intrinsics.checkNotNullParameter((Object)featureName2, (String)"featureName");
            Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
            this.modulePath = modulePath;
            this.featureName = featureName2;
            this.resOffset = resOffset2;
            this.namespace = namespace2;
        }

        @NotNull
        public final String getModulePath() {
            return this.modulePath;
        }

        @NotNull
        public final String getFeatureName() {
            return this.featureName;
        }

        public final int getResOffset() {
            return this.resOffset;
        }

        @NotNull
        public final String getNamespace() {
            return this.namespace;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$FeatureInfoTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$FeatureInfo;", "<init>", "()V", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "featureInfo", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "gradle-core"})
    private static final class FeatureInfoTypeAdapter
    extends TypeAdapter<FeatureInfo> {
        @NotNull
        public static final FeatureInfoTypeAdapter INSTANCE = new FeatureInfoTypeAdapter();

        private FeatureInfoTypeAdapter() {
        }

        public void write(@NotNull JsonWriter writer, @NotNull FeatureInfo featureInfo) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)featureInfo, (String)"featureInfo");
            JsonWriter $this$write_u24lambda_u240 = writer;
            boolean bl = false;
            $this$write_u24lambda_u240.beginObject();
            $this$write_u24lambda_u240.name("modulePath").value(featureInfo.getModulePath());
            $this$write_u24lambda_u240.name("featureName").value(featureInfo.getFeatureName());
            $this$write_u24lambda_u240.name("resOffset").value((Number)featureInfo.getResOffset());
            $this$write_u24lambda_u240.name("namespace").value(featureInfo.getNamespace());
            $this$write_u24lambda_u240.endObject();
        }

        @NotNull
        public FeatureInfo read(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            JsonReader $this$read_u24lambda_u241 = reader;
            boolean bl = false;
            $this$read_u24lambda_u241.beginObject();
            String modulePath = null;
            String featureName2 = null;
            Integer resOffset2 = null;
            String namespace2 = null;
            block12: while ($this$read_u24lambda_u241.hasNext()) {
                block17: {
                    String string = $this$read_u24lambda_u241.nextName();
                    if (string == null) break block17;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -870291279: {
                            if (string.equals("modulePath")) {
                                n = 1;
                            }
                            break;
                        }
                        case -377160031: {
                            if (string.equals("featureName")) {
                                n = 2;
                            }
                            break;
                        }
                        case 1252218203: {
                            if (string.equals("namespace")) {
                                n = 3;
                            }
                            break;
                        }
                        case 1381568851: {
                            if (string.equals("resOffset")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            modulePath = $this$read_u24lambda_u241.nextString();
                            continue block12;
                        }
                        case 2: {
                            featureName2 = $this$read_u24lambda_u241.nextString();
                            continue block12;
                        }
                        case 4: {
                            resOffset2 = $this$read_u24lambda_u241.nextInt();
                            continue block12;
                        }
                        case 3: {
                            namespace2 = $this$read_u24lambda_u241.nextString();
                            continue block12;
                        }
                    }
                }
                $this$read_u24lambda_u241.skipValue();
            }
            String string = modulePath;
            Intrinsics.checkNotNull(string);
            String string2 = featureName2;
            Intrinsics.checkNotNull(string2);
            Integer n = resOffset2;
            Intrinsics.checkNotNull(n);
            int n2 = n;
            String string3 = namespace2;
            Intrinsics.checkNotNull((Object)string3);
            FeatureInfo featureInfo = new FeatureInfo(string, string2, n2, string3);
            $this$read_u24lambda_u241.endObject();
            return featureInfo;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata$FeatureSetMetadataTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadata;", "sourceFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "metadata", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "gradle-core"})
    private static final class FeatureSetMetadataTypeAdapter
    extends TypeAdapter<FeatureSetMetadata> {
        @Nullable
        private final File sourceFile;

        public FeatureSetMetadataTypeAdapter(@Nullable File sourceFile) {
            this.sourceFile = sourceFile;
        }

        public void write(@NotNull JsonWriter writer, @NotNull FeatureSetMetadata metadata) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            JsonWriter $this$write_u24lambda_u240 = writer;
            boolean bl = false;
            $this$write_u24lambda_u240.beginObject();
            $this$write_u24lambda_u240.name("minSdkVersion").value((Number)metadata.minSdkVersion);
            $this$write_u24lambda_u240.name("maxNumberOfSplitsBeforeO").value((Number)metadata.maxNumberOfSplitsBeforeO);
            $this$write_u24lambda_u240.name("featureSplits").beginArray();
            UnmodifiableIterator unmodifiableIterator = metadata.featureSplits.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
            UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
            while (unmodifiableIterator2.hasNext()) {
                FeatureInfo split = (FeatureInfo)unmodifiableIterator2.next();
                Intrinsics.checkNotNull((Object)split);
                FeatureInfoTypeAdapter.INSTANCE.write(writer, split);
            }
            writer.endArray();
            $this$write_u24lambda_u240.endObject();
        }

        @NotNull
        public FeatureSetMetadata read(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            ImmutableSet.Builder splits = ImmutableSet.builder();
            Integer minSdkVersion2 = null;
            Integer maxNumberOfSplitsBeforeO = null;
            JsonReader $this$read_u24lambda_u241 = reader;
            boolean bl = false;
            $this$read_u24lambda_u241.beginObject();
            block10: while ($this$read_u24lambda_u241.hasNext()) {
                block15: {
                    String string = $this$read_u24lambda_u241.nextName();
                    if (string == null) break block15;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1312692432: {
                            if (string.equals("minSdkVersion")) {
                                n = 1;
                            }
                            break;
                        }
                        case -1516560593: {
                            if (string.equals("featureSplits")) {
                                n = 2;
                            }
                            break;
                        }
                        case -542778445: {
                            if (string.equals("maxNumberOfSplitsBeforeO")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            minSdkVersion2 = $this$read_u24lambda_u241.nextInt();
                            continue block10;
                        }
                        case 3: {
                            maxNumberOfSplitsBeforeO = $this$read_u24lambda_u241.nextInt();
                            continue block10;
                        }
                        case 2: {
                            $this$read_u24lambda_u241.beginArray();
                            while ($this$read_u24lambda_u241.hasNext()) {
                                splits.add((Object)FeatureInfoTypeAdapter.INSTANCE.read(reader));
                            }
                            $this$read_u24lambda_u241.endArray();
                            continue block10;
                        }
                    }
                }
                $this$read_u24lambda_u241.skipValue();
            }
            $this$read_u24lambda_u241.endObject();
            ImmutableSet immutableSet = splits.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"build(...)");
            Set set = (Set)immutableSet;
            Integer n = minSdkVersion2;
            Intrinsics.checkNotNull((Object)n);
            int n2 = ((Number)n).intValue();
            Integer n3 = maxNumberOfSplitsBeforeO;
            Intrinsics.checkNotNull((Object)n3);
            return new FeatureSetMetadata(this.sourceFile, set, n2, ((Number)n3).intValue(), null);
        }
    }
}

