/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.dsl.ProductFlavor;
import com.android.build.gradle.internal.core.dsl.MultiVariantComponentDslInfo;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ6\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u001a\u0010\u0014\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011H\u0004J>\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u001a\u0010\u0014\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/dependency/VariantAwareDependenciesBuilder;", "", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "dslInfo", "Lcom/android/build/gradle/internal/core/dsl/MultiVariantComponentDslInfo;", "<init>", "(Lorg/gradle/api/Project;Lcom/android/builder/errors/IssueReporter;Lcom/android/build/gradle/internal/core/dsl/MultiVariantComponentDslInfo;)V", "getProject", "()Lorg/gradle/api/Project;", "getIssueReporter", "()Lcom/android/builder/errors/IssueReporter;", "getDslInfo", "()Lcom/android/build/gradle/internal/core/dsl/MultiVariantComponentDslInfo;", "getConsumptionFlavorAttributes", "", "Lorg/gradle/api/attributes/Attribute;", "Lcom/android/build/api/attributes/ProductFlavorAttr;", "flavorSelection", "getFlavorAttributes", "addCompatibilityUnprefixedFlavorDimensionAttributes", "", "gradle-core"})
public class VariantAwareDependenciesBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final IssueReporter issueReporter;
    @NotNull
    private final MultiVariantComponentDslInfo dslInfo;

    public VariantAwareDependenciesBuilder(@NotNull Project project, @NotNull IssueReporter issueReporter2, @NotNull MultiVariantComponentDslInfo dslInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)dslInfo, (String)"dslInfo");
        this.project = project;
        this.issueReporter = issueReporter2;
        this.dslInfo = dslInfo;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IssueReporter getIssueReporter() {
        return this.issueReporter;
    }

    @NotNull
    public final MultiVariantComponentDslInfo getDslInfo() {
        return this.dslInfo;
    }

    @NotNull
    protected final Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getConsumptionFlavorAttributes(@Nullable Map<Attribute<ProductFlavorAttr>, ? extends ProductFlavorAttr> flavorSelection) {
        return this.getFlavorAttributes(flavorSelection, false);
    }

    private final Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorAttributes(Map<Attribute<ProductFlavorAttr>, ? extends ProductFlavorAttr> flavorSelection, boolean addCompatibilityUnprefixedFlavorDimensionAttributes) {
        List<ProductFlavor> productFlavors = this.dslInfo.getProductFlavorList();
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)productFlavors.size());
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(...)");
        Map map = hashMap;
        if (this.issueReporter.hasIssue(IssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
            return map;
        }
        ObjectFactory objectFactory = this.project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory objectFactory2 = objectFactory;
        for (ProductFlavor f : productFlavors) {
            String dimension;
            if (f.getDimension() == null) continue;
            boolean bl = false;
            map.put(ProductFlavorAttr.Companion.of(dimension), objectFactory2.named(ProductFlavorAttr.class, f.getName()));
            if (!addCompatibilityUnprefixedFlavorDimensionAttributes) continue;
            map.put(Attribute.of((String)dimension, ProductFlavorAttr.class), objectFactory2.named(ProductFlavorAttr.class, f.getName()));
        }
        if (flavorSelection != null) {
            map.putAll(flavorSelection);
        }
        return map;
    }
}

