/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.options.SyncOptions;
import com.android.ide.common.workers.WorkerExecutorException;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001e0\"J\u0012\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0$H\u0002J\u0006\u0010%\u001a\u00020\u001eJ\b\u0010&\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/services/AsyncResourceProcessor;", "ServiceT", "Ljava/io/Closeable;", "owner", "", "executor", "Ljava/util/concurrent/ExecutorService;", "service", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Ljava/lang/Object;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;)V", "Ljava/lang/Object;", "getErrorFormatMode", "()Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "iLogger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getILogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "counter", "", "futures", "", "Ljava/util/concurrent/Future;", "submit", "", "analyticsService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "action", "Lkotlin/Function1;", "drainFutures", "", "await", "close", "gradle-core"})
@ThreadSafe
public final class AsyncResourceProcessor<ServiceT>
implements Closeable {
    @NotNull
    private final String owner;
    @NotNull
    private final ExecutorService executor;
    private final ServiceT service;
    @NotNull
    private final SyncOptions.ErrorFormatMode errorFormatMode;
    private final Logger logger;
    @NotNull
    private final LoggerWrapper iLogger;
    private int counter;
    @NotNull
    private final List<Future<?>> futures;

    public AsyncResourceProcessor(@NotNull String owner, @NotNull ExecutorService executor2, ServiceT service, @NotNull SyncOptions.ErrorFormatMode errorFormatMode) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        this.owner = owner;
        this.executor = executor2;
        this.service = service;
        this.errorFormatMode = errorFormatMode;
        this.logger = Logging.getLogger(this.getClass());
        this.iLogger = new LoggerWrapper(this.logger);
        this.futures = new ArrayList();
    }

    @NotNull
    public final SyncOptions.ErrorFormatMode getErrorFormatMode() {
        return this.errorFormatMode;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final LoggerWrapper getILogger() {
        return this.iLogger;
    }

    public final synchronized void submit(@NotNull AnalyticsService analyticsService, @NotNull Function1<? super ServiceT, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String workerKey = this.owner + (this.counter + 1);
        TaskProfilingRecord taskProfilingRecord = analyticsService.getTaskRecord(this.owner);
        if (taskProfilingRecord != null) {
            taskProfilingRecord.addWorker(workerKey, GradleBuildProfileSpan.ExecutionType.THREAD_EXECUTION);
        }
        Future<?> future = this.executor.submit(new Runnable(analyticsService, this, workerKey, action){
            final /* synthetic */ AnalyticsService $analyticsService;
            final /* synthetic */ AsyncResourceProcessor<ServiceT> this$0;
            final /* synthetic */ String $workerKey;
            final /* synthetic */ Function1<ServiceT, Unit> $action;
            {
                this.$analyticsService = $analyticsService;
                this.this$0 = $receiver;
                this.$workerKey = $workerKey;
                this.$action = $action;
            }

            public final void run() {
                this.$analyticsService.workerStarted(AsyncResourceProcessor.access$getOwner$p(this.this$0), this.$workerKey);
                this.$action.invoke(AsyncResourceProcessor.access$getService$p(this.this$0));
                this.$analyticsService.workerFinished(AsyncResourceProcessor.access$getOwner$p(this.this$0), this.$workerKey);
            }
        });
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        this.futures.add(future);
    }

    private final synchronized List<Future<?>> drainFutures() {
        List currentTasks = new ArrayList();
        currentTasks.addAll((Collection)this.futures);
        this.futures.clear();
        return currentTasks;
    }

    public final void await() {
        List<Future<?>> currentTasks = this.drainFutures();
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
        for (Future<?> task : currentTasks) {
            try {
                task.get();
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
        }
        if (!((Collection)exceptions).isEmpty()) {
            throw new WorkerExecutorException((Iterable)exceptions);
        }
    }

    @Override
    public void close() {
        this.await();
    }

    public static final /* synthetic */ String access$getOwner$p(AsyncResourceProcessor $this) {
        return $this.owner;
    }

    public static final /* synthetic */ Object access$getService$p(AsyncResourceProcessor $this) {
        return $this.service;
    }
}

