/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.CompressAssetsWorkAction;
import com.android.build.gradle.internal.tasks.CompressAssetsWorkParameters;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.file.FileType;
import org.gradle.work.FileChange;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/CompressAssetsDelegate;", "", "workQueue", "Lorg/gradle/workers/WorkQueue;", "outputDir", "Ljava/io/File;", "noCompressPredicate", "Ljava/util/function/Predicate;", "", "compressionLevel", "", "changes", "", "Lorg/gradle/work/FileChange;", "<init>", "(Lorg/gradle/workers/WorkQueue;Ljava/io/File;Ljava/util/function/Predicate;ILjava/lang/Iterable;)V", "getOutputDir", "()Ljava/io/File;", "getChanges", "()Ljava/lang/Iterable;", "run", "", "gradle-core"})
public final class CompressAssetsDelegate {
    @NotNull
    private final WorkQueue workQueue;
    @NotNull
    private final File outputDir;
    @NotNull
    private final Predicate<String> noCompressPredicate;
    private final int compressionLevel;
    @NotNull
    private final Iterable<FileChange> changes;

    public CompressAssetsDelegate(@NotNull WorkQueue workQueue2, @NotNull File outputDir, @NotNull Predicate<String> noCompressPredicate, int compressionLevel, @NotNull Iterable<? extends FileChange> changes) {
        Intrinsics.checkNotNullParameter((Object)workQueue2, (String)"workQueue");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(noCompressPredicate, (String)"noCompressPredicate");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.workQueue = workQueue2;
        this.outputDir = outputDir;
        this.noCompressPredicate = noCompressPredicate;
        this.compressionLevel = compressionLevel;
        this.changes = changes;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    @NotNull
    public final Iterable<FileChange> getChanges() {
        return this.changes;
    }

    public final void run() {
        for (FileChange change : this.changes) {
            if (change.getFileType() == FileType.DIRECTORY) continue;
            String entryPath = "assets/" + change.getNormalizedPath();
            File targetFile = new File(this.outputDir, entryPath + ".jar");
            int entryCompressionLevel = this.noCompressPredicate.test(entryPath) ? 0 : this.compressionLevel;
            this.workQueue.submit(CompressAssetsWorkAction.class, new Action(change, targetFile, entryPath, entryCompressionLevel){
                final /* synthetic */ FileChange $change;
                final /* synthetic */ File $targetFile;
                final /* synthetic */ String $entryPath;
                final /* synthetic */ int $entryCompressionLevel;
                {
                    this.$change = $change;
                    this.$targetFile = $targetFile;
                    this.$entryPath = $entryPath;
                    this.$entryCompressionLevel = $entryCompressionLevel;
                }

                public final void execute(CompressAssetsWorkParameters it) {
                    it.getInput().set(this.$change.getFile());
                    it.getOutput().set(this.$targetFile);
                    it.getEntryPath().set((Object)this.$entryPath);
                    it.getEntryCompressionLevel().set((Object)this.$entryCompressionLevel);
                    it.getChangeType().set((Object)this.$change.getChangeType());
                }
            });
        }
    }
}

