/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalGlobalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.testing.utp.ManagedDeviceImageSuggestionGenerator;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.repository.Revision;
import com.android.testing.utils.SystemImageHashUtilsKt;
import com.android.utils.ComputerArchUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b'\u0018\u0000 32\u00020\u0001:\u00040123B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020+H\u0002J\b\u0010.\u001a\u00020+H\u0002J\b\u0010/\u001a\u00020+H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\bR\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\b\u00a8\u00064"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalGlobalTask;", "<init>", "()V", "sdkService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "()Lorg/gradle/api/provider/Property;", "avdService", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdService", "compileSdkVersion", "", "getCompileSdkVersion", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "abi", "getAbi", "testedAbi", "getTestedAbi", "sdkVersion", "", "getSdkVersion", "sdkMinorVersion", "getSdkMinorVersion", "systemImageVendor", "getSystemImageVendor", "sdkExtensionVersion", "getSdkExtensionVersion", "pageAlignmentSuffix", "getPageAlignmentSuffix", "hardwareProfile", "getHardwareProfile", "emulatorGpuFlag", "getEmulatorGpuFlag", "managedDeviceName", "getManagedDeviceName", "require64Bit", "", "getRequire64Bit", "doTaskAction", "", "assertNoTvOrAuto", "assertSourceDoesNotIncludePageAlignment", "assertNoMinorVersionOnOldApi", "assertTestedAbiCompatible", "ManagedDeviceSetupRunnable", "ManagedDeviceSetupParams", "CreationAction", "Companion", "gradle-core"})
public abstract class ManagedDeviceInstrumentationTestSetupTask
extends NonIncrementalGlobalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ABI_X86 = "x86";
    @NotNull
    public static final String ABI_X86_64 = "x86_64";
    @NotNull
    public static final String ABI_ARM = "arm64-v8a";

    @Internal
    @NotNull
    public abstract Property<SdkComponentsBuildService> getSdkService();

    @Internal
    @NotNull
    public abstract Property<AvdComponentsBuildService> getAvdService();

    @Input
    @NotNull
    public abstract Property<String> getCompileSdkVersion();

    @Input
    @NotNull
    public abstract Property<Revision> getBuildToolsRevision();

    @Input
    @NotNull
    public abstract Property<String> getAbi();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getTestedAbi();

    @Input
    @NotNull
    public abstract Property<Integer> getSdkVersion();

    @Input
    @NotNull
    public abstract Property<Integer> getSdkMinorVersion();

    @Input
    @NotNull
    public abstract Property<String> getSystemImageVendor();

    @Input
    @Optional
    @NotNull
    public abstract Property<Integer> getSdkExtensionVersion();

    @Input
    @NotNull
    public abstract Property<String> getPageAlignmentSuffix();

    @Input
    @NotNull
    public abstract Property<String> getHardwareProfile();

    @Input
    @NotNull
    public abstract Property<String> getEmulatorGpuFlag();

    @Internal
    @NotNull
    public abstract Property<String> getManagedDeviceName();

    @Internal
    @NotNull
    public abstract Property<Boolean> getRequire64Bit();

    @Override
    protected void doTaskAction() {
        this.assertSourceDoesNotIncludePageAlignment();
        this.assertNoMinorVersionOnOldApi();
        this.assertNoTvOrAuto();
        this.assertTestedAbiCompatible();
        this.getWorkerExecutor().noIsolation().submit(ManagedDeviceSetupRunnable.class, new Action(this){
            final /* synthetic */ ManagedDeviceInstrumentationTestSetupTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ManagedDeviceSetupParams it) {
                Provider provider2 = (Provider)this.this$0.getProjectPath();
                String string = this.this$0.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                it.initializeWith((Provider<String>)provider2, string, (Provider<AnalyticsService>)((Provider)this.this$0.getAnalyticsService()));
                it.getSdkService().set((Provider)this.this$0.getSdkService());
                it.getCompileSdkVersion().set((Provider)this.this$0.getCompileSdkVersion());
                it.getBuildToolsRevision().set((Provider)this.this$0.getBuildToolsRevision());
                it.getAvdService().set((Provider)this.this$0.getAvdService());
                Property<String> property = it.getDeviceName();
                Object object = this.this$0.getSdkVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                int n = ((Number)object).intValue();
                Object object2 = this.this$0.getSdkMinorVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                int n2 = ((Number)object2).intValue();
                Integer n3 = (Integer)this.this$0.getSdkExtensionVersion().getOrNull();
                Object object3 = this.this$0.getSystemImageVendor().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                String string2 = (String)object3;
                Object object4 = this.this$0.getPageAlignmentSuffix().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                String string3 = (String)object4;
                Object object5 = this.this$0.getAbi().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                String string4 = (String)object5;
                Object object6 = this.this$0.getHardwareProfile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
                property.set((Object)ManagedDeviceUtilsKt.computeAvdName(n, n2, n3, string2, string3, string4, (String)object6));
                it.getHardwareProfile().set((Provider)this.this$0.getHardwareProfile());
                it.getEmulatorGpuFlag().set((Provider)this.this$0.getEmulatorGpuFlag());
                it.getManagedDeviceName().set((Provider)this.this$0.getManagedDeviceName());
                it.getSystemImageVendor().set((Provider)this.this$0.getSystemImageVendor());
                it.getPageAlignmentSuffix().set((Provider)this.this$0.getPageAlignmentSuffix());
                it.getSdkVersion().set((Provider)this.this$0.getSdkVersion());
                it.getSdkMinorVersion().set((Provider)this.this$0.getSdkMinorVersion());
                it.getSdkExtensionVersion().set((Provider)this.this$0.getSdkExtensionVersion());
                it.getRequire64Bit().set((Provider)this.this$0.getRequire64Bit());
                it.getAbi().set((Provider)this.this$0.getAbi());
            }
        });
    }

    private final void assertNoTvOrAuto() {
        Object object = this.getSystemImageVendor().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (SystemImageHashUtilsKt.isTvOrAutoSource((String)((String)object))) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a systemImageSource of " + this.getSystemImageVendor().get() + ".\n                    TV and Auto devices are presently not supported with Gradle Managed Devices.\n                ")).toString());
        }
        Object object2 = this.getHardwareProfile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        if (SystemImageHashUtilsKt.isTvOrAutoDevice((String)((String)object2))) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a device profile of " + this.getHardwareProfile().get() + ".\n                    TV and Auto devices are presently not supported with Gradle Managed Devices.\n                ")).toString());
        }
    }

    private final void assertSourceDoesNotIncludePageAlignment() {
        Object object = this.getSystemImageVendor().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String sourcePageAlignment = SystemImageHashUtilsKt.getPageAlignmentSuffix((String)((String)object));
        if (sourcePageAlignment != null) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a systemImageSource = " + this.getSystemImageVendor().get() + ",\n                    The system image source should not include page alignment information\n                    (" + sourcePageAlignment + "). Use the ManagedVirtualDevice.pageAlignment instead.\n                ")).toString());
        }
    }

    private final void assertNoMinorVersionOnOldApi() {
        if (((Number)this.getSdkVersion().get()).intValue() <= 35) {
            Integer n = (Integer)this.getSdkMinorVersion().get();
            if (n == null || n != 0) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a minor version specified for\n                    sdkVersion = " + this.getSdkVersion().get() + ". The minimum api version that supports minor\n                    versions is 36.\n                ")).toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void assertTestedAbiCompatible() {
        block27: {
            block32: {
                block33: {
                    block28: {
                        block29: {
                            block30: {
                                block31: {
                                    v0 = this.getSystemImageVendor().get();
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                                    v1 = (String)v0;
                                    v2 = this.getSdkVersion().get();
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                                    translationEnabled = SystemImageHashUtilsKt.canSourcePerformNdkTranslation((String)v1, (int)((Number)v2).intValue());
                                    var2_2 = (String)this.getAbi().get();
                                    if (var2_2 == null) break block27;
                                    switch (var2_2.hashCode()) {
                                        case -806050265: {
                                            if (!var2_2.equals("x86_64")) {
                                                ** break;
                                            }
                                            break block28;
                                        }
                                        case 117110: {
                                            if (var2_2.equals("x86")) break;
                                            ** break;
                                        }
                                        case 1431565292: {
                                            if (!var2_2.equals("arm64-v8a")) ** break;
                                            var3_3 = (String)this.getTestedAbi().getOrNull();
                                            if (var3_3 == null) ** GOTO lbl30
                                            switch (var3_3.hashCode()) {
                                                case -806050265: {
                                                    if (var3_3.equals("x86_64")) break;
                                                    ** break;
                                                }
                                                case 117110: {
                                                    if (var3_3.equals("x86")) break;
                                                    ** break;
                                                }
                                                case 1431565292: {
                                                    if (!var3_3.equals("arm64-v8a")) ** break;
lbl30:
                                                    // 2 sources

                                                    return;
                                                }
                                            }
                                            v3 = this.getManagedDeviceName().get();
                                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
                                            v4 = (String)v3;
                                            v5 = (String)this.getTestedAbi().getOrNull();
                                            v6 = this.getAbi().get();
                                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"get(...)");
                                            var4_6 = com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateTestedAbiNotCompatibleError(ManagedDeviceInstrumentationTestSetupTask.Companion, v4, v5, (String)v6);
                                            throw new IllegalStateException(var4_6.toString());
lbl39:
                                            // 4 sources

                                            v7 = this.getManagedDeviceName().get();
                                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"get(...)");
                                            var4_7 = com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateUnrecognizedTestedAbiError(ManagedDeviceInstrumentationTestSetupTask.Companion, (String)v7, (String)this.getTestedAbi().getOrNull());
                                            throw new IllegalStateException(var4_7.toString());
                                        }
                                    }
                                    v8 = var3_4 = (String)this.getTestedAbi().getOrNull();
                                    if (v8 == null) break block29;
                                    switch (v8.hashCode()) {
                                        case -806050265: {
                                            if (!var3_4.equals("x86_64")) {
                                                ** break;
                                            }
                                            break block30;
                                        }
                                        case 117110: {
                                            if (var3_4.equals("x86")) break;
                                            ** break;
                                        }
                                        case 1431565292: {
                                            if (!var3_4.equals("arm64-v8a")) {
                                                ** break;
                                            }
                                            break block31;
                                        }
                                    }
                                    return;
                                }
                                v9 = this.getManagedDeviceName().get();
                                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"get(...)");
                                v10 = (String)v9;
                                v11 = this.getAbi().get();
                                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"get(...)");
                                var4_8 = com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateArmTranslationOnX86Error(ManagedDeviceInstrumentationTestSetupTask.Companion, v10, (String)v11);
                                throw new IllegalStateException(var4_8.toString());
                            }
                            v12 = this.getManagedDeviceName().get();
                            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"get(...)");
                            v13 = (String)v12;
                            v14 = (String)this.getTestedAbi().getOrNull();
                            v15 = this.getAbi().get();
                            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"get(...)");
                            var4_9 = com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateTestedAbiNotCompatibleError(ManagedDeviceInstrumentationTestSetupTask.Companion, v13, v14, (String)v15);
                            throw new IllegalStateException(var4_9.toString());
                        }
                        v16 = this.getLogger();
                        v17 = this.getManagedDeviceName().get();
                        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"get(...)");
                        v18 = (String)v17;
                        v19 = this.getAbi().get();
                        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"get(...)");
                        v16.warn(com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateUnspecifiedAbiWarningWithNdkTranslationUnsupported(ManagedDeviceInstrumentationTestSetupTask.Companion, v18, (String)v19));
                        return;
lbl84:
                        // 4 sources

                        v20 = this.getManagedDeviceName().get();
                        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"get(...)");
                        var4_10 = com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateUnrecognizedTestedAbiError(ManagedDeviceInstrumentationTestSetupTask.Companion, (String)v20, (String)this.getTestedAbi().getOrNull());
                        throw new IllegalStateException(var4_10.toString());
                    }
                    v21 = var3_5 = (String)this.getTestedAbi().getOrNull();
                    if (v21 == null) break block32;
                    switch (v21.hashCode()) {
                        case -806050265: {
                            if (var3_5.equals("x86_64")) break;
                            ** break;
                        }
                        case 117110: {
                            if (var3_5.equals("x86")) break;
                            ** break;
                        }
                        case 1431565292: {
                            if (!var3_5.equals("arm64-v8a")) {
                                ** break;
                            }
                            break block33;
                        }
                    }
                    return;
                }
                if (!translationEnabled) {
                    v22 = this.getManagedDeviceName().get();
                    Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"get(...)");
                    v23 = (String)v22;
                    v24 = this.getSystemImageVendor().get();
                    Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"get(...)");
                    v25 = (String)v24;
                    v26 = this.getSdkVersion().get();
                    Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"get(...)");
                    v27 = ((Number)v26).intValue();
                    v28 = (String)this.getTestedAbi().getOrNull();
                    v29 = this.getAbi().get();
                    Intrinsics.checkNotNullExpressionValue((Object)v29, (String)"get(...)");
                    var4_11 = com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateNDKTranslationUnsupportedError(ManagedDeviceInstrumentationTestSetupTask.Companion, v23, v25, v27, v28, (String)v29);
                    throw new IllegalStateException(var4_11.toString());
                }
                return;
            }
            if (!translationEnabled) {
                v30 = this.getLogger();
                v31 = this.getManagedDeviceName().get();
                Intrinsics.checkNotNullExpressionValue((Object)v31, (String)"get(...)");
                v32 = (String)v31;
                v33 = this.getAbi().get();
                Intrinsics.checkNotNullExpressionValue((Object)v33, (String)"get(...)");
                v30.warn(com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateUnspecifiedAbiWarningWithNdkTranslationUnsupported(ManagedDeviceInstrumentationTestSetupTask.Companion, v32, (String)v33));
            } else {
                v34 = this.getLogger();
                v35 = this.getManagedDeviceName().get();
                Intrinsics.checkNotNullExpressionValue((Object)v35, (String)"get(...)");
                v36 = (String)v35;
                v37 = this.getAbi().get();
                Intrinsics.checkNotNullExpressionValue((Object)v37, (String)"get(...)");
                v34.warn(com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateUnspecifiedAbiWarningWithNdkTranslation(ManagedDeviceInstrumentationTestSetupTask.Companion, v36, (String)v37));
            }
            return;
lbl138:
            // 4 sources

            v38 = this.getManagedDeviceName().get();
            Intrinsics.checkNotNullExpressionValue((Object)v38, (String)"get(...)");
            var4_12 = com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask$Companion.access$generateUnrecognizedTestedAbiError(ManagedDeviceInstrumentationTestSetupTask.Companion, (String)v38, (String)this.getTestedAbi().getOrNull());
            throw new IllegalStateException(var4_12.toString());
lbl142:
            // 4 sources

        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J2\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001a\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002JO\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$Companion;", "", "<init>", "()V", "ABI_X86", "", "ABI_X86_64", "ABI_ARM", "generateTestedAbiNotCompatibleError", "deviceName", "testedAbi", "abi", "generateArmTranslationOnX86Error", "generateNDKTranslationUnsupportedError", "systemImageSource", "sdkVersion", "", "generateUnrecognizedTestedAbiError", "generateUnspecifiedAbiWarningWithNdkTranslationUnsupported", "generateUnspecifiedAbiWarningWithNdkTranslation", "generateSystemImageErrorMessage", "sdkMinorVersion", "extensionVersion", "pageAlignmentSuffix", "require64Bit", "", "versionedSdkLoader", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "(Ljava/lang/String;IILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;ZLcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;)Ljava/lang/String;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String generateTestedAbiNotCompatibleError(String deviceName, String testedAbi, String abi) {
            return StringsKt.trimIndent((String)("\n                " + deviceName + " cannot be run in the given environment. Tests cannot be\n                run with testedAbi = \"" + testedAbi + "\". This may be intentional as " + deviceName + "\n                may be configured for testing on a different machine.\n                If this is not intended, set testedAbi = \"" + abi + "\".\n            "));
        }

        private final String generateArmTranslationOnX86Error(String deviceName, String abi) {
            return StringsKt.trimIndent((String)("\n                ARM translation is not available for x86 system images.\n                An x86 image was selected as the image was available for the\n                given sdkVersion and require64Bit = false for " + deviceName + ".\n                This configuration may be intentional as " + deviceName + " may be configured for\n                testing on a different machine.\n                If ARM translation is not intended for this device, set testedAbi = \"" + abi + "\"\n            "));
        }

        private final String generateNDKTranslationUnsupportedError(String deviceName, String systemImageSource, int sdkVersion, String testedAbi, String abi) {
            return StringsKt.trimIndent((String)("\n                ARM translation is only available for google apis or playstore images\n                with an api level of 30 or higher.\n                " + deviceName + " has a systemImageSource = \"" + systemImageSource + "\"\n                and sdkVersion = " + sdkVersion + "\n                This may be intentional as " + deviceName + " may be configured for\n                testing on an ARM system and not an " + abi + " system.\n                If ARM is not the intended abi for this device, set testedAbi = \"" + abi + "\"\n                If Ndk Translation is intended for this device, set\n                systemImageSource = \"google\" and set the sdkVersion to 30 or higher.\n            "));
        }

        private final String generateUnrecognizedTestedAbiError(String deviceName, String testedAbi) {
            return StringsKt.trimIndent((String)("\n                Could not determine testedAbi \"" + testedAbi + "\" for " + deviceName + ". Either unset\n                testedAbi or set testedAbi to one of {\"x86\", \"x86_64\", \"arm64-v8a\"}\n            "));
        }

        private final String generateUnspecifiedAbiWarningWithNdkTranslationUnsupported(String deviceName, String abi) {
            return StringsKt.trimIndent((String)("\n                " + deviceName + " has an unspecified testedAbi. This presently defaults to\n                \"" + abi + "\". However, in 9.0 this will change to \"arm64-v8a\"\n\n                " + deviceName + " specifies a system image that that does not support NDK translation,\n                and will no longer be able to run tests in this environment. This\n                device will wtill be able to run on ARM machines.\n                To continue running tests with the current configuration, and not use\n                NDK translation set testedAbi = \"" + abi + "\"\n            "));
        }

        private final String generateUnspecifiedAbiWarningWithNdkTranslation(String deviceName, String abi) {
            return StringsKt.trimIndent((String)("\n            " + deviceName + " has an unspecified testedAbi. This presently defaults to\n            \"" + abi + "\". However, in 9.0 this will change to \"arm64-v8a\"\n\n            This device will use NDK translation for native code during testing. To continue\n            running tests using the current configuration and not use NDK translation,\n            set testedAbi = \"" + abi + "\"\n        "));
        }

        @VisibleForTesting
        @NotNull
        public final String generateSystemImageErrorMessage(@NotNull String deviceName, int sdkVersion, int sdkMinorVersion, @Nullable Integer extensionVersion, @NotNull String systemImageSource, @NotNull String pageAlignmentSuffix, boolean require64Bit, @NotNull SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2) {
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)systemImageSource, (String)"systemImageSource");
            Intrinsics.checkNotNullParameter((Object)pageAlignmentSuffix, (String)"pageAlignmentSuffix");
            Intrinsics.checkNotNullParameter((Object)versionedSdkLoader2, (String)"versionedSdkLoader");
            if (versionedSdkLoader2.getOfflineMode()) {
                return StringsKt.trimIndent((String)("\n                    The system image for " + deviceName + " is not available and Gradle is in offline mode.\n                    Could not download the image or find other compatible images.\n                "));
            }
            List list = versionedSdkLoader2.allSystemImageHashes();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List allImages = list;
            return new ManagedDeviceImageSuggestionGenerator(ComputerArchUtilsKt.getOsArchitecture(), deviceName, sdkVersion, sdkMinorVersion, extensionVersion, systemImageSource, pageAlignmentSuffix, require64Bit, allImages).getMessage();
        }

        public static final /* synthetic */ String access$generateTestedAbiNotCompatibleError(Companion $this, String deviceName, String testedAbi, String abi) {
            return $this.generateTestedAbiNotCompatibleError(deviceName, testedAbi, abi);
        }

        public static final /* synthetic */ String access$generateUnrecognizedTestedAbiError(Companion $this, String deviceName, String testedAbi) {
            return $this.generateUnrecognizedTestedAbiError(deviceName, testedAbi);
        }

        public static final /* synthetic */ String access$generateArmTranslationOnX86Error(Companion $this, String deviceName, String abi) {
            return $this.generateArmTranslationOnX86Error(deviceName, abi);
        }

        public static final /* synthetic */ String access$generateUnspecifiedAbiWarningWithNdkTranslationUnsupported(Companion $this, String deviceName, String abi) {
            return $this.generateUnspecifiedAbiWarningWithNdkTranslationUnsupported(deviceName, abi);
        }

        public static final /* synthetic */ String access$generateNDKTranslationUnsupportedError(Companion $this, String deviceName, String systemImageSource, int sdkVersion, String testedAbi, String abi) {
            return $this.generateNDKTranslationUnsupportedError(deviceName, systemImageSource, sdkVersion, testedAbi, abi);
        }

        public static final /* synthetic */ String access$generateUnspecifiedAbiWarningWithNdkTranslation(Companion $this, String deviceName, String abi) {
            return $this.generateUnspecifiedAbiWarningWithNdkTranslation(deviceName, abi);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001Ba\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask;", "name", "", "systemImageSource", "pageAlignmentSuffix", "sdkVersion", "", "sdkMinorVersion", "sdkExtensionVersion", "abi", "hardwareProfile", "managedDeviceName", "require64Bit", "", "creationConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "managedDevice", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "(Ljava/lang/String;Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "getName", "()Ljava/lang/String;", "Ljava/lang/Integer;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nManagedDeviceInstrumentationTestSetupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedDeviceInstrumentationTestSetupTask.kt\ncom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$CreationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,547:1\n78#2:548\n78#2:549\n*S KotlinDebug\n*F\n+ 1 ManagedDeviceInstrumentationTestSetupTask.kt\ncom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$CreationAction\n*L\n411#1:548\n416#1:549\n*E\n"})
    public static final class CreationAction
    extends GlobalTaskCreationAction<ManagedDeviceInstrumentationTestSetupTask> {
        @NotNull
        private final String name;
        @NotNull
        private final String systemImageSource;
        @NotNull
        private final String pageAlignmentSuffix;
        private final int sdkVersion;
        private final int sdkMinorVersion;
        @Nullable
        private final Integer sdkExtensionVersion;
        @NotNull
        private final String abi;
        @NotNull
        private final String hardwareProfile;
        @NotNull
        private final String managedDeviceName;
        private final boolean require64Bit;
        @NotNull
        private final GlobalTaskCreationConfig creationConfig;

        public CreationAction(@NotNull String name, @NotNull String systemImageSource, @NotNull String pageAlignmentSuffix, int sdkVersion, int sdkMinorVersion, @Nullable Integer sdkExtensionVersion, @NotNull String abi, @NotNull String hardwareProfile, @NotNull String managedDeviceName, boolean require64Bit, @NotNull GlobalTaskCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)systemImageSource, (String)"systemImageSource");
            Intrinsics.checkNotNullParameter((Object)pageAlignmentSuffix, (String)"pageAlignmentSuffix");
            Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
            Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
            Intrinsics.checkNotNullParameter((Object)managedDeviceName, (String)"managedDeviceName");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this.name = name;
            this.systemImageSource = systemImageSource;
            this.pageAlignmentSuffix = pageAlignmentSuffix;
            this.sdkVersion = sdkVersion;
            this.sdkMinorVersion = sdkMinorVersion;
            this.sdkExtensionVersion = sdkExtensionVersion;
            this.abi = abi;
            this.hardwareProfile = hardwareProfile;
            this.managedDeviceName = managedDeviceName;
            this.require64Bit = require64Bit;
            this.creationConfig = creationConfig;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public CreationAction(@NotNull String name, @NotNull ManagedVirtualDevice managedDevice, @NotNull GlobalTaskCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)managedDevice, (String)"managedDevice");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this(name, managedDevice.getSystemImageSource(), managedDevice.getPageAlignmentSuffix(), managedDevice.getSdkVersion(), managedDevice.getSdkMinorVersion(), managedDevice.getSdkExtensionVersion(), ManagedDeviceUtilsKt.computeAbiFromArchitecture(managedDevice), managedDevice.getDevice(), managedDevice.getName(), managedDevice.getRequire64Bit(), creationConfig);
        }

        @Override
        @NotNull
        public Class<ManagedDeviceInstrumentationTestSetupTask> getType() {
            return ManagedDeviceInstrumentationTestSetupTask.class;
        }

        @Override
        public void configure(@NotNull ManagedDeviceInstrumentationTestSetupTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            BuildServiceRegistry buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, SdkComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getCompileSdkVersion(), this.creationConfig.getCompileSdkHashString());
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildToolsRevision(), this.creationConfig.getBuildToolsRevision());
            buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            $i$f$getBuildService = false;
            HasConfigurableValuesKt.setDisallowChanges(task.getAvdService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, AvdComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getSystemImageVendor(), this.systemImageSource);
            HasConfigurableValuesKt.setDisallowChanges(task.getPageAlignmentSuffix(), this.pageAlignmentSuffix);
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkVersion(), this.sdkVersion);
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkMinorVersion(), this.sdkMinorVersion);
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkExtensionVersion(), this.sdkExtensionVersion);
            HasConfigurableValuesKt.setDisallowChanges(task.getAbi(), this.abi);
            HasConfigurableValuesKt.setDisallowChanges(task.getHardwareProfile(), this.hardwareProfile);
            HasConfigurableValuesKt.setDisallowChanges(task.getEmulatorGpuFlag(), ManagedDeviceUtilsKt.computeManagedDeviceEmulatorMode(this.creationConfig.getServices().getProjectOptions()));
            HasConfigurableValuesKt.setDisallowChanges(task.getManagedDeviceName(), this.managedDeviceName);
            HasConfigurableValuesKt.setDisallowChanges(task.getRequire64Bit(), this.require64Bit);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\bR\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\bR\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\bR\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\bR\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\b\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$ManagedDeviceSetupParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "sdkService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "()Lorg/gradle/api/provider/Property;", "compileSdkVersion", "", "getCompileSdkVersion", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "avdService", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdService", "deviceName", "getDeviceName", "hardwareProfile", "getHardwareProfile", "emulatorGpuFlag", "getEmulatorGpuFlag", "managedDeviceName", "getManagedDeviceName", "systemImageVendor", "getSystemImageVendor", "pageAlignmentSuffix", "getPageAlignmentSuffix", "sdkVersion", "", "getSdkVersion", "sdkMinorVersion", "getSdkMinorVersion", "sdkExtensionVersion", "getSdkExtensionVersion", "require64Bit", "", "getRequire64Bit", "abi", "getAbi", "gradle-core"})
    public static abstract class ManagedDeviceSetupParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkService();

        @NotNull
        public abstract Property<String> getCompileSdkVersion();

        @NotNull
        public abstract Property<Revision> getBuildToolsRevision();

        @NotNull
        public abstract Property<AvdComponentsBuildService> getAvdService();

        @NotNull
        public abstract Property<String> getDeviceName();

        @NotNull
        public abstract Property<String> getHardwareProfile();

        @NotNull
        public abstract Property<String> getEmulatorGpuFlag();

        @NotNull
        public abstract Property<String> getManagedDeviceName();

        @NotNull
        public abstract Property<String> getSystemImageVendor();

        @NotNull
        public abstract Property<String> getPageAlignmentSuffix();

        @NotNull
        public abstract Property<Integer> getSdkVersion();

        @NotNull
        public abstract Property<Integer> getSdkMinorVersion();

        @NotNull
        public abstract Property<Integer> getSdkExtensionVersion();

        @NotNull
        public abstract Property<Boolean> getRequire64Bit();

        @NotNull
        public abstract Property<String> getAbi();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$ManagedDeviceSetupRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$ManagedDeviceSetupParams;", "<init>", "()V", "run", "", "computeImageHash", "", "gradle-core"})
    public static abstract class ManagedDeviceSetupRunnable
    extends ProfileAwareWorkAction<ManagedDeviceSetupParams> {
        @Override
        public void run() {
            String imageHash;
            SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2 = ((SdkComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getSdkService().get()).sdkLoader((Provider<String>)((Provider)((ManagedDeviceSetupParams)this.getParameters()).getCompileSdkVersion()), (Provider<Revision>)((Provider)((ManagedDeviceSetupParams)this.getParameters()).getBuildToolsRevision()));
            Provider<Directory> sdkImageProvider = versionedSdkLoader2.sdkImageDirectoryProvider(imageHash = this.computeImageHash());
            if (!sdkImageProvider.isPresent()) {
                Object object = ((ManagedDeviceSetupParams)this.getParameters()).getManagedDeviceName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                String string = (String)object;
                Object object2 = ((ManagedDeviceSetupParams)this.getParameters()).getSdkVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                int n = ((Number)object2).intValue();
                Object object3 = ((ManagedDeviceSetupParams)this.getParameters()).getSdkMinorVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                int n2 = ((Number)object3).intValue();
                Integer n3 = (Integer)((ManagedDeviceSetupParams)this.getParameters()).getSdkExtensionVersion().getOrNull();
                Object object4 = ((ManagedDeviceSetupParams)this.getParameters()).getSystemImageVendor().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                String string2 = (String)object4;
                Object object5 = ((ManagedDeviceSetupParams)this.getParameters()).getPageAlignmentSuffix().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                String string3 = (String)object5;
                Object object6 = ((ManagedDeviceSetupParams)this.getParameters()).getRequire64Bit().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
                String string4 = Companion.generateSystemImageErrorMessage(string, n, n2, n3, string2, string3, (Boolean)object6, versionedSdkLoader2);
                throw new IllegalStateException(string4.toString());
            }
            versionedSdkLoader2.getEmulatorDirectoryProvider().get();
            AvdComponentsBuildService avdComponentsBuildService = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
            Object object = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String string = (String)object;
            Object object7 = ((ManagedDeviceSetupParams)this.getParameters()).getHardwareProfile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
            avdComponentsBuildService.avdProvider(sdkImageProvider, imageHash, string, (String)object7).get();
            AvdComponentsBuildService avdComponentsBuildService2 = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
            Object object8 = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
            String string5 = (String)object8;
            Object object9 = ((ManagedDeviceSetupParams)this.getParameters()).getEmulatorGpuFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get(...)");
            avdComponentsBuildService2.ensureLoadableSnapshot(string5, (String)object9);
        }

        private final String computeImageHash() {
            Object object = ((ManagedDeviceSetupParams)this.getParameters()).getSdkVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            int n = ((Number)object).intValue();
            Object object2 = ((ManagedDeviceSetupParams)this.getParameters()).getSdkMinorVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            int n2 = ((Number)object2).intValue();
            Integer n3 = (Integer)((ManagedDeviceSetupParams)this.getParameters()).getSdkExtensionVersion().getOrNull();
            Object object3 = ((ManagedDeviceSetupParams)this.getParameters()).getSystemImageVendor().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            String string = (String)object3;
            Object object4 = ((ManagedDeviceSetupParams)this.getParameters()).getPageAlignmentSuffix().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            String string2 = (String)object4;
            Object object5 = ((ManagedDeviceSetupParams)this.getParameters()).getAbi().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
            return SystemImageHashUtilsKt.computeSystemImageHashFromDsl((int)n, (int)n2, (Integer)n3, (String)string, (String)string2, (String)((String)object5));
        }
    }
}

