/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.dsl.DataBinding;
import com.android.build.api.variant.VariantBuilder;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AndroidTestTaskManager;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.ScreenshotTestTaskManager;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.TestFixturesTaskManager;
import com.android.build.gradle.internal.UnitTestTaskManager;
import com.android.build.gradle.internal.VariantTaskManager;
import com.android.build.gradle.internal.attribution.CheckJetifierBuildService;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.DeviceTestCreationConfig;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.component.NestedComponentCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.component.features.RenderscriptCreationConfig;
import com.android.build.gradle.internal.core.ProductFlavor;
import com.android.build.gradle.internal.cxx.configure.CxxCreateGradleTasksKt;
import com.android.build.gradle.internal.dependency.AndroidXDependencySubstitution;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.lint.LintTaskManager;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.CheckJetifierTask;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.utils.KgpUtils;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.AnalyzeDependenciesTask;
import com.android.build.gradle.tasks.JavaCompileKt;
import com.android.builder.core.ComponentType;
import com.android.builder.errors.IssueReporter;
import com.android.prefs.AndroidLocationsProvider;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u0000 L*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0001LB]\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020(J\u001c\u0010.\u001a\u00020(2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0002J\u0018\u00100\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u00101\u001a\u00020(H\u0002J\b\u00102\u001a\u00020(H\u0002J\u0010\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020\fH\u0002J\b\u00105\u001a\u00020(H\u0002J\u0010\u00106\u001a\u00020(2\u0006\u00107\u001a\u000208H\u0002J0\u00109\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00107\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010F\u001a\u00020(2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020HH\u0002J\u001c\u0010J\u001a\u00020(2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH$R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00128\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00148\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00188\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/android/build/gradle/internal/VariantTaskManager;", "VariantBuilderT", "Lcom/android/build/api/variant/VariantBuilder;", "VariantT", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "Lcom/android/build/gradle/internal/TaskManager;", "project", "Lorg/gradle/api/Project;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "testFixturesComponents", "Lcom/android/build/gradle/internal/component/TestFixturesCreationConfig;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "localConfig", "Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;", "extension", "Lcom/android/build/gradle/BaseExtension;", "<init>", "(Lorg/gradle/api/Project;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;Lcom/android/build/gradle/BaseExtension;)V", "variantPropertiesList", "", "nestedComponents", "Lcom/android/build/gradle/internal/component/NestedComponentCreationConfig;", "allPropertiesList", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "lintTaskManager", "Lcom/android/build/gradle/internal/lint/LintTaskManager;", "unitTestTaskManager", "Lcom/android/build/gradle/internal/UnitTestTaskManager;", "screenshotTestTaskManager", "Lcom/android/build/gradle/internal/ScreenshotTestTaskManager;", "androidTestTaskManager", "Lcom/android/build/gradle/internal/AndroidTestTaskManager;", "testFixturesTaskManager", "Lcom/android/build/gradle/internal/TestFixturesTaskManager;", "createTasks", "", "componentType", "Lcom/android/builder/core/ComponentType;", "variantModel", "Lcom/android/build/gradle/internal/variant/VariantModel;", "createPostApiTasks", "createTasksForVariant", "componentInfo", "createTopLevelTasks", "createReportTasks", "createDependencyAnalyzerTask", "createTasksForTest", "testVariant", "configureKotlinPluginTasksIfNecessary", "addBindingDependenciesIfNecessary", "dataBindingOptions", "Lcom/android/build/api/dsl/DataBinding;", "addDataBindingKtxIfNecessary", "Lcom/android/build/gradle/internal/dsl/DataBindingOptions;", "dataBindingBuilder", "Landroid/databinding/tool/DataBindingBuilder;", "version", "", "useAndroidX", "", "configureKotlinKaptTasksForDataBinding", "configureKaptTaskInScopeForDataBinding", "creationConfig", "kaptTask", "Lorg/gradle/api/Task;", "createAnchorAssembleTasks", "flavorCount", "", "flavorDimensionCount", "doCreateTasksForVariant", "variantInfo", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nVariantTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariantTaskManager.kt\ncom/android/build/gradle/internal/VariantTaskManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,768:1\n1557#2:769\n1628#2,3:770\n1755#2,3:773\n1755#2,3:777\n1755#2,3:780\n1202#2,2:783\n1230#2,4:785\n78#3:776\n*S KotlinDebug\n*F\n+ 1 VariantTaskManager.kt\ncom/android/build/gradle/internal/VariantTaskManager\n*L\n90#1:769\n90#1:770,3\n127#1:773,3\n231#1:777,3\n354#1:780,3\n566#1:783,2\n566#1:785,4\n216#1:776\n*E\n"})
public abstract class VariantTaskManager<VariantBuilderT extends VariantBuilder, VariantT extends VariantCreationConfig>
extends TaskManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<ComponentInfo<VariantBuilderT, VariantT>> variants;
    @NotNull
    private final Collection<TestComponentCreationConfig> testComponents;
    @NotNull
    private final Collection<TestFixturesCreationConfig> testFixturesComponents;
    @JvmField
    @NotNull
    protected final TaskManagerConfig localConfig;
    @JvmField
    @NotNull
    protected final BaseExtension extension;
    @JvmField
    @NotNull
    protected final List<VariantT> variantPropertiesList;
    @NotNull
    private final List<NestedComponentCreationConfig> nestedComponents;
    @NotNull
    private final List<ComponentCreationConfig> allPropertiesList;
    @NotNull
    private final LintTaskManager lintTaskManager;
    @NotNull
    private final UnitTestTaskManager unitTestTaskManager;
    @NotNull
    private final ScreenshotTestTaskManager screenshotTestTaskManager;
    @NotNull
    private final AndroidTestTaskManager androidTestTaskManager;
    @NotNull
    private final TestFixturesTaskManager testFixturesTaskManager;
    @NotNull
    private static final String MULTIDEX_VERSION = "1.0.2";
    @NotNull
    private static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.2";
    @NotNull
    private static final String ANDROIDX_MULTIDEX_MULTIDEX = (String)MapsKt.getValue(AndroidXDependencySubstitution.getAndroidXMappings(), (Object)"com.android.support:multidex");
    @NotNull
    private static final String COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION = "com.android.support:multidex-instrumentation:1.0.2";
    @NotNull
    private static final String ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION = (String)MapsKt.getValue(AndroidXDependencySubstitution.getAndroidXMappings(), (Object)"com.android.support:multidex-instrumentation");

    /*
     * WARNING - void declaration
     */
    public VariantTaskManager(@NotNull Project project, @NotNull Collection<? extends ComponentInfo<VariantBuilderT, VariantT>> variants, @NotNull Collection<? extends TestComponentCreationConfig> testComponents, @NotNull Collection<? extends TestFixturesCreationConfig> testFixturesComponents, @NotNull GlobalTaskCreationConfig globalConfig2, @NotNull TaskManagerConfig localConfig, @NotNull BaseExtension extension2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
        Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
        Intrinsics.checkNotNullParameter((Object)globalConfig2, (String)"globalConfig");
        Intrinsics.checkNotNullParameter((Object)localConfig, (String)"localConfig");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        super(project, globalConfig2);
        this.variants = variants;
        this.testComponents = testComponents;
        this.testFixturesComponents = testFixturesComponents;
        this.localConfig = localConfig;
        this.extension = extension2;
        Iterable iterable = this.variants;
        VariantTaskManager variantTaskManager = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ComponentInfo componentInfo = (ComponentInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((VariantCreationConfig)p0.getVariant());
        }
        variantTaskManager.variantPropertiesList = (List)destination$iv$iv;
        this.nestedComponents = CollectionsKt.plus(this.testComponents, (Iterable)this.testFixturesComponents);
        this.allPropertiesList = CollectionsKt.plus((Collection)this.variantPropertiesList, (Iterable)this.nestedComponents);
        this.lintTaskManager = new LintTaskManager(globalConfig2, this.taskFactory, project);
        this.unitTestTaskManager = new UnitTestTaskManager(project, globalConfig2);
        this.screenshotTestTaskManager = new ScreenshotTestTaskManager(project, globalConfig2);
        this.androidTestTaskManager = new AndroidTestTaskManager(project, globalConfig2);
        this.testFixturesTaskManager = new TestFixturesTaskManager(project, globalConfig2, this.localConfig);
    }

    public final void createTasks(@NotNull ComponentType componentType, @NotNull VariantModel variantModel) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
            Intrinsics.checkNotNullParameter((Object)variantModel, (String)"variantModel");
            this.createPrepareLintJarForPublishTask();
            this.taskFactory.register(this.globalConfig.getTaskNames().getCompileLintChecks(), (Action<? super Task>)new Action(this){
                final /* synthetic */ VariantTaskManager<VariantBuilderT, VariantT> this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void execute(Task task) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    Object[] objectArray = new Object[]{this.this$0.globalConfig.getLocalCustomLintChecks()};
                    task.dependsOn(objectArray);
                }
            });
            this.unitTestTaskManager.createTopLevelTasks();
            this.androidTestTaskManager.createTopLevelTasks();
            Iterable $this$any$iv = this.testComponents;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestComponentCreationConfig it = (TestComponentCreationConfig)element$iv;
                    boolean bl2 = false;
                    if (!it.getComponentType().isForScreenshotPreview()) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            this.screenshotTestTaskManager.createTopLevelTasks();
        }
        for (ComponentInfo<VariantBuilderT, VariantT> variant : this.variants) {
            this.createTasksForVariant(variant);
        }
        for (TestFixturesCreationConfig testFixturesComponent : this.testFixturesComponents) {
            this.testFixturesTaskManager.createTasks(testFixturesComponent);
        }
        for (TestComponentCreationConfig testComponent : this.testComponents) {
            this.createTasksForTest(testComponent);
        }
        this.createTopLevelTasks(componentType, variantModel);
    }

    public final void createPostApiTasks() {
        this.addBindingDependenciesIfNecessary(this.globalConfig.getDataBinding());
        this.configureKotlinPluginTasksIfNecessary();
        this.createAnchorAssembleTasks(this.globalConfig.getProductFlavorCount(), this.globalConfig.getProductFlavorDimensionCount());
    }

    private final void createTasksForVariant(ComponentInfo<VariantBuilderT, VariantT> componentInfo) {
        RenderscriptCreationConfig renderscriptCreationConfig2;
        VariantCreationConfig variant = (VariantCreationConfig)componentInfo.getVariant();
        ComponentType componentType = ((ComponentCreationConfig)variant).getComponentType();
        VariantDependencies variantDependencies2 = ((ComponentCreationConfig)variant).getVariantDependencies();
        if (variant instanceof ApkCreationConfig && ((ApkCreationConfig)((Object)variant)).getDexing().getDexingType().isLegacyMultiDex()) {
            String multiDexDependency = ((ComponentCreationConfig)variant).getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX : COM_ANDROID_SUPPORT_MULTIDEX;
            this.project.getDependencies().add(variantDependencies2.getCompileClasspath().getName(), (Object)multiDexDependency);
            this.project.getDependencies().add(variantDependencies2.getRuntimeClasspath().getName(), (Object)multiDexDependency);
        }
        if ((renderscriptCreationConfig2 = ((ConsumableCreationConfig)variant).getRenderscriptCreationConfig()) != null && (renderscriptCreationConfig2 = renderscriptCreationConfig2.getRenderscript()) != null && (renderscriptCreationConfig2 = renderscriptCreationConfig2.getSupportModeEnabled()) != null ? Intrinsics.areEqual((Object)renderscriptCreationConfig2.get(), (Object)true) : false) {
            Object[] objectArray = new Object[]{this.globalConfig.getVersionedSdkLoader().flatMap((Transformer)createTasksForVariant.fileCollection.1.INSTANCE)};
            ConfigurableFileCollection fileCollection2 = this.project.files(objectArray);
            this.project.getDependencies().add(variantDependencies2.getCompileClasspath().getName(), (Object)fileCollection2);
            if (componentType.isApk() && !componentType.isForTesting()) {
                this.project.getDependencies().add(variantDependencies2.getRuntimeClasspath().getName(), (Object)fileCollection2);
            }
        }
        this.createAssembleTask(variant);
        this.doCreateTasksForVariant(componentInfo);
        ((ComponentCreationConfig)variant).getArtifacts().getListenerManager$gradle_core().executeActions();
    }

    public void createTopLevelTasks(@NotNull ComponentType componentType, @NotNull VariantModel variantModel) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
            Intrinsics.checkNotNullParameter((Object)variantModel, (String)"variantModel");
            this.lintTaskManager.createLintTasks(componentType, variantModel, this.variantPropertiesList, this.testComponents, this.globalConfig.getServices().getProjectOptions().get(BooleanOption.LINT_ANALYSIS_PER_COMPONENT));
            this.createReportTasks();
            BuildServiceRegistry buildServiceRegistry = this.project.getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"getSharedServices(...)");
            BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
            boolean $i$f$getBuildService = false;
            Provider<AndroidLocationsBuildService> androidLocationBuildService = BuildServicesKt.getBuildService(buildServiceRegistry$iv, AndroidLocationsBuildService.class);
            Object object = androidLocationBuildService.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            AndroidLocationsProvider androidLocationsProvider = (AndroidLocationsProvider)object;
            Object object2 = BuildServicesKt.getBuildService(this.globalConfig.getServices().getBuildServiceRegistry(), SdkComponentsBuildService.class).get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            CxxCreateGradleTasksKt.createCxxTasks(androidLocationsProvider, (SdkComponentsBuildService)object2, this.globalConfig.getServices().getIssueReporter(), this.taskFactory, this.globalConfig.getServices().getProjectOptions(), this.variants, this.project);
            Iterable $this$any$iv = this.variants;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ComponentInfo it = (ComponentInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.getVariant().getPrivacySandboxCreationConfig() != null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.taskFactory.register(new ValidateSigningTask.PrivacySandboxSdkCreationAction(this.globalConfig));
        }
    }

    private final void createReportTasks() {
        this.taskFactory.register("androidDependencies", DependencyReportTask.class, (Action)new Action(this){
            final /* synthetic */ VariantTaskManager<VariantBuilderT, VariantT> this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(DependencyReportTask task) {
                Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
                task.setDescription("Displays the Android dependencies of the project.");
                HasConfigurableValuesKt.setDisallowChanges(task.getVariants(), (Iterable)this.this$0.variantPropertiesList);
                HasConfigurableValuesKt.setDisallowChanges(task.getNestedComponents(), (Iterable)VariantTaskManager.access$getNestedComponents$p(this.this$0));
                task.setGroup("Android");
                Property<MavenCoordinatesCacheBuildService> property = task.getMavenCoordinateCache();
                BuildServiceRegistry buildServiceRegistry = this.this$0.project.getGradle().getSharedServices();
                Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"getSharedServices(...)");
                HasConfigurableValuesKt.setDisallowChanges(property, BuildServicesKt.getBuildService(buildServiceRegistry, MavenCoordinatesCacheBuildService.class).get());
                task.notCompatibleWithConfigurationCache("DependencyReportTask not compatible with config caching");
            }
        });
        List<ApkCreationConfig> signingReportComponents2 = this.allPropertiesList.stream().filter(createReportTasks.signingReportComponents.1.INSTANCE).map(createReportTasks.signingReportComponents.2.INSTANCE).collect(Collectors.toList());
        Intrinsics.checkNotNull(signingReportComponents2);
        if (!((Collection)signingReportComponents2).isEmpty()) {
            this.taskFactory.register("signingReport", SigningReportTask.class, (Action)new Action(signingReportComponents2){
                final /* synthetic */ List<ApkCreationConfig> $signingReportComponents;
                {
                    this.$signingReportComponents = $signingReportComponents;
                }

                public final void execute(SigningReportTask task) {
                    Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
                    task.setDescription("Displays the signing info for the base and test modules");
                    task.setComponents((Collection<ApkCreationConfig>)this.$signingReportComponents);
                    task.setGroup("Android");
                }
            });
        }
        this.createDependencyAnalyzerTask();
        Provider<CheckJetifierBuildService> checkJetifierBuildService = new CheckJetifierBuildService.RegistrationAction(this.project, this.globalConfig.getServices().getProjectOptions()).execute();
        this.taskFactory.register(new CheckJetifierTask.CreationAction(this.globalConfig, checkJetifierBuildService, this.variants, this.testComponents, this.testFixturesComponents));
    }

    private final void createDependencyAnalyzerTask() {
        for (VariantCreationConfig variant : this.variantPropertiesList) {
            this.taskFactory.register(new AnalyzeDependenciesTask.CreationAction(variant));
        }
        for (NestedComponentCreationConfig component2 : this.nestedComponents) {
            this.taskFactory.register(new AnalyzeDependenciesTask.CreationAction(component2));
        }
    }

    private final void createTasksForTest(TestComponentCreationConfig testVariant) {
        this.createAssembleTask(testVariant);
        VariantCreationConfig testedVariant = testVariant.getMainVariant();
        VariantDependencies variantDependencies2 = testVariant.getVariantDependencies();
        RenderscriptCreationConfig renderscriptCreationConfig2 = testedVariant.getRenderscriptCreationConfig();
        if (renderscriptCreationConfig2 != null && (renderscriptCreationConfig2 = renderscriptCreationConfig2.getRenderscript()) != null && (renderscriptCreationConfig2 = renderscriptCreationConfig2.getSupportModeEnabled()) != null ? Intrinsics.areEqual((Object)renderscriptCreationConfig2.get(), (Object)true) : false) {
            Object[] objectArray = new Object[]{this.globalConfig.getVersionedSdkLoader().flatMap((Transformer)createTasksForTest.1.INSTANCE)};
            this.project.getDependencies().add(variantDependencies2.getCompileClasspath().getName(), (Object)this.project.files(objectArray));
        }
        if (testVariant.getComponentType().isApk()) {
            Intrinsics.checkNotNull((Object)testVariant, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.component.ApkCreationConfig");
            if (((ApkCreationConfig)((Object)testVariant)).getDexing().getDexingType().isLegacyMultiDex()) {
                String multiDexInstrumentationDep = testVariant.getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION : COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION;
                this.project.getDependencies().add(variantDependencies2.getCompileClasspath().getName(), (Object)multiDexInstrumentationDep);
                this.project.getDependencies().add(variantDependencies2.getRuntimeClasspath().getName(), (Object)multiDexInstrumentationDep);
            }
            this.androidTestTaskManager.createTasks((DeviceTestCreationConfig)testVariant);
        } else if (testVariant.getComponentType().isForScreenshotPreview()) {
            Intrinsics.checkNotNull((Object)testVariant, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.component.HostTestCreationConfig");
            this.screenshotTestTaskManager.createTasks((HostTestCreationConfig)testVariant);
        } else {
            Intrinsics.checkNotNull((Object)testVariant, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.component.HostTestCreationConfig");
            this.unitTestTaskManager.createTasks((HostTestCreationConfig)testVariant);
        }
    }

    private final void configureKotlinPluginTasksIfNecessary() {
        boolean bl;
        block7: {
            if (!KgpUtils.isKotlinPluginAppliedInTheSameClassloader(this.project) && !this.project.getPluginManager().hasPlugin("com.android.experimental.built-in-kotlin")) {
                return;
            }
            KgpUtils.configureKotlinCompileTasks(this.project, this.allPropertiesList, (Function2<? super KotlinCompile, ? super ComponentCreationConfig, Unit>)((Function2)new Function2<KotlinCompile, ComponentCreationConfig, Unit>(this){
                final /* synthetic */ VariantTaskManager<VariantBuilderT, VariantT> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(KotlinCompile kotlinCompile, ComponentCreationConfig creationConfig) {
                    Intrinsics.checkNotNullParameter((Object)kotlinCompile, (String)"kotlinCompile");
                    Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
                    if (this.this$0.globalConfig.getServices().getProjectOptions().get(BooleanOption.DISABLE_INLINE_SCOPES_NUMBERS)) {
                        return;
                    }
                    KgpUtils.maybeUseInlineScopesNumbers(kotlinCompile, creationConfig, this.this$0.getLogger());
                }
            }));
            Iterable $this$any$iv = this.allPropertiesList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ComponentCreationConfig componentProperties = (ComponentCreationConfig)element$iv;
                    boolean bl2 = false;
                    if (!componentProperties.getBuildFeatures().getCompose()) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean composeIsEnabled = bl;
        KgpUtils.recordKgpPropertiesForAnalytics(this.project, this.allPropertiesList);
        if (!composeIsEnabled) {
            return;
        }
        KotlinVersion kotlinVersion = KgpUtils.getProjectKotlinPluginKotlinVersion(this.project);
        if (kotlinVersion != null && kotlinVersion.getMajor() >= 2 && !KgpUtils.isComposeCompilerPluginApplied(this.project)) {
            IssueReporter.reportError$default((IssueReporter)this.globalConfig.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.MISSING_COMPOSE_COMPILER_GRADLE_PLUGIN, (String)"Starting in Kotlin 2.0, the Compose Compiler Gradle plugin is required\nwhen compose is enabled. See the following link for more information:\nhttps://d.android.com/r/studio-ui/compose-compiler", (String)kotlinVersion.toString(), null, (int)8, null);
        }
        boolean useLiveLiterals = this.globalConfig.getComposeOptions().getUseLiveLiterals();
        BuildServiceRegistry buildServiceRegistry = this.project.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"getSharedServices(...)");
        AnalyticsConfiguratorService analyticsConfiguratorService = (AnalyticsConfiguratorService)BuildServicesKt.getBuildService(buildServiceRegistry, AnalyticsConfiguratorService.class).get();
        String string = this.project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        GradleBuildProject.Builder builder = analyticsConfiguratorService.getProjectBuilder(string);
        if (builder != null) {
            builder.setComposeEnabled(true);
        }
        Configuration kotlinExtension2 = this.maybeCreateKotlinExtensionConfiguration();
        KgpUtils.configureKotlinCompileTasks(this.project, this.allPropertiesList, (Function2<? super KotlinCompile, ? super ComponentCreationConfig, Unit>)((Function2)new Function2<KotlinCompile, ComponentCreationConfig, Unit>(this, kotlinExtension2, useLiveLiterals){
            final /* synthetic */ VariantTaskManager<VariantBuilderT, VariantT> this$0;
            final /* synthetic */ Configuration $kotlinExtension;
            final /* synthetic */ boolean $useLiveLiterals;
            {
                this.this$0 = $receiver;
                this.$kotlinExtension = $kotlinExtension;
                this.$useLiveLiterals = $useLiveLiterals;
                super(2);
            }

            public final void invoke(KotlinCompile kotlinCompile, ComponentCreationConfig creationConfig) {
                Intrinsics.checkNotNullParameter((Object)kotlinCompile, (String)"kotlinCompile");
                Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
                Object[] objectArray = new Object[]{this.$kotlinExtension};
                ConfigurableFileCollection configurableFileCollection = this.this$0.project.files(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"files(...)");
                KgpUtils.addComposeArgsToKotlinCompile(kotlinCompile, creationConfig, (FileCollection)configurableFileCollection, this.$useLiveLiterals);
            }
        }));
    }

    private final void addBindingDependenciesIfNecessary(DataBinding dataBindingOptions) {
        String version;
        boolean viewBindingEnabled2 = this.allPropertiesList.stream().anyMatch(addBindingDependenciesIfNecessary.viewBindingEnabled.1.INSTANCE);
        boolean dataBindingEnabled2 = this.allPropertiesList.stream().anyMatch(addBindingDependenciesIfNecessary.dataBindingEnabled.1.INSTANCE);
        boolean useAndroidX = this.globalConfig.getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X);
        DataBindingBuilder dataBindingBuilder = this.localConfig.getDataBindingBuilder();
        if (viewBindingEnabled2) {
            version = dataBindingBuilder.getLibraryVersion(dataBindingBuilder.getCompilerVersion());
            String groupAndArtifact = useAndroidX ? "androidx.databinding:viewbinding" : "com.android.databinding:viewbinding";
            this.project.getDependencies().add("api", (Object)(groupAndArtifact + ":" + version));
        }
        if (dataBindingEnabled2) {
            version = (String)MoreObjects.firstNonNull((Object)dataBindingOptions.getVersion(), (Object)dataBindingBuilder.getCompilerVersion());
            String baseLibArtifact = useAndroidX ? "androidx.databinding:databinding-common" : "com.android.databinding:baseLibrary";
            this.project.getDependencies().add("api", (Object)(baseLibArtifact + ":" + dataBindingBuilder.getBaseLibraryVersion(version)));
            this.project.getDependencies().add("annotationProcessor", (Object)("androidx.databinding:databinding-compiler:" + version));
            if (dataBindingOptions.getEnableForTests() || this instanceof LibraryTaskManager) {
                String dataBindingArtifact = "androidx.databinding:databinding-compiler:" + version;
                this.project.getDependencies().add("androidTestAnnotationProcessor", (Object)dataBindingArtifact);
                if (this.globalConfig.getUnitTestOptions().isIncludeAndroidResources()) {
                    this.project.getDependencies().add("testAnnotationProcessor", (Object)dataBindingArtifact);
                }
            }
            Intrinsics.checkNotNull((Object)dataBindingOptions, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.dsl.DataBindingOptions");
            if (((DataBindingOptions)dataBindingOptions).getAddDefaultAdapters()) {
                String libArtifact = useAndroidX ? "androidx.databinding:databinding-runtime" : "com.android.databinding:library";
                String adaptersArtifact = useAndroidX ? "androidx.databinding:databinding-adapters" : "com.android.databinding:adapters";
                this.project.getDependencies().add("api", (Object)(libArtifact + ":" + dataBindingBuilder.getLibraryVersion(version)));
                this.project.getDependencies().add("api", (Object)(adaptersArtifact + ":" + dataBindingBuilder.getBaseAdaptersVersion(version)));
            }
            DataBindingOptions dataBindingOptions2 = (DataBindingOptions)dataBindingOptions;
            Intrinsics.checkNotNull((Object)version);
            this.addDataBindingKtxIfNecessary(this.project, dataBindingOptions2, dataBindingBuilder, version, useAndroidX);
            this.project.getPluginManager().withPlugin("org.jetbrains.kotlin.kapt", new Action(this, version){
                final /* synthetic */ VariantTaskManager<VariantBuilderT, VariantT> this$0;
                final /* synthetic */ String $version;
                {
                    this.this$0 = $receiver;
                    this.$version = $version;
                }

                public final void execute(AppliedPlugin it) {
                    Project project = this.this$0.project;
                    String string = this.$version;
                    Intrinsics.checkNotNull((Object)string);
                    VariantTaskManager.access$configureKotlinKaptTasksForDataBinding(this.this$0, project, string);
                }
            });
        }
    }

    private final void addDataBindingKtxIfNecessary(Project project, DataBindingOptions dataBindingOptions, DataBindingBuilder dataBindingBuilder, String version, boolean useAndroidX) {
        boolean enableKtx;
        Boolean ktxDataBindingDslValue = dataBindingOptions.getAddKtx();
        boolean ktxGradlePropertyValue = this.globalConfig.getServices().getProjectOptions().get(BooleanOption.ENABLE_DATABINDING_KTX);
        Boolean bl = ktxDataBindingDslValue;
        boolean bl2 = enableKtx = bl != null ? bl : ktxGradlePropertyValue;
        if (enableKtx) {
            if (useAndroidX && KgpUtils.isKotlinPluginAppliedInTheSameClassloader(project)) {
                project.getDependencies().add("api", (Object)("androidx.databinding:databinding-ktx:" + dataBindingBuilder.getLibraryVersion(version)));
            } else if (Intrinsics.areEqual((Object)ktxDataBindingDslValue, (Object)true)) {
                IssueReporter.reportWarning$default((IssueReporter)this.globalConfig.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"The `android.dataBinding.addKtx` DSL option has no effect because the `android.useAndroidX` property is not enabled or the project does not use Kotlin.", null, null, (int)12, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureKotlinKaptTasksForDataBinding(Project project, String version) {
        void $this$associateByTo$iv$iv;
        DependencySet kaptDeps = project.getConfigurations().getByName("kapt").getAllDependencies();
        kaptDeps.forEach(new Consumer(version, this){
            final /* synthetic */ String $version;
            final /* synthetic */ VariantTaskManager<VariantBuilderT, VariantT> this$0;
            {
                this.$version = $version;
                this.this$0 = $receiver;
            }

            public final void accept(Dependency dependency) {
                Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
                if (Intrinsics.areEqual((Object)(dependency.getGroup() + ":" + dependency.getName()), (Object)"androidx.databinding:databinding-compiler") && !Intrinsics.areEqual((Object)dependency.getVersion(), (Object)this.$version)) {
                    String depString = dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion();
                    IssueReporter.reportError$default((IssueReporter)this.this$0.globalConfig.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)("Data Binding annotation processor version needs to match the Android Gradle Plugin version. You can remove the kapt dependency " + depString + " and Android Gradle Plugin will inject the right version."), null, null, (int)12, null);
                }
            }
        });
        project.getDependencies().add("kapt", (Object)("androidx.databinding:databinding-compiler:" + version));
        Class<?> kaptTaskClass = null;
        try {
            Class<?> clazz = Class.forName("org.jetbrains.kotlin.gradle.internal.KaptTask");
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<out org.gradle.api.Task>");
            kaptTaskClass = clazz;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().error("Kotlin plugin is applied to the project " + project.getPath() + " but we cannot find the KaptTask. Make sure you apply the kotlin-kapt plugin because it is necessary to use kotlin with data binding.");
        }
        if (kaptTaskClass == null) {
            return;
        }
        Iterable $this$associateBy$iv = this.allPropertiesList;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ComponentCreationConfig componentCreationConfig = (ComponentCreationConfig)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.computeTaskNameInternal("kapt", "Kotlin"), element$iv$iv);
        }
        Map kaptTaskNameOrPrefixToVariant = destination$iv$iv;
        project.getTasks().withType(kaptTaskClass, new Action(kaptTaskNameOrPrefixToVariant, this){
            final /* synthetic */ Map<String, ComponentCreationConfig> $kaptTaskNameOrPrefixToVariant;
            final /* synthetic */ VariantTaskManager<VariantBuilderT, VariantT> this$0;
            {
                this.$kaptTaskNameOrPrefixToVariant = $kaptTaskNameOrPrefixToVariant;
                this.this$0 = $receiver;
            }

            public final void execute(Task kaptTask) {
                block4: {
                    ComponentCreationConfig variant;
                    ComponentCreationConfig componentCreationConfig;
                    Object object;
                    Object v1;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)kaptTask, (String)"kaptTask");
                        Iterable $this$firstOrNull$iv = this.$kaptTaskNameOrPrefixToVariant.keySet();
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            String string = kaptTask.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            if (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                            v1 = element$iv;
                            break block3;
                        }
                        v1 = null;
                    }
                    String string = v1;
                    if (string != null) {
                        object = string;
                        Map<String, ComponentCreationConfig> $i$f$firstOrNull = this.$kaptTaskNameOrPrefixToVariant;
                        String it = object;
                        boolean bl = false;
                        ComponentCreationConfig componentCreationConfig2 = $i$f$firstOrNull.get(it);
                        Intrinsics.checkNotNull((Object)componentCreationConfig2);
                        componentCreationConfig = componentCreationConfig2;
                    } else {
                        componentCreationConfig = null;
                    }
                    ComponentCreationConfig componentCreationConfig3 = variant = componentCreationConfig;
                    if (componentCreationConfig3 == null) break block4;
                    string = componentCreationConfig3;
                    object = this.this$0;
                    String it = string;
                    boolean bl = false;
                    VariantTaskManager.access$configureKaptTaskInScopeForDataBinding((VariantTaskManager)object, variant, kaptTask);
                }
            }
        });
    }

    private final void configureKaptTaskInScopeForDataBinding(ComponentCreationConfig creationConfig, Task kaptTask) {
        DirectoryProperty dataBindingArtifactDir = this.project.getObjects().directoryProperty();
        RegularFileProperty exportClassListFile = this.project.getObjects().fileProperty();
        String string = kaptTask.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        TaskProvider<Task> kaptTaskProvider = this.taskFactory.named(string);
        Intrinsics.checkNotNull((Object)dataBindingArtifactDir);
        Intrinsics.checkNotNull((Object)exportClassListFile);
        JavaCompileKt.registerDataBindingOutputs(dataBindingArtifactDir, exportClassListFile, creationConfig.getComponentType().isExportDataBindingClassList(), kaptTaskProvider, creationConfig.getArtifacts(), false);
        kaptTask.getOutputs().dir((Object)dataBindingArtifactDir).withPropertyName("dataBindingArtifactDir");
        if (creationConfig.getComponentType().isExportDataBindingClassList()) {
            kaptTask.getOutputs().file((Object)exportClassListFile).withPropertyName("dataBindingExportClassListFile");
        }
    }

    private final void createAnchorAssembleTasks(int flavorCount, int flavorDimensionCount) {
        List subAssembleTasks = new ArrayList();
        List subBundleTasks = new ArrayList();
        if (flavorCount > 0) {
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
            ListMultimap assembleMap = (ListMultimap)arrayListMultimap;
            ArrayListMultimap arrayListMultimap2 = ArrayListMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap2, (String)"create(...)");
            ListMultimap bundleMap = (ListMultimap)arrayListMultimap2;
            for (ComponentCreationConfig componentCreationConfig : this.allPropertiesList) {
                ComponentType componentType = componentCreationConfig.getComponentType();
                if (componentType.isNestedComponent()) continue;
                MutableTaskContainer taskContainer = componentCreationConfig.getTaskContainer();
                String buildType = componentCreationConfig.getBuildType();
                TaskProvider<? extends Task> assembleTask = taskContainer.getAssembleTask();
                if (buildType != null) {
                    assembleMap.put((Object)buildType, assembleTask);
                }
                for (ProductFlavor flavor : componentCreationConfig.getProductFlavorList()) {
                    assembleMap.put((Object)flavor.getName(), assembleTask);
                }
                if (flavorDimensionCount > 1) {
                    assembleMap.put((Object)componentCreationConfig.getFlavorName(), assembleTask);
                }
                if (!componentType.isBaseModule()) continue;
                TaskProvider<? extends Task> bundleTask = taskContainer.getBundleTask();
                if (buildType != null) {
                    bundleMap.put((Object)buildType, bundleTask);
                }
                for (ProductFlavor flavor : componentCreationConfig.getProductFlavorList()) {
                    bundleMap.put((Object)flavor.getName(), bundleTask);
                }
                if (flavorDimensionCount <= 1) continue;
                bundleMap.put((Object)componentCreationConfig.getFlavorName(), bundleTask);
            }
            Set dimensionKeys = assembleMap.keySet();
            for (String dimensionKey : dimensionKeys) {
                Intrinsics.checkNotNull((Object)dimensionKey);
                String dimensionName = StringHelper.usLocaleCapitalize((String)dimensionKey);
                subAssembleTasks.add(this.taskFactory.register("assemble" + dimensionName, (Action<? super Task>)new Action(dimensionName, (ListMultimap<String, TaskProvider<? extends Task>>)assembleMap, dimensionKey){
                    final /* synthetic */ String $dimensionName;
                    final /* synthetic */ ListMultimap<String, TaskProvider<? extends Task>> $assembleMap;
                    final /* synthetic */ String $dimensionKey;
                    {
                        this.$dimensionName = $dimensionName;
                        this.$assembleMap = $assembleMap;
                        this.$dimensionKey = $dimensionKey;
                    }

                    public final void execute(Task task) {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        task.setDescription("Assembles main outputs for all " + this.$dimensionName + " variants.");
                        task.setGroup("build");
                        Object[] objectArray = new Object[]{this.$assembleMap.get((Object)this.$dimensionKey)};
                        task.dependsOn(objectArray);
                    }
                }));
                List subBundleMap = bundleMap.get((Object)dimensionKey);
                if (subBundleMap.isEmpty()) continue;
                subBundleTasks.add(this.taskFactory.register("bundle" + dimensionName, (Action<? super Task>)new Action(dimensionName, subBundleMap){
                    final /* synthetic */ String $dimensionName;
                    final /* synthetic */ List<TaskProvider<? extends Task>> $subBundleMap;
                    {
                        this.$dimensionName = $dimensionName;
                        this.$subBundleMap = $subBundleMap;
                    }

                    public final void execute(Task task) {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        task.setDescription("Assembles bundles for all " + this.$dimensionName + " variants.");
                        task.setGroup("build");
                        Object[] objectArray = new Object[]{this.$subBundleMap};
                        task.dependsOn(objectArray);
                    }
                }));
            }
        } else {
            for (ComponentCreationConfig creationConfig : this.allPropertiesList) {
                ComponentType componentType = creationConfig.getComponentType();
                if (componentType.isNestedComponent()) continue;
                MutableTaskContainer mutableTaskContainer = creationConfig.getTaskContainer();
                subAssembleTasks.add(mutableTaskContainer.getAssembleTask());
                if (!componentType.isBaseModule()) continue;
                subBundleTasks.add(mutableTaskContainer.getBundleTask());
            }
        }
        if (!((Collection)subAssembleTasks).isEmpty()) {
            this.taskFactory.configure("assemble", (Action<? super Task>)new Action(subAssembleTasks){
                final /* synthetic */ List<TaskProvider<? extends Task>> $subAssembleTasks;
                {
                    this.$subAssembleTasks = $subAssembleTasks;
                }

                public final void execute(Task task) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    task.setDescription("Assemble main outputs for all the variants.");
                    task.setGroup("build");
                    Object[] objectArray = new Object[]{this.$subAssembleTasks};
                    task.dependsOn(objectArray);
                }
            });
        }
        if (!((Collection)subBundleTasks).isEmpty()) {
            this.taskFactory.register("bundle", (Action<? super Task>)new Action(subBundleTasks){
                final /* synthetic */ List<TaskProvider<? extends Task>> $subBundleTasks;
                {
                    this.$subBundleTasks = $subBundleTasks;
                }

                public final void execute(Task task) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    task.setDescription("Assemble bundles for all the variants.");
                    task.setGroup("build");
                    Object[] objectArray = new Object[]{this.$subBundleTasks};
                    task.dependsOn(objectArray);
                }
            });
        }
    }

    protected abstract void doCreateTasksForVariant(@NotNull ComponentInfo<VariantBuilderT, VariantT> var1);

    public static final /* synthetic */ List access$getNestedComponents$p(VariantTaskManager $this) {
        return $this.nestedComponents;
    }

    public static final /* synthetic */ void access$configureKotlinKaptTasksForDataBinding(VariantTaskManager $this, Project project, String version) {
        $this.configureKotlinKaptTasksForDataBinding(project, version);
    }

    public static final /* synthetic */ void access$configureKaptTaskInScopeForDataBinding(VariantTaskManager $this, ComponentCreationConfig creationConfig, Task kaptTask) {
        $this.configureKaptTaskInScopeForDataBinding(creationConfig, kaptTask);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/VariantTaskManager$Companion;", "", "<init>", "()V", "MULTIDEX_VERSION", "", "COM_ANDROID_SUPPORT_MULTIDEX", "ANDROIDX_MULTIDEX_MULTIDEX", "COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION", "ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

