/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.build;

import com.android.build.gradle.internal.cxx.build.CxxBuilder;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.cxx.io.IoUtilsKt;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRepublishBuilder;", "Lcom/android/build/gradle/internal/cxx/build/CxxBuilder;", "model", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "<init>", "(Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;)V", "getModel", "()Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "objFolder", "Ljava/io/File;", "getObjFolder", "()Ljava/io/File;", "soFolder", "getSoFolder", "build", "", "ops", "Lorg/gradle/process/ExecOperations;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nCxxRepublishBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CxxRepublishBuilder.kt\ncom/android/build/gradle/internal/cxx/build/CxxRepublishBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n626#2,12:89\n*S KotlinDebug\n*F\n+ 1 CxxRepublishBuilder.kt\ncom/android/build/gradle/internal/cxx/build/CxxRepublishBuilder\n*L\n51#1:89,12\n*E\n"})
public final class CxxRepublishBuilder
implements CxxBuilder {
    @NotNull
    private final CxxConfigurationModel model;

    public CxxRepublishBuilder(@NotNull CxxConfigurationModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
    }

    @NotNull
    public final CxxConfigurationModel getModel() {
        return this.model;
    }

    @NotNull
    public final File getObjFolder() {
        return ((CxxAbiModel)CollectionsKt.first((List)CollectionsKt.plus((Collection)this.model.getActiveAbis(), (Iterable)this.model.getUnusedAbis()))).getIntermediatesParentFolder();
    }

    @NotNull
    public final File getSoFolder() {
        return ((CxxAbiModel)CollectionsKt.first((List)CollectionsKt.plus((Collection)this.model.getActiveAbis(), (Iterable)this.model.getUnusedAbis()))).getIntermediatesParentFolder();
    }

    @Override
    public void build(@NotNull ExecOperations ops) {
        Intrinsics.checkNotNullParameter((Object)ops, (String)"ops");
        LoggingEnvironmentKt.infoln("link or copy build outputs to republish point", new Object[0]);
        List<CxxAbiModel> abis = this.model.getActiveAbis();
        List<NativeBuildConfigValueMini> miniConfigs = AndroidBuildGradleJsons.getNativeBuildMiniConfigs(abis, null);
        for (NativeBuildConfigValueMini config2 : miniConfigs) {
            for (NativeLibraryValueMini library : config2.libraries.values()) {
                File baseOutputLibrary;
                if (library.output == null) continue;
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)baseOutputLibrary), (Object)"") && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)baseOutputLibrary), (Object)"so")) {
                    LoggingEnvironmentKt.infoln("Not republishing " + baseOutputLibrary + " because it wasn't an executable type", new Object[0]);
                    continue;
                }
                Iterable $this$single$iv = abis;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    CxxAbiModel it = (CxxAbiModel)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)CxxAbiModelKt.getName(it), (Object)library.abi)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                CxxAbiModel abi = single$iv;
                String string = baseOutputLibrary.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
                String string2 = abi.getSoFolder().getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
                if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                    LoggingEnvironmentKt.infoln("Not republishing " + baseOutputLibrary + " because it wasn't under " + abi.getSoFolder(), new Object[0]);
                    continue;
                }
                File subfolderSegment = FilesKt.relativeTo((File)baseOutputLibrary, (File)abi.getSoFolder());
                File republishOutputLibrary = FilesKt.resolve((File)abi.getSoRepublishFolder(), (File)subfolderSegment).getCanonicalFile();
                Intrinsics.checkNotNull((Object)republishOutputLibrary);
                IoUtilsKt.synchronizeFile$default(baseOutputLibrary, republishOutputLibrary, null, 4, null);
                for (File runtimeFile : library.runtimeFiles) {
                    Intrinsics.checkNotNull((Object)runtimeFile);
                    File file = abi.getSoRepublishFolder();
                    String string3 = runtimeFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    IoUtilsKt.synchronizeFile$default(runtimeFile, FilesKt.resolve((File)file, (String)string3), null, 4, null);
                }
            }
        }
        for (CxxAbiModel abi : this.model.getActiveAbis()) {
            if (abi.getStlLibraryFile() == null || !abi.getStlLibraryFile().isFile() || !abi.getSoRepublishFolder().isDirectory()) continue;
            File file = abi.getSoRepublishFolder();
            String string = abi.getStlLibraryFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            File objAbi = FilesKt.resolve((File)file, (String)string);
            IoUtilsKt.synchronizeFile$default(abi.getStlLibraryFile(), objAbi, null, 4, null);
        }
    }
}

