/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.impl.SingleArtifactContainer;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.AndroidAttributes;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.AndroidArtifactsUtilKt;
import com.android.build.gradle.internal.publishing.ComponentPublishingInfo;
import com.android.build.gradle.internal.publishing.PublishedConfigSpec;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.publishing.VariantPublishingInfo;
import com.android.build.gradle.internal.scope.BuildArtifactSpec;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u001a,\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u001a\u001a\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a@\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u00a8\u0006\u001c"}, d2={"publishArtifactToConfiguration", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "file", "", "artifactType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;", "attributes", "Lcom/android/build/gradle/internal/dependency/AndroidAttributes;", "publishArtifactToDefaultVariant", "classifier", "", "getConfigurationVariantName", "publishBuildArtifacts", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "publishInfo", "Lcom/android/build/gradle/internal/publishing/VariantPublishingInfo;", "publishIntermediateArtifact", "artifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "configSpecs", "", "Lcom/android/build/gradle/internal/publishing/PublishedConfigSpec;", "libraryElements", "Lorg/gradle/api/attributes/LibraryElements;", "gradle-core"})
@JvmName(name="ArtifactPublishingUtil")
@SourceDebugExtension(value={"SMAP\nArtifactPublishingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactPublishingUtil.kt\ncom/android/build/gradle/internal/scope/ArtifactPublishingUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1755#2,3:211\n1557#2:214\n1628#2,3:215\n1557#2:218\n1628#2,3:219\n*S KotlinDebug\n*F\n+ 1 ArtifactPublishingUtil.kt\ncom/android/build/gradle/internal/scope/ArtifactPublishingUtil\n*L\n119#1:211,3\n128#1:214\n128#1:215,3\n140#1:218\n140#1:219,3\n*E\n"})
public final class ArtifactPublishingUtil {
    @JvmOverloads
    public static final void publishArtifactToConfiguration(@NotNull Configuration configuration, @NotNull Object file, @NotNull AndroidArtifacts.ArtifactType artifactType, @Nullable AndroidAttributes attributes2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)artifactType), (String)"artifactType");
        String string = artifactType.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        String type = string;
        configuration.getOutgoing().variants(new Action(artifactType, attributes2, file, type){
            final /* synthetic */ AndroidArtifacts.ArtifactType $artifactType;
            final /* synthetic */ AndroidAttributes $attributes;
            final /* synthetic */ Object $file;
            final /* synthetic */ String $type;
            {
                this.$artifactType = $artifactType;
                this.$attributes = $attributes;
                this.$file = $file;
                this.$type = $type;
            }

            public final void execute(NamedDomainObjectContainer<ConfigurationVariant> variants) {
                Intrinsics.checkNotNullParameter(variants, (String)"variants");
                variants.create(ArtifactPublishingUtil.access$getConfigurationVariantName(this.$artifactType, this.$attributes), new Action(this.$file, this.$type, this.$attributes){
                    final /* synthetic */ Object $file;
                    final /* synthetic */ String $type;
                    final /* synthetic */ AndroidAttributes $attributes;
                    {
                        this.$file = $file;
                        this.$type = $type;
                        this.$attributes = $attributes;
                    }

                    public final void execute(ConfigurationVariant variant) {
                        block0: {
                            variant.artifact(this.$file, new Action(this.$type){
                                final /* synthetic */ String $type;
                                {
                                    this.$type = $type;
                                }

                                public final void execute(ConfigurablePublishArtifact artifact) {
                                    artifact.setType(this.$type);
                                }
                            });
                            AttributeContainer attributeContainer = variant.getAttributes();
                            AndroidAttributes androidAttributes = this.$attributes;
                            AttributeContainer container = attributeContainer;
                            boolean bl = false;
                            AndroidAttributes androidAttributes2 = androidAttributes;
                            if (androidAttributes2 == null) break block0;
                            Intrinsics.checkNotNull((Object)container);
                            androidAttributes2.addAttributesToContainer(container);
                        }
                    }
                });
            }
        });
    }

    public static /* synthetic */ void publishArtifactToConfiguration$default(Configuration configuration, Object object, AndroidArtifacts.ArtifactType artifactType, AndroidAttributes androidAttributes, int n, Object object2) {
        if ((n & 8) != 0) {
            androidAttributes = null;
        }
        ArtifactPublishingUtil.publishArtifactToConfiguration(configuration, object, artifactType, androidAttributes);
    }

    @JvmOverloads
    public static final void publishArtifactToDefaultVariant(@NotNull Configuration configuration, @NotNull Object file, @NotNull AndroidArtifacts.ArtifactType artifactType, @Nullable String classifier) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)artifactType), (String)"artifactType");
        String string = artifactType.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        String type = string;
        configuration.getOutgoing().artifact(file, new Action(type, classifier){
            final /* synthetic */ String $type;
            final /* synthetic */ String $classifier;
            {
                this.$type = $type;
                this.$classifier = $classifier;
            }

            public final void execute(ConfigurablePublishArtifact artifact) {
                block0: {
                    artifact.setType(this.$type);
                    String string = this.$classifier;
                    if (string == null) break block0;
                    String string2 = string;
                    String string3 = this.$classifier;
                    String it = string2;
                    boolean bl = false;
                    artifact.setClassifier(string3);
                }
            }
        });
    }

    public static /* synthetic */ void publishArtifactToDefaultVariant$default(Configuration configuration, Object object, AndroidArtifacts.ArtifactType artifactType, String string, int n, Object object2) {
        if ((n & 8) != 0) {
            string = null;
        }
        ArtifactPublishingUtil.publishArtifactToDefaultVariant(configuration, object, artifactType, string);
    }

    private static final String getConfigurationVariantName(AndroidArtifacts.ArtifactType artifactType, AndroidAttributes attributes2) {
        String string = artifactType.getType();
        Object object = attributes2;
        if (object == null || (object = ((AndroidAttributes)object).toAttributeMapString()) == null) {
            object = "";
        }
        return string + (String)object;
    }

    /*
     * WARNING - void declaration
     */
    public static final void publishBuildArtifacts(@NotNull ComponentCreationConfig creationConfig, @Nullable VariantPublishingInfo publishInfo) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        for (PublishingSpecs.OutputSpec outputSpec : PublishingSpecs.Companion.getVariantPublishingSpec(creationConfig.getComponentType()).getOutputs()) {
            LibraryElements libraryElements;
            String $this$mapTo$iv$iv;
            void $this$map$iv;
            LibraryElements libraryElements2;
            Collection<PublishedConfigSpec> collection;
            ComponentCreationConfig componentCreationConfig;
            Provider<? extends FileSystemLocation> provider2;
            AndroidArtifacts.ArtifactType artifactType;
            ComponentPublishingInfo component22;
            Iterable<ComponentPublishingInfo> components2;
            boolean isPublicationConfigs;
            Provider<? extends FileSystemLocation> artifactProvider;
            block13: {
                boolean bl;
                Artifact.Single<? extends FileSystemLocation> buildArtifactType = outputSpec.getOutputType();
                if (BuildArtifactSpec.Companion.has((Artifact)buildArtifactType) && BuildArtifactSpec.Companion.get((Artifact)buildArtifactType).getAppendable()) {
                    throw new RuntimeException("Appendable ArtifactType '" + buildArtifactType.name() + "' cannot be published.");
                }
                artifactProvider = creationConfig.getArtifacts().get(buildArtifactType);
                SingleArtifactContainer<? extends FileSystemLocation> artifactContainer = creationConfig.getArtifacts().getArtifactContainer$gradle_core(buildArtifactType);
                if (artifactContainer.needInitialProducer().get()) continue;
                Iterable $this$any$iv = (Iterable)outputSpec.getPublishedConfigTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AndroidArtifacts.PublishedConfigType it = (AndroidArtifacts.PublishedConfigType)((Object)element$iv);
                        boolean bl2 = false;
                        if (!it.isPublicationConfig()) continue;
                        bl = true;
                        break block13;
                    }
                    bl = isPublicationConfigs = false;
                }
            }
            if (isPublicationConfigs) {
                VariantPublishingInfo variantPublishingInfo = publishInfo;
                Intrinsics.checkNotNull((Object)variantPublishingInfo);
                components2 = variantPublishingInfo.getComponents();
                for (ComponentPublishingInfo component22 : components2) {
                    LibraryElements libraryElements3;
                    String $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Object element$iv;
                    element$iv = (Iterable)outputSpec.getPublishedConfigTypes();
                    artifactType = outputSpec.getArtifactType();
                    provider2 = artifactProvider;
                    componentCreationConfig = creationConfig;
                    boolean $i$f$map = false;
                    void bl2 = $this$map$iv2;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
                    while (iterator2.hasNext()) {
                        void it;
                        Object item$iv$iv = iterator2.next();
                        AndroidArtifacts.PublishedConfigType publishedConfigType = (AndroidArtifacts.PublishedConfigType)((Object)item$iv$iv);
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(new PublishedConfigSpec((AndroidArtifacts.PublishedConfigType)it, component22));
                    }
                    collection = (List)destination$iv$iv;
                    ComponentCreationConfig componentCreationConfig2 = componentCreationConfig;
                    Provider<? extends FileSystemLocation> provider3 = provider2;
                    AndroidArtifacts.ArtifactType artifactType2 = artifactType;
                    Collection collection2 = CollectionsKt.toSet((Iterable)collection);
                    if (outputSpec.getLibraryElements() != null) {
                        void it;
                        collection = collection2;
                        artifactType = artifactType2;
                        provider2 = provider3;
                        componentCreationConfig = componentCreationConfig2;
                        boolean bl = false;
                        libraryElements2 = creationConfig.getServices().named(LibraryElements.class, (String)it);
                        componentCreationConfig2 = componentCreationConfig;
                        provider3 = provider2;
                        artifactType2 = artifactType;
                        collection2 = collection;
                        libraryElements3 = libraryElements2;
                    } else {
                        libraryElements3 = null;
                    }
                    ArtifactPublishingUtil.publishIntermediateArtifact(componentCreationConfig2, provider3, artifactType2, collection2, libraryElements3);
                }
                continue;
            }
            components2 = (Iterable)outputSpec.getPublishedConfigTypes();
            artifactType = outputSpec.getArtifactType();
            provider2 = artifactProvider;
            componentCreationConfig = creationConfig;
            boolean $i$f$map = false;
            component22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it;
                Object item$iv$iv = iterator3.next();
                AndroidArtifacts.PublishedConfigType $i$f$mapTo2 = (AndroidArtifacts.PublishedConfigType)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new PublishedConfigSpec((AndroidArtifacts.PublishedConfigType)it, null, false, 6, null));
            }
            collection = (List)destination$iv$iv;
            ComponentCreationConfig componentCreationConfig3 = componentCreationConfig;
            Provider<? extends FileSystemLocation> provider4 = provider2;
            AndroidArtifacts.ArtifactType artifactType3 = artifactType;
            Collection collection3 = CollectionsKt.toSet((Iterable)collection);
            if (outputSpec.getLibraryElements() != null) {
                void it;
                collection = collection3;
                artifactType = artifactType3;
                provider2 = provider4;
                componentCreationConfig = componentCreationConfig3;
                boolean bl = false;
                libraryElements2 = creationConfig.getServices().named(LibraryElements.class, (String)it);
                componentCreationConfig3 = componentCreationConfig;
                provider4 = provider2;
                artifactType3 = artifactType;
                collection3 = collection;
                libraryElements = libraryElements2;
            } else {
                libraryElements = null;
            }
            ArtifactPublishingUtil.publishIntermediateArtifact(componentCreationConfig3, provider4, artifactType3, collection3, libraryElements);
        }
    }

    private static final void publishIntermediateArtifact(ComponentCreationConfig creationConfig, Provider<? extends FileSystemLocation> artifact, AndroidArtifacts.ArtifactType artifactType, Set<PublishedConfigSpec> configSpecs, LibraryElements libraryElements) {
        Preconditions.checkState((!((Collection)configSpecs).isEmpty() ? 1 : 0) != 0);
        for (PublishedConfigSpec configSpec : configSpecs) {
            Map map;
            Configuration config2 = creationConfig.getVariantDependencies().getElements(configSpec);
            AndroidArtifacts.PublishedConfigType configType = configSpec.getConfigType();
            if (config2 == null) continue;
            if (configType.isPublicationConfig()) {
                boolean isJavaDocPublication;
                Object classifier = null;
                boolean isSourcePublication = configType == AndroidArtifacts.PublishedConfigType.SOURCE_PUBLICATION;
                boolean bl = isJavaDocPublication = configType == AndroidArtifacts.PublishedConfigType.JAVA_DOC_PUBLICATION;
                if (configSpec.isClassifierRequired()) {
                    classifier = isSourcePublication ? creationConfig.getName() + "-sources" : (isJavaDocPublication ? creationConfig.getName() + "-javadoc" : creationConfig.getName());
                } else if (creationConfig.getComponentType().isTestFixturesComponent()) {
                    classifier = "test-fixtures";
                } else if (isSourcePublication) {
                    classifier = "sources";
                } else if (isJavaDocPublication) {
                    classifier = "javadoc";
                }
                ArtifactPublishingUtil.publishArtifactToDefaultVariant(config2, artifact, artifactType, (String)classifier);
                continue;
            }
            Configuration configuration = config2;
            Provider<? extends FileSystemLocation> provider2 = artifact;
            AndroidArtifacts.ArtifactType artifactType2 = artifactType;
            AndroidArtifacts.ArtifactType artifactType3 = artifactType;
            if (libraryElements != null) {
                AndroidArtifacts.ArtifactType artifactType4 = artifactType3;
                AndroidArtifacts.ArtifactType artifactType5 = artifactType2;
                Provider<? extends FileSystemLocation> provider3 = provider2;
                Configuration configuration2 = configuration;
                boolean bl = false;
                Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)libraryElements));
                configuration = configuration2;
                provider2 = provider3;
                artifactType2 = artifactType5;
                artifactType3 = artifactType4;
                map = map2;
            } else {
                map = null;
            }
            ArtifactPublishingUtil.publishArtifactToConfiguration(configuration, provider2, artifactType2, AndroidArtifactsUtilKt.getAttributes(artifactType3, map, (Function2<? super Class<? extends Named>, ? super String, ? extends Named>)((Function2)new Function2<Class<? extends Named>, String, Named>(creationConfig){
                final /* synthetic */ ComponentCreationConfig $creationConfig;
                {
                    this.$creationConfig = $creationConfig;
                    super(2);
                }

                public final Named invoke(Class<? extends Named> type, String name) {
                    Intrinsics.checkNotNullParameter(type, (String)"type");
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    return this.$creationConfig.getServices().named(type, name);
                }
            })));
        }
    }

    @JvmOverloads
    public static final void publishArtifactToConfiguration(@NotNull Configuration configuration, @NotNull Object file, @NotNull AndroidArtifacts.ArtifactType artifactType) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)artifactType), (String)"artifactType");
        ArtifactPublishingUtil.publishArtifactToConfiguration$default(configuration, file, artifactType, null, 8, null);
    }

    @JvmOverloads
    public static final void publishArtifactToDefaultVariant(@NotNull Configuration configuration, @NotNull Object file, @NotNull AndroidArtifacts.ArtifactType artifactType) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)artifactType), (String)"artifactType");
        ArtifactPublishingUtil.publishArtifactToDefaultVariant$default(configuration, file, artifactType, null, 8, null);
    }

    public static final /* synthetic */ String access$getConfigurationVariantName(AndroidArtifacts.ArtifactType artifactType, AndroidAttributes attributes2) {
        return ArtifactPublishingUtil.getConfigurationVariantName(artifactType, attributes2);
    }
}

