/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.ShrinkerVersion;
import com.android.ide.common.gradle.Version;
import java.io.Serializable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00132\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\t\u0010\f\u001a\u00020\u0004H\u00c2\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0012\u001a\u00020\bH\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/dependency/ShrinkerVersion;", "Ljava/io/Serializable;", "", "version", "Lcom/android/ide/common/gradle/Version;", "<init>", "(Lcom/android/ide/common/gradle/Version;)V", "asString", "", "compareTo", "", "other", "component1", "copy", "equals", "", "", "hashCode", "toString", "Companion", "gradle-core"})
public final class ShrinkerVersion
implements Serializable,
Comparable<ShrinkerVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Version version;
    @NotNull
    private static final Lazy<ShrinkerVersion> R8$delegate = LazyKt.lazy((Function0)Companion.R8.2.INSTANCE);
    @NotNull
    private static final String R8_MAIN_VERSION = "9999.0.0-dev";
    @NotNull
    private static final Regex versionPattern = new Regex("[^\\s.]+(?:\\.[^\\s.]+)+");

    public ShrinkerVersion(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.version = version;
    }

    @NotNull
    public final String asString() {
        return this.version.toString();
    }

    @Override
    public int compareTo(@NotNull ShrinkerVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.version.compareTo(other.version);
    }

    private final Version component1() {
        return this.version;
    }

    @NotNull
    public final ShrinkerVersion copy(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new ShrinkerVersion(version);
    }

    public static /* synthetic */ ShrinkerVersion copy$default(ShrinkerVersion shrinkerVersion, Version version, int n, Object object) {
        if ((n & 1) != 0) {
            version = shrinkerVersion.version;
        }
        return shrinkerVersion.copy(version);
    }

    @NotNull
    public String toString() {
        return "ShrinkerVersion(version=" + this.version + ")";
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShrinkerVersion)) {
            return false;
        }
        ShrinkerVersion shrinkerVersion = (ShrinkerVersion)other;
        return Intrinsics.areEqual((Object)this.version, (Object)shrinkerVersion.version);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u000bR\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/dependency/ShrinkerVersion$Companion;", "", "<init>", "()V", "R8", "Lcom/android/build/gradle/internal/dependency/ShrinkerVersion;", "getR8", "()Lcom/android/build/gradle/internal/dependency/ShrinkerVersion;", "R8$delegate", "Lkotlin/Lazy;", "R8_MAIN_VERSION", "", "versionPattern", "Lkotlin/text/Regex;", "parse", "version", "tryParse", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nShrinkerVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShrinkerVersion.kt\ncom/android/build/gradle/internal/dependency/ShrinkerVersion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShrinkerVersion getR8() {
            Lazy lazy = R8$delegate;
            return (ShrinkerVersion)lazy.getValue();
        }

        @NotNull
        public final ShrinkerVersion parse(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            ShrinkerVersion shrinkerVersion = this.tryParse(version);
            if (shrinkerVersion == null) {
                throw new IllegalStateException(("Unrecognized version: " + version).toString());
            }
            return shrinkerVersion;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final ShrinkerVersion tryParse(@NotNull String version) {
            ShrinkerVersion shrinkerVersion;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            if (StringsKt.startsWith$default((String)version, (String)"main", (boolean)false, (int)2, null)) {
                shrinkerVersion = new ShrinkerVersion(Version.Companion.parse(ShrinkerVersion.R8_MAIN_VERSION));
                return shrinkerVersion;
            } else {
                MatchResult matchResult = Regex.find$default((Regex)versionPattern, (CharSequence)version, (int)0, (int)2, null);
                if (matchResult == null) return null;
                MatchResult matchResult2 = matchResult;
                boolean bl = false;
                String string = (String)matchResult2.getGroupValues().get(0);
                if (string == null) return null;
                String it = string;
                boolean bl2 = false;
                Version version2 = Version.Companion.parse(it);
                if (version2 == null) return null;
                it = version2;
                boolean bl3 = false;
                shrinkerVersion = new ShrinkerVersion((Version)it);
            }
            return shrinkerVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

