/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.matcher;

import com.android.build.gradle.internal.matcher.GlobPathMatcherFactory;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/matcher/FileExtensionWithPrefixPathMatcher;", "Ljava/nio/file/PathMatcher;", "matcher", "Ljava/util/regex/Matcher;", "<init>", "(Ljava/util/regex/Matcher;)V", "getMatcher", "()Ljava/util/regex/Matcher;", "prefix", "", "getPrefix", "()Ljava/lang/String;", "extension", "getExtension", "matches", "", "p0", "Ljava/nio/file/Path;", "Companion", "gradle-core"})
public class FileExtensionWithPrefixPathMatcher
implements PathMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Matcher matcher;
    @NotNull
    private final String prefix;
    @NotNull
    private final String extension;
    @NotNull
    private static final Pattern pattern;

    public FileExtensionWithPrefixPathMatcher(@NotNull Matcher matcher) {
        String string;
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this.matcher = matcher;
        if (!this.matcher.matches()) {
            throw new IllegalArgumentException("matcher " + this.matcher + " does not match this factory");
        }
        String string2 = this.matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        this.prefix = string2;
        if (this.matcher.groupCount() > 1) {
            String string3 = this.matcher.group(2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
        } else {
            string = "";
        }
        this.extension = string;
    }

    @NotNull
    public final Matcher getMatcher() {
        return this.matcher;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @Override
    public boolean matches(@Nullable Path p0) {
        Object object = p0;
        if (object == null || (object = object.toString()) == null || (object = StringsKt.replace$default((String)object, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null)) == null) {
            return false;
        }
        Object pathAsString = object;
        return StringsKt.startsWith$default((String)pathAsString, (String)this.prefix, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)((CharSequence)pathAsString), (char)'/', (int)this.prefix.length(), (boolean)false, (int)4, null) == -1 && StringsKt.endsWith$default((String)pathAsString, (String)this.extension, (boolean)false, (int)2, null);
    }

    static {
        Pattern pattern = Pattern.compile("(/[^*{}]*/)\\*\\.([^*/{}]*)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        FileExtensionWithPrefixPathMatcher.pattern = pattern;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/matcher/FileExtensionWithPrefixPathMatcher$Companion;", "", "<init>", "()V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "factory", "Lcom/android/build/gradle/internal/matcher/GlobPathMatcherFactory;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        @NotNull
        public final GlobPathMatcherFactory factory() {
            return new GlobPathMatcherFactory(){

                public FileExtensionWithPrefixPathMatcher build(Matcher glob) {
                    Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
                    return new FileExtensionWithPrefixPathMatcher(glob);
                }

                public Pattern pattern() {
                    return FileExtensionWithPrefixPathMatcher.Companion.getPattern();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

