/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.r8;

import com.android.build.gradle.internal.dependency.ShrinkerVersion;
import com.android.build.gradle.internal.r8.LegacyProguardRules;
import com.android.build.gradle.internal.r8.TargetedR8Rules;
import com.android.build.gradle.internal.r8.VersionedR8Rules;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005*\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/r8/TargetedR8RulesReadWriter;", "", "<init>", "()V", "createJarContents", "", "", "", "Lcom/android/build/gradle/internal/r8/TargetedR8Rules;", "isClassesJarInAar", "", "readFromJar", "jarFile", "Ljava/io/File;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nTargetedR8Rules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetedR8Rules.kt\ncom/android/build/gradle/internal/r8/TargetedR8RulesReadWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1187#2,2:204\n1261#2,4:206\n1187#2,2:210\n1261#2,4:212\n1#3:216\n*S KotlinDebug\n*F\n+ 1 TargetedR8Rules.kt\ncom/android/build/gradle/internal/r8/TargetedR8RulesReadWriter\n*L\n156#1:204,2\n156#1:206,4\n158#1:210,2\n158#1:212,4\n*E\n"})
public final class TargetedR8RulesReadWriter {
    @NotNull
    public static final TargetedR8RulesReadWriter INSTANCE = new TargetedR8RulesReadWriter();

    private TargetedR8RulesReadWriter() {
    }

    @NotNull
    public final Map<String, byte[]> createJarContents(@NotNull TargetedR8Rules $this$createJarContents, boolean isClassesJarInAar) {
        Map map;
        Object it;
        Map map2;
        Iterable $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createJarContents, (String)"<this>");
        Iterable $this$associate$iv = $this$createJarContents.getR8Rules();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map2 = destination$iv$iv;
            it = (VersionedR8Rules)element$iv$iv;
            boolean bl = false;
            String string = ((VersionedR8Rules)it).getRelativeFilePath();
            byte[] byArray = ((VersionedR8Rules)it).getR8Rules().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            it = TuplesKt.to((Object)string, (Object)byArray);
            map2.put(it.getFirst(), it.getSecond());
        }
        Map map3 = destination$iv$iv;
        if (isClassesJarInAar) {
            map = MapsKt.emptyMap();
        } else {
            $this$associate$iv = $this$createJarContents.getLegacyProguardRules();
            Map map4 = map3;
            $i$f$associate = false;
            capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            $this$associateTo$iv$iv = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                map2 = destination$iv$iv;
                it = (LegacyProguardRules)element$iv$iv;
                boolean bl = false;
                String string = ((LegacyProguardRules)it).getRelativeFilePath(false);
                byte[] byArray = ((LegacyProguardRules)it).getLegacyProguardRules().getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                Pair pair = TuplesKt.to((Object)string, (Object)byArray);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
            map3 = map4;
        }
        return MapsKt.plus((Map)map3, (Map)map);
    }

    public static /* synthetic */ Map createJarContents$default(TargetedR8RulesReadWriter targetedR8RulesReadWriter, TargetedR8Rules targetedR8Rules, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return targetedR8RulesReadWriter.createJarContents(targetedR8Rules, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TargetedR8Rules readFromJar(@NotNull File jarFile, boolean isClassesJarInAar) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        List r8Rules = new ArrayList();
        List legacyProguardRules = new ArrayList();
        Closeable closeable = new FileInputStream(jarFile);
        int n = 8192;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ZipInputStream zipInputStream = (ZipInputStream)closeable;
            boolean bl = false;
            while (zipInputStream.getNextEntry() != null) {
                MatchResult matchResult;
                ZipEntry zipEntry;
                Regex regex = VersionedR8Rules.Companion.getRelativeFilePathRegex();
                String string = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (regex.matchEntire((CharSequence)string) != null) {
                    ShrinkerVersion shrinkerVersion;
                    Object object;
                    ShrinkerVersion shrinkerVersion2;
                    Object it;
                    List list;
                    MatchResult matchResult2;
                    boolean bl2 = false;
                    List list2 = r8Rules;
                    Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"minVersion");
                    if (object2 != null && (object2 = object2.getValue()) != null) {
                        Object object3 = object2;
                        list = list2;
                        boolean bl3 = false;
                        shrinkerVersion2 = ShrinkerVersion.Companion.tryParse((String)it);
                        list2 = list;
                    } else {
                        shrinkerVersion2 = null;
                    }
                    if ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"maxVersionExclusive")) != null && (object = object.getValue()) != null) {
                        it = object;
                        ShrinkerVersion shrinkerVersion3 = shrinkerVersion2;
                        list = list2;
                        boolean bl4 = false;
                        ShrinkerVersion shrinkerVersion4 = ShrinkerVersion.Companion.tryParse((String)it);
                        list2 = list;
                        shrinkerVersion2 = shrinkerVersion3;
                        shrinkerVersion = shrinkerVersion4;
                    } else {
                        shrinkerVersion = null;
                    }
                    MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"fileName");
                    Intrinsics.checkNotNull((Object)matchGroup);
                    String string2 = StringsKt.decodeToString((byte[])ByteStreamsKt.readBytes((InputStream)zipInputStream));
                    String string3 = matchGroup.getValue();
                    ShrinkerVersion shrinkerVersion5 = shrinkerVersion;
                    ShrinkerVersion shrinkerVersion6 = shrinkerVersion2;
                    list2.add(new VersionedR8Rules(shrinkerVersion6, shrinkerVersion5, string3, string2));
                    continue;
                }
                if (isClassesJarInAar) continue;
                Regex regex2 = LegacyProguardRules.Companion.getLegacyProguardRulesRelativeFilePathRegexForJar();
                String string4 = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                if (regex2.matchEntire((CharSequence)string4) == null) continue;
                boolean bl5 = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"fileName");
                Intrinsics.checkNotNull((Object)matchGroup);
                legacyProguardRules.add(new LegacyProguardRules(matchGroup.getValue(), StringsKt.decodeToString((byte[])ByteStreamsKt.readBytes((InputStream)zipInputStream))));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new TargetedR8Rules(r8Rules, legacyProguardRules);
    }

    public static /* synthetic */ TargetedR8Rules readFromJar$default(TargetedR8RulesReadWriter targetedR8RulesReadWriter, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return targetedR8RulesReadWriter.readFromJar(file, bl);
    }
}

