/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.InputData;
import com.android.build.gradle.internal.tasks.JavaResMergingPriority;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableInputChanges;
import com.android.builder.files.ZipSnapshot;
import com.android.builder.files.ZipSnapshotRepository;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInputs;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a.\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a8\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\u001a0\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\u001aJ\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001f\u001a\u00020 H\u0000\u001a\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\""}, d2={"toIncrementalInput", "Lcom/android/builder/merge/IncrementalFileMergerInput;", "input", "Ljava/io/File;", "name", "", "changedInputs", "", "Lcom/android/ide/common/resources/FileStatus;", "zipCache", "Lcom/android/builder/files/ZipSnapshotRepository;", "cacheUpdates", "", "Ljava/lang/Runnable;", "toNonIncrementalInput", "computeUpdatesFromJar", "Lcom/android/builder/files/RelativeFile;", "jar", "computeFilesFromJar", "", "computeUpdatesFromDir", "Lcom/google/common/collect/ImmutableMap;", "dir", "computeFilesFromDir", "toInputs", "Lcom/android/build/gradle/internal/tasks/JavaResMergingPriority;", "inputs", "", "Lcom/android/build/gradle/internal/tasks/InputData;", "changes", "Lcom/android/builder/files/SerializableInputChanges;", "full", "", "collectChanges", "gradle-core"})
@JvmName(name="IncrementalFileMergerTaskUtils")
@SourceDebugExtension(value={"SMAP\nIncrementalFileMergerTaskUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalFileMergerTaskUtils.kt\ncom/android/build/gradle/internal/tasks/IncrementalFileMergerTaskUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1#2:285\n1863#3,2:286\n*S KotlinDebug\n*F\n+ 1 IncrementalFileMergerTaskUtils.kt\ncom/android/build/gradle/internal/tasks/IncrementalFileMergerTaskUtils\n*L\n270#1:286,2\n*E\n"})
public final class IncrementalFileMergerTaskUtils {
    @NotNull
    public static final IncrementalFileMergerInput toIncrementalInput(@NotNull File input, @NotNull String name, @NotNull Map<File, ? extends FileStatus> changedInputs, @NotNull ZipSnapshotRepository zipCache, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(changedInputs, (String)"changedInputs");
        Intrinsics.checkNotNullParameter((Object)zipCache, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        String string = input.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            if (changedInputs.containsKey(input)) {
                Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(input, zipCache){
                    final /* synthetic */ File $input;
                    final /* synthetic */ ZipSnapshotRepository $zipCache;
                    {
                        this.$input = $input;
                        this.$zipCache = $zipCache;
                    }

                    public final void run() {
                        if (this.$input.isFile()) {
                            this.$zipCache.takeSnapshotOfZip(this.$input);
                        } else {
                            this.$zipCache.removeSnapshotOfZip(this.$input);
                        }
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"asRunnable(...)");
                cacheUpdates.add(runnable);
            }
            return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(name, new CachedSupplier(new Supplier(input, changedInputs, zipCache){
                final /* synthetic */ File $input;
                final /* synthetic */ Map<File, FileStatus> $changedInputs;
                final /* synthetic */ ZipSnapshotRepository $zipCache;
                {
                    this.$input = $input;
                    this.$changedInputs = $changedInputs;
                    this.$zipCache = $zipCache;
                }

                public final Map<RelativeFile, FileStatus> get() {
                    return IncrementalFileMergerTaskUtils.access$computeUpdatesFromJar(this.$input, this.$changedInputs, this.$zipCache);
                }
            }), new CachedSupplier(new Supplier(input){
                final /* synthetic */ File $input;
                {
                    this.$input = $input;
                }

                public final Set<RelativeFile> get() {
                    return IncrementalFileMergerTaskUtils.access$computeFilesFromJar(this.$input);
                }
            }));
        }
        Preconditions.checkState((!input.isFile() ? 1 : 0) != 0, (String)("Non-directory inputs must have .jar extension: " + input), (Object[])new Object[0]);
        return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(name, new CachedSupplier(new Supplier(input, changedInputs){
            final /* synthetic */ File $input;
            final /* synthetic */ Map<File, FileStatus> $changedInputs;
            {
                this.$input = $input;
                this.$changedInputs = $changedInputs;
            }

            public final Map<RelativeFile, FileStatus> get() {
                return (Map)IncrementalFileMergerTaskUtils.access$computeUpdatesFromDir(this.$input, this.$changedInputs);
            }
        }), new CachedSupplier(new Supplier(input){
            final /* synthetic */ File $input;
            {
                this.$input = $input;
            }

            public final Set<RelativeFile> get() {
                return IncrementalFileMergerTaskUtils.access$computeFilesFromDir(this.$input);
            }
        }));
    }

    @Nullable
    public static final IncrementalFileMergerInput toNonIncrementalInput(@NotNull File input, @NotNull String name, @NotNull ZipSnapshotRepository zipCache, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)zipCache, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        if (!input.isFile() && !input.isDirectory()) {
            return null;
        }
        if (input.isFile()) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache, input){
                final /* synthetic */ ZipSnapshotRepository $zipCache;
                final /* synthetic */ File $input;
                {
                    this.$zipCache = $zipCache;
                    this.$input = $input;
                }

                public final void run() {
                    this.$zipCache.takeSnapshotOfZip(this.$input);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"asRunnable(...)");
            cacheUpdates.add(runnable);
        }
        return (IncrementalFileMergerInput)LazyIncrementalFileMergerInputs.fromNew((String)name, (Set)((Set)ImmutableSet.of((Object)input)));
    }

    private static final Map<RelativeFile, FileStatus> computeUpdatesFromJar(File jar, Map<File, ? extends FileStatus> changedInputs, ZipSnapshotRepository zipCache) {
        if (changedInputs.containsKey(jar)) {
            FileStatus fileStatus = changedInputs.get(jar);
            try {
                Map map;
                FileStatus fileStatus2 = fileStatus;
                switch (fileStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fileStatus2.ordinal()]) {
                    case 1: {
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZipSnapshot((File)jar, (FileStatus)FileStatus.NEW);
                        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"fromZipSnapshot(...)");
                        map = (Map)immutableMap;
                        break;
                    }
                    case 2: {
                        ZipSnapshot zipSnapshot = zipCache.getLastSnapshotOfZip(jar);
                        if (zipSnapshot == null) {
                            throw new RuntimeException("File '" + jar + "' was deleted, but previous version not found in cache");
                        }
                        ZipSnapshot cached = zipSnapshot;
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZipSnapshot((ZipSnapshot)cached, (FileStatus)FileStatus.REMOVED);
                        Intrinsics.checkNotNull((Object)immutableMap);
                        map = (Map)immutableMap;
                        break;
                    }
                    case 3: {
                        Map map2 = IncrementalRelativeFileSets.fromZip((File)jar, (ZipSnapshotRepository)zipCache, (Set)new HashSet());
                        map = map2;
                        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"fromZip(...)");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected FileStatus: " + fileStatus));
                    }
                }
                return map;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ImmutableMap immutableMap = ImmutableMap.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
        return (Map)immutableMap;
    }

    private static final Set<RelativeFile> computeFilesFromJar(File jar) {
        if (!jar.isFile()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(...)");
            return (Set)immutableSet;
        }
        try {
            Set set = RelativeFiles.fromZip((File)jar);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fromZip(...)");
            return set;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static final ImmutableMap<RelativeFile, FileStatus> computeUpdatesFromDir(File dir, Map<File, ? extends FileStatus> changedInputs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<File, ? extends FileStatus> entry2 : changedInputs.entrySet()) {
            RelativeFile rf;
            File file = entry2.getKey();
            FileStatus status = entry2.getValue();
            if (!FileUtils.isFileInDirectory((File)file, (File)dir) || (rf = new RelativeFile(dir, file)).getFile().isDirectory()) continue;
            builder.put((Object)rf, (Object)status);
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"build(...)");
        return immutableMap;
    }

    private static final Set<RelativeFile> computeFilesFromDir(File dir) {
        if (!dir.isDirectory()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(...)");
            return (Set)immutableSet;
        }
        Set set = RelativeFiles.fromDirectory((File)dir);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fromDirectory(...)");
        return set;
    }

    @NotNull
    public static final ImmutableMap<IncrementalFileMergerInput, JavaResMergingPriority> toInputs(@NotNull List<InputData> inputs, @Nullable SerializableInputChanges changes, @NotNull ZipSnapshotRepository zipCache, @NotNull List<Runnable> cacheUpdates, boolean full) {
        Map<File, FileStatus> map;
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter((Object)zipCache, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        if (full) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache){
                final /* synthetic */ ZipSnapshotRepository $zipCache;
                {
                    this.$zipCache = $zipCache;
                }

                public final void run() {
                    this.$zipCache.clear();
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"asRunnable(...)");
            cacheUpdates.add(runnable);
        }
        SerializableInputChanges serializableInputChanges = changes;
        if (serializableInputChanges != null) {
            SerializableInputChanges it = serializableInputChanges;
            boolean bl = false;
            map = IncrementalFileMergerTaskUtils.collectChanges(it);
        } else {
            map = null;
        }
        Map<File, FileStatus> changedInputs = map;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (InputData input : inputs) {
            IncrementalFileMergerInput it;
            IncrementalFileMergerInput fileMergerInput;
            IncrementalFileMergerInput incrementalFileMergerInput;
            if (full) {
                incrementalFileMergerInput = IncrementalFileMergerTaskUtils.toNonIncrementalInput(input.getFile(), input.getSource(), zipCache, cacheUpdates);
            } else {
                Map<File, FileStatus> map2 = changedInputs;
                if (map2 == null) {
                    throw new IllegalArgumentException("changes must be specified for incremental merging.");
                }
                incrementalFileMergerInput = fileMergerInput = IncrementalFileMergerTaskUtils.toIncrementalInput(input.getFile(), input.getSource(), map2, zipCache, cacheUpdates);
            }
            if (fileMergerInput == null) continue;
            boolean bl = false;
            builder.put((Object)it, (Object)input.getPriority());
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"build(...)");
        return immutableMap;
    }

    private static final Map<File, FileStatus> collectChanges(SerializableInputChanges changes) {
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = changes.getChanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileStatus fileStatus;
            SerializableChange change = (SerializableChange)element$iv;
            boolean bl = false;
            FileStatus currentState = (FileStatus)map.get(change.getFile());
            FileStatus changeState = change.getFileStatus();
            if (currentState == null) {
                fileStatus = changeState;
            } else if (currentState == FileStatus.NEW && changeState == FileStatus.REMOVED) {
                fileStatus = FileStatus.CHANGED;
            } else if (currentState == FileStatus.REMOVED && changeState == FileStatus.NEW) {
                fileStatus = FileStatus.CHANGED;
            } else {
                throw new IllegalStateException("Unexpected combination of states " + currentState + ", " + changeState + " for file " + change.getFile());
            }
            FileStatus newState = fileStatus;
            map.put(change.getFile(), newState);
        }
        Map<File, FileStatus> map2 = Collections.unmodifiableMap(map);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        return map2;
    }

    public static final /* synthetic */ Map access$computeUpdatesFromJar(File jar, Map changedInputs, ZipSnapshotRepository zipCache) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromJar(jar, changedInputs, zipCache);
    }

    public static final /* synthetic */ Set access$computeFilesFromJar(File jar) {
        return IncrementalFileMergerTaskUtils.computeFilesFromJar(jar);
    }

    public static final /* synthetic */ ImmutableMap access$computeUpdatesFromDir(File dir, Map changedInputs) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromDir(dir, changedInputs);
    }

    public static final /* synthetic */ Set access$computeFilesFromDir(File dir) {
        return IncrementalFileMergerTaskUtils.computeFilesFromDir(dir);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileStatus.values().length];
            try {
                nArray[FileStatus.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileStatus.REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileStatus.CHANGED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

