/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.gnumake;

import com.android.build.gradle.external.gnumake.AbstractOsFileConventions;
import com.android.build.gradle.external.gnumake.BuildStepInfo;
import com.android.build.gradle.external.gnumake.CommandClassifier;
import com.android.build.gradle.external.gnumake.CommandLine;
import com.android.build.gradle.external.gnumake.FlowAnalyzer;
import com.android.build.gradle.external.gnumake.OsFileConventions;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.json.NativeSourceFileValue;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.utils.NativeSourceFileExtensions;
import com.android.utils.NdkUtils;
import com.android.utils.cxx.CompileCommandsCodecKt;
import com.android.utils.cxx.CompileCommandsEncoder;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u000234B+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ2\u0010\u001e\u001a\u00020\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fJ\u0010\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020&H\u0002J\b\u0010(\u001a\u00020$H\u0002J\b\u0010)\u001a\u00020$H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0002J\b\u0010,\u001a\u00020$H\u0002J\u0014\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00150\u0015H\u0002J\u0016\u0010.\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u0002000/H\u0002J\u0016\u00101\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u0002020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder;", "", "androidMk", "Ljava/io/File;", "executionRootPath", "compileCommandsJsonBinFile", "fileConventions", "Lcom/android/build/gradle/external/gnumake/OsFileConventions;", "<init>", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/external/gnumake/OsFileConventions;)V", "toolChainToCCompiler", "", "", "toolChainToCppCompiler", "cFileExtensions", "", "cppFileExtensions", "outputs", "", "Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Output;", "buildTargetsCommand", "", "skipProcessingCompilerFlags", "", "getSkipProcessingCompilerFlags", "()Z", "setSkipProcessingCompilerFlags", "(Z)V", "compileCommandsEncoder", "Lcom/android/utils/cxx/CompileCommandsEncoder;", "setCommands", "buildCommand", "cleanCommand", "variantName", "dryRunOutput", "extractWorkingDirectoryFromDryRunOutputIfAvailable", "", "build", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "buildImpl", "findLibraryNames", "findToolChainCompilers", "findToolChainName", "outputFileName", "findToolchainNames", "generateCleanCommands", "generateLibraries", "", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValue;", "generateToolchains", "Lcom/android/build/gradle/internal/cxx/json/NativeToolchainValue;", "Output", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNativeBuildConfigValueBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeBuildConfigValueBuilder.kt\ncom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1010#2,2:334\n1557#2:336\n1628#2,3:337\n1611#2,9:340\n1863#2:349\n1864#2:351\n1620#2:352\n1#3:350\n*S KotlinDebug\n*F\n+ 1 NativeBuildConfigValueBuilder.kt\ncom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder\n*L\n131#1:334,2\n282#1:336\n282#1:337,3\n289#1:340,9\n289#1:349\n289#1:351\n289#1:352\n289#1:350\n*E\n"})
public final class NativeBuildConfigValueBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File androidMk;
    @NotNull
    private File executionRootPath;
    @NotNull
    private final File compileCommandsJsonBinFile;
    @NotNull
    private final OsFileConventions fileConventions;
    @NotNull
    private final Map<String, String> toolChainToCCompiler;
    @NotNull
    private final Map<String, String> toolChainToCppCompiler;
    @NotNull
    private final Set<String> cFileExtensions;
    @NotNull
    private final Set<String> cppFileExtensions;
    @NotNull
    private final List<Output> outputs;
    @Nullable
    private List<String> buildTargetsCommand;
    private boolean skipProcessingCompilerFlags;
    private CompileCommandsEncoder compileCommandsEncoder;

    public NativeBuildConfigValueBuilder(@NotNull File androidMk, @NotNull File executionRootPath, @NotNull File compileCommandsJsonBinFile, @NotNull OsFileConventions fileConventions) {
        Intrinsics.checkNotNullParameter((Object)androidMk, (String)"androidMk");
        Intrinsics.checkNotNullParameter((Object)executionRootPath, (String)"executionRootPath");
        Intrinsics.checkNotNullParameter((Object)compileCommandsJsonBinFile, (String)"compileCommandsJsonBinFile");
        Intrinsics.checkNotNullParameter((Object)fileConventions, (String)"fileConventions");
        this.androidMk = androidMk;
        this.executionRootPath = executionRootPath;
        this.compileCommandsJsonBinFile = compileCommandsJsonBinFile;
        this.fileConventions = fileConventions;
        this.toolChainToCCompiler = new HashMap();
        this.toolChainToCppCompiler = new HashMap();
        this.cFileExtensions = new HashSet();
        this.cppFileExtensions = new HashSet();
        this.outputs = new ArrayList();
    }

    public /* synthetic */ NativeBuildConfigValueBuilder(File file, File file2, File file3, OsFileConventions osFileConventions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            OsFileConventions osFileConventions2 = AbstractOsFileConventions.createForCurrentHost();
            Intrinsics.checkNotNullExpressionValue((Object)osFileConventions2, (String)"createForCurrentHost(...)");
            osFileConventions = osFileConventions2;
        }
        this(file, file2, file3, osFileConventions);
    }

    public final boolean getSkipProcessingCompilerFlags() {
        return this.skipProcessingCompilerFlags;
    }

    public final void setSkipProcessingCompilerFlags(boolean bl) {
        this.skipProcessingCompilerFlags = bl;
    }

    @NotNull
    public final NativeBuildConfigValueBuilder setCommands(@NotNull List<String> buildCommand, @NotNull List<String> cleanCommand, @NotNull String variantName, @NotNull String dryRunOutput) {
        Intrinsics.checkNotNullParameter(buildCommand, (String)"buildCommand");
        Intrinsics.checkNotNullParameter(cleanCommand, (String)"cleanCommand");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)dryRunOutput, (String)"dryRunOutput");
        if (!((Collection)this.outputs).isEmpty()) {
            throw new RuntimeException("setCommands should be called once");
        }
        this.extractWorkingDirectoryFromDryRunOutputIfAvailable(dryRunOutput);
        List<BuildStepInfo> list = CommandClassifier.classify(dryRunOutput, this.fileConventions.os());
        Intrinsics.checkNotNullExpressionValue(list, (String)"classify(...)");
        List<BuildStepInfo> buildSteps = list;
        ListMultimap<String, List<BuildStepInfo>> listMultimap = FlowAnalyzer.analyze(buildSteps);
        Intrinsics.checkNotNullExpressionValue(listMultimap, (String)"analyze(...)");
        ListMultimap<String, List<BuildStepInfo>> outputs2 = listMultimap;
        for (Map.Entry entry2 : outputs2.entries()) {
            Intrinsics.checkNotNull((Object)entry2);
            String key = (String)entry2.getKey();
            List value = (List)entry2.getValue();
            Intrinsics.checkNotNull((Object)key);
            Intrinsics.checkNotNull((Object)value);
            this.outputs.add(new Output(key, value, buildCommand, cleanCommand, variantName));
        }
        this.buildTargetsCommand = CollectionsKt.plus((Collection)buildCommand, (Iterable)CollectionsKt.listOf((Object)"{LIST_OF_TARGETS_TO_BUILD}"));
        return this;
    }

    private final void extractWorkingDirectoryFromDryRunOutputIfAvailable(String dryRunOutput) {
        if (StringsKt.contains$default((CharSequence)dryRunOutput, (CharSequence)"make: Entering directory", (boolean)false, (int)2, null)) {
            Regex workingDirPattern = new Regex("^make: Entering directory [`'](.*?)'$", RegexOption.MULTILINE);
            MatchResult matchResult = Regex.find$default((Regex)workingDirPattern, (CharSequence)dryRunOutput, (int)0, (int)2, null);
            if (matchResult == null) {
                return;
            }
            MatchResult match2 = matchResult;
            MatchGroup matchGroup = match2.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            this.executionRootPath = new File(matchGroup.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final NativeBuildConfigValue build() {
        NativeBuildConfigValue nativeBuildConfigValue;
        AutoCloseable autoCloseable = (AutoCloseable)new CompileCommandsEncoder(this.compileCommandsJsonBinFile, 0, 2, null);
        Throwable throwable = null;
        try {
            CompileCommandsEncoder encoder = (CompileCommandsEncoder)autoCloseable;
            boolean bl = false;
            this.compileCommandsEncoder = encoder;
            nativeBuildConfigValue = this.buildImpl();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return nativeBuildConfigValue;
    }

    private final NativeBuildConfigValue buildImpl() {
        this.findLibraryNames();
        this.findToolchainNames();
        this.findToolChainCompilers();
        NativeBuildConfigValue config2 = new NativeBuildConfigValue();
        List<Output> $this$sortBy$iv = this.outputs;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Output it = (Output)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getLibraryName());
                    it = (Output)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getLibraryName())));
                }
            });
        }
        config2.cleanCommandsComponents = this.generateCleanCommands();
        config2.buildTargetsCommandComponents = this.buildTargetsCommand;
        Object[] objectArray = new File[]{this.androidMk};
        config2.buildFiles = Lists.newArrayList((Object[])objectArray);
        config2.libraries = this.generateLibraries();
        config2.toolchains = this.generateToolchains();
        config2.cFileExtensions = NativeBuildConfigValueBuilder.Companion.generateExtensions(this.cFileExtensions);
        config2.cppFileExtensions = NativeBuildConfigValueBuilder.Companion.generateExtensions(this.cppFileExtensions);
        return config2;
    }

    private final void findLibraryNames() {
        for (Output output2 : this.outputs) {
            String abi;
            String parentFile;
            Intrinsics.checkNotNullExpressionValue((Object)this.fileConventions.getFileParent(output2.getOutputFileName()), (String)"getFileParent(...)");
            Intrinsics.checkNotNullExpressionValue((Object)this.fileConventions.getFileName(parentFile), (String)"getFileName(...)");
            output2.setArtifactName(NdkUtils.getTargetNameFromBuildOutputFileName((String)this.fileConventions.getFileName(output2.getOutputFileName())));
            String string = "%s-%s-%s";
            Object[] objectArray = new Object[]{output2.getArtifactName(), output2.getVariantName(), abi};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            output2.setLibraryName(string2);
        }
    }

    private final void findToolChainCompilers() {
        for (Output output2 : this.outputs) {
            String string;
            String cCompiler;
            String string2;
            String it;
            String toolchain = output2.getToolchain();
            Set cCompilers = new HashSet();
            Set cppCompilers = new HashSet();
            Map compilerToWeirdExtensions = new HashMap();
            for (BuildStepInfo command : output2.getCommandInputs()) {
                boolean bl;
                String compilerCommand = command.getCommand().getExecutable();
                String extension2 = FilesKt.getExtension((File)new File(command.getOnlyInput()));
                if (NativeSourceFileExtensions.C_FILE_EXTENSIONS.contains(extension2)) {
                    this.cFileExtensions.add(extension2);
                    bl = cCompilers.add(compilerCommand);
                    continue;
                }
                if (NativeSourceFileExtensions.CPP_FILE_EXTENSIONS.contains(extension2)) {
                    this.cppFileExtensions.add(extension2);
                    bl = cppCompilers.add(compilerCommand);
                    continue;
                }
                Set extensions = (Set)compilerToWeirdExtensions.get(compilerCommand);
                if (extensions == null) {
                    extensions = new HashSet();
                    compilerToWeirdExtensions.put(compilerCommand, extensions);
                }
                bl = extensions.add(extension2);
            }
            if (cCompilers.size() > 1) {
                throw new RuntimeException("Too many c compilers in toolchain.");
            }
            if (cppCompilers.size() > 1) {
                throw new RuntimeException("Too many cpp compilers in toolchain.");
            }
            String string3 = (String)CollectionsKt.firstOrNull((Iterable)cCompilers);
            if (string3 != null) {
                String string4 = string3;
                it = string4;
                boolean bl = false;
                if (toolchain != null) {
                    this.toolChainToCCompiler.put(toolchain, it);
                }
                string2 = string4;
            } else {
                string2 = cCompiler = null;
            }
            if ((String)CollectionsKt.firstOrNull((Iterable)cppCompilers) != null) {
                String it2 = it;
                boolean bl = false;
                if (toolchain != null) {
                    this.toolChainToCppCompiler.put(toolchain, it2);
                }
                string = it;
            } else {
                string = null;
            }
            String cppCompiler = string;
            for (String compiler : compilerToWeirdExtensions.keySet()) {
                if (Intrinsics.areEqual((Object)compiler, (Object)cCompiler)) {
                    Object v = compilerToWeirdExtensions.get(compiler);
                    Intrinsics.checkNotNull(v);
                    this.cFileExtensions.addAll((Collection)v);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)compiler, (Object)cppCompiler)) continue;
                Object v = compilerToWeirdExtensions.get(compiler);
                Intrinsics.checkNotNull(v);
                this.cppFileExtensions.addAll((Collection)v);
            }
        }
    }

    private final String findToolChainName(String outputFileName) {
        return "toolchain-" + this.fileConventions.getFileName(this.fileConventions.getFileParent(outputFileName));
    }

    private final void findToolchainNames() {
        for (Output output2 : this.outputs) {
            output2.setToolchain(this.findToolChainName(output2.getOutputFileName()));
        }
    }

    private final List<List<String>> generateCleanCommands() {
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        Set cleanCommands = hashSet;
        for (Output output2 : this.outputs) {
            cleanCommands.add(output2.getCleanCommand());
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)cleanCommands);
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, NativeLibraryValue> generateLibraries() {
        Map librariesMap = new HashMap();
        for (Output output2 : this.outputs) {
            if (StringsKt.endsWith$default((String)output2.getOutputFileName(), (String)".gch", (boolean)false, (int)2, null)) continue;
            NativeLibraryValue value = new NativeLibraryValue();
            librariesMap.put(output2.getLibraryName(), value);
            value.buildCommandComponents = CollectionsKt.plus((Collection)output2.getBuildCommand(), (Iterable)CollectionsKt.listOf((Object)output2.getOutputFileName()));
            value.abi = this.fileConventions.getFileName(this.fileConventions.getFileParent(output2.getOutputFileName()));
            value.artifactName = output2.getArtifactName();
            value.toolchain = output2.getToolchain();
            value.output = this.fileConventions.toFile(output2.getOutputFileName());
            String workingDirPath = this.executionRootPath.getAbsolutePath();
            for (BuildStepInfo commandInput : output2.getCommandInputs()) {
                CommandLine command = commandInput.getCommand();
                String outputFile = CompileCommandsCodecKt.extractFlagArgument((String)"-o", (String)"--output", command.getEscapedFlags());
                CompileCommandsEncoder compileCommandsEncoder = this.compileCommandsEncoder;
                if (compileCommandsEncoder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compileCommandsEncoder");
                    compileCommandsEncoder = null;
                }
                File file = this.fileConventions.toFile(commandInput.getOnlyInput());
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                File file2 = new File(command.getExecutable());
                List list = CompileCommandsCodecKt.stripArgsForIde$default((String)commandInput.getOnlyInput(), command.getEscapedFlags(), null, (int)4, null);
                File file3 = new File(workingDirPath);
                String string = outputFile;
                Intrinsics.checkNotNull((Object)string);
                File file4 = new File(string);
                String string2 = output2.getArtifactName();
                Intrinsics.checkNotNull((Object)string2);
                compileCommandsEncoder.writeCompileCommand(file, file2, list, file3, file4, string2);
            }
            if (this.skipProcessingCompilerFlags) continue;
            ArrayList<NativeSourceFileValue> nativeSourceFiles = new ArrayList<NativeSourceFileValue>();
            value.files = nativeSourceFiles;
            for (BuildStepInfo input : output2.getCommandInputs()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                NativeSourceFileValue file = new NativeSourceFileValue();
                nativeSourceFiles.add(file);
                file.src = this.fileConventions.toFile(input.getOnlyInput());
                if (!this.fileConventions.isPathAbsolute(input.getOnlyInput())) {
                    file.src = this.fileConventions.toFile(this.executionRootPath, input.getOnlyInput());
                }
                Map rawFlagsLookUpMap = new LinkedHashMap();
                int n = input.getCommand().getRawFlags().size();
                for (int i = 0; i < n; ++i) {
                    rawFlagsLookUpMap.put(input.getCommand().getEscapedFlags().get(i), input.getCommand().getRawFlags().get(i));
                }
                Iterable i = CompileCommandsCodecKt.stripArgsForIde$default((String)input.getOnlyInput(), input.getCommand().getEscapedFlags(), null, (int)4, null);
                NativeSourceFileValue nativeSourceFileValue = file;
                boolean $i$f$map = false;
                void var13_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)rawFlagsLookUpMap.get(it));
                }
                nativeSourceFileValue.flags = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            }
        }
        return librariesMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, NativeToolchainValue> generateToolchains() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.outputs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Output output2 = (Output)element$iv$iv;
            boolean bl2 = false;
            if (output2.getToolchain() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set toolchainSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List toolchains = new ArrayList(toolchainSet);
        CollectionsKt.sort((List)toolchains);
        Map toolchainsMap = new HashMap();
        for (String toolchain : toolchains) {
            NativeToolchainValue toolchainValue = new NativeToolchainValue();
            toolchainsMap.put(toolchain, toolchainValue);
            if (this.toolChainToCCompiler.containsKey(toolchain)) {
                String string = this.toolChainToCCompiler.get(toolchain);
                Intrinsics.checkNotNull((Object)string);
                toolchainValue.cCompilerExecutable = this.fileConventions.toFile(string);
            }
            if (!this.toolChainToCppCompiler.containsKey(toolchain)) continue;
            String string = this.toolChainToCppCompiler.get(toolchain);
            Intrinsics.checkNotNull((Object)string);
            toolchainValue.cppCompilerExecutable = this.fileConventions.toFile(string);
        }
        return toolchainsMap;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Companion;", "", "<init>", "()V", "generateExtensions", "", "", "extensionSet", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Collection<String> generateExtensions(Set<String> extensionSet) {
            ArrayList arrayList = Lists.newArrayList((Iterable)extensionSet);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
            List extensionList = arrayList;
            CollectionsKt.sort((List)extensionList);
            return extensionList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Output;", "", "outputFileName", "", "commandInputs", "", "Lcom/android/build/gradle/external/gnumake/BuildStepInfo;", "buildCommand", "cleanCommand", "variantName", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getOutputFileName", "()Ljava/lang/String;", "getCommandInputs", "()Ljava/util/List;", "getBuildCommand", "getCleanCommand", "getVariantName", "artifactName", "getArtifactName", "setArtifactName", "(Ljava/lang/String;)V", "libraryName", "getLibraryName", "setLibraryName", "toolchain", "getToolchain", "setToolchain", "gradle-core"})
    private static final class Output {
        @NotNull
        private final String outputFileName;
        @NotNull
        private final List<BuildStepInfo> commandInputs;
        @NotNull
        private final List<String> buildCommand;
        @NotNull
        private final List<String> cleanCommand;
        @NotNull
        private final String variantName;
        @Nullable
        private String artifactName;
        @Nullable
        private String libraryName;
        @Nullable
        private String toolchain;

        public Output(@NotNull String outputFileName, @NotNull List<BuildStepInfo> commandInputs, @NotNull List<String> buildCommand, @NotNull List<String> cleanCommand, @NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)outputFileName, (String)"outputFileName");
            Intrinsics.checkNotNullParameter(commandInputs, (String)"commandInputs");
            Intrinsics.checkNotNullParameter(buildCommand, (String)"buildCommand");
            Intrinsics.checkNotNullParameter(cleanCommand, (String)"cleanCommand");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            this.outputFileName = outputFileName;
            this.commandInputs = commandInputs;
            this.buildCommand = buildCommand;
            this.cleanCommand = cleanCommand;
            this.variantName = variantName;
        }

        @NotNull
        public final String getOutputFileName() {
            return this.outputFileName;
        }

        @NotNull
        public final List<BuildStepInfo> getCommandInputs() {
            return this.commandInputs;
        }

        @NotNull
        public final List<String> getBuildCommand() {
            return this.buildCommand;
        }

        @NotNull
        public final List<String> getCleanCommand() {
            return this.cleanCommand;
        }

        @NotNull
        public final String getVariantName() {
            return this.variantName;
        }

        @Nullable
        public final String getArtifactName() {
            return this.artifactName;
        }

        public final void setArtifactName(@Nullable String string) {
            this.artifactName = string;
        }

        @Nullable
        public final String getLibraryName() {
            return this.libraryName;
        }

        public final void setLibraryName(@Nullable String string) {
            this.libraryName = string;
        }

        @Nullable
        public final String getToolchain() {
            return this.toolchain;
        }

        public final void setToolchain(@Nullable String string) {
            this.toolchain = string;
        }
    }
}

