/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.build;

import com.android.build.gradle.internal.cxx.attribution.AttributionStructuredLogCodecKt;
import com.android.build.gradle.internal.cxx.attribution.BuildAttributionUtilsKt;
import com.android.build.gradle.internal.cxx.attribution.BuildTaskAttributions;
import com.android.build.gradle.internal.cxx.build.CxxBuilder;
import com.android.build.gradle.internal.cxx.io.IoUtilsKt;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessCommand;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessKt;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessType;
import com.android.build.gradle.internal.cxx.settings.BuildSettingsFactoryKt;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.utils.FileUtils;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessageV3;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.gradle.api.GradleException;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e\u00b2\u0006\u0012\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u008a\u0084\u0002"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder;", "Lcom/android/build/gradle/internal/cxx/build/CxxBuilder;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "<init>", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;)V", "getAbi", "()Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "getVariant", "()Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "nativeBuildConfigValueMini", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "getNativeBuildConfigValueMini", "()Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "build", "", "ops", "Lorg/gradle/process/ExecOperations;", "verifyTargetExists", "config", "findLibrariesToBuild", "", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "executeProcessBatch", "buildSteps", "Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$BuildStep;", "BuildStep", "Companion", "gradle-core", "attributions", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttributions;", "kotlin.jvm.PlatformType"})
@SourceDebugExtension(value={"SMAP\nCxxRegularBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CxxRegularBuilder.kt\ncom/android/build/gradle/internal/cxx/build/CxxRegularBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n*L\n1#1,399:1\n1611#2,9:400\n1863#2:409\n1864#2:411\n1620#2:412\n1557#2:413\n1628#2,3:414\n1557#2:417\n1628#2,3:418\n1#3:410\n1#3:426\n284#4,5:421\n*S KotlinDebug\n*F\n+ 1 CxxRegularBuilder.kt\ncom/android/build/gradle/internal/cxx/build/CxxRegularBuilder\n*L\n101#1:400,9\n101#1:409\n101#1:411\n101#1:412\n287#1:413\n287#1:414,3\n291#1:417\n291#1:418,3\n101#1:410\n329#1:426\n329#1:421,5\n*E\n"})
public final class CxxRegularBuilder
implements CxxBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CxxAbiModel abi;
    @NotNull
    public static final String BUILD_TARGETS_PLACEHOLDER = "{LIST_OF_TARGETS_TO_BUILD}";

    public CxxRegularBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        this.abi = abi;
    }

    @NotNull
    public final CxxAbiModel getAbi() {
        return this.abi;
    }

    private final CxxVariantModel getVariant() {
        return this.abi.getVariant();
    }

    private final NativeBuildConfigValueMini getNativeBuildConfigValueMini() {
        NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig(this.abi, null);
        Intrinsics.checkNotNullExpressionValue((Object)nativeBuildConfigValueMini, (String)"getNativeBuildMiniConfig(...)");
        return nativeBuildConfigValueMini;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void build(@NotNull ExecOperations ops) {
        Intrinsics.checkNotNullParameter((Object)ops, (String)"ops");
        LoggingEnvironmentKt.infoln("starting build", new Object[0]);
        LoggingEnvironmentKt.infoln("reading expected JSONs", new Object[0]);
        NativeBuildConfigValueMini config2 = this.getNativeBuildConfigValueMini();
        LoggingEnvironmentKt.infoln("done reading expected JSONs", new Object[0]);
        Set<String> targets2 = this.getVariant().getBuildTargetSet();
        if (targets2.isEmpty()) {
            LoggingEnvironmentKt.infoln("executing build commands for targets that produce .so files or executables", new Object[0]);
        } else {
            this.verifyTargetExists(config2);
        }
        ArrayList buildSteps = Lists.newArrayList();
        LoggingEnvironmentKt.infoln("evaluate miniconfig", new Object[0]);
        if (config2.libraries.isEmpty()) {
            LoggingEnvironmentKt.infoln("no libraries", new Object[0]);
            return;
        }
        List<NativeLibraryValueMini> librariesToBuild = this.findLibrariesToBuild(config2);
        if (librariesToBuild.isEmpty()) {
            LoggingEnvironmentKt.infoln("no libraries to build", new Object[0]);
            return;
        }
        List<String> list = config2.buildTargetsCommandComponents;
        boolean bl = list != null ? !((Collection)list).isEmpty() : false;
        if (bl) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = librariesToBuild;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                NativeLibraryValueMini library = (NativeLibraryValueMini)element$iv$iv;
                boolean bl3 = false;
                if (library.artifactName == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List artifactNames = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
            List<String> list2 = config2.buildTargetsCommandComponents;
            Intrinsics.checkNotNull(list2);
            List buildTargetsCommand = CxxRegularBuilder.Companion.substituteBuildTargetsCommand(list2, artifactNames);
            buildSteps.add(new BuildStep(buildTargetsCommand, librariesToBuild));
            LoggingEnvironmentKt.infoln("about to build targets " + CollectionsKt.joinToString$default((Iterable)artifactNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), new Object[0]);
        } else {
            for (NativeLibraryValueMini libraryValue : librariesToBuild) {
                List<String> list3 = libraryValue.buildCommandComponents;
                Intrinsics.checkNotNull(list3);
                buildSteps.add(new BuildStep(list3, CollectionsKt.listOf((Object)libraryValue)));
                List<String> list4 = libraryValue.buildCommandComponents;
                Intrinsics.checkNotNull(list4);
                LoggingEnvironmentKt.infoln("about to build " + CollectionsKt.joinToString$default((Iterable)list4, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            }
        }
        Intrinsics.checkNotNull((Object)buildSteps);
        this.executeProcessBatch(ops, buildSteps);
        LoggingEnvironmentKt.infoln("check expected build outputs", new Object[0]);
        for (NativeLibraryValueMini library : config2.libraries.values()) {
            File output2;
            Preconditions.checkState((!Strings.isNullOrEmpty((String)library.artifactName) ? 1 : 0) != 0);
            if (!((Collection)targets2).isEmpty() && !CollectionsKt.contains((Iterable)targets2, (Object)library.artifactName) || buildSteps.stream().noneMatch(new Predicate(library){
                final /* synthetic */ NativeLibraryValueMini $library;
                {
                    this.$library = $library;
                }

                public final boolean test(BuildStep step) {
                    return step.getLibraries().contains(this.$library);
                }
            }) || library.output == null) continue;
            if (!output2.exists()) {
                throw new GradleException("Expected output file at " + output2 + " for target " + library.artifactName + " but there was none");
            }
            String[] stringArray = new String[]{output2.getName()};
            File expectedOutputFile = FileUtils.join((File)this.abi.getSoFolder(), (String[])stringArray);
            if (!FileUtils.isSameFile((File)output2, (File)expectedOutputFile)) {
                LoggingEnvironmentKt.infoln("external build set its own library output location for '" + output2.getName() + "', hard link or copy to expected location", new Object[0]);
                Intrinsics.checkNotNull((Object)expectedOutputFile);
                IoUtilsKt.synchronizeFile$default(output2, expectedOutputFile, null, 4, null);
            }
            for (File runtimeFile : library.runtimeFiles) {
                String[] stringArray2 = new String[]{runtimeFile.getName()};
                File dest = FileUtils.join((File)this.abi.getSoFolder(), (String[])stringArray2);
                Intrinsics.checkNotNull((Object)runtimeFile);
                Intrinsics.checkNotNull((Object)dest);
                IoUtilsKt.synchronizeFile$default(runtimeFile, dest, null, 4, null);
            }
        }
        if (!this.abi.getSoFolder().isDirectory()) {
            LoggingEnvironmentKt.infoln("didn't copy STL file to " + this.abi.getSoFolder() + " because that folder wasn't created by the build ", new Object[0]);
        } else if (this.abi.getStlLibraryFile() != null && this.abi.getStlLibraryFile().isFile()) {
            File file = this.abi.getSoFolder();
            String string = this.abi.getStlLibraryFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            File objAbi = FilesKt.resolve((File)file, (String)string);
            IoUtilsKt.synchronizeFile$default(this.abi.getStlLibraryFile(), objAbi, null, 4, null);
        }
        LoggingEnvironmentKt.infoln("build complete", new Object[0]);
    }

    private final void verifyTargetExists(NativeBuildConfigValueMini config2) {
        Set<String> targets2 = this.getVariant().getBuildTargetSet();
        LoggingEnvironmentKt.infoln("executing build commands for targets: '" + Joiner.on((String)", ").join((Iterable)targets2) + "'", new Object[0]);
        HashSet matchingTargets = Sets.newHashSet();
        HashSet unmatchedTargets = Sets.newHashSet();
        for (NativeLibraryValueMini libraryValue : config2.libraries.values()) {
            boolean bl = CollectionsKt.contains((Iterable)targets2, (Object)libraryValue.artifactName) ? matchingTargets.add(libraryValue.artifactName) : unmatchedTargets.add(libraryValue.artifactName);
        }
        for (String target : targets2) {
            if (matchingTargets.contains(target)) continue;
            throw new GradleException("Unexpected native build target " + target + ". Valid values are: " + Joiner.on((String)", ").join((Iterable)unmatchedTargets));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<NativeLibraryValueMini> findLibrariesToBuild(NativeBuildConfigValueMini config2) {
        Collection collection;
        void $this$mapTo$iv$iv;
        ArrayList librariesToBuild = Lists.newArrayList();
        Set<String> targets2 = this.getVariant().getBuildTargetSet();
        Set implicitTargets = CollectionsKt.toMutableSet((Iterable)this.getVariant().getImplicitBuildTargetSet());
        block10: for (NativeLibraryValueMini libraryValue : config2.libraries.values()) {
            block21: {
                File output2;
                block22: {
                    LoggingEnvironmentKt.infoln("evaluate library " + libraryValue.artifactName + " (" + libraryValue.abi + ")", new Object[0]);
                    if (!((Collection)targets2).isEmpty() && !CollectionsKt.contains((Iterable)targets2, (Object)libraryValue.artifactName)) {
                        String string = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)string);
                        LoggingEnvironmentKt.infoln("not building target " + string + " because it isn't in targets set", new Object[0]);
                        continue;
                    }
                    List<String> list = config2.buildTargetsCommandComponents;
                    if (!(list != null ? !list.isEmpty() : false)) {
                        List<String> list2 = libraryValue.buildCommandComponents;
                        if (!(list2 != null ? !list2.isEmpty() : false)) {
                            String string = libraryValue.artifactName;
                            Intrinsics.checkNotNull((Object)string);
                            LoggingEnvironmentKt.infoln("not building target " + string + " because there was no buildCommandComponents for the target, nor a buildTargetsCommandComponents for the config", new Object[0]);
                            continue;
                        }
                    }
                    if (!targets2.isEmpty()) break block21;
                    output2 = libraryValue.output;
                    if (output2 == null) {
                        String string = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)string);
                        LoggingEnvironmentKt.infoln("not building target " + string + " because no targets are specified and library build output file is null", new Object[0]);
                        continue;
                    }
                    if (!CollectionsKt.contains((Iterable)this.getVariant().getImplicitBuildTargetSet(), (Object)libraryValue.artifactName)) break block22;
                    LoggingEnvironmentKt.infoln("building target " + libraryValue.artifactName + " because it is required by the build", new Object[0]);
                    break block21;
                }
                switch (FilesKt.getExtension((File)output2)) {
                    case "a": {
                        String string = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)string);
                        LoggingEnvironmentKt.infoln("not building target library " + string + " because static libraries are not build by default.", new Object[0]);
                        continue block10;
                    }
                    case "so": {
                        String string = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)string);
                        LoggingEnvironmentKt.infoln("building target library " + string + " because no targets are specified.", new Object[0]);
                        break;
                    }
                    case "": {
                        String string = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)string);
                        LoggingEnvironmentKt.infoln("building target executable " + string + " because no targets are specified.", new Object[0]);
                        break;
                    }
                    default: {
                        String string = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)string);
                        LoggingEnvironmentKt.infoln("not building target " + string + " because the type cannot be determined.", new Object[0]);
                        continue block10;
                    }
                }
            }
            librariesToBuild.add(libraryValue);
        }
        Object object = implicitTargets;
        Intrinsics.checkNotNull((Object)librariesToBuild);
        Iterable $this$map$iv = librariesToBuild;
        boolean $i$f$map3 = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            NativeLibraryValueMini nativeLibraryValueMini = (NativeLibraryValueMini)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.artifactName);
        }
        $this$map$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        TypeIntrinsics.asMutableCollection((Object)object).removeAll((Collection<?>)$this$map$iv);
        if (!((Collection)implicitTargets).isEmpty()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            object = librariesToBuild;
            String string = CollectionsKt.joinToString$default((Iterable)implicitTargets, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            collection = CxxDiagnosticCode.REQUIRED_BUILD_TARGETS_MISSING;
            boolean $i$f$map2 = false;
            void $i$f$map3 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Object item$iv$iv2;
                item$iv$iv2 = (NativeLibraryValueMini)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl = false;
                collection2.add(it.artifactName);
            }
            collection2 = (List)destination$iv$iv2;
            LoggingEnvironmentKt.errorln((CxxDiagnosticCode)collection, "did not find implicitly required targets: " + string + ". Valid targets are: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)collection2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), new Object[0]);
        }
        return librariesToBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeProcessBatch(ExecOperations ops, List<BuildStep> buildSteps) {
        for (BuildStep buildStep : buildSteps) {
            int n;
            String string;
            List<String> tokens = buildStep.getBuildCommandComponents();
            ExecuteProcessCommand command = ExecuteProcessKt.createExecuteProcessCommand(tokens.get(0)).addArgs(CollectionsKt.drop((Iterable)tokens, (int)1)).addEnvironments(BuildSettingsFactoryKt.getEnvironmentVariableMap(this.abi.getBuildSettings()));
            if (buildStep.getLibraries().size() > 1) {
                Stream stream2 = buildStep.getLibraries().stream().map(new Function(this){
                    final /* synthetic */ CxxRegularBuilder this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final String apply(NativeLibraryValueMini library) {
                        return library.artifactName + "_" + CxxAbiModelKt.getName(this.this$0.getAbi());
                    }
                });
                Intrinsics.checkNotNullExpressionValue(stream2, (String)"map(...)");
                List targetNames2 = StreamsKt.toList(stream2);
                LoggingEnvironmentKt.infoln("Build multiple targets " + CollectionsKt.joinToString$default((Iterable)targetNames2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), new Object[0]);
                string = "targets";
            } else {
                Preconditions.checkElementIndex((int)0, (int)buildStep.getLibraries().size());
                String string2 = buildStep.getLibraries().get((int)0).artifactName;
                Intrinsics.checkNotNull((Object)string2);
                LoggingEnvironmentKt.infoln("Build " + string2, new Object[0]);
                String string3 = buildStep.getLibraries().get((int)0).artifactName;
                string = string3;
                Intrinsics.checkNotNull((Object)string3);
            }
            String logFileSuffix2 = string;
            long buildStartTime = Clock.systemUTC().millis();
            if (CxxAbiModelKt.getNinjaLogFile(this.abi).isFile()) {
                File $this$useLines_u24default$iv = CxxAbiModelKt.getNinjaLogFile(this.abi);
                Charset charset$iv = Charsets.UTF_8;
                boolean $i$f$useLines = false;
                Object object = $this$useLines_u24default$iv;
                int n2 = 8192;
                Object object2 = object;
                object = (object2 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv)) instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n2);
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)object;
                    boolean bl = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl2 = false;
                    int n3 = SequencesKt.count((Sequence)it);
                    n = n3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                n = 0;
            }
            int linesToSkip = n;
            ExecuteProcessKt.executeProcess$default(this.abi, ExecuteProcessType.BUILD_PROCESS, command, ops, logFileSuffix2, null, null, 48, null);
            if (this.getVariant().getModule().getBuildSystem() != NativeBuildSystem.CMAKE && this.getVariant().getModule().getBuildSystem() != NativeBuildSystem.NINJA) continue;
            Lazy attributions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BuildTaskAttributions>(this, linesToSkip, buildStartTime, buildStep){
                final /* synthetic */ CxxRegularBuilder this$0;
                final /* synthetic */ int $linesToSkip;
                final /* synthetic */ long $buildStartTime;
                final /* synthetic */ BuildStep $buildStep;
                {
                    this.this$0 = $receiver;
                    this.$linesToSkip = $linesToSkip;
                    this.$buildStartTime = $buildStartTime;
                    this.$buildStep = $buildStep;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final BuildTaskAttributions invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$buildStep.getLibraries();
                    BuildTaskAttributions.Builder builder = BuildAttributionUtilsKt.generateNinjaSourceFileAttribution(this.this$0.getAbi(), this.$linesToSkip, this.$buildStartTime).toBuilder();
                    boolean $i$f$map = false;
                    void var3_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        NativeLibraryValueMini nativeLibraryValueMini = (NativeLibraryValueMini)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.artifactName);
                    }
                    return builder.addAllLibrary((List)destination$iv$iv).build();
                }
            }));
            if (this.abi.getVariant().getModule().getProject().getChromeTraceJsonFolder() != null) {
                File traceFolder;
                boolean bl = false;
                BuildTaskAttributions buildTaskAttributions = CxxRegularBuilder.executeProcessBatch$lambda$4((Lazy<BuildTaskAttributions>)attributions$delegate);
                Intrinsics.checkNotNullExpressionValue((Object)buildTaskAttributions, (String)"executeProcessBatch$lambda$4(...)");
                BuildAttributionUtilsKt.generateChromeTrace(buildTaskAttributions, this.abi, buildStartTime, traceFolder);
            }
            LoggingEnvironmentKt.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>((Lazy<BuildTaskAttributions>)attributions$delegate){
                final /* synthetic */ Lazy<BuildTaskAttributions> $attributions$delegate;
                {
                    this.$attributions$delegate = $attributions$delegate;
                    super(1);
                }

                public final GeneratedMessageV3 invoke(StringEncoder encoder) {
                    Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
                    BuildTaskAttributions buildTaskAttributions = CxxRegularBuilder.access$executeProcessBatch$lambda$4(this.$attributions$delegate);
                    Intrinsics.checkNotNullExpressionValue((Object)buildTaskAttributions, (String)"access$executeProcessBatch$lambda$4(...)");
                    return AttributionStructuredLogCodecKt.encode(buildTaskAttributions, encoder);
                }
            }));
        }
    }

    private static final BuildTaskAttributions executeProcessBatch$lambda$4(Lazy<BuildTaskAttributions> $attributions$delegate) {
        Lazy<BuildTaskAttributions> lazy = $attributions$delegate;
        return (BuildTaskAttributions)lazy.getValue();
    }

    public static final /* synthetic */ BuildTaskAttributions access$executeProcessBatch$lambda$4(Lazy $attributions$delegate) {
        return CxxRegularBuilder.executeProcessBatch$lambda$4((Lazy<BuildTaskAttributions>)$attributions$delegate);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$BuildStep;", "", "buildCommandComponents", "", "", "libraries", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getBuildCommandComponents", "()Ljava/util/List;", "getLibraries", "gradle-core"})
    private static final class BuildStep {
        @NotNull
        private final List<String> buildCommandComponents;
        @NotNull
        private final List<NativeLibraryValueMini> libraries;

        public BuildStep(@NotNull List<String> buildCommandComponents, @NotNull List<? extends NativeLibraryValueMini> libraries) {
            Intrinsics.checkNotNullParameter(buildCommandComponents, (String)"buildCommandComponents");
            Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
            this.buildCommandComponents = buildCommandComponents;
            this.libraries = libraries;
        }

        @NotNull
        public final List<String> getBuildCommandComponents() {
            return this.buildCommandComponents;
        }

        @NotNull
        public final List<NativeLibraryValueMini> getLibraries() {
            return this.libraries;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$Companion;", "", "<init>", "()V", "BUILD_TARGETS_PLACEHOLDER", "", "substituteBuildTargetsCommand", "", "buildTargetsCommandComponents", "artifactNames", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nCxxRegularBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CxxRegularBuilder.kt\ncom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n967#2,7:400\n944#2,15:407\n*S KotlinDebug\n*F\n+ 1 CxxRegularBuilder.kt\ncom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$Companion\n*L\n392#1:400,7\n394#1:407,15\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> substituteBuildTargetsCommand(List<String> buildTargetsCommandComponents, List<String> artifactNames) {
            List list;
            Collection collection;
            block8: {
                void $this$takeLastWhile$iv;
                if (!buildTargetsCommandComponents.contains(CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER)) {
                    return buildTargetsCommandComponents;
                }
                List<String> $this$takeWhile$iv = buildTargetsCommandComponents;
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object t : $this$takeWhile$iv) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER))) break;
                    list$iv.add(t);
                }
                $this$takeWhile$iv = buildTargetsCommandComponents;
                collection = CollectionsKt.plus((Collection)list$iv, (Iterable)artifactNames);
                boolean $i$f$takeLastWhile = false;
                if ($this$takeLastWhile$iv.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else {
                    ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER)) continue;
                        iterator$iv.next();
                        int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                        if (expectedSize$iv == 0) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ArrayList arrayList;
                            ArrayList $this$takeLastWhile_u24lambda_u248$iv = arrayList = new ArrayList(expectedSize$iv);
                            boolean bl2 = false;
                            while (iterator$iv.hasNext()) {
                                $this$takeLastWhile_u24lambda_u248$iv.add(iterator$iv.next());
                            }
                            list = arrayList;
                        }
                        break block8;
                    }
                    list = CollectionsKt.toList((Iterable)((Iterable)$this$takeLastWhile$iv));
                }
            }
            return CollectionsKt.plus((Collection)collection, (Iterable)list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

